/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.MonitorMessage;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.BatchConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.BlsEnqMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.GDSNMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ListQueueMessage;
import com.ca.intertest.tools.QueueListMessage;
import com.ca.intertest.wizards.BatchLinkData;
import com.ca.intertest.wizards.BatchLinkRow;
import com.ca.intertest.wizards.IntertestWizardDialog;
import com.ca.intertest.wizards.ProjectCreationPage;
import com.ca.intertest.wizards.SelectJobWizard;
import com.ca.intertest.wizards.projectBatch;
import com.ca.testingtools.common.TTException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SelectJobPage
extends WizardPage
implements SelectionListener,
ISelectionChangedListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private Combo sessionslist;
    private ArrayList<debugBatchSession> sessions;
    private Combo servers;
    private ArrayList<FileServer> serverlist;
    private String errorText = null;
    private FileServer server = null;
    private Debug debug = Debug.getInstance();
    private final String CONTEXT_HELP_ID = "com.ca.intertest.selectJobPage";
    private SelectJobWizard wizard;
    private IDialogSettings settings;
    private TableViewer tableViewer;
    private Table table;
    private Group group;
    private GridData gridData;
    private BatchLinkData rowData;
    private boolean autoRefresh = false;
    private String autoRefreshError = null;
    private boolean isJobSelected = false;
    private static final int SCROLL_LINES = 5;
    static final String COL_WIDTH = "column_width";
    private final int JOBNAME = 0;
    private final int STEPNAME = 1;
    private final int PROGRAM = 2;
    private final int OWNER = 3;
    private final int USERID = 4;
    private final int TRANSACTION = 5;
    private final int SYSID = 6;
    protected int[] order;
    protected int[] COLUMN_WIDTHS;
    protected int[] width;
    private final String JOBNAME_COLUMN;
    private final String STEPNAME_COLUMN;
    private final String PROGRAM_COLUMN;
    private final String OWNER_COLUMN;
    private final String USERID_COLUMN;
    private final String TRANSACTION_COLUMN;
    private final String SYSID_COLUMN;
    private String[] columnNames;

    protected SelectJobPage(String pageName) {
        super(pageName);
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        this.order = nArray;
        this.COLUMN_WIDTHS = new int[]{15, 15, 15, 15, 15, 15, 15};
        this.width = null;
        this.JOBNAME_COLUMN = Messages.SchedulingPage_5;
        this.STEPNAME_COLUMN = Messages.SelectJobPage_30;
        this.PROGRAM_COLUMN = Messages.SchedulingPage_6;
        this.OWNER_COLUMN = Messages.SelectJobPage_31;
        this.USERID_COLUMN = Messages.SchedulingPage_95;
        this.TRANSACTION_COLUMN = Messages.SchedulingPage_96;
        this.SYSID_COLUMN = Messages.SelectJobPage_36;
        this.columnNames = new String[]{this.JOBNAME_COLUMN, this.STEPNAME_COLUMN, this.PROGRAM_COLUMN, this.OWNER_COLUMN, this.USERID_COLUMN, this.TRANSACTION_COLUMN, this.SYSID_COLUMN};
    }

    public void createControl(Composite parent) {
        this.wizard = (SelectJobWizard)this.getWizard();
        this.settings = this.wizard.getDialogSettings();
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        this.checkWidth(control);
        GridLayout gridLayout = new GridLayout(1, true);
        control.setLayout((Layout)gridLayout);
        this.serverlist = ServerList.getInstance().getFileServers();
        this.createServersGroup(control);
        this.createTable(control);
        this.createColumnSorter();
        this.createSessionGroup(control);
        this.servers.forceFocus();
        this.servers.addSelectionListener((SelectionListener)this);
        this.sessionslist.addSelectionListener((SelectionListener)this);
        this.setTitle(Messages.SelectJobPage_32);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.selectJobPage");
    }

    private void createServersGroup(Composite parent) {
        this.group = new Group(parent, 16);
        this.group.setLayout((Layout)new GridLayout(1, true));
        this.group.setText(Messages.SchedulingPage_10);
        this.servers = new Combo((Composite)this.group, 2060);
        int defaultIndex = -1;
        int availableIndex = -1;
        int numAvailable = 0;
        for (FileServer item : this.serverlist) {
            this.servers.add(item.getName());
            if (!item.getStatusText().equalsIgnoreCase("Available")) continue;
            ++numAvailable;
            if (item.isDefaultserver()) {
                defaultIndex = this.servers.indexOf(item.getName());
                continue;
            }
            if (numAvailable != 1) continue;
            availableIndex = this.servers.indexOf(item.getName());
        }
        if (defaultIndex >= 0) {
            this.servers.select(defaultIndex);
            this.autoRefresh = true;
        } else if (this.servers.getItemCount() == 1) {
            this.servers.select(0);
            this.autoRefresh = true;
            ServerList.getInstance().getServer(this.servers.getItem(0)).setDefaultserver(true);
        } else if (numAvailable == 1) {
            this.servers.select(availableIndex);
            this.autoRefresh = true;
        } else {
            this.servers.select(-1);
            this.autoRefresh = false;
        }
    }

    private void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.table = this.tableViewer.getTable();
        int[] styles = new int[]{16384, 16384, 16384, 16384, 16384, 16384, 16384};
        int columnIndex = 0;
        while (columnIndex < this.columnNames.length) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((BatchLinkRow)element).getJobname();
                        }
                    });
                    column.getColumn().setWidth(this.width[0]);
                    break;
                }
                case 1: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((BatchLinkRow)element).getStepname();
                        }
                    });
                    column.getColumn().setWidth(this.width[1]);
                    break;
                }
                case 2: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((BatchLinkRow)element).getProgram();
                        }
                    });
                    column.getColumn().setWidth(this.width[1]);
                    break;
                }
                case 3: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((BatchLinkRow)element).getOwner();
                        }
                    });
                    column.getColumn().setWidth(this.width[3]);
                    break;
                }
                case 4: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((BatchLinkRow)element).getImsUserId();
                        }
                    });
                    column.getColumn().setWidth(this.width[4]);
                    break;
                }
                case 5: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((BatchLinkRow)element).getImsTransaction();
                        }
                    });
                    column.getColumn().setWidth(this.width[5]);
                    break;
                }
                case 6: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((BatchLinkRow)element).getSystemId();
                        }
                    });
                    column.getColumn().setWidth(this.width[6]);
                }
            }
            column.getColumn().setText(this.columnNames[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData(COL_WIDTH, (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(false);
            ++columnIndex;
        }
        this.gridData = new GridData(1808);
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.grabExcessHorizontalSpace = false;
        this.table.setLayoutData((Object)this.gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(JFaceResources.getTextFont());
        Control control = this.tableViewer.getControl();
        GridData gridData = new GridData(4, 4, true, true, 2, 2);
        GC gc = new GC((Drawable)control);
        int height = gc.stringExtent((String)"W").y;
        gc.dispose();
        Point size = control.computeSize(-1, height * 5);
        control.setSize(size);
        gridData.heightHint = size.y;
        control.setLayoutData((Object)gridData);
        this.rowData = new BatchLinkData();
        this.tableViewer.setContentProvider((IContentProvider)this.rowData);
        this.tableViewer.setColumnProperties(this.columnNames);
        this.setControl(this.tableViewer.getControl());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tableViewer.setInput((Object)this.rowData);
    }

    private void createSessionGroup(Composite parent) {
        this.group = new Group(parent, 16);
        this.group.setLayout((Layout)new GridLayout(1, true));
        this.group.setText(Messages.SelectJobPage_3);
        this.sessionslist = new Combo((Composite)this.group, 8);
        this.gridData = new GridData(4, 0, true, true);
        this.sessionslist.setLayoutData((Object)this.gridData);
        this.sessions = new ArrayList();
        this.sessionslist.add(Messages.SelectJobPage_4);
        for (debugSession item : this.debug.getSessions()) {
            if (!item.isBatch() || item.isDebugging()) continue;
            this.sessionslist.add(item.getName());
            this.sessions.add((debugBatchSession)item);
        }
        this.sessionslist.select(0);
        this.sessionslist.setSelection(new Point(0, 1));
    }

    public void reSize() {
        Table tab;
        if (this.tableViewer != null && (tab = this.tableViewer.getTable()) != null && !tab.isDisposed()) {
            tab.setColumnOrder(this.order);
            TableColumn[] tableColumnArray = tab.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                Integer colid = (Integer)column.getData(COL_WIDTH);
                column.setWidth(this.width[colid]);
                ++n2;
            }
        }
    }

    public boolean isPageComplete() {
        int[] nArray = new int[]{3, 2, 1};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.setMessage(null, type);
            ++n2;
        }
        if (this.autoRefresh) {
            this.autoRefreshError = null;
            this.refreshQueue();
            this.autoRefresh = false;
        }
        if (this.servers.getItemCount() < 1) {
            this.setErrorMessage(Messages.SelectJobPage_5);
            return false;
        }
        if (this.servers.getSelectionIndex() == -1) {
            this.setErrorMessage(Messages.SelectJobPage_6);
            return false;
        }
        if (this.autoRefreshError != null) {
            this.setErrorMessage(this.autoRefreshError);
            return false;
        }
        if (this.rowData.getRowlist() == null || this.rowData.getRowlist().size() < 1) {
            this.setErrorMessage(Messages.SelectJobPage_7);
            return false;
        }
        if (!this.isJobSelected) {
            this.setErrorMessage(Messages.SelectJobPage_8);
            return false;
        }
        this.sessionslist.setEnabled(true);
        if (this.sessionslist.getSelectionIndex() == -1) {
            this.setErrorMessage(Messages.SelectJobPage_9);
            return false;
        }
        debugBatchSession session = this.getSelectedSession();
        if (session == null) {
            this.setMessage(Messages.SelectJobPage_10, 2);
            return true;
        }
        if (session.getMonitored(true).size() < 1) {
            this.setMessage(Messages.SelectJobPage_11, 2);
            return true;
        }
        if (session.getProtsymlist().size() == 0) {
            this.setMessage(Messages.SelectJobPage_12, 2);
            return true;
        }
        return super.isPageComplete();
    }

    private debugBatchSession getSelectedSession() {
        int ix = this.sessionslist.getSelectionIndex();
        if (ix <= 0) {
            return null;
        }
        return this.sessions.get(ix - 1);
    }

    private void refreshQueue() {
        this.setErrorMessage(null);
        int ix = this.servers.getSelectionIndex();
        if (ix < 0) {
            return;
        }
        String name = this.servers.getItem(ix);
        this.server = ServerList.getInstance().getFileServer(name);
        if (this.server == null) {
            this.showError(Messages.SelectJobPage_13);
            return;
        }
        try {
            if (!this.server.isEnabled(false)) {
                this.server.reportCavhconfError(false);
                return;
            }
        }
        catch (TTException e) {
            this.server.reportCavhconfError(false, e);
            return;
        }
        if (this.rowData.getRowlist() != null) {
            this.rowData.getRowlist().clear();
        }
        ListQueueMessage queue = new ListQueueMessage();
        this.setMessage(Messages.SelectJobPage_14, 1);
        BatchConnection connection = new BatchConnection(this.server);
        try {
            connection.connect(true);
            queue.setUserid(this.server.getUser());
            short status = 0;
            CVMO cvmo = null;
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)queue);
            this.setMessage(Messages.SelectJobPage_15, 1);
            cvmo = connection.process(cvmi);
            status = (short)connection.getErrorLevel();
            this.errorText = connection.getErrorMessage();
            connection.disconnect();
            if (cvmo == null) {
                this.showError(String.format(Messages.SelectJobPage_16, status, this.errorText));
                return;
            }
            ArrayList<BatchLinkRow> jobList = new ArrayList<BatchLinkRow>();
            DebugMessage msg = cvmo.getMessage(1);
            if (msg instanceof StatusMessage) {
                StatusMessage statusmsg = (StatusMessage)msg;
                status = statusmsg.getStatus();
                if (status < 8) {
                    if (this.autoRefresh) {
                        this.autoRefreshError = statusmsg.getMessage();
                    } else {
                        this.showWarning(statusmsg.getMessage());
                    }
                } else if (this.autoRefresh) {
                    this.autoRefreshError = String.valueOf(Messages.SelectJobPage_17) + statusmsg.getMessage();
                } else {
                    this.showError(String.valueOf(Messages.SelectJobPage_17) + statusmsg.getMessage());
                }
            } else if (msg instanceof QueueListMessage) {
                String[] entrylist;
                QueueListMessage queuelist = (QueueListMessage)msg;
                status = queuelist.getResult();
                this.errorText = Messages.SelectJobPage_18;
                String[] stringArray = entrylist = queuelist.getEntries();
                int n = entrylist.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    String jobname = item.substring(0, 8);
                    String stepname = item.substring(8, 16);
                    String owner = item.substring(16, 24);
                    String program = item.substring(48, 56);
                    String imsUsr = "        ";
                    String imsTrx = "        ";
                    String ipName = null;
                    String sysId = null;
                    if (item.length() >= 83) {
                        imsUsr = item.substring(67, 75);
                        imsTrx = item.substring(75, 83);
                        if (item.length() >= 107) {
                            ipName = item.substring(99, 107);
                            sysId = item.substring(107, 115);
                        }
                    }
                    byte[] testForNullChars = imsUsr.getBytes();
                    if (imsUsr == null || testForNullChars[0] == 0) {
                        imsUsr = "        ";
                    }
                    testForNullChars = imsTrx.getBytes();
                    if (imsTrx == null || testForNullChars[0] == 0) {
                        imsTrx = "        ";
                    }
                    testForNullChars = ipName.getBytes();
                    if (ipName == null || testForNullChars[0] == 0) {
                        ipName = this.server.getHostname();
                    }
                    testForNullChars = sysId.getBytes();
                    if (sysId == null || testForNullChars[0] == 0) {
                        sysId = "        ";
                    }
                    BatchLinkRow rw = new BatchLinkRow(jobname, stepname, program, owner, imsUsr, imsTrx, ipName, sysId, item);
                    jobList.add(rw);
                    ++n2;
                }
                if (entrylist.length > 0) {
                    this.rowData.setRowlist(jobList);
                }
                this.tableViewer.setInput((Object)this.rowData);
                this.sortOnColumn(this.table.getSortColumn());
            } else {
                this.showError(Messages.SelectJobPage_20);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.showError(Messages.SelectJobPage_21);
        }
        this.setMessage(null, 1);
    }

    public boolean submitJob() {
        CVMI cvmi;
        BatchConnection connection;
        debugBatchSession session;
        block15: {
            String selection = this.getSelectedJob();
            if (selection == null) {
                this.isJobSelected = false;
                return false;
            }
            session = null;
            int ix = this.sessionslist.getSelectionIndex();
            if (ix < 0) {
                ix = 0;
            }
            if (ix == 0) {
                projectBatch wizard = new projectBatch();
                IWorkbench workbench = PlatformUI.getWorkbench();
                String jobname = selection.substring(0, 8);
                String stepname = selection.substring(8, 16);
                String name = String.format(Messages.SelectJobPage_22, jobname, stepname);
                wizard.init(workbench, this.server.getName(), name);
                Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                IntertestWizardDialog dialog = new IntertestWizardDialog(shell, (IWizard)wizard);
                dialog.create();
                ProjectCreationPage page = (ProjectCreationPage)wizard.getPage(ProjectCreationPage.PAGE_NAME);
                int result = dialog.open();
                if (result != 0) {
                    return false;
                }
                IProject project = page.getProject();
                session = (debugBatchSession)this.debug.getSession((IResource)project);
            } else {
                session = this.sessions.get(ix - 1);
            }
            String sToken = selection.substring(24, 48);
            session.setSToken(HexUtil.HextoBytes((String)sToken));
            if (session.getFileServer() == null || !this.server.getName().equalsIgnoreCase(session.getFileServer().getName())) {
                session.setFileServer(this.server);
            }
            ListQueueMessage queue = new ListQueueMessage();
            connection = new BatchConnection(this.server);
            try {
                connection.connect(true);
                this.setMessage(Messages.SelectJobPage_23, 1);
                cvmi = new CVMI();
                queue.setPort(IntertestPlugin.getDefault().getServerPort());
                queue.setUID(session.getUID().intValue());
                queue.setUserid(this.server.getUser());
                queue.setSelection(selection);
                ResourceProperty store = session.getStore();
                this.errorText = null;
                if (store.getBoolean("PL/I")) {
                    queue.setSubmessageID((short)1);
                }
                String endevorfile = store.getString("protsymEndevor");
                cvmi.addMessage((DebugMessage)queue);
                for (debugFile file : session.getMonitored(true)) {
                    cvmi.addMessage((DebugMessage)new MonitorMessage(file));
                }
                for (String item : session.getProtsymlist()) {
                    GDSNMessage msg = new GDSNMessage();
                    msg.setDSName(item);
                    if (item.equals(endevorfile)) {
                        if (store.getBoolean("settingsForceASM")) {
                            msg.setSubmessageID((short)257);
                        } else {
                            msg.setSubmessageID((short)1);
                        }
                    }
                    cvmi.addMessage((DebugMessage)msg);
                }
                session.setDebug();
                CVMO cvmo = connection.process(cvmi);
                if (connection.getErrorLevel() == 0 && cvmo != null) break block15;
                session.resetDebug();
                this.showError(String.format(Messages.SelectJobPage_24, connection.getErrorLevel(), connection.getErrorMessage()));
                connection.disconnect();
                return false;
            }
            catch (Exception e) {
                Logger.loggit(e);
                this.showError(Messages.SelectJobPage_26);
                return false;
            }
        }
        this.errorText = Messages.SelectJobPage_25;
        debugEvent event = new debugEvent((Object)cvmi, null);
        session.fireDebugMessageListeners(event);
        connection.disconnect();
        return true;
    }

    private void showError(String message) {
        this.errorText = message;
        MessageDialog.openError((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)message);
    }

    private void showWarning(String message) {
        this.errorText = message;
        MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)message);
    }

    private void showInformation(String message) {
        this.errorText = message;
        MessageDialog.openInformation((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)message);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.servers.equals(event.widget)) {
            this.refreshQueue();
        }
        this.getWizard().getContainer().updateButtons();
    }

    private String getSelectedJob() {
        String jobSelected = null;
        ISelection selection = this.tableViewer.getSelection();
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int cnt = objs.length;
        if (cnt > 0) {
            boolean serverFound;
            BatchLinkRow rw = (BatchLinkRow)objs[0];
            jobSelected = rw.getSelection();
            String ipName = rw.getIpName().trim();
            String sysId = rw.getSystemId().trim();
            if (!this.sameIPaddress(this.server.getHostname(), ipName) && !(serverFound = this.findCorrectServer(ipName, sysId))) {
                jobSelected = null;
            }
        }
        return jobSelected;
    }

    private boolean findCorrectServer(String ipName, String sysId) {
        boolean serverFound = false;
        int i = 0;
        while (!serverFound && i < this.serverlist.size()) {
            FileServer srvr = this.serverlist.get(i);
            if (srvr.getStatusText().equalsIgnoreCase("Available") && this.sameIPaddress(srvr.getHostname(), ipName)) {
                this.server = srvr;
                return true;
            }
            ++i;
        }
        if (!serverFound) {
            CVMO cvmo;
            BatchConnection connection;
            block13: {
                BlsEnqMessage enqMsg = new BlsEnqMessage();
                connection = new BatchConnection(this.server);
                connection.connect(true);
                this.setMessage("Finding Server", 1);
                CVMI cvmi = new CVMI();
                enqMsg.setEnqId(null);
                String ipAddr = InetAddress.getByName(ipName).getHostAddress();
                enqMsg.setLocalHost(ipAddr);
                this.errorText = null;
                cvmi.addMessage((DebugMessage)enqMsg);
                cvmo = connection.process(cvmi);
                if (connection.getErrorLevel() == 0 && cvmo != null) break block13;
                this.showError(String.format(Messages.SelectJobPage_33, sysId));
                this.setMessage(null);
                connection.disconnect();
                return false;
            }
            try {
                this.errorText = Messages.SelectJobPage_34;
                connection.disconnect();
                int statusRc = 0;
                String statusMsg = "";
                DebugMessage[] debugMessageArray = cvmo.getMessages();
                int n = debugMessageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugMessage message = debugMessageArray[n2];
                    switch (message.getMessageID()) {
                        case 51: {
                            BlsEnqMessage blsMsg = (BlsEnqMessage)message;
                            String port = blsMsg.getPort();
                            if (port == null || port.trim().length() == 0) {
                                port = blsMsg.getSysplexPort();
                            }
                            int portNum = Integer.parseInt(port);
                            String serverName = String.valueOf(sysId) + ":" + port;
                            this.server = new FileServer(serverName, ipName, portNum);
                            serverFound = true;
                            for (FileServer item : this.serverlist) {
                                if (!serverName.equalsIgnoreCase(item.getName())) continue;
                                ServerList.getInstance().removeServerElement(item);
                            }
                            ServerList.getInstance().addServerElement(this.server);
                            break;
                        }
                        case 18: {
                            StatusMessage smsg = (StatusMessage)message;
                            statusRc = smsg.getStatus();
                            statusMsg = smsg.getMessage();
                            this.showError(String.format(Messages.SelectJobPage_33, sysId, statusRc, statusMsg));
                            break;
                        }
                        default: {
                            statusMsg = String.format(Messages.SelectJobPage_35, sysId);
                            statusRc = 32;
                            this.showError(statusMsg);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
                this.showError(Messages.SelectJobPage_26);
            }
        }
        return serverFound;
    }

    private boolean sameIPaddress(String host1, String host2) {
        try {
            String ip1 = InetAddress.getByName(host1).getHostAddress();
            String ip2 = InetAddress.getByName(host2).getHostAddress();
            if (ip1.equalsIgnoreCase(ip2)) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void checkWidth(Composite parent) {
        if (this.width == null && parent != null) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[this.COLUMN_WIDTHS.length];
            int j = 0;
            while (j < this.COLUMN_WIDTHS.length) {
                this.width[j] = this.COLUMN_WIDTHS[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    private void createColumnSorter() {
        Table tab;
        if (this.tableViewer != null && (tab = this.tableViewer.getTable()) != null && !tab.isDisposed()) {
            TableColumn[] tableColumnArray = tab.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableColumn col = (TableColumn)e.widget;
                        Table t = col.getParent();
                        if (col.equals(t.getSortColumn())) {
                            t.setSortDirection(t.getSortDirection() == 128 ? 1024 : 128);
                        } else {
                            t.setSortColumn(col);
                            t.setSortDirection(128);
                        }
                        SelectJobPage.this.sortOnColumn(col);
                    }
                });
                ++n2;
            }
        }
    }

    private void sortOnColumn(TableColumn column) {
        if (column != null) {
            String columnName = column.getText();
            if (columnName.equalsIgnoreCase("Job Name")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<BatchLinkRow>(){

                    @Override
                    public int compare(BatchLinkRow r1, BatchLinkRow r2) {
                        return r1.getJobname().compareToIgnoreCase(r2.getJobname());
                    }
                });
            } else if (columnName.equalsIgnoreCase("Step Name")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<BatchLinkRow>(){

                    @Override
                    public int compare(BatchLinkRow r1, BatchLinkRow r2) {
                        return r1.getStepname().compareToIgnoreCase(r2.getStepname());
                    }
                });
            } else if (columnName.equalsIgnoreCase("Program")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<BatchLinkRow>(){

                    @Override
                    public int compare(BatchLinkRow r1, BatchLinkRow r2) {
                        return r1.getProgram().compareToIgnoreCase(r2.getProgram());
                    }
                });
            } else if (columnName.equalsIgnoreCase("Owner")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<BatchLinkRow>(){

                    @Override
                    public int compare(BatchLinkRow r1, BatchLinkRow r2) {
                        return r1.getOwner().compareToIgnoreCase(r2.getOwner());
                    }
                });
            } else if (columnName.equalsIgnoreCase("User ID")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<BatchLinkRow>(){

                    @Override
                    public int compare(BatchLinkRow r1, BatchLinkRow r2) {
                        return r1.getImsUserId().compareToIgnoreCase(r2.getImsUserId());
                    }
                });
            } else if (columnName.equalsIgnoreCase("Transaction")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<BatchLinkRow>(){

                    @Override
                    public int compare(BatchLinkRow r1, BatchLinkRow r2) {
                        return r1.getImsTransaction().compareToIgnoreCase(r2.getImsTransaction());
                    }
                });
            } else {
                Collections.sort(this.rowData.getRowlist(), new Comparator<BatchLinkRow>(){

                    @Override
                    public int compare(BatchLinkRow r1, BatchLinkRow r2) {
                        return r1.getSystemId().compareToIgnoreCase(r2.getSystemId());
                    }
                });
            }
            if (this.table != null && !this.table.isDisposed() && this.table.getSortDirection() == 1024) {
                Collections.reverse(this.rowData.getRowlist());
            }
            if (this.tableViewer != null) {
                this.tableViewer.refresh();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.isJobSelected = ((IStructuredSelection)this.tableViewer.getSelection()).toArray().length > 0;
        this.setErrorMessage(null);
        ((WizardDialog)this.wizard.getContainer()).updateButtons();
    }
}

