/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugMarkerGroup;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.wizards.BatchConfigWizard;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class BatchConfigPage
extends WizardPage
implements Listener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private debugMarkerGroup group = null;
    private Button monitor = null;
    private Button datamonitor;
    private boolean changed = false;
    IResource resource;
    debugFile item;
    String title;
    debugSession session;
    private SelectionListener selectionlistener;
    protected BatchConfigWizard wizard;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.batchConfigPage";

    public BatchConfigPage(String pageName) {
        super(pageName);
    }

    public BatchConfigPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.wizard = (BatchConfigWizard)this.getWizard();
        this.item = this.wizard.getDebugfile();
        this.group = this.item.getMarkergroup();
        this.session = this.item.getSession();
        this.selectionlistener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    BatchConfigPage.this.changed = true;
                    BatchConfigPage.this.wizard.getContainer().updateButtons();
                }
            }
        };
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 4, true, true));
        this.monitor = new Button(composite, 32);
        this.monitor.setSelection(this.item.isMonitor());
        this.monitor.setText(Messages.BatchConfigPage_1);
        this.monitor.setToolTipText(Messages.BatchConfigPage_2);
        this.monitor.addSelectionListener(this.selectionlistener);
        if (this.session.isBatch() && this.session.isDebugging() && this.monitor.getSelection()) {
            this.monitor.setEnabled(false);
        }
        String format = Messages.BatchConfigPage_3;
        String rbpTooltip = Messages.BatchConfigPage_4;
        IDebugMarker[] iDebugMarkerArray = this.group.getChildren();
        int n = iDebugMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugMarker marker = iDebugMarkerArray[n2];
            boolean enable = true;
            if (marker.getCommandID() != 64 || !(this.item instanceof debugFile) || this.item.getLanguage() == 32) {
                Button button = new Button(composite, 32);
                button.setText(String.format(format, marker.toString()));
                button.setToolTipText(String.format(rbpTooltip, marker.toString()));
                button.setSelection(marker.isEnabled());
                button.setData((Object)marker);
                button.setEnabled(enable);
                button.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.widget;
                        IDebugMarker marker = (IDebugMarker)button.getData();
                        marker.setEnabled(button.getSelection());
                        BatchConfigPage.this.changed = true;
                        BatchConfigPage.this.wizard.getContainer().updateButtons();
                    }
                });
            }
            ++n2;
        }
        if (this.item.getLanguage() == 32) {
            this.datamonitor = new Button(composite, 32);
            this.datamonitor.setSelection(this.item.isDataMonitor());
            this.datamonitor.setText(Messages.BatchConfigPage_5);
            this.datamonitor.setToolTipText(Messages.BatchConfigPage_6);
            this.datamonitor.setSelection(this.item.isDataMonitor());
            this.datamonitor.addSelectionListener(this.selectionlistener);
        }
        parent.setSize(parent.computeSize(-1, -1));
        this.setControl((Control)composite);
        this.setPageComplete(this.validatePage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.batchConfigPage");
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        if (!this.session.isStatementTrace() && this.datamonitor != null && this.datamonitor.getSelection()) {
            this.setMessage(Messages.BatchConfigPage_7, 2);
        }
        return this.changed;
    }

    public boolean doFinish() {
        this.group.cleanEnable();
        this.group.checkChanged();
        this.group.save();
        if (this.monitor != null) {
            this.item.setMonitor(this.monitor.getSelection());
        }
        if (this.datamonitor != null) {
            this.item.setDataMonitor(this.datamonitor.getSelection());
        }
        return true;
    }

    public void handleEvent(Event event) {
    }

    public boolean isPageComplete() {
        return this.validatePage();
    }
}

