/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.ui.views.data.AbstractColumnLabelProvider;

public class PropertyColumnLabelProvider
extends AbstractColumnLabelProvider {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String CORE_WORD = "Memory";
    private String sFsiz;
    private int fsiz;

    public PropertyColumnLabelProvider(IDebug debugitem) {
        super(debugitem);
    }

    @Override
    public String getText(Object element) {
        String ix;
        String pic;
        String str;
        String key;
        TreeObject parent;
        boolean dsflag;
        TreeObject treeobject = (TreeObject)element;
        if (this.isExpression(treeobject)) {
            return CORE_WORD + Messages.PropertyColumnLabelProvider_1 + treeobject.getAlternateName();
        }
        boolean bl = dsflag = treeobject.getKeyword() != null;
        if (!dsflag && (parent = treeobject.getParent()) != null) {
            dsflag = parent.getKeyword() != null;
        }
        this.fsiz = (Integer)Attribute.getValue("length", treeobject);
        this.sFsiz = "[" + String.valueOf(this.fsiz) + "]";
        String value = "";
        String arrayTag = "";
        String picTag = "";
        Integer[] idxs = new Integer[7];
        int i = 0;
        while (i < 7) {
            key = "gt_dmax" + String.valueOf(i + 1);
            str = treeobject.getAttribute(key);
            idxs[i] = str.length() > 0 ? Integer.valueOf(str) : Integer.valueOf(0);
            ++i;
        }
        if (this.lang == 128) {
            i = 0;
            while (i < 7) {
                key = "pl1arlb" + String.valueOf(i + 1);
                str = treeobject.getAttribute(key);
                if (str.length() > 0) {
                    int n = i;
                    idxs[n] = idxs[n] - (Integer.valueOf(str) - 1);
                }
                ++i;
            }
        }
        if (idxs[0] > 0) {
            arrayTag = " OCCURS (" + String.valueOf(idxs[0]);
            i = 1;
            while (i < 7) {
                if (idxs[i] == 0) {
                    i = 7;
                } else {
                    arrayTag = String.valueOf(arrayTag) + "," + String.valueOf(idxs[i]);
                }
                ++i;
            }
            arrayTag = String.valueOf(arrayTag) + ")";
        }
        if ((pic = (String)Attribute.getValue("gt_pic", treeobject)).length() > 0) {
            picTag = pic;
        }
        if (dsflag || this.lang == 16) {
            value = this.propertiesASM(treeobject);
        } else if (this.lang == 32) {
            value = this.propertiesCOB(treeobject, picTag);
            if (value.length() == 0 && (ix = treeobject.getAttribute("gt_dstyp")).equals("f0")) {
                value = "Index";
                this.sFsiz = "";
            }
        } else {
            value = this.propertiesPL1(treeobject, picTag);
            if (value.length() == 0 && (ix = treeobject.getAttribute("gt_pvltp")).equals("40")) {
                value = Messages.PropertyColumnLabelProvider_19;
            }
        }
        return String.format("%s %s%s", value, this.sFsiz, arrayTag).trim();
    }

    protected String propertiesASM(TreeObject treeobject) {
        String value = "";
        Integer dptyp = (Integer)Attribute.getValue("gt_dptyp", treeobject);
        switch (dptyp) {
            case 0: {
                value = "DSECT";
                break;
            }
            case 193: {
                value = Messages.PropertyColumnLabelProvider_0;
                break;
            }
            case 194: {
                value = Messages.PropertyColumnLabelProvider_25;
                break;
            }
            case 195: {
                value = Messages.PropertyColumnLabelProvider_26;
                break;
            }
            case 196: {
                value = Messages.PropertyColumnLabelProvider_27;
                break;
            }
            case 197: {
                value = Messages.PropertyColumnLabelProvider_28;
                break;
            }
            case 198: {
                value = Messages.PropertyColumnLabelProvider_29;
                break;
            }
            case 199: {
                value = Messages.PropertyColumnLabelProvider_30;
                break;
            }
            case 200: {
                value = Messages.PropertyColumnLabelProvider_31;
                break;
            }
            case 210: {
                value = Messages.PropertyColumnLabelProvider_32;
                break;
            }
            case 211: {
                value = Messages.PropertyColumnLabelProvider_33;
                break;
            }
            case 215: {
                value = Messages.PropertyColumnLabelProvider_34;
                break;
            }
            case 216: {
                value = Messages.PropertyColumnLabelProvider_35;
                break;
            }
            case 217: {
                value = Messages.PropertyColumnLabelProvider_36;
                break;
            }
            case 226: {
                value = Messages.PropertyColumnLabelProvider_37;
                break;
            }
            case 229: {
                value = Messages.PropertyColumnLabelProvider_38;
                break;
            }
            case 231: {
                value = Messages.PropertyColumnLabelProvider_39;
                break;
            }
            case 232: {
                value = Messages.PropertyColumnLabelProvider_40;
                break;
            }
            case 233: {
                value = Messages.PropertyColumnLabelProvider_41;
            }
        }
        return value;
    }

    protected String propertiesCOB(TreeObject treeobject, String pic) {
        String value = "";
        Integer dptyp = (Integer)Attribute.getValue("gt_dptyp", treeobject);
        switch (dptyp) {
            case 1: {
                value = Messages.PropertyColumnLabelProvider_44;
                break;
            }
            case 2: {
                value = Messages.PropertyColumnLabelProvider_45;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
                break;
            }
            case 3: {
                value = Messages.PropertyColumnLabelProvider_49;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
                break;
            }
            case 4: {
                value = Messages.PropertyColumnLabelProvider_53;
                break;
            }
            case 5: {
                value = Messages.PropertyColumnLabelProvider_54;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
                break;
            }
            case 6: {
                value = Messages.PropertyColumnLabelProvider_58;
                break;
            }
            case 7: {
                value = Messages.PropertyColumnLabelProvider_59;
                break;
            }
            case 8: {
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic;
                this.sFsiz = "";
                break;
            }
            case 9: {
                value = Messages.PropertyColumnLabelProvider_62;
                break;
            }
            case 10: {
                value = Messages.PropertyColumnLabelProvider_63;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
                break;
            }
            case 11: {
                value = Messages.PropertyColumnLabelProvider_67;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
                break;
            }
            case 12: {
                value = Messages.PropertyColumnLabelProvider_71;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
                break;
            }
            case 13: {
                value = Messages.PropertyColumnLabelProvider_75;
                break;
            }
            case 14: {
                value = Messages.PropertyColumnLabelProvider_76;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
                break;
            }
            case 15: {
                value = Messages.PropertyColumnLabelProvider_80;
                break;
            }
            case 16: {
                value = Messages.PropertyColumnLabelProvider_81;
                break;
            }
            case 17: {
                value = Messages.PropertyColumnLabelProvider_82;
                break;
            }
            case 32: {
                value = Messages.PropertyColumnLabelProvider_83;
                break;
            }
            case 48: {
                value = Messages.PropertyColumnLabelProvider_84;
                break;
            }
            case 64: {
                value = Messages.PropertyColumnLabelProvider_85;
                break;
            }
            case 80: {
                value = Messages.PropertyColumnLabelProvider_86;
                break;
            }
            case 96: {
                value = Messages.PropertyColumnLabelProvider_87;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_46) + pic + " " + value;
                this.sFsiz = "";
            }
        }
        return value;
    }

    protected String propertiesPL1(TreeObject treeobject, String pic) {
        int iPvdes = (Integer)Attribute.getValue("gt_pvdes", treeobject);
        int iPrec = (Integer)Attribute.getValue("gt_prec", treeobject);
        int iScale = (Integer)Attribute.getValue("gt_scale", treeobject);
        if (iScale > 127) {
            iScale -= 256;
        }
        String value = "";
        Integer pvdtp = (Integer)Attribute.getValue("gt_pvdtp", treeobject);
        switch (pvdtp) {
            case 4: {
                value = Messages.PropertyColumnLabelProvider_96;
                String prefix = Messages.PropertyColumnLabelProvider_97;
                if ((iPvdes & 2) != 0) {
                    prefix = Messages.PropertyColumnLabelProvider_98;
                }
                if (iPrec <= 0) break;
                String str = iScale != 0 ? "," + String.valueOf(iScale) : "";
                value = String.valueOf(prefix) + Messages.PropertyColumnLabelProvider_101 + String.valueOf(iPrec) + str + ")";
                this.sFsiz = "";
                break;
            }
            case 8: {
                value = Messages.PropertyColumnLabelProvider_104;
                String prefix = Messages.PropertyColumnLabelProvider_97;
                String suffix = "";
                if ((iPvdes & 2) != 0) {
                    prefix = Messages.PropertyColumnLabelProvider_98;
                }
                if ((iPvdes & 1) != 0) {
                    suffix = Messages.PropertyColumnLabelProvider_151;
                }
                if ((iPvdes & 0x10) != 0) {
                    suffix = Messages.PropertyColumnLabelProvider_109;
                }
                if (iPrec <= 0) break;
                String str = iScale != 0 ? "," + String.valueOf(iScale) : "";
                value = String.valueOf(prefix) + Messages.PropertyColumnLabelProvider_112 + String.valueOf(iPrec) + str + ")" + suffix;
                this.sFsiz = "";
                break;
            }
            case 16: {
                int iFsiz = this.fsiz;
                String suffix = "";
                if ((iPvdes & 2) != 0) {
                    String string = Messages.PropertyColumnLabelProvider_116;
                }
                if ((iPvdes & 1) != 0) {
                    suffix = Messages.PropertyColumnLabelProvider_117;
                    iFsiz -= 2;
                } else if ((iPvdes & 0x10) != 0) {
                    suffix = Messages.PropertyColumnLabelProvider_118;
                    --iFsiz;
                }
                value = String.valueOf(Messages.PropertyColumnLabelProvider_119) + String.valueOf(iFsiz) + ")" + suffix;
                this.sFsiz = "";
                break;
            }
            case 32: {
                value = Messages.PropertyColumnLabelProvider_122;
                int iPvigl = 0;
                int iPvigr = 0;
                String pvigl = treeobject.getAttribute("gt_pvigl");
                String pvigr = treeobject.getAttribute("gt_pvigr");
                if (pvigl.length() <= 0) break;
                iPvigl = Integer.valueOf(pvigl);
                if (pvigr.length() <= 0) break;
                iPvigr = Integer.valueOf(pvigr);
                int len = 8 * this.fsiz - (iPvigl + iPvigr);
                value = String.valueOf(Messages.PropertyColumnLabelProvider_125) + String.valueOf(len) + ")";
                this.sFsiz = "";
                break;
            }
            case 64: 
            case 80: {
                value = Messages.PropertyColumnLabelProvider_128;
                if (pic.length() <= 0) break;
                value = String.valueOf(Messages.PropertyColumnLabelProvider_129) + pic;
                this.sFsiz = "";
                break;
            }
            case 0: {
                String pvltp = treeobject.getAttribute(Messages.PropertyColumnLabelProvider_131);
                if (pvltp.length() <= 0) break;
                int iPvltp = Integer.parseInt(pvltp, 16);
                switch (iPvltp) {
                    case 1: {
                        value = Messages.PropertyColumnLabelProvider_132;
                        this.sFsiz = "";
                        break;
                    }
                    case 2: {
                        value = Messages.PropertyColumnLabelProvider_134;
                        this.sFsiz = "";
                        break;
                    }
                    case 4: {
                        value = Messages.PropertyColumnLabelProvider_136;
                        this.sFsiz = "";
                        break;
                    }
                    case 16: {
                        value = Messages.PropertyColumnLabelProvider_138;
                        this.sFsiz = "";
                        break;
                    }
                    case 32: {
                        value = Messages.PropertyColumnLabelProvider_140;
                        this.sFsiz = "";
                        break;
                    }
                    case 64: {
                        value = Messages.PropertyColumnLabelProvider_142;
                        this.sFsiz = "";
                    }
                }
                break;
            }
            case 128: {
                int jFsiz = this.fsiz;
                String suffix = "";
                if ((iPvdes & 2) != 0) {
                    String string = Messages.PropertyColumnLabelProvider_145;
                }
                if ((iPvdes & 1) != 0) {
                    suffix = Messages.PropertyColumnLabelProvider_146;
                    jFsiz -= 2;
                } else if ((iPvdes & 0x10) != 0) {
                    suffix = Messages.PropertyColumnLabelProvider_147;
                    jFsiz -= 2;
                }
                value = String.valueOf(Messages.PropertyColumnLabelProvider_148) + String.valueOf(jFsiz /= 2) + ")" + suffix;
                this.sFsiz = "";
            }
        }
        return value;
    }
}

