/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.ASMBaseRegisters;
import com.ca.intertest.common.ASMVariable;
import com.ca.intertest.common.Expressions;
import com.ca.intertest.common.Keywords;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.Structures;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.VariableArrays;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.tools.DataRequestMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.ViewData;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class KeepViewData
extends ViewData {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected IResourceChangeListener resourcelistener;
    private IDebugListener debuglistener;

    public KeepViewData(IResource resource, AbstractDataViewPage viewpage) {
        super(resource, viewpage);
        this.refreshed = false;
        this.resourcelistener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] markerdeltas = event.findMarkerDeltas("com.ca.intertest.keep", false);
                TreeObject[] objects = null;
                IMarkerDelta[] iMarkerDeltaArray = markerdeltas;
                int n = markerdeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta element = iMarkerDeltaArray[n2];
                    if (element.getResource().equals((Object)KeepViewData.this.debugitem.getResource())) {
                        IMarker marker = element.getMarker();
                        switch (element.getKind()) {
                            case 1: {
                                TreeObject item;
                                TreeObject[] treeObjectArray = objects = KeepViewData.this.makeTreeObjects(marker);
                                int n3 = objects.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    item = treeObjectArray[n4];
                                    if (!KeepViewData.this.isDuplicate(item)) {
                                        item.setAttribute(KeepViewData.this.UniqueKey, Long.toString(marker.getId()));
                                        if (KeepViewData.this.addObject(item)) {
                                            KeepViewData.this.fetchBackingData(item);
                                        }
                                    }
                                    ++n4;
                                }
                                break;
                            }
                            case 2: {
                                TreeObject item;
                                TreeObject[] treeObjectArray = objects = KeepViewData.this.getTreeObjects(element.getAttribute("name", ""));
                                int n3 = objects.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    item = treeObjectArray[n4];
                                    KeepViewData.this.removeObject(item);
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            (this).KeepViewData.this.viewer.remove((Object)item);
                                        }
                                    });
                                    ++n4;
                                }
                                break;
                            }
                        }
                        KeepViewData.this.refreshViewer();
                    }
                    ++n2;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourcelistener, 1);
        this.debuglistener = new IDebugListener(){

            @Override
            public void debugEventOccured(final debugEvent event) {
                if (KeepViewData.this.viewer.getControl().isDisposed()) {
                    return;
                }
                Display display = Display.getDefault();
                if (display != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object source = event.getSource();
                            if (source instanceof CVMO && !(this).KeepViewData.this.refreshed) {
                                KeepViewData.this.fetchBackingData(true);
                            } else if (source instanceof CVMI) {
                                for (TreeObject item : (this).KeepViewData.this.keepObjects) {
                                    item.nullBackingdata();
                                }
                            }
                        }
                    });
                }
            }
        };
        this.debugitem.addDebugListener(this.debuglistener);
    }

    @Override
    public void sendMemoryMessage(TreeObject treeobject, TreeObject parent) {
        this.refreshed = true;
        int lth = 0;
        int offset = (Integer)Attribute.getValue("structureoffset", treeobject);
        DataRequestMessage msg = null;
        if (this.session.isAtBreakpoint()) {
            TreeObject tree = parent == null ? treeobject : parent;
            String varName = tree.getName();
            if (this.session.isCICS() && tree instanceof ASMVariable && !((String)Attribute.getValue("asmlbl", treeobject)).equals("true")) {
                ListerEditor lister = this.viewpage.getEditor();
                if (lister == null) {
                    varName = "";
                } else {
                    int bpstmt = lister.getBPStatement();
                    if (bpstmt == 0) {
                        varName = "";
                    } else {
                        ASMBaseRegisters breg = new ASMBaseRegisters(this.viewpage.getEditor());
                        varName = breg.getBaseRegister(tree, offset);
                    }
                }
                if (varName.length() == 0) {
                    String msgText = String.valueOf(Messages.KeepViewData_8) + tree.getName() + Messages.KeepViewData_9;
                    Logger.loggit(0, msgText);
                    return;
                }
            }
            try {
                msg = new DataRequestMessage(3);
                msg.setProgram(this.debugitem.getName());
                int stmt = (Integer)Attribute.getValue("statementnumber", tree);
                msg.setStmt(stmt);
                msg.setVarName(varName);
                lth = (Integer)Attribute.getValue("length", tree);
                if ((Integer)Attribute.getValue("gt_dmax1", tree) > 0) {
                    Integer[] idxs = new Integer[]{0};
                    int max = VariableArrays.getArrayLth(tree, idxs, 3);
                    int min = VariableArrays.getArrayLth(tree, idxs, 1);
                    lth += max - min;
                }
                msg.setDataLength(lth);
                this.cvmiPacket.addMessage((DebugMessage)msg);
                ++this.msgcnt;
                this.fetchObjects.add(tree);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    public TreeObject getKeywordObject(String name, IMarker marker) {
        TreeObject treeobject = null;
        if (name == null || name.trim().length() < 1) {
            return treeobject;
        }
        String servertype = marker.getAttribute("servertype", "");
        String keeptype = marker.getAttribute("keeptype", "");
        String version = marker.getAttribute("serverversion", "");
        String keyword = marker.getAttribute("keyword", "");
        String altname = marker.getAttribute("altname", "");
        try {
            if (keeptype.equals("DATAVIEW_EXPRESSION")) {
                treeobject = Expressions.getTree(keyword, "CORE_EXPRESSION");
            } else {
                treeobject = version.length() > 0 ? Keywords.getTree(keyword, servertype, version) : Structures.getTree(altname, 1, this.session);
                treeobject.setAttribute("dataflag", "DATAVIEW_KEYWORD");
            }
            treeobject.setAlternateName(altname);
            treeobject.setKeyword(keyword);
            treeobject.setAttribute("isclean", "true");
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return treeobject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TreeObject[] makeTreeObjects(IMarker marker) {
        if (!marker.exists() || !marker.getAttribute("enabled", true)) return new TreeObject[0];
        if (marker.getAttribute("keeptype", "").equals("DATAVIEW_EXPRESSION") || marker.getAttribute("keeptype", "").equals("DATAVIEW_KEYWORD")) {
            String postView = marker.getAttribute("postview", "");
            if (postView.length() != 0 && !postView.equals("com.ca.intertest.ui.views.dataview")) return new TreeObject[0];
            TreeObject treeobject = this.getKeywordObject(marker.getAttribute("name", ""), marker);
            if (treeobject == null) return new TreeObject[0];
            return new TreeObject[]{treeobject};
        }
        String key = marker.getAttribute("name", "");
        if (key.equals("FILLER")) return new TreeObject[0];
        TreeObject treeobject = this.viewpage.getOutline().getPostedTreeObject(key, 0);
        if (treeobject != null) {
            treeobject.setAlternateName(marker.getAttribute("altname", ""));
            if (marker.getAttribute("altname", "").length() <= 0) return new TreeObject[]{treeobject};
            try {
                return new TreeObject[]{(TreeObject)treeobject.clone()};
            }
            catch (Exception e) {
                Logger.loggit(e);
                return new TreeObject[0];
            }
        }
        try {
            marker.setAttribute("enabled", false);
            return new TreeObject[0];
        }
        catch (CoreException coreException) {}
        return new TreeObject[0];
    }

    @Override
    public TreeObject[] findObjects(String name) {
        return null;
    }

    @Override
    public boolean deleteObject(TreeObject treeobject) {
        boolean result = false;
        String markerid = treeobject.getAttribute(this.getUniqueKey());
        if (markerid != null) {
            try {
                long id = Long.parseLong(markerid);
                IMarker marker = this.debugitem.getResource().getMarker(id);
                if (marker != null && marker.exists()) {
                    marker.delete();
                    result = true;
                }
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        return result;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        try {
            IMarker[] markers;
            this.refreshed = true;
            this.keepObjects.clear();
            IMarker[] iMarkerArray = markers = this.debugitem.getResource().findMarkers("com.ca.intertest.keep", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                TreeObject[] objects;
                IMarker marker = iMarkerArray[n2];
                TreeObject[] treeObjectArray = objects = this.makeTreeObjects(marker);
                int n3 = objects.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeObject item = treeObjectArray[n4];
                    item.setAttribute(this.UniqueKey, Long.toString(marker.getId()));
                    this.addObject(item);
                    this.refreshed = false;
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        this.fetchBackingData(false);
        return this.keepObjects.toArray(new Object[this.keepObjects.size()]);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected TreeObject[] getTreeObjects(String name) {
        ArrayList<TreeObject> list = new ArrayList<TreeObject>();
        Outline outline = this.viewpage.getOutline();
        for (TreeObject item : this.keepObjects) {
            boolean exprFlag = item.getAttribute("dataflag").equals("CORE_EXPRESSION");
            if (item.getType() != 1 && !exprFlag) continue;
            String keepname = "";
            keepname = item.getType() == 1 ? outline.getQualifiedName(item) : item.getName();
            if (!name.equals(keepname)) continue;
            list.add(item);
        }
        return list.toArray(new TreeObject[list.size()]);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourcelistener);
        this.debugitem.removeDebugListener(this.debuglistener);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.debugitem.equals(event.getSource()) && "com.ca.intertest.property.outline".equals(event.getProperty())) {
            this.refreshViewer();
        }
        super.propertyChange(event);
    }

    private void refreshViewer() {
        Display display = this.viewpage.getSite().getShell().getDisplay();
        if (display != null) {
            this.refreshed = false;
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Object[] elements = KeepViewData.this.viewer.getExpandedElements();
                    TreePath[] treePaths = KeepViewData.this.viewer.getExpandedTreePaths();
                    KeepViewData.this.fetchBackingData(true);
                    KeepViewData.this.viewer.refresh();
                    KeepViewData.this.viewer.setExpandedElements(elements);
                    KeepViewData.this.viewer.setExpandedTreePaths(treePaths);
                }
            });
        }
    }
}

