/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.Messages;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public abstract class AbstractDataViewPageBook
extends PageBookView {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final String COL_ORDER = "column_order";
    public static final String COL_WIDTH = "column_width";
    public static final String COL_COUNT = "column_count";
    public static final String VARIABLE_COLUMN = Messages.AbstractDataViewPageBook_3;
    public static final String NON_HEX_COLUMN = Messages.AbstractDataViewPageBook_4;
    public static final String HEX_COLUMN = Messages.AbstractDataViewPageBook_5;
    public static final String PROPERTIES_COLUMN = Messages.AbstractDataViewPageBook_6;
    public static final int VARIABLE = 0;
    public static final int VALUE = 1;
    public static final int HEXVALUE = 2;
    public static final int PROPERTIES = 3;
    public static final String[] labels = new String[]{VARIABLE_COLUMN, NON_HEX_COLUMN, HEX_COLUMN, PROPERTIES_COLUMN};
    public static final int[] styles = new int[]{16384, 16384, 16384, 16384};
    protected int[] Column_width = new int[]{10, 15, 15, 20};
    protected Object myself;
    protected boolean active = true;
    protected int[] order;
    private int[] width;

    public AbstractDataViewPageBook() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.order = nArray;
        this.width = null;
        this.myself = this;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            Integer count = memento.getInteger(COL_COUNT);
            if (count == null) {
                count = this.order.length;
            }
            if (count == this.order.length) {
                int i;
                String colstring = memento.getString(COL_ORDER);
                if (colstring != null) {
                    String[] colorder = colstring.split(";");
                    this.order = new int[colorder.length];
                    i = 0;
                    while (i < colorder.length) {
                        this.order[i] = Integer.parseInt(colorder[i]);
                        ++i;
                    }
                }
                if ((colstring = memento.getString(COL_WIDTH)) != null) {
                    String[] colwidth = colstring.split(";");
                    this.width = new int[colwidth.length];
                    i = 0;
                    while (i < colwidth.length) {
                        this.width[i] = Integer.parseInt(colwidth[i]);
                        ++i;
                    }
                }
            }
        }
        super.init(site, memento);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new IPerspectiveListener2(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
                IWorkbenchPart part = partRef.getPart(false);
                if (AbstractDataViewPageBook.this.myself == part) {
                    if ("viewShow".equals(changeId)) {
                        AbstractDataViewPageBook.this.active = true;
                    } else if ("viewHide".equals(changeId)) {
                        AbstractDataViewPageBook.this.active = false;
                    }
                    return;
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        memento.putInteger(COL_COUNT, this.order.length);
        StringBuilder colstring = new StringBuilder();
        int[] nArray = this.order;
        int n = this.order.length;
        int n2 = 0;
        while (n2 < n) {
            int item = nArray[n2];
            colstring.append(String.format("%d;", item));
            ++n2;
        }
        colstring.setLength(colstring.length() - 1);
        memento.putString(COL_ORDER, colstring.toString());
        colstring = new StringBuilder();
        if (this.width != null) {
            nArray = this.width;
            n = this.width.length;
            n2 = 0;
            while (n2 < n) {
                int col = nArray[n2];
                colstring.append(String.format("%d;", col));
                ++n2;
            }
            colstring.setLength(colstring.length() - 1);
            memento.putString(COL_WIDTH, colstring.toString());
        }
        super.saveState(memento);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    public int[] getOrder() {
        return this.order;
    }

    public void setOrder(int[] order) {
        this.order = order;
    }

    public int[] getWidth() {
        this.checkWidth();
        return this.width;
    }

    protected abstract Class<?> getPageClass();

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.setMessage(Messages.AbstractDataViewPageBook_no_info);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        this.checkWidth();
        IPageBookViewPage page = (IPageBookViewPage)part.getAdapter(this.getPageClass());
        if (page != null) {
            this.initPage(page);
            if (page instanceof AbstractDataViewPage) {
                ((AbstractDataViewPage)page).setPagebook(this);
            }
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void checkWidth() {
        PageBook pagebook;
        if (this.width == null && (pagebook = this.getPageBook()) != null) {
            Composite control = pagebook.getParent();
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[this.Column_width.length];
            int j = 0;
            while (j < this.Column_width.length) {
                this.width[j] = this.Column_width[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        IPage obj = pageRec.page;
        if (obj instanceof AbstractDataViewPage) {
            ((AbstractDataViewPage)obj).reSize();
        }
    }

    public boolean isActive() {
        return this.active;
    }
}

