/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.util;

import com.ca.intertest.common.Outline;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IScanSource;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public abstract class AbstractTextHover
implements ITextHover {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected Outline outline = null;
    protected IScanSource scanner = null;
    protected HashMap<String, ArrayList<TreeObject>> names = null;

    public AbstractTextHover(IScanSource scanner, Outline outline) {
        this.outline = outline;
        this.scanner = scanner;
        this.names = outline.getNames();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String text = null;
        String hoverText = null;
        try {
            IDocument document = textViewer.getDocument();
            IRegion region = document.getLineInformationOfOffset(hoverRegion.getOffset());
            text = document.get(region.getOffset(), region.getLength());
            int start = hoverRegion.getOffset() - region.getOffset();
            String token = this.getToken(text, start, region.getLength());
            if (token != null) {
                hoverText = this.getHoverText(token, document);
            }
            if (hoverText != null) {
                hoverText = HexUtil.Squeeze((String)hoverText);
            }
        }
        catch (BadLocationException badLocationException) {}
        return hoverText != null && hoverText.length() > 0 ? hoverText : null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument document = textViewer.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String text = document.get(region.getOffset(), region.getLength());
            if (this.scanner.isExecuteCode(text)) {
                return new Region(offset, 0);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected abstract String getHoverText(String var1, IDocument var2);

    public abstract char[] getDelimiters();

    protected String getToken(String text, int offset, int length) {
        String token;
        int x;
        int right_delim = 0;
        int left_delim = 0;
        char[] delimiters = this.getDelimiters();
        int i = offset;
        while (i >= 0) {
            text.charAt(i);
            x = 0;
            while (x < delimiters.length) {
                if (text.charAt(i) == delimiters[x]) {
                    left_delim = i + 1;
                    i = -1;
                    break;
                }
                ++x;
            }
            --i;
        }
        int j = offset;
        while (j < length) {
            right_delim = j;
            text.charAt(j);
            x = 0;
            while (x < delimiters.length) {
                if (text.charAt(j) == delimiters[x]) {
                    j = length;
                    break;
                }
                ++x;
            }
            ++j;
        }
        if (left_delim > right_delim) {
            return null;
        }
        if (length - right_delim == 1) {
            ++right_delim;
        }
        if ((token = text.substring(left_delim, right_delim)) != null && token.length() > 0) {
            return token;
        }
        return null;
    }
}

