/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.scanASM;
import com.ca.intertest.tools.scanCOBOL;
import com.ca.intertest.tools.scanPLI;
import com.ca.intertest.ui.actions.RulerConfigureBPaction;
import com.ca.intertest.ui.lister.ListerDocumentProvider;
import com.ca.intertest.ui.lister.asm.AsmPartitioner;
import com.ca.intertest.ui.lister.asm.AsmScanner;
import com.ca.intertest.ui.lister.asm.AsmSourceViewerConfiguration;
import com.ca.intertest.ui.lister.cobol.CobolPartitioner;
import com.ca.intertest.ui.lister.cobol.CobolScanner;
import com.ca.intertest.ui.lister.cobol.CobolSourceViewerConfiguration;
import com.ca.intertest.ui.lister.pli.PLIPartitioner;
import com.ca.intertest.ui.lister.pli.PLIScanner;
import com.ca.intertest.ui.lister.pli.PLISourceViewerConfiguration;
import com.ca.intertest.ui.views.backtrace.BacktracePage;
import com.ca.intertest.ui.views.breakpoint.BreakpointPage;
import com.ca.intertest.ui.views.calltrace.CalltracePage;
import com.ca.intertest.ui.views.data.AutoDataViewPage;
import com.ca.intertest.ui.views.data.DataViewPage;
import com.ca.intertest.ui.views.data.RegisterViewPage;
import com.ca.intertest.ui.views.data.SessionViewPage;
import com.ca.intertest.ui.views.outline.OutlinePage;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ListerEditor
extends TextEditor
implements IShowInSource,
IDocumentListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private int lang;
    private Image image;
    private IDocumentProvider provider;
    private IDocument document;
    private boolean intertest = false;
    private IResource resource;
    private debugFile debugfile;
    private IScanSource scansource;
    private Outline outline;
    private ResourceProperty store;
    private int laststatement = 0;
    private int currbpstatement = 0;
    private DebugListener debugListener = new DebugListener();
    private Annotation currentIP = null;
    private static final String CONTEXT_HELP_ID = "com.ca.intertest.lister";

    public ListerEditor() {
        this.provider = new ListerDocumentProvider();
        this.setDocumentProvider(this.provider);
        this.doGetSelection();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.resource = (IResource)input.getAdapter(IFile.class);
        if (this.resource instanceof IFile) {
            super.init(site, input);
            this.document = this.provider.getDocument((Object)input);
            Debug debug = Debug.getInstance();
            this.debugfile = (debugFile)debug.getResource(this.resource);
            if (this.debugfile != null) {
                this.intertest = true;
                this.store = this.debugfile.getStore();
            }
        }
    }

    public void createPartControl(Composite parent) {
        Object obj;
        this.setHelpContextId(CONTEXT_HELP_ID);
        this.setupEditor();
        super.createPartControl(parent);
        if (this.document != null) {
            this.document.addDocumentListener((IDocumentListener)this);
        }
        this.getSourceViewer().setEditable(false);
        if (this.debugListener == null) {
            this.debugListener = new DebugListener();
        }
        if (this.debugfile != null && (obj = this.debugfile.getParent()) instanceof debugSession) {
            this.debugfile.addDebugListener(this.debugListener);
        }
    }

    private void createCobolPartControl() {
        IScanSource sc = this.getScansource();
        if (!(sc instanceof scanCOBOL)) {
            sc = new scanCOBOL(this.store.getString("gt_m_cty"));
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new CobolSourceViewerConfiguration(this.getPreferenceStore(), (scanCOBOL)sc, this.outline));
        CobolScanner scanner = new CobolScanner(sc);
        CobolPartitioner partitioner = new CobolPartitioner(scanner);
        if (this.document instanceof IDocumentExtension3) {
            IDocumentExtension3 docExt3 = (IDocumentExtension3)this.document;
            IDocumentPartitioner oldpart = docExt3.getDocumentPartitioner("__source_code_partitioning");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__source_code_partitioning", (IDocumentPartitioner)partitioner);
            oldpart = docExt3.getDocumentPartitioner("__dflt_position_category");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__dflt_position_category", (IDocumentPartitioner)partitioner);
        } else {
            IDocumentPartitioner oldpart = this.document.getDocumentPartitioner();
            if (oldpart != null) {
                oldpart.disconnect();
            }
        }
        partitioner.connect(this.document, false, this);
    }

    private void createAsmPartControl() {
        IScanSource sa = this.getScansource();
        if (!(sa instanceof scanASM)) {
            sa = new scanASM(this.store.getString("gt_m_aty"));
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AsmSourceViewerConfiguration(this.getPreferenceStore(), (scanASM)sa, this.outline));
        AsmScanner scanner = new AsmScanner(sa);
        AsmPartitioner partitioner = new AsmPartitioner(scanner);
        if (this.document instanceof IDocumentExtension3) {
            IDocumentExtension3 docExt3 = (IDocumentExtension3)this.document;
            IDocumentPartitioner oldpart = docExt3.getDocumentPartitioner("__source_code_partitioning");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__source_code_partitioning", (IDocumentPartitioner)partitioner);
            oldpart = docExt3.getDocumentPartitioner("__dflt_position_category");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__dflt_position_category", (IDocumentPartitioner)partitioner);
        } else {
            IDocumentPartitioner oldpart = this.document.getDocumentPartitioner();
            if (oldpart != null) {
                oldpart.disconnect();
            }
        }
        partitioner.connect(this.document, false, this);
    }

    private void createPLIPartControl() {
        IScanSource pa = this.getScansource();
        if (!(pa instanceof scanPLI)) {
            pa = new scanPLI(this.store.getString("gt_m_aty"));
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new PLISourceViewerConfiguration(this.getPreferenceStore(), (scanPLI)pa, this.outline));
        PLIScanner scanner = new PLIScanner(pa);
        PLIPartitioner partitioner = new PLIPartitioner(scanner);
        if (this.document instanceof IDocumentExtension3) {
            IDocumentExtension3 docExt3 = (IDocumentExtension3)this.document;
            IDocumentPartitioner oldpart = docExt3.getDocumentPartitioner("__source_code_partitioning");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__source_code_partitioning", (IDocumentPartitioner)partitioner);
            oldpart = docExt3.getDocumentPartitioner("__dflt_position_category");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__dflt_position_category", (IDocumentPartitioner)partitioner);
        } else {
            IDocumentPartitioner oldpart = this.document.getDocumentPartitioner();
            if (oldpart != null) {
                oldpart.disconnect();
            }
        }
        partitioner.connect(this.document, false, this);
    }

    protected void createActions() {
        super.createActions();
        this.setAction("ShiftRight", null);
        this.setAction("ShiftLeft", null);
        this.setAction("QuickDiff.Toggle", null);
        RulerConfigureBPaction confbpAction = new RulerConfigureBPaction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerDoubleClick", (IAction)confbpAction);
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.Accessibility"};
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public boolean isPrefQuickDiffAlwaysOn() {
        return false;
    }

    public boolean isOverwriteModeEnabled() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput && this.intertest) {
                OutlinePage page = new OutlinePage(this.provider, this);
                page.setInput(input);
                return page;
            }
        } else if (adapter.equals(BreakpointPage.class)) {
            IResource input = this.getResource();
            if (input != null && this.intertest) {
                BreakpointPage page = new BreakpointPage(this);
                page.setInput(input);
                return page;
            }
        } else if (adapter.equals(DataViewPage.class)) {
            TreeObject input = this.getTree();
            if (input != null) {
                return new DataViewPage(this.provider, this, this.lang);
            }
        } else if (adapter.equals(SessionViewPage.class)) {
            TreeObject input = this.getTree();
            if (input != null) {
                return new SessionViewPage(this.provider, this, this.lang);
            }
        } else if (adapter.equals(RegisterViewPage.class)) {
            TreeObject input = this.getTree();
            if (input != null) {
                return new RegisterViewPage(this.provider, this, this.lang);
            }
        } else if (adapter.equals(AutoDataViewPage.class)) {
            TreeObject input = this.getTree();
            if (input != null) {
                return new AutoDataViewPage(this.provider, this, this.lang);
            }
        } else {
            if (adapter.equals(BacktracePage.class)) {
                return new BacktracePage(this.resource.getProject());
            }
            if (adapter.equals(CalltracePage.class)) {
                return new CalltracePage(this.resource.getProject());
            }
            if (adapter.equals(IProject.class)) {
                return this.resource.getProject();
            }
        }
        return super.getAdapter(adapter);
    }

    public IDocument getDocument() {
        return this.document;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IOverviewRuler getOverviewRuler() {
        return super.getOverviewRuler();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public IScanSource getScansource() {
        return this.scansource;
    }

    public TreeObject getTree() {
        return this.outline == null ? null : this.outline.getTree();
    }

    public Outline getOutline() {
        return this.outline;
    }

    private void processBreakpoint(CVMO cvmo) {
        this.currbpstatement = 0;
        DebugMessage msg = cvmo.getMessage(1);
        if (msg instanceof BreakMessage) {
            this.currbpstatement = ((BreakMessage)msg).getStatement();
        } else if (msg.getMessageID() == 3) {
            this.processBacktrace(cvmo);
        }
        this.positionDebugStatement(this.currbpstatement);
    }

    public int getBPStatement() {
        return this.currbpstatement;
    }

    private void processBacktrace(CVMO cvmo) {
    }

    public void positionDebugStatement(int stmtNumber) {
        Integer lineNumber = this.outline.getStatementXref().get(stmtNumber);
        if (lineNumber != null) {
            try {
                IRegion region = this.document.getLineInformation(lineNumber - 1);
                final int offset = region.getOffset();
                final int length = region.getLength();
                final IAnnotationModel am = this.provider.getAnnotationModel((Object)this.getEditorInput());
                Position pos = null;
                if (am != null) {
                    pos = am.getPosition(this.currentIP);
                }
                final Annotation oldIP = pos != null ? this.currentIP : null;
                final Position position = new Position(offset, length);
                String text = this.debugfile.getSession().getBreakText();
                this.currentIP = new Annotation("com.ca.intertest.lister.pointer", false, text);
                Display display = Display.getDefault();
                if (display != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListerEditor.this.selectAndReveal(offset, length);
                            if (oldIP != null) {
                                am.removeAnnotation(oldIP);
                            }
                            if (am != null) {
                                am.addAnnotation(ListerEditor.this.currentIP, position);
                            }
                        }
                    });
                }
            }
            catch (BadLocationException e) {
                Logger.loggit(e);
            }
        }
    }

    private void debugSessionEnd() {
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IAnnotationModel am = ListerEditor.this.provider.getAnnotationModel((Object)ListerEditor.this.getEditorInput());
                    if (am == null) {
                        return;
                    }
                    Iterator amit = am.getAnnotationIterator();
                    String type = null;
                    Annotation annie = null;
                    while (amit.hasNext()) {
                        annie = (Annotation)amit.next();
                        type = annie.getType();
                        boolean persistent = annie.isPersistent();
                        if (persistent || !"com.ca.intertest.lister.pointer".equals(type)) continue;
                        am.removeAnnotation(annie);
                    }
                    ListerEditor.this.resetHighlightRange();
                }
            });
        }
    }

    public ShowInContext getShowInContext() {
        ShowInContext context = new ShowInContext((Object)this.debugfile, null);
        return context;
    }

    protected void setTitleImage(Image titleImage) {
        if (this.resource != null && (this.image == null || this.image.isDisposed())) {
            this.image = new decorator().decorateImage(titleImage, this.resource);
        }
        if (this.image != null) {
            super.setTitleImage(this.image);
        } else {
            super.setTitleImage(titleImage);
        }
    }

    public ResourceProperty getStore() {
        return this.store;
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("textDragAndDropEnabled", false);
    }

    public void dispose() {
        if (this.debugfile != null) {
            this.debugfile.removeDebugListener(this.debugListener);
        }
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    private void setupEditor() {
        String name = this.resource.getName();
        this.image = null;
        if (this.debugfile != null) {
            decorator dec = new decorator();
            name = dec.decorateText("", this.resource);
            this.image = dec.decorateImage(null, this.resource);
            this.lang = this.store.getHex("gt_m_lang");
            this.scansource = this.debugfile.getScansource();
            this.laststatement = this.store.getInt("laststatement");
            if (this.laststatement == 0) {
                this.laststatement = this.store.getInt("records");
            }
            try {
                this.outline = Outline.getInstance(this.debugfile);
            }
            catch (ITException e) {
                Logger.loggit(e);
            }
            switch (this.lang) {
                case 32: {
                    this.createCobolPartControl();
                    break;
                }
                case 16: {
                    this.createAsmPartControl();
                    break;
                }
                case 128: {
                    this.createPLIPartControl();
                }
            }
        }
        this.setPartName(name);
        this.setTitleImage(this.image);
    }

    protected void handleEditorInputChanged() {
        this.setupEditor();
        super.handleEditorInputChanged();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.setupEditor();
    }

    public class DebugListener
    implements IDebugListener {
        IDebugMessage debugMessage;

        @Override
        public void debugEventOccured(debugEvent event) {
            CVMI cvmi;
            Object object = event.getSource();
            if (object instanceof CVMO) {
                CVMO cvmo = (CVMO)((Object)object);
                if (cvmo.getMessage(1).getMessageID() == 4) {
                    ListerEditor.this.debugSessionEnd();
                } else {
                    ListerEditor.this.processBreakpoint((CVMO)((Object)object));
                }
            } else if (object instanceof CVMI && (cvmi = (CVMI)((Object)object)).getMessage(1).getMessageID() == 22) {
                ListerEditor.this.debugSessionEnd();
            }
        }
    }
}

