/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.ui.actions.ConfigureBreakpointAction;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.BatchConfigWizard;
import com.ca.intertest.wizards.BatchSettingsWizard;
import com.ca.intertest.wizards.CICSConfigWizard;
import com.ca.intertest.wizards.CICSSettingsWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import com.ca.intertest.wizards.SettingsWizardDialog;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class ConfigureProgramAction
implements IEditorActionDelegate {
    private ListerEditor editor;
    private debugFile debugfile;
    private Debug debug = Debug.getInstance();
    private debugSession session;
    private Shell shell;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        ListerEditor listerEditor = this.editor = targetEditor instanceof ListerEditor ? (ListerEditor)targetEditor : null;
        if (this.editor != null) {
            IResource resource = this.editor.getResource();
            if (resource == null) {
                return;
            }
            this.debugfile = (debugFile)this.debug.getResource(resource);
            if (this.debugfile == null) {
                return;
            }
            this.session = this.debugfile.getSession();
            action.setEnabled(true);
            this.shell = this.editor.getSite().getShell();
            action.setText(String.format(ConfigureBreakpointAction.CONFIGURE_FORMAT, ConfigureBreakpointAction.PROGRAM));
            action.setToolTipText(String.format(ConfigureBreakpointAction.CONFIGURE_TOOLTIP_FORMAT, this.debugfile.getName()));
        }
    }

    public void run(IAction action) {
        IntertestWizardDialog dialog = null;
        if (this.debugfile != null) {
            dialog = this.debugfile.getSession().isCICS() ? new IntertestWizardDialog(this.shell, (IWizard)new CICSConfigWizard(this.debugfile)) : new IntertestWizardDialog(this.shell, (IWizard)new BatchConfigWizard(this.debugfile));
        } else if (this.session != null) {
            dialog = this.session.isCICS() ? new SettingsWizardDialog(this.shell, (IWizard)new CICSSettingsWizard(this.session, false)) : new SettingsWizardDialog(this.shell, (IWizard)new BatchSettingsWizard(this.session, false));
        } else {
            return;
        }
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }
}

