/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.debug.SynchSymbolic2;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServiceConnection;
import com.ca.intertest.tools.BackStepMessage;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.EndTaskMessage;
import com.ca.intertest.tools.ExecuteMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IStatusMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MoreMessage;
import com.ca.intertest.tools.SynchSymbolicMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import com.ca.intertest.tools.TerminateProgramMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class DebugTalker
implements Runnable {
    static final String cacopyright = "Copyright (c) 2016 CA";
    private static final int TIMEOUT = 1000;
    private Socket client;
    private boolean more = true;
    private final InputStream inReader;
    private final OutputStream outWriter;
    private debugSession session = null;
    private debugFile debugfile;
    private debugFile prior_debugfile;
    private BreakMessage breakmessage;
    private BreakpointMarker bpmarker;
    private boolean waiting = true;
    private CVMO breakpointCVMO;
    private static final Debug debug = Debug.getInstance();
    private boolean goodbyeSent = false;
    private String connectionID = Messages.DebugTalker_0;
    private boolean initialMessage = false;
    final int count = 0;
    final int error = 0;
    boolean displayWindow = true;

    DebugTalker(Socket client, CVMO cvmo, String connectionID) throws IOException {
        this.client = client;
        this.connectionID = connectionID;
        this.initialMessage = cvmo != null;
        this.breakpointCVMO = cvmo;
        Logger.logPacket(this, DebugTalker.class, new Throwable(), connectionID);
        try {
            this.inReader = client.getInputStream();
            this.outWriter = client.getOutputStream();
        }
        catch (IOException e) {
            Logger.loggit(32, String.format(Messages.DebugTalker_4, HexUtil.getErrorText((Throwable)e)));
            throw e;
        }
    }

    private void readFirstPacket() {
        try {
            this.setWaiting(false);
            this.displayWindow = true;
            this.breakpointCVMO = this.ReadIn();
            if (this.breakpointCVMO != null) {
                Connection.processStatusMessages(null, this.breakpointCVMO);
                if (this.client.getSoTimeout() != 0) {
                    this.client.setSoTimeout(0);
                }
                this.bpmarker = null;
                Display display = Display.getDefault();
                DebugMessage[] messages = this.breakpointCVMO.getMessages();
                int count = 0;
                while (count < messages.length) {
                    DebugMessage msg = messages[count];
                    switch (msg.getMessageID()) {
                        case 1: {
                            this.breakmessage = (BreakMessage)msg;
                            this.setupSession(this.breakmessage.getSessionID());
                            if (this.session != null) {
                                if (this.session.isBatch()) {
                                    boolean neverstopped = true;
                                    for (debugFile item : this.session.getMonitored(true)) {
                                        if (!item.isEntered()) continue;
                                        neverstopped = false;
                                        break;
                                    }
                                    if (neverstopped && this.breakmessage.getSubmessageID() == 6) {
                                        this.displayWindow = false;
                                    }
                                }
                                Logger.loggit(0, String.format(Messages.DebugTalker_33, this.session.getName(), this.breakmessage.getText()));
                                this.session.setTalker(this);
                                debugEvent event = new debugEvent((Object)this.breakpointCVMO, this);
                                String progid = String.valueOf(this.breakmessage.getProgram()) + ".intertest";
                                this.debugfile = this.getFile(progid, true, false, this.breakmessage.getDate(), this.breakmessage.getTime(), this.breakmessage.getDSName(), this.breakmessage.getLongText());
                                this.session.setMemoryUpdatePassword("");
                                if (this.debugfile != null) {
                                    boolean stop = true;
                                    if (this.session.isBatch()) {
                                        if (!this.debugfile.isEntered()) {
                                            if (!(this.session.isFirstModule() || this.breakmessage.getSubmessageID() != 1 && this.breakmessage.getSubmessageID() != 4)) {
                                                stop = this.debugfile.hasInitialBreakpoint();
                                            }
                                            this.debugfile.setEntered(true);
                                            this.session.addBreakpoints(this.debugfile);
                                            this.session.post(null);
                                        } else if (this.breakmessage.getSubmessageID() == 4 && this.breakmessage.getBreakpointID() == 128L) {
                                            stop = this.debugfile.hasInitialBreakpoint();
                                        }
                                    } else {
                                        this.debugfile.setEntered(true);
                                    }
                                    switch (this.breakmessage.getType()) {
                                        case 4: {
                                            String text;
                                            if (!this.session.isBatch() || !(text = this.breakmessage.getLongText()).equals(BreakMessage.names[4])) break;
                                            this.breakmessage.setText(BreakMessage.names[1]);
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            String text;
                                            long ID = this.breakmessage.getBreakpointID();
                                            if (ID == 0L) break;
                                            this.bpmarker = this.debugfile.getBreakpointMarkerbyID(ID);
                                            if (this.bpmarker == null || (text = this.bpmarker.getAttribute("message").toString()) == null || text.length() <= 0) break;
                                            this.breakmessage.setText(text);
                                        }
                                    }
                                    if (stop) {
                                        if (display != null) {
                                            display.syncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                                    Shell shell = window.getShell();
                                                    shell.setMinimized(false);
                                                    shell.forceActive();
                                                    shell.forceFocus();
                                                    if (DebugTalker.this.breakmessage != null && DebugTalker.this.breakmessage.getSubmessageID() == 6 && DebugTalker.this.displayWindow) {
                                                        Status status = new Status(4, "com.ca.intertest", 32, Messages.DebugTalker_7, null);
                                                        ErrorDialog.openError((Shell)window.getShell(), (String)Messages.DebugTalker_8, (String)DebugTalker.this.breakmessage.getText(), (IStatus)status);
                                                    }
                                                    try {
                                                        IWorkbenchPage page = window.getActivePage();
                                                        page.showView("com.ca.intertest.ui.views.debug");
                                                        if (DebugTalker.this.debugfile != null) {
                                                            page.openEditor((IEditorInput)new FileEditorInput((IFile)DebugTalker.this.debugfile.getResource()), "com.ca.intertest.ui.lister");
                                                        } else {
                                                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DebugTalker_9, (String)String.format(Messages.DebugTalker_10, DebugTalker.this.breakmessage.getProgram()));
                                                        }
                                                    }
                                                    catch (PartInitException partInitException) {}
                                                }
                                            });
                                        }
                                        this.session.fireDebugMessageListeners(event);
                                        this.debugfile.fireDebugMessageListeners(event);
                                    } else {
                                        ExecuteMessage message = new ExecuteMessage();
                                        message.setMessageID((short)10);
                                        message.setProgram(this.breakmessage.getProgram());
                                        message.setStatement(this.breakmessage.getStatement());
                                        this.processExecute(message);
                                    }
                                } else {
                                    this.session.fireDebugMessageListeners(event);
                                }
                            } else {
                                Logger.loggit(8, Messages.DebugTalker_11);
                            }
                            Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
                            return;
                        }
                        case 4: {
                            boolean warn;
                            boolean notify = true;
                            boolean monitored = false;
                            final EndTaskMessage endtaskmessage = (EndTaskMessage)msg;
                            this.setupSession(endtaskmessage.getSessionID());
                            Logger.loggit(0, String.format(Messages.DebugTalker_12, this.connectionID));
                            if (this.session != null) {
                                Object[] files;
                                this.session.setTalker(this);
                                this.session.setMemoryUpdatePassword("");
                                for (debugFile item : this.session.getMonitored(true)) {
                                    if (!item.isEntered()) continue;
                                    monitored = true;
                                    break;
                                }
                                this.more = false;
                                this.session.endSession();
                                CVMO tempcvmo = new CVMO();
                                tempcvmo.addMessage(msg);
                                debugEvent event = new debugEvent((Object)tempcvmo, this);
                                this.session.fireDebugMessageListeners(event);
                                Object[] objectArray = files = this.session.getChildren();
                                int n = files.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object item = objectArray[n2];
                                    ((debugFile)item).fireDebugMessageListeners(event);
                                    ++n2;
                                }
                                String value = this.session.getStore().getString("settingsNotifyEOJ");
                                notify = value == null || value.length() == 0 ? true : Boolean.parseBoolean(value);
                            }
                            if (this.breakpointCVMO.getErrorLevel() > 0) {
                                Connection.displayError(this.breakpointCVMO, Messages.DebugTalker_14);
                            }
                            boolean bl = warn = !monitored;
                            if ((warn || notify || this.breakpointCVMO.getErrorLevel() > 0) && display != null) {
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                        window.getShell().forceActive();
                                        window.getShell().forceFocus();
                                        String rc_text = endtaskmessage.getReturncode() == 65535 ? String.valueOf(IConstants.LINEFEED) + IConstants.LINEFEED + endtaskmessage.getAbendMessage() : String.format(Messages.DebugTalker_15, endtaskmessage.getReturncode());
                                        if (warn) {
                                            MessageDialog.openWarning((Shell)window.getShell(), (String)Messages.DebugTalker_16, (String)(String.valueOf(Messages.DebugTalker_17) + rc_text));
                                        } else {
                                            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.DebugTalker_16, (String)(String.valueOf(Messages.DebugTalker_19) + rc_text));
                                        }
                                    }
                                });
                            }
                            Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
                            return;
                        }
                    }
                    ++count;
                }
            }
            Logger.loggit(32, Messages.DebugTalker_20);
        }
        catch (ITException iTException) {
            this.more = false;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.setWaiting(true);
            return;
        }
        catch (Exception e) {
            Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
            Logger.loggit(e);
            this.more = false;
            this.setWaiting(false);
        }
        if (this.session != null && this.session.isBatch()) {
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)new EndTaskMessage());
            debugEvent event = new debugEvent((Object)cvmi, this);
            this.session.fireDebugMessageListeners(event);
        }
    }

    private void setupSession(Integer sessionID) {
        if (this.session == null) {
            this.session = debug.getSession(sessionID);
        }
        if (this.session.getTalker() == null || this.session.getTalker().equals(this)) {
            return;
        }
        Logger.loggit(0, Messages.DebugTalker_21);
        while (this.session.getTalker() != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Logger.loggit(0, Messages.DebugTalker_22);
    }

    @Override
    public void run() {
        while (this.more) {
            if (this.isWaiting()) {
                this.readFirstPacket();
            }
            try {
                Thread.sleep(1000L);
                if (this.client != null && !this.client.isClosed() && this.client.isConnected()) continue;
                this.more = false;
            }
            catch (InterruptedException interruptedException) {
                this.more = false;
            }
        }
        if (this.client != null) {
            this.Shutdown();
        }
        if (this.isWaiting() || this.isActive()) {
            this.sayGoodbye();
        }
        Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
    }

    private CVMI sayGoodbye() {
        CVMI cvmi = null;
        if (this.session != null && !this.goodbyeSent) {
            this.Shutdown();
            this.goodbyeSent = true;
            MessageDialog.openError(null, (String)Messages.DebugTalker_25, (String)Messages.DebugTalker_26);
            if (this.session.isBatch()) {
                this.session.suspendSession();
            } else {
                ServerElement server = this.session.getDebugServer();
                ServiceConnection connection = new ServiceConnection(server);
                boolean active = connection.isActive();
                connection.disconnect(true);
                if (!active) {
                    this.session.suspendSession();
                } else {
                    cvmi = new CVMI();
                    try {
                        TerminateProgramMessage message = new TerminateProgramMessage();
                        message.setProgram(this.getBreakmessage().getProgram());
                        cvmi.addMessage((DebugMessage)message);
                        this.notifyExecute(cvmi);
                    }
                    catch (ITException e) {
                        Logger.loggit(e);
                    }
                }
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            try {
                IViewPart view = page.showView("com.ca.intertest.ui.views.debug");
                if (view instanceof IShowInTarget) {
                    ShowInContext context = new ShowInContext((Object)this.debugfile, null);
                    ((IShowInTarget)view).show(context);
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        return cvmi;
    }

    private debugFile getFile(String progid, boolean monitor, boolean post, int date, int time, String DSN, String reasonText) {
        debugFile file = null;
        if (DSN == null || DSN.length() == 0) {
            DSN = this.getDSN(progid);
        }
        if (DSN.length() != 0 && (file = this.session.getFile(progid)) != null && file.equals(this.prior_debugfile)) {
            return this.prior_debugfile;
        }
        if (file == null) {
            this.prior_debugfile = this.session.refreshFile(progid, DSN, true, post, true, date, time, reasonText);
        } else {
            ResourceProperty store = file.getStore();
            int filedate = (Integer)Attribute.getValue("gt_m_jul", store);
            int filetime = (Integer)Attribute.getValue("gt_m_tim", store);
            if (filedate == date && filetime == time) {
                file.setMonitor(true);
                this.prior_debugfile = file;
            } else {
                this.prior_debugfile = this.session.refreshFile(progid, DSN, true, true, post, date, time, reasonText);
            }
        }
        return this.prior_debugfile;
    }

    private String getDSN(String progid) {
        CVMO cvmo;
        block7: {
            CVMI cvmi = new CVMI();
            SynchSymbolicMessage sychrequest = new SynchSymbolicMessage();
            sychrequest.setSubmessageID((short)5);
            sychrequest.setProgram(progid);
            cvmi.addMessage((DebugMessage)sychrequest);
            cvmo = this.process(cvmi);
            if (cvmo.getErrorLevel() == 0) break block7;
            Connection.displayError(cvmo, "Synchronize Symbolics");
            return "";
        }
        try {
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage message = debugMessageArray[n2];
                if (message.getMessageID() == 45) {
                    SynchronizeMessage.SynchProtsym prot;
                    SynchronizeMessage synchmsg = (SynchronizeMessage)message;
                    Logger.loggit(0, String.format("Synchronize %s in %s", synchmsg.getProgram(), this.session.getName()));
                    if (synchmsg.getProtsyms().size() == 1 && (prot = (SynchronizeMessage.SynchProtsym)synchmsg.getProtsyms().get(0)).isExact()) {
                        return prot.getDSN();
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return "";
    }

    public void Shutdown() {
        if (this.session != null && this.session.isBatch()) {
            ((debugBatchSession)this.session).setSToken(null);
        }
        Logger.loggit(0, String.format(Messages.DebugTalker_27, this.connectionID));
        try {
            try {
                if (this.client != null && this.client.isConnected()) {
                    this.client.shutdownInput();
                    this.client.shutdownOutput();
                    this.client.close();
                }
            }
            catch (IOException iOException) {
                this.more = false;
                this.setWaiting(false);
                this.client = null;
            }
        }
        finally {
            this.more = false;
            this.setWaiting(false);
            this.client = null;
        }
    }

    private CVMO ReadIn() throws Exception {
        DebugMessage msg;
        CVMO newCVMO;
        if (this.client == null || this.client.isClosed() || !this.client.isConnected()) {
            this.more = false;
        }
        if (!this.more) {
            return null;
        }
        byte[] len = new byte[4];
        byte[] buffer = null;
        int bufflen = 0;
        ByteBuffer bytebuffer = null;
        boolean morepackets = true;
        if (this.initialMessage) {
            this.initialMessage = false;
            morepackets = false;
            newCVMO = this.breakpointCVMO;
        } else {
            newCVMO = new CVMO();
        }
        while (this.more && morepackets) {
            if (this.client == null || this.client.isClosed() || !this.client.isConnected()) {
                this.more = false;
                break;
            }
            int bytesread = this.inReader.read(len, 0, 4);
            if (bytesread == -1) {
                this.client.close();
                this.more = false;
                break;
            }
            if (bytesread != len.length || (bufflen = ByteBuffer.wrap(len).getInt()) <= 4) continue;
            int toread = bufflen - 4;
            try {
                buffer = new byte[toread + 4];
                int pos = 4;
                while (bytesread >= 0 && toread > 0) {
                    bytesread = this.inReader.read(buffer, pos, toread);
                    toread -= bytesread;
                    pos += bytesread;
                }
                bytebuffer = ByteBuffer.wrap(buffer).putInt(0, bufflen);
                Logger.logPacket(buffer, CVMO.class, new Throwable(), this.connectionID);
                newCVMO.setArray(bytebuffer, false);
                morepackets = newCVMO.getLastMessage() instanceof MoreMessage;
            }
            catch (VirtualMachineError e) {
                Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
                Logger.loggit(e);
                newCVMO.addMessage((DebugMessage)new StatusMessage(32, HexUtil.getErrorText((Throwable)e)));
                morepackets = false;
            }
        }
        Logger.DisplayPacket((DSECT)newCVMO, new Throwable());
        if (newCVMO.size() == 1 && (msg = newCVMO.getMessage(1)) instanceof SynchronizeMessage) {
            SynchSymbolic2 synch = new SynchSymbolic2((SynchronizeMessage)msg, null, null);
            this.process(synch.synchronizeFile());
            return this.ReadIn();
        }
        return newCVMO;
    }

    private void WriteOut(byte[] buffer) throws Exception {
        try {
            if (this.client == null || this.client.isClosed() || !this.client.isConnected() || this.outWriter == null) {
                this.more = false;
            } else if (buffer == null || buffer.length == 0) {
                this.outWriter.close();
                this.more = false;
            }
            if (!this.more) {
                throw new ITException(Messages.DebugTalker_28);
            }
            if (this.outWriter != null) {
                this.outWriter.write(buffer);
                this.outWriter.flush();
                Logger.logPacket(buffer, CVMI.class, new Throwable(), this.connectionID);
            }
        }
        catch (IOException e) {
            Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
            throw e;
        }
    }

    public synchronized void processExecute(ExecuteMessage message) {
        this._processExecute((DebugMessage)message);
    }

    public synchronized void processExecute(BackStepMessage message) {
        this._processExecute((DebugMessage)message);
    }

    private synchronized void _processExecute(DebugMessage message) {
        CVMI cvmi = new CVMI();
        cvmi.addMessage(message);
        this.processExecute(cvmi);
    }

    public synchronized void processExecute(CVMI cvmi) {
        IStatusMessage statusMsg;
        String text;
        int ix;
        DebugMessage cvmoMsg;
        DebugMessage cvmiMsg;
        CVMO breakpointCVMO;
        block17: {
            breakpointCVMO = new CVMO();
            if (this.isWaiting()) {
                Logger.loggit(8, Messages.DebugTalker_29);
            }
            try {
                this.WriteOut(cvmi.getArray());
            }
            catch (Exception e) {
                Logger.loggit(e);
                if (this.session != null) {
                    cvmi = this.sayGoodbye();
                }
                this.Shutdown();
            }
            try {
                short msgId = cvmi.getLastMessage().getMessageID();
                if (msgId != 9) {
                    breakpointCVMO = this.ReadIn();
                }
            }
            catch (Exception exception) {
                if (this.session == null) break block17;
                if (this.session.isBatch()) {
                    this.sayGoodbye();
                }
                this.Shutdown();
            }
        }
        if (breakpointCVMO.getErrorLevel() != 0 && this.session != null) {
            cvmi = this.sayGoodbye();
        }
        if ((cvmiMsg = cvmi.getMessage(1)) instanceof ExecuteMessage && cvmiMsg.getSubmessageID() != 0 && (cvmoMsg = breakpointCVMO.getMessage(1)) instanceof IStatusMessage && (ix = (text = (statusMsg = (IStatusMessage)cvmoMsg).getMessage()).indexOf(":")) != -1) {
            text = text.substring(ix + 1).trim();
            MessageDialog.openWarning(null, (String)"Step Warning", (String)text);
            return;
        }
        if (this.session.isCICS()) {
            this.Shutdown();
        }
        this.breakmessage = null;
        this.notifyExecute(cvmi);
        if (this.client != null && !this.client.isClosed() && this.session.isBatch()) {
            DebugMessage msg = cvmi.getMessage(1);
            switch (msg.getMessageID()) {
                case 9: 
                case 17: 
                case 22: {
                    this.Shutdown();
                    break;
                }
                default: {
                    try {
                        this.client.setSoTimeout(1000);
                    }
                    catch (SocketException e) {
                        Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
                        Logger.loggit(e);
                    }
                    this.setWaiting(true);
                }
            }
        }
    }

    private void notifyExecute(CVMI cvmi) {
        debugEvent event = new debugEvent((Object)cvmi, this);
        this.session.fireDebugMessageListeners(event);
        if (this.debugfile != null) {
            this.debugfile.fireDebugMessageListeners(event);
        }
    }

    public synchronized CVMO process(CVMI cvmi) throws Exception {
        if (cvmi == null || cvmi.size() == 0) {
            return null;
        }
        Logger.DisplayPacket((DSECT)cvmi, new Throwable());
        try {
            this.WriteOut(cvmi.getArray());
            CVMO cvmo = this.ReadIn();
            Connection.processStatusMessages(cvmi, cvmo);
            return cvmo;
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.process(this.sayGoodbye());
            throw e;
        }
    }

    public boolean isActive() {
        return this.client != null && !this.client.isClosed() && this.client.isConnected() && this.more && this.breakmessage != null && !this.isWaiting();
    }

    public int getBreakType() {
        return this.breakmessage == null ? -1 : (int)this.breakmessage.getSubmessageID();
    }

    public debugFile getDebugfile() {
        return this.debugfile;
    }

    public BreakMessage getBreakmessage() {
        return this.breakmessage;
    }

    public synchronized boolean isWaiting() {
        return this.waiting;
    }

    private synchronized void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    public BreakpointMarker getBpmarker() {
        return this.bpmarker;
    }

    public String toString() {
        Formatter format = new Formatter();
        format.format(Messages.DebugTalker_30, super.toString(), this.client == null ? Messages.DebugTalker_31 : this.client.getRemoteSocketAddress());
        if (this.session != null) {
            format.format(Messages.DebugTalker_32, this.session.getName(), this.session.getUID());
        }
        return format.toString();
    }

    public CVMO getBreakpointCVMO() {
        return this.breakpointCVMO;
    }
}

