/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.DebugSessionSetup;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.CICSServer;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.INQSYSMessage;
import com.ca.intertest.tools.INQSYSResponseMessage;
import com.ca.intertest.tools.ITException;

public class DebugCICSSessionSetup
extends DebugSessionSetup {
    static String cacopyright = "Copyright \u00a9 2016 CA";

    public DebugCICSSessionSetup(debugSession session) throws ITException, Exception {
        super(session);
    }

    @Override
    protected boolean connect() {
        try {
            this.connection = new CICSConnection((CICSServer)this.server, this.session);
            this.connection.connect(false);
            CVMO cvmo = this.setSessionInfo();
            return cvmo.getErrorLevel() == 0;
        }
        catch (Exception e) {
            Logger.loggit(e);
            return false;
        }
    }

    @Override
    public int launch() throws Exception {
        int rc = 0;
        this.session.setDebug();
        this.session.postSnapshot(null, false);
        this.session.buildBreakpointQueue();
        this.session.post(this.connection);
        this.cvmi = new CVMI();
        this.cvmi.addMessage((DebugMessage)new InitMessage(this.session));
        debugEvent event = new debugEvent((Object)this.cvmi, null);
        this.session.fireDebugMessageListeners(event);
        return rc;
    }

    private CVMO setSessionInfo() {
        CVMO cvmo = new CVMO();
        CVMI cvmi = new CVMI();
        try {
            cvmi.addMessage((DebugMessage)new SignonMessage((CICSServer)this.session.getDebugServer()));
            cvmi.addMessage((DebugMessage)new InitMessage(this.session));
            cvmi.addMessage((DebugMessage)new INQSYSMessage());
            ServerElement sElement = this.session.getDebugServer();
            if (sElement != null && sElement instanceof CICSServer) {
                this.connection = new CICSConnection((CICSServer)sElement, this.session);
            }
            if (this.connection != null && this.connection.connect(true)) {
                cvmo = this.connection.process(cvmi);
                this.connection.disconnect(true);
                if (cvmo.getErrorLevel() == 0) {
                    DebugMessage[] debugMessageArray = cvmo.getMessages();
                    int n = debugMessageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugMessage message = debugMessageArray[n2];
                        if (message.getMessageID() == 48) {
                            INQSYSResponseMessage inqmsg = (INQSYSResponseMessage)message;
                            this.session.setVersion(inqmsg.getSystemVersion());
                            this.session.setAFloat(inqmsg.isAFloat());
                            this.session.setWideRegs(inqmsg.isWideRegs());
                        }
                        ++n2;
                    }
                } else {
                    Connection.displayError(cvmo, Messages.DebugCICSSessionSetup_0);
                }
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return cvmo;
    }
}

