/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Keywords;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.ITException;
import java.util.ArrayList;
import java.util.HashMap;

public class Structures {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private TreeObject treeobject;
    private String program;
    private String structure;
    static Structures Structures = null;
    private static ArrayList<TreeObject> structobjs;
    private static HashMap<String, TreeObject> progobjs;
    private static ArrayList<String> structs;
    private static ArrayList<String> progs;
    private static final int LEVEL1_VARIABLES = 1;
    private static final int ALL_VARIABLES = 2;
    private static final int GROUP_VARIABLES = 3;
    private static String[] protLit;

    static {
        protLit = new String[]{"CI", "IN"};
    }

    private TreeObject _getTree(String altname, int structOpt, debugSession session) {
        String[] tokens = altname.split("[.]");
        this.program = tokens[0];
        this.structure = tokens[1];
        TreeObject pgmtree = this.getProgramTree(this.program, session);
        if (pgmtree == null) {
            return pgmtree;
        }
        this.treeobject = this.getStructureTree(pgmtree, this.structure, structOpt);
        return this.treeobject;
    }

    private TreeObject getProgramTree(String pgm, debugSession currSession) {
        TreeObject tree = null;
        Debug dbug = Debug.getInstance();
        for (debugSession session : dbug.getSessions()) {
            String dbugpgm;
            if (!session.equals(currSession) || session.getName() == "") continue;
            for (debugFile debugfile : session.getMonitored(true)) {
                dbugpgm = debugfile.getName();
                if (dbugpgm.equals(pgm)) {
                    tree = this.getProgramTreeObject(debugfile);
                }
                if (tree == null) continue;
                return tree;
            }
            for (debugFile debugfile : session.getMonitored(false)) {
                dbugpgm = debugfile.getName();
                if (dbugpgm.equals(pgm)) {
                    tree = this.getProgramTreeObject(debugfile);
                }
                if (tree == null) continue;
                return tree;
            }
            if (!session.isCICS()) continue;
            int i = 0;
            while (i < 2) {
                try {
                    TreeObject[] tos = Keywords.getTrees(protLit[i], session.getVersion());
                    if (tos != null && tos.length > 0) {
                        String dsect = tos[0].getParent().getName();
                        if (dsect.equals(pgm)) {
                            tree = this.getProgramTreeObject(tos[0].getParent());
                        }
                        if (tree != null) {
                            return tree;
                        }
                    }
                }
                catch (ITException iTException) {}
                ++i;
            }
        }
        return null;
    }

    private TreeObject getProgramTreeObject(TreeObject tree) {
        return tree;
    }

    private TreeObject getProgramTreeObject(debugFile debugfile) {
        try {
            Outline out = Outline.getInstance(debugfile);
            return out.getTree();
        }
        catch (ITException e) {
            Logger.loggit(e);
            return null;
        }
    }

    public static ArrayList<String> getAvailablePrograms(debugSession currSession) {
        progs = new ArrayList();
        progobjs = new HashMap();
        Debug dbug = Debug.getInstance();
        for (debugSession session : dbug.getSessions()) {
            if (!session.equals(currSession) || !session.isAtBreakpoint() || session.getName() == "") continue;
            for (debugFile debugfile : session.getMonitored(true)) {
                if (!debugfile.isProgram()) continue;
                progs.add(debugfile.getName());
            }
            for (debugFile debugfile : session.getMonitored(false)) {
                if (!debugfile.isProgram()) continue;
                progs.add(debugfile.getName());
            }
            if (!session.isCICS()) continue;
            int i = 0;
            while (i < 2) {
                try {
                    TreeObject[] tos = Keywords.getTrees(protLit[i], session.getVersion());
                    if (tos != null && tos.length > 0) {
                        TreeObject parent = tos[0].getParent();
                        progs.add(parent.getName());
                        progobjs.put(parent.getName(), parent);
                    }
                }
                catch (ITException iTException) {}
                ++i;
            }
        }
        return progs;
    }

    public static HashMap<String, TreeObject> getProgObjs(debugSession sess, String prog) {
        Outline out;
        boolean progFound = false;
        for (debugFile debugfile : sess.getMonitored(true)) {
            if (!debugfile.getName().equals(prog)) continue;
            try {
                out = Outline.getInstance(debugfile);
                progobjs.put(prog, out.getTree());
                progFound = true;
            }
            catch (ITException e) {
                Logger.loggit(e);
            }
        }
        if (!progFound) {
            for (debugFile debugfile : sess.getMonitored(false)) {
                if (!debugfile.getName().equals(prog)) continue;
                try {
                    out = Outline.getInstance(debugfile);
                    progobjs.put(prog, out.getTree());
                }
                catch (ITException e) {
                    Logger.loggit(e);
                }
            }
        }
        return progobjs;
    }

    public static ArrayList<TreeObject> getStructObjs() {
        return structobjs;
    }

    private TreeObject getStructureTree(TreeObject pgmtree, String struct, int opt) {
        structobjs = new ArrayList();
        structs = new ArrayList();
        TreeObject elementclone = null;
        com.ca.intertest.common.Structures.loadChildren(pgmtree, opt);
        for (TreeObject element : structobjs) {
            if (!element.getName().equals(struct)) continue;
            try {
                elementclone = (TreeObject)element.clone();
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
            return elementclone;
        }
        return elementclone;
    }

    public static void loadChildren(TreeObject to, int opt) {
        TreeObject[] treeObjectArray = to.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject element = treeObjectArray[n2];
            if (element.getType() == 1) {
                boolean hitFlag = false;
                switch (opt) {
                    case 1: {
                        Integer level = (Integer)Attribute.getValue("level", element);
                        if (level != 1) break;
                        hitFlag = true;
                        break;
                    }
                    case 3: {
                        if (!element.hasChildren()) break;
                        hitFlag = true;
                        break;
                    }
                    case 2: {
                        hitFlag = true;
                    }
                }
                if (hitFlag) {
                    structs.add(element.getName());
                    structobjs.add(element);
                }
            }
            com.ca.intertest.common.Structures.loadChildren(element, opt);
            ++n2;
        }
    }

    public static ArrayList<String> getAvailableStructures(String selProg, HashMap<String, TreeObject> treeobjs, ArrayList<String> progs, int opt) {
        structs = new ArrayList();
        structobjs = new ArrayList();
        TreeObject tree = treeobjs.get(selProg);
        com.ca.intertest.common.Structures.loadChildren(tree, opt);
        return structs;
    }

    public static Structures getInstance() {
        if (Structures == null) {
            Structures = new Structures();
        }
        return Structures;
    }

    public static TreeObject getTree(String altname, int opt, debugSession session) {
        return com.ca.intertest.common.Structures.getInstance()._getTree(altname, opt, session);
    }
}

