/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.ASMVariable;
import com.ca.intertest.common.CobolVariable;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.PLIVariable;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.dialogs.ArrayRowList;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.tools.XMLFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Outline {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String FORMAT_NUMBER = "%06d:%s";
    private static final Debug debug = Debug.getInstance();
    private debugFile debugfile;
    private HashMap<String, ArrayList<TreeObject>> names;
    private ArrayList<ArrayRowList> arrayObjects = new ArrayList();
    private HashMap<String, NamedNodeMap> altvars = new HashMap();
    private HashMap<Integer, Integer> statementXref;
    private HashMap<Integer, Integer> lineXref;
    private int language;
    private TreeObject tree;
    private Statement stmtTree;
    private static final TreeObject[] EMPTYTREE = new TreeObject[0];
    private static final String COBOLDELIMITER = " IN | OF ";
    private static final String DEFAULTDELIMITER = "\\.";
    private final HashMap<String, TreeObject> pointers = new HashMap();

    private Outline(debugFile debugfile) throws ITException {
        this.tree = new TreeObject("root", "root");
        this.debugfile = debugfile;
        this.reLoad();
    }

    public void reLoad() throws ITException {
        TreeObject[] treeObjectArray = this.tree.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject item = treeObjectArray[n2];
            this.tree.removeChildTree(item);
            ++n2;
        }
        this.language = this.debugfile.getLanguage();
        XMLFile xml = null;
        InputStream settingsfile = this.debugfile.getSettingsstream();
        if (settingsfile == null) {
            throw new ITException(Messages.Outline_5);
        }
        xml = new XMLFile(settingsfile);
        this.debugfile.closeSettingsFile();
        if (xml == null) {
            throw new ITException(Messages.Outline_6);
        }
        Element member = xml.getFirstMember();
        if (member == null) {
            throw new ITException(Messages.Outline_7);
        }
        NodeList list = member.getElementsByTagName("symbols");
        if (list.getLength() < 1) {
            throw new ITException(Messages.Outline_7);
        }
        this.names = new HashMap();
        NodeList children = list.item(0).getChildNodes();
        int limit = children.getLength();
        int i = 0;
        while (i < limit) {
            this.buildTree((Element)children.item(i), this.tree);
            ++i;
        }
        list = member.getElementsByTagName("statement");
        this.stmtTree = list.getLength() > 0 ? new Statement((Element)list.item(0)) : new Statement(StatementType.NOOP, 0, 0, 0);
        list = member.getElementsByTagName("linenumbers");
        if (list.getLength() > 0) {
            this.statementXref = new HashMap(children.getLength());
            this.lineXref = new HashMap(children.getLength());
            children = list.item(0).getChildNodes();
            limit = children.getLength();
            i = 0;
            while (i < limit) {
                Element xref = (Element)children.item(i);
                this.statementXref.put(Integer.valueOf(xref.getAttribute("statementnumber")), Integer.valueOf(xref.getAttribute("linenumber")));
                this.lineXref.put(Integer.valueOf(xref.getAttribute("linenumber")), Integer.valueOf(xref.getAttribute("statementnumber")));
                ++i;
            }
        } else {
            this.statementXref = new HashMap(0);
            this.lineXref = new HashMap(0);
        }
        list = member.getElementsByTagName("altvarnames");
        if (list.getLength() > 0) {
            children = list.item(0).getChildNodes();
            this.altvars = new HashMap(children.getLength());
            limit = children.getLength();
            i = 0;
            while (i < limit) {
                Element altvar = (Element)children.item(i);
                NamedNodeMap nodes = altvar.getAttributes();
                this.altvars.put(altvar.getAttribute("name"), nodes);
                ++i;
            }
        } else {
            this.altvars = new HashMap(0);
        }
        for (Map.Entry<String, ArrayList<TreeObject>> name : this.names.entrySet()) {
            for (TreeObject item : name.getValue()) {
                item.setAttribute("name", this.getQualifiedName(item));
            }
        }
    }

    public TreeObject getVarLenTreeobject(TreeObject varLenTreeobject) {
        int varLenStmt = (Integer)Attribute.getValue("statementnumber", varLenTreeobject);
        HashMap<Integer, TreeObject> tos = new HashMap<Integer, TreeObject>(this.names.size());
        ArrayList<Integer> stmts = new ArrayList<Integer>();
        int i = 0;
        Object[] objectArray = this.names.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            String str = (String)obj;
            ArrayList<TreeObject> treeList = this.names.get(str);
            for (TreeObject treeobject : treeList) {
                int stmt = (Integer)Attribute.getValue("statementnumber", treeobject);
                tos.put(stmt, treeobject);
                stmts.add(stmt);
                ++i;
            }
            ++n2;
        }
        Object[] objstmt = new Object[i];
        objstmt = stmts.toArray();
        Arrays.sort(objstmt);
        int j = 0;
        while (j < objstmt.length) {
            TreeObject lenTree;
            int dptyp;
            TreeObject tree = (TreeObject)tos.get(objstmt[j]);
            if (tree.getName().equals(varLenTreeobject.getName()) && varLenStmt == (Integer)objstmt[j] && (dptyp = ((Integer)Attribute.getValue("gt_dptyp", lenTree = (TreeObject)tos.get(objstmt[j + 1]))).intValue()) == 11) {
                return lenTree;
            }
            ++j;
        }
        return null;
    }

    private TreeObject buildTree(Element child, TreeObject parent) {
        if (child == null) {
            return parent;
        }
        TreeObject current = parent;
        String type = child.getTagName();
        if (type.equals("variables")) {
            try {
                switch (this.language) {
                    case 32: {
                        current = new CobolVariable(child);
                        break;
                    }
                    case 16: {
                        current = new ASMVariable(child);
                        break;
                    }
                    case 128: {
                        current = new PLIVariable(child);
                        int hpvltp = Integer.parseInt((String)Attribute.getValue("gt_pvltp", current), 16);
                        if ((hpvltp & 0x10) != 0) {
                            this.pointers.put(current.getName(), current);
                        }
                        break;
                    }
                    default: {
                        current = new TreeObject(child);
                        break;
                    }
                }
            }
            catch (ITException e) {
                Logger.loggit(e);
                current = new TreeObject(child);
            }
        } else {
            current = new TreeObject(child);
        }
        if (this.language == 16 && !parent.hasChildren() && parent.toString().equals(current.toString())) {
            return null;
        }
        parent.addChild(current);
        switch (current.getType()) {
            case 1: 
            case 2: {
                String key = current.getName();
                ArrayList<TreeObject> array = this.names.get(key);
                if (array == null) {
                    array = new ArrayList(1);
                    this.names.put(key, array);
                }
                array.add(current);
            }
        }
        NodeList children = child.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.buildTree((Element)children.item(i), current);
            ++i;
        }
        return current;
    }

    public HashMap<String, ArrayList<TreeObject>> getNames() {
        return this.names;
    }

    private TreeObject getParent(String name, TreeObject child) {
        if (child == null) {
            return null;
        }
        TreeObject parent = child.getParent();
        if (parent == null) {
            return null;
        }
        Integer level = (Integer)parent.getValue("level");
        if (level < 0) {
            return null;
        }
        if (parent.getName().equals(name)) {
            return parent;
        }
        return this.getParent(name, parent);
    }

    public String getQualifiedName(TreeObject element) {
        int ilevel = (Integer)Attribute.getValue("level", element);
        if (ilevel < 1) {
            return null;
        }
        String name = element.getName();
        if (this.language == 16) {
            return name;
        }
        if (this.language == 32 && "FILLER".equalsIgnoreCase(name)) {
            return name;
        }
        TreeObject[] namelist = this.getQualifiedObjects(name);
        while (namelist.length > 1) {
            StringBuilder fullname = new StringBuilder(name);
            if ((element = element.getParent()).getParent() == null) {
                namelist = new TreeObject[]{};
                continue;
            }
            String parentname = element.getName();
            if (parentname != null) {
                switch (this.language) {
                    case 32: {
                        fullname.append(" OF ");
                        fullname.append(parentname);
                        break;
                    }
                    case 128: {
                        fullname.insert(0, '.');
                        fullname.insert(0, parentname);
                    }
                }
            }
            name = fullname.toString();
            namelist = this.getQualifiedObjects(name);
        }
        return name;
    }

    public TreeObject getPostedTreeObject(String name, int statement) {
        String key = statement > 0 ? String.format(FORMAT_NUMBER, statement, name) : name;
        TreeObject[] trees = this.getQualifiedObjects(key);
        return trees.length == 1 ? trees[0] : null;
    }

    public TreeObject[] getQualifiedObjects(String name) {
        String[] namelist;
        if (name == null) {
            return EMPTYTREE;
        }
        if ((name = name.trim()).length() == 0) {
            return EMPTYTREE;
        }
        if (this.language != 128) {
            name = name.toUpperCase();
        }
        name = name.replaceAll("[ ]+", " ");
        int statement = 0;
        if (name.length() > 7 && name.charAt(6) == ':') {
            try {
                statement = Integer.parseInt(name.substring(0, 6));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
            name = name.substring(7);
        }
        switch (this.language) {
            case 32: {
                namelist = name.split(COBOLDELIMITER);
                break;
            }
            case 128: {
                namelist = name.split(DEFAULTDELIMITER);
                break;
            }
            default: {
                namelist = new String[]{name};
            }
        }
        if (namelist.length == 0) {
            namelist = new String[]{name};
        }
        ArrayList<String> qnames = new ArrayList<String>(namelist.length);
        if (this.language == 32) {
            String[] stringArray = namelist;
            int n = namelist.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null) {
                    qnames.add(item);
                }
                ++n2;
            }
        } else {
            int i = namelist.length - 1;
            while (i >= 0) {
                if (namelist[i] != null) {
                    qnames.add(namelist[i]);
                }
                --i;
            }
        }
        if (qnames.size() == 0) {
            return EMPTYTREE;
        }
        String candidatename = (String)qnames.get(0);
        ArrayList<TreeObject> candidates = this.names.get(candidatename);
        if (candidates == null || candidates.size() == 0) {
            return EMPTYTREE;
        }
        if (candidates.size() > 1) {
            if (statement != 0) {
                for (TreeObject item : candidates) {
                    int newstatement = (Integer)Attribute.getValue("statementnumber", item);
                    if (statement != newstatement) continue;
                    return new TreeObject[]{item};
                }
            }
            candidates = new ArrayList<TreeObject>(candidates);
            qnames.remove(0);
            for (String qname : qnames) {
                if (candidates.size() <= 1) break;
                Iterator<TreeObject> it = candidates.iterator();
                while (it.hasNext()) {
                    TreeObject next = it.next();
                    TreeObject result = this.getParent(qname, next);
                    if (result != null) continue;
                    it.remove();
                }
            }
        }
        return candidates.toArray(new TreeObject[candidates.size()]);
    }

    public TreeObject getTree() {
        return this.tree;
    }

    public HashMap<Integer, Integer> getStatementXref() {
        return this.statementXref;
    }

    public int getLineNumber(int statement) {
        Integer result = this.statementXref.get(statement);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public debugFile getDebugfile() {
        return this.debugfile;
    }

    public int getLanguage() {
        return this.language;
    }

    public final Statement getStmtTree() {
        return this.stmtTree;
    }

    public final HashMap<String, NamedNodeMap> getAltVars() {
        return this.altvars;
    }

    public final HashMap<Integer, Integer> getLineXref() {
        return this.lineXref;
    }

    public int getStatementNumber(int liennumber) {
        Integer result = this.lineXref.get(liennumber);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public static final Outline getInstance(IFile file) throws ITException {
        debugFile debugfile = (debugFile)debug.getResource((IResource)file);
        debugfile = (debugFile)debug.getResource((IResource)file);
        if (debugfile == null) {
            throw new ITException(Messages.Outline_17);
        }
        return Outline.getInstance(debugfile);
    }

    public static final Outline getInstance(debugFile debugfile) throws ITException {
        if (debugfile == null) {
            throw new ITException(Messages.Outline_18);
        }
        Outline outline = debugfile.getOutline();
        if (outline == null) {
            outline = new Outline(debugfile);
            debugfile.setOutline(outline);
        }
        return outline;
    }

    public Statement hasLinenumber(int linenumber) {
        return this.stmtTree.hasLinenumber(linenumber);
    }

    public Statement hasStatement(int statement) {
        return this.stmtTree.hasStatement(statement);
    }

    public Statement hasOffset(byte[] offset, StatementType type) {
        return this.stmtTree.hasOffset(offset, type);
    }

    public ArrayList<ArrayRowList> getArrayObjects() {
        return this.arrayObjects;
    }

    public void setArrayObjects(ArrayList<ArrayRowList> objs) {
        this.arrayObjects = objs;
    }

    public HashMap<String, TreeObject> getPLIPointerObjects() {
        return this.pointers;
    }
}

