/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.ASMBaseRegisters;
import com.ca.intertest.common.ASMVariable;
import com.ca.intertest.common.Expressions;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.PLIVariable;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.common.VariableArrays;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DataRequestMessage;
import com.ca.intertest.tools.DataReturnMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.StatusMessage;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.AutoDataViewPage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MemoryRequest {
    protected static final boolean debugOn = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/debug/trace"));
    private short requestType;
    private String program;
    private debugSession session;
    private String fetchMsg;
    private int dataLength;
    private MFAddress address;
    private long offset;
    private String coreCmd;
    private CVMI cvmiPacket;
    private int msgcnt = 0;
    private int lang;
    boolean isDataView = true;
    private TreeObject parentTree;
    private DataReturnMessage drmsg = null;
    private AbstractDataViewPage viewpage;
    protected ArrayList<TreeObject> fetchObjects;
    public TreeObject initTreeObject = null;
    protected final IPreferenceStore store = IntertestPlugin.getConfigurationPreferences();
    private ListerEditor editor;
    private static String ASM_ERROR = Messages.MemoryRequest_errorAsmRegister;
    private static String FETCH_FAILED = Messages.MemoryRequest_errorFetch;
    private static String CORECMD_MSG = Messages.MemoryRequest_infoCorecmdFetch;
    private static String BASEOFF_MSG = Messages.MemoryRequest_infoBaseoffFetch;
    private static String VARNAME_MSG = Messages.MemoryRequest_infoVarnameFetch;
    private static String BAD_INDEX = Messages.MemoryRequest_errorBadIndexRetrieval;
    private static String DEBUG_MSG = Messages.MemoryRequest_debugMessage;

    public MemoryRequest(debugSession session, String program, int msgcnt, CVMI cvmiPacket, ArrayList<TreeObject> fetchObjects, AbstractDataViewPage viewpage, int lang) {
        this.msgcnt = msgcnt;
        this.program = program;
        this.session = session;
        this.cvmiPacket = cvmiPacket;
        this.fetchObjects = fetchObjects;
        this.viewpage = viewpage;
        this.lang = lang;
        this.editor = viewpage.getEditor();
    }

    public MemoryRequest(debugSession session, ListerEditor editor, String program, int lang) {
        this.program = program;
        this.session = session;
        this.editor = editor;
        this.cvmiPacket = null;
        this.isDataView = false;
        this.lang = lang;
    }

    public boolean sendMemoryMessage(TreeObject child, TreeObject parent) {
        if (debugOn) {
            boolean bts = false;
            if (this.viewpage != null) {
                bts = this.viewpage.isBackTraceStop();
            }
            boolean idm = this.session.isDataMonitorOK();
            int bkpstatement = this.editor.getBPStatement();
            String par = parent == null ? "(null)" : parent.getName();
            String chi = child == null ? "(null)" : child.getName();
            String loc = this.viewpage instanceof AutoDataViewPage ? "auto" : "watch";
            Logger.loggit(0, String.format(DEBUG_MSG, String.valueOf(bkpstatement), loc, chi, par, String.valueOf(bts), String.valueOf(idm)));
        }
        this.parentTree = child;
        return this.sendMemoryMessage(child);
    }

    public TreeObject autoDataTransform(TreeObject treeobject) {
        TreeObject child = treeobject;
        TreeObject parent = child.getAttribute("gt_dstyp").equals("f0") ? null : child.getParent();
        String exprName = child.getName();
        TreeObject tree = Expressions.getTree(exprName, "CORE_EXPRESSION");
        tree.setKeyword(exprName);
        String sLth = child.getAttribute("length");
        switch (this.lang) {
            case 16: {
                tree.setAttribute("length", sLth);
                tree.setAlternateName(child.getAlternateName());
                break;
            }
            case 32: 
            case 128: {
                if ((Integer)Attribute.getValue("gt_dmax1", child) > 0) {
                    tree.setAttribute("length", sLth);
                    tree.setAlternateName(String.format("/%s/%s/%s/%s/", child.getAddress().getAddrString(), "0", "0", sLth));
                    break;
                }
                int offset = (Integer)Attribute.getValue("structureoffset", child);
                int lth = (Integer)Attribute.getValue("length", child);
                int parentoffset = 0;
                int parentlth = 0;
                if (parent != null && (Integer)Attribute.getValue("level", parent) > 0) {
                    parentoffset = (Integer)Attribute.getValue("structureoffset", parent);
                    parentlth = (Integer)Attribute.getValue("length", parent);
                    this.parentTree = parent;
                }
                if (offset < 0) {
                    offset = 0;
                }
                if (parentlth > 0) {
                    lth = parentlth;
                    offset -= parentoffset;
                }
                MFAddress baseaddr = child.getAddress().subtract((long)offset);
                sLth = String.valueOf(lth);
                tree.setAlternateName(String.format("/%s/%s/%s/%s/", baseaddr.getAddrString(), "0", "0", sLth));
                tree.setAttribute("length", sLth);
                break;
            }
        }
        return tree;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendMemoryMessage(TreeObject treeobject) {
        boolean result;
        TreeObject tree;
        block32: {
            block31: {
                this.initTreeObject = treeobject;
                tree = treeobject;
                result = false;
                this.requestType = (short)-1;
                this.coreCmd = "";
                if (this.viewpage instanceof AutoDataViewPage) {
                    tree = this.autoDataTransform(treeobject);
                }
                if (tree instanceof Variable) {
                    this.requestType = (short)3;
                }
                if (!tree.getAttribute("dataflag").equals("CORE_EXPRESSION")) break block31;
                this.coreCmd = tree.getAlternateName().toUpperCase();
                this.requestType = 1;
                if (this.coreCmd.substring(0, 1).equals("/")) {
                    this.requestType = (short)2;
                    String[] parms = this.coreCmd.split("/");
                    this.coreCmd = "";
                    try {
                        this.address = new MFAddress(parms[1]);
                    }
                    catch (Exception e) {
                        this.address = MFAddress.ZERO_ADDR;
                        Logger.loggit(e);
                    }
                    try {
                        this.offset = Long.parseLong(parms[2], 16);
                    }
                    catch (Exception e) {
                        this.offset = 0L;
                        Logger.loggit(e);
                    }
                    try {
                        this.address.setAlet(Long.parseLong(parms[3], 16));
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
                break block32;
            }
            if (tree.getAttribute("dataflag").equals("DATAVIEW_KEYWORD")) {
                this.coreCmd = tree.getKeyword().toUpperCase();
                this.requestType = 1;
            }
        }
        if (this.requestType == -1) {
            return result;
        }
        this.dataLength = (Integer)Attribute.getValue("length", tree);
        if (this.dataLength == 0) {
            this.dataLength = this.store.getInt("DATAVIEW_ASM_VAR_DEFAULT_LENGTH");
        }
        DataRequestMessage msg = null;
        if (this.session.isAtBreakpoint()) {
            CVMO cvmo = null;
            try {
                CVMI cvmi = new CVMI();
                msg = new DataRequestMessage(this.requestType);
                switch (this.requestType) {
                    case 1: {
                        msg.setCoreCmd(this.coreCmd);
                        msg.setProgram(this.program);
                        String str = "Command ";
                        if (!((String)Attribute.getValue("asmlbl", tree)).equals("true")) {
                            str = "Assembler label ";
                        }
                        this.fetchMsg = String.format(CORECMD_MSG, str, this.coreCmd, this.program);
                        break;
                    }
                    case 2: {
                        this.fetchMsg = String.format(BASEOFF_MSG, this.address.getLowString(), String.valueOf(this.offset));
                        this.address.add(this.offset);
                        msg.setAddress(this.address);
                        break;
                    }
                    case 3: {
                        String varName = tree.getName();
                        if (this.session.isCICS() && tree instanceof ASMVariable && (varName = this.getASMVarName(tree, this.editor, varName, this.offset)).length() == 0) {
                            String msgText = String.format(ASM_ERROR, tree.getName());
                            Logger.loggit(0, msgText);
                            return false;
                        }
                        if ((Integer)Attribute.getValue("gt_dmax1", tree) > 0) {
                            Integer[] idxs = new Integer[]{0};
                            int max = VariableArrays.getArrayLth(tree, idxs, 3);
                            int min = VariableArrays.getArrayLth(tree, idxs, 1);
                            this.dataLength += max - min;
                        } else {
                            String ix = tree.getAttribute("gt_dstyp");
                            if (ix.equals("f0")) {
                                this.dataLength = 4;
                            }
                        }
                        msg.setProgram(this.program);
                        msg.setStmt(((Integer)Attribute.getValue("statementnumber", tree)).intValue());
                        if (tree instanceof PLIVariable) {
                            int dstyp;
                            int hpvltp = Integer.parseInt((String)Attribute.getValue("gt_pvltp", tree), 16);
                            boolean baseaddr = false;
                            if ((hpvltp & 4) != 0) {
                                baseaddr = true;
                            }
                            if ((dstyp = ((Integer)Attribute.getValue("gt_dstyp", tree)).intValue()) == 6 && !baseaddr) {
                                varName = tree.getAlternateName();
                            }
                        }
                        msg.setVarName(varName);
                        this.fetchMsg = String.format(VARNAME_MSG, varName, this.program);
                        break;
                    }
                }
                msg.setDataLength(this.dataLength);
                cvmi.addMessage((DebugMessage)msg);
                if (this.isDataView) {
                    this.cvmiPacket.addMessage((DebugMessage)msg);
                    ++this.msgcnt;
                    this.fetchObjects.add(this.parentTree);
                    return true;
                }
                try {
                    cvmo = this.session.getTalker().process(cvmi);
                    this.processCVMO(cvmo, tree);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        return false;
    }

    public void processCVMO(CVMO cvmoPacket) {
        int msgptr = 0;
        DebugMessage[] debugMessageArray = cvmoPacket.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            this.processCVMO(message, msgptr);
            ++msgptr;
            ++n2;
        }
    }

    protected void processCVMO(DebugMessage message, int idx) {
        TreeObject treeobject = this.fetchObjects.get(idx);
        this.processMessage(message, treeobject);
    }

    protected void processCVMO(CVMO cvmo, TreeObject treeobject) {
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            this.processMessage(message, treeobject);
            ++n2;
        }
    }

    protected void processMessage(DebugMessage message, TreeObject treeobject) {
        switch (message.getMessageID()) {
            case 5: {
                this.drmsg = (DataReturnMessage)message;
                ByteBuffer bb = ByteBuffer.wrap(this.drmsg.getHexdata());
                treeobject.setBackingdata(bb);
                if (MemoryRequest.isBatchRegs(treeobject, this.session)) {
                    bb = treeobject.reorderBackingdata(bb);
                    treeobject.setBackingdata(bb);
                }
                treeobject.setAddress(this.drmsg.getAddress());
                if (this.isDataView) {
                    int backingdataOffset = (Integer)Attribute.getValue("structureoffset", treeobject);
                    this.loadChildren(treeobject, backingdataOffset, treeobject.getAddress());
                }
                treeobject.setAttribute("isclean", "true");
                break;
            }
            case 18: {
                StatusMessage smsg = (StatusMessage)message;
                Shell shell = Display.getDefault().getActiveShell();
                String caption = this.isDataView ? "Data View" : "Memory Dump";
                String text = String.format(FETCH_FAILED, this.fetchMsg, smsg.getStatus(), smsg.getMessage());
                MessageDialog.openWarning((Shell)shell, (String)caption, (String)text);
                treeobject.setAttribute("isclean", "false");
            }
        }
    }

    protected void loadChildren(TreeObject to, int backingdataOffset, MFAddress backingdataAddr) {
        to.setBackingdataAddress(backingdataAddr);
        to.setBackingdataOffset(backingdataOffset);
        String keyword = to.getKeyword();
        TreeObject[] treeObjectArray = to.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject element = treeObjectArray[n2];
            String ix = element.getAttribute("gt_dstyp");
            if (!ix.equals("f0")) {
                element.setBackingdata(to.getBackingdata());
                element.setKeyword(keyword);
                int elementOffset = (Integer)Attribute.getValue("structureoffset", element);
                element.setAddress(backingdataAddr.add((long)(elementOffset - backingdataOffset)));
                this.loadChildren(element, backingdataOffset, backingdataAddr);
            } else {
                this.sendIndexMemoryMessage(element);
            }
            ++n2;
        }
    }

    public void sendIndexMemoryMessage(TreeObject treeobject) {
        DataRequestMessage msg = null;
        if (this.session.isAtBreakpoint()) {
            String varName = treeobject.getName();
            CVMO cvmo = null;
            try {
                CVMI cvmi = new CVMI();
                msg = new DataRequestMessage(3);
                msg.setProgram(this.program);
                msg.setStmt(((Integer)Attribute.getValue("statementnumber", treeobject)).intValue());
                msg.setVarName(varName);
                msg.setDataLength(4);
                cvmi.addMessage((DebugMessage)msg);
                cvmo = this.session.getTalker().process(cvmi);
                this.processIndexCVMO(cvmo, treeobject);
            }
            catch (Exception exception) {}
        }
    }

    protected void processIndexCVMO(CVMO cvmo, TreeObject treeobject) {
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 5: {
                    this.drmsg = (DataReturnMessage)message;
                    ByteBuffer bb = ByteBuffer.wrap(this.drmsg.getHexdata());
                    treeobject.setBackingdata(bb);
                    treeobject.setAddress(this.drmsg.getAddress());
                    break;
                }
                case 18: {
                    StatusMessage smsg = (StatusMessage)message;
                    Shell shell = Display.getDefault().getActiveShell();
                    String text = String.format(BAD_INDEX, smsg.getStatus(), smsg.getMessage());
                    MessageDialog.openWarning((Shell)shell, (String)"Data View", (String)text);
                }
            }
            ++n2;
        }
    }

    public MFAddress fetchAddressMessage(TreeObject treeobject) {
        DataRequestMessage msg = null;
        if (this.session.isAtBreakpoint()) {
            String varName = treeobject.getName();
            CVMO cvmo = null;
            try {
                CVMI cvmi = new CVMI();
                msg = new DataRequestMessage(3);
                msg.setProgram(this.program);
                msg.setStmt(((Integer)Attribute.getValue("statementnumber", treeobject)).intValue());
                msg.setVarName(varName);
                msg.setDataLength(1);
                cvmi.addMessage((DebugMessage)msg);
                cvmo = this.session.getTalker().process(cvmi);
                return this.processAddressCVMO(cvmo, treeobject);
            }
            catch (Exception exception) {
                return MFAddress.ZERO_ADDR;
            }
        }
        return MFAddress.ZERO_ADDR;
    }

    protected MFAddress processAddressCVMO(CVMO cvmo, TreeObject treeobject) {
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 5: {
                    DataReturnMessage drmsg = (DataReturnMessage)message;
                    treeobject.setAddress(drmsg.getAddress());
                    return drmsg.getAddress();
                }
                case 18: {
                    StatusMessage smsg = (StatusMessage)message;
                    Shell shell = Display.getDefault().getActiveShell();
                    String text = String.format(Messages.ViewData_24, smsg.getStatus(), smsg.getMessage());
                    MessageDialog.openWarning((Shell)shell, (String)Messages.ViewData_23, (String)text);
                    return MFAddress.ZERO_ADDR;
                }
            }
            ++n2;
        }
        return MFAddress.ZERO_ADDR;
    }

    public static boolean isBatchRegs(TreeObject tree, debugSession sess) {
        boolean result = false;
        if (tree.getKeyword() == null || sess.isCICS()) {
            return false;
        }
        if (tree.getBackingdata().limit() > 64 && (tree.getKeyword().equals("REGS") || tree.getKeyword().equals("REGS64"))) {
            result = true;
        }
        return result;
    }

    public int getMsgcnt() {
        return this.msgcnt;
    }

    public TreeObject getParentTree() {
        return this.parentTree;
    }

    public DataReturnMessage getDataReturnMessage() {
        return this.drmsg;
    }

    public String getASMVarName(TreeObject tree, ListerEditor editor, String varName, long offset) {
        String newVar = varName;
        if (!((String)Attribute.getValue("asmlbl", tree)).equals("true")) {
            if (editor == null) {
                newVar = "";
            } else {
                int bpstmt = editor.getBPStatement();
                if (bpstmt == 0) {
                    newVar = "";
                } else {
                    ASMBaseRegisters breg = new ASMBaseRegisters(editor);
                    newVar = breg.getBaseRegister(tree, (int)offset);
                }
            }
        }
        return newVar;
    }
}

