/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.admin.preferences;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.dialogs.JclEditDialog;
import com.ca.intertest.server.ServerList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AdminPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected List jclViewer = null;
    private boolean oldAdmin;

    public AdminPreferencePage() {
        super(1);
        if (this.oldAdmin) {
            this.setDescription(Messages.PreferencePage_description);
        } else {
            this.setDescription(Messages.AdminPreferencePage_0);
        }
        this.setPreferenceStore(IntertestPlugin.getConfigurationPreferences());
    }

    public AdminPreferencePage(int style) {
        super(style);
    }

    public AdminPreferencePage(String title, int style) {
        super(title, style);
    }

    public AdminPreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    protected void createFieldEditors() {
        if (this.oldAdmin) {
            ScopedPreferenceStore store = (ScopedPreferenceStore)IntertestPlugin.getConfigurationPreferences();
            Composite parent = this.getFieldEditorParent();
            this.addBlankLine(parent);
            IntegerFieldEditor port = new IntegerFieldEditor("DEFAULT_SERVER_PORT", Messages.PreferencePage_port, this.getFieldEditorParent(), 5);
            port.setValidRange(1, 65534);
            port.setTextLimit(5);
            Text text = port.getTextControl(parent);
            text.setText(store.getString("DEFAULT_SERVER_PORT"));
            GridData data = (GridData)text.getLayoutData();
            data.grabExcessHorizontalSpace = false;
            data.horizontalAlignment = 1;
            data.widthHint = 35;
            this.addField((FieldEditor)port);
            this.addBlankLine(parent);
            this.jclViewer = new List(parent, 2816);
            this.jclViewer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            String JCL = store.getString("JCL_stream");
            if (JCL == null || JCL.length() == 0) {
                ServerList.getInstance();
                JCL = store.getDefaultString("JCL_stream");
            }
            this.jclViewer.setItems(this.getJclViewerItems(JCL));
        }
    }

    public void init(IWorkbench workbench) {
        this.oldAdmin = IntertestPlugin.getDefault().isOldAdmin();
    }

    protected void contributeButtons(Composite parent) {
        if (this.oldAdmin) {
            Button editjcl = new Button(parent, 8);
            editjcl.setText(Messages.PreferencePage_edit_button);
            editjcl.setToolTipText(Messages.PreferencePage_edit_button_tooltip);
            ++((GridLayout)parent.getLayout()).numColumns;
            editjcl.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    JclEditDialog dialog;
                    int ok;
                    ScopedPreferenceStore store = (ScopedPreferenceStore)IntertestPlugin.getConfigurationPreferences();
                    String JCL = store.getString("JCL_stream");
                    if (JCL == null || JCL.length() == 0) {
                        ServerList.getInstance();
                        JCL = store.getDefaultString("JCL_stream");
                    }
                    if ((ok = (dialog = new JclEditDialog(AdminPreferencePage.this.getShell(), JCL)).open()) == 0) {
                        JCL = dialog.getJclStream();
                        store.setValue("JCL_stream", JCL);
                        AdminPreferencePage.this.jclViewer.setItems(AdminPreferencePage.this.getJclViewerItems(JCL));
                        AdminPreferencePage.this.jclViewer.update();
                    }
                }
            });
        }
        super.contributeButtons(parent);
    }

    public boolean performOk() {
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        ScopedPreferenceStore store = (ScopedPreferenceStore)IntertestPlugin.getConfigurationPreferences();
        String jcl = null;
        try {
            jcl = ServerList.getInstance().getDefaultJCL();
        }
        catch (Exception e) {
            Logger.loggit((Throwable)e);
        }
        store.setValue("JCL_stream", jcl);
        this.jclViewer.setItems(this.getJclViewerItems(jcl));
        this.jclViewer.update();
    }

    protected String[] getJclViewerItems(String jcl) {
        String[] items = null;
        if (jcl == null || jcl.length() <= 0) {
            return null;
        }
        items = jcl.split("[\n\r]+");
        return items;
    }

    protected void addBlankLine(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }
}

