/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLRequest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Element;

public class XMLFile
extends XMLRequest {
    static String cacopyright = "Copyright \u00a9 2011 CA";
    private static final long serialVersionUID = -4150893290700971194L;
    protected static final SimpleDateFormat df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");

    static {
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static void setDay(Element element, int day) {
        element.setAttribute("gt_m_jul", Integer.toString(day));
    }

    public static void settime(Element element, int time) {
        element.setAttribute("gt_m_tim", Integer.toString(time));
    }

    public static String getAddr(Element element) {
        return element.getAttribute("OBJADDR");
    }

    public static String getCmsg(Element element) {
        return element.getAttribute("CICSmsg");
    }

    public static int getDay(Element element) {
        String day = element.getAttribute("gt_m_jul");
        int iday = 0;
        if (day != null && day.length() > 0) {
            try {
                iday = Integer.parseInt(day);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return iday;
    }

    public static String getDisaObj(Element element) {
        return element.getAttribute("disaobj");
    }

    public static String getDispObj(Element element) {
        return element.getAttribute("dispobj");
    }

    public static String getDmpObj(Element element) {
        return element.getAttribute("dumpobj");
    }

    public static String getDsn(Element element) {
        return element.getAttribute("dsn");
    }

    public static String getEnqu(Element element) {
        return element.getAttribute("enqu");
    }

    public static String getEqObj(Element element) {
        return element.getAttribute("eqtobj");
    }

    public static String getEqVal(Element element) {
        return element.getAttribute("eqtval");
    }

    public static String getFndObj(Element element) {
        return element.getAttribute("findobj");
    }

    public static String getLabelFileName(Element element) {
        return element.getAttribute("label_file_name");
    }

    public static String getObject(Element element) {
        return element.getAttribute("object");
    }

    public static int getRecordCount(Element element) {
        String count = element.getAttribute("records");
        int icount = 0;
        try {
            icount = Integer.parseInt(count);
        }
        catch (Exception exception) {}
        return icount;
    }

    public static String getSessionID(Element element) {
        return element.getAttribute("session");
    }

    public static String getSourceFileName(Element element) {
        return element.getAttribute("listing_file_name");
    }

    public static String getStr(Element element) {
        return XMLFile.decodeAttribute(element, "recstring");
    }

    public static int getTime(Element element) {
        String tod = element.getAttribute("gt_m_tim");
        int itod = 0;
        if (tod != null && tod.length() > 0) {
            try {
                itod = Integer.parseInt(tod);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return itod;
    }

    public static Calendar getTimeStamp(Element element) {
        return HexUtil.TimeStamp(element.getAttribute("time"));
    }

    public static String getTimeString(Element element) {
        return element.getAttribute("time");
    }

    public static String getVarialbeFileName(Element element) {
        return element.getAttribute("variable_file_name");
    }

    public static void setAddr(Element element, long addr) {
        String Addrs = String.valueOf(addr);
        element.setAttribute("OBJADDR", Addrs);
    }

    public static void setCmsg(Element element, String cmsg) {
        element.setAttribute("CICSmsg", cmsg.trim());
    }

    public static void setDisaObj(Element element, String disaObj) {
        element.setAttribute("disaobj", disaObj.trim());
    }

    public static void setDispObj(Element element, String dispObj) {
        element.setAttribute("dispobj", dispObj.trim());
    }

    public static void setDmpObj(Element element, String dmpObj) {
        element.setAttribute("dumpobj", dmpObj.trim());
    }

    public static void setDsn(Element element, String dsn) {
        element.setAttribute("dsn", dsn.trim());
    }

    public static void setEnq(Element element, String enQu) {
        element.setAttribute("enqu", enQu.trim());
    }

    public static void setEqObj(Element element, String eqtObj) {
        element.setAttribute("eqtobj", eqtObj.trim());
    }

    public static void setEqVal(Element element, String eqtVal) {
        element.setAttribute("eqtobj", eqtVal.trim());
    }

    public static void setFndObj(Element element, String fndObj) {
        element.setAttribute("eqtobj", fndObj.trim());
    }

    public static void setLabelFileName(Element element, String name) {
        if (name == null || name.length() < 1) {
            element.removeAttribute("label_file_name");
        } else {
            element.setAttribute("label_file_name", name);
        }
    }

    public static void setObj(Element element, String object) {
        element.setAttribute("object", object);
    }

    public static void setPwrd(Element element, String pwrd) {
        element.setAttribute("password", pwrd.trim());
    }

    public static void setRecordCount(Element element, int count) {
        element.setAttribute("records", Integer.toString(count));
    }

    public static void setSessionID(Element element, String uuid) {
        element.setAttribute("session", uuid);
    }

    public static void setSourceFileName(Element element, String name) {
        if (name == null || name.length() < 1) {
            element.removeAttribute("listing_file_name");
        } else {
            element.setAttribute("listing_file_name", name);
        }
    }

    public static void setStr(Element element, String record) {
        XMLFile.encodeAttribute(element, record, "recstring");
    }

    public static void setTimeStamp(Element element, Calendar time) {
        String date = df.format(time != null ? time.getTime() : new Date());
        element.setAttribute("time", date);
    }

    public static void setUsr(Element element, String user) {
        element.setAttribute("userid", user.trim());
    }

    public static void setVariableFileName(Element element, String name) {
        if (name == null || name.length() < 1) {
            element.removeAttribute("variable_file_name");
        } else {
            element.setAttribute("variable_file_name", name);
        }
    }

    public static void setCICSToken(Element element, byte[] token) {
        XMLFile.setCICSToken(element, HexUtil.toHex(token, 0, ' '));
    }

    public static void setCICSToken(Element element, String token) {
        element.setAttribute("cicstoken", token.trim());
    }

    public static byte[] getCICSTokenAsBytes(Element element) {
        return HexUtil.HextoBytes(XMLFile.getCICSToken(element));
    }

    public static String getCICSToken(Element element) {
        return element.getAttribute("cicstoken");
    }
}

