/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.StatementType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Statement
implements Comparable<Statement> {
    static String cacopyright = "Copyright \u00a9 2011 CA";
    private static final String sourceClass = Statement.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    public static final Statement nullStatement = new Statement(StatementType.NOOP, 0, 0, 0);
    private ArrayList<Statement> children = new ArrayList();
    private Integer statement = 0;
    private Integer laststatement = 0;
    private Integer line = 0;
    private Integer lastline = 0;
    private Integer subindex = 0;
    private Integer offset = 0;
    private Integer lastoffset = 0;
    private Statement parent = null;
    private StatementType type = StatementType.NOOP;

    private Statement() {
    }

    public Statement(String type, int statement, int subindex, int offset) {
        this(Enum.valueOf(StatementType.class, type), statement, subindex, offset);
    }

    public Statement(StatementType type, int statement, int subindex, int offset) {
        this(type, statement, subindex, 0, 0, 0, offset);
    }

    public Statement(StatementType type, int statement, int subindex, int firstline, int offset) {
        this(type, statement, subindex, statement, firstline, firstline, offset);
    }

    public Statement(StatementType type, int statement, int subindex, int laststatement, int firstline, int lastline, int offset) {
        this();
        assert (type != null);
        this.type = type;
        this.statement = statement;
        this.subindex = subindex;
        this.laststatement = laststatement == 0 ? statement : laststatement;
        this.line = firstline;
        this.lastline = lastline == 0 ? firstline : lastline;
        this.offset = offset;
    }

    public Statement(Element verb) {
        String typestring = verb.getAttribute("statement_type");
        try {
            this.type = Enum.valueOf(StatementType.class, typestring);
        }
        catch (IllegalArgumentException e) {
            this.log.log(Level.SEVERE, String.format("Invalid StatementType %s", typestring.length() == 0 ? null : typestring), e);
            this.type = StatementType.VERB;
        }
        Integer value = (Integer)Attribute.getValue("laststatement", verb);
        this.setLaststatement(value);
        value = (Integer)Attribute.getValue("statementnumber", verb);
        this.setStatement(value);
        value = (Integer)Attribute.getValue("lastlinenumber", verb);
        this.setLastline(value);
        value = (Integer)Attribute.getValue("linenumber", verb);
        this.setLine(value);
        this.subindex = (Integer)Attribute.getValue("subindex", verb);
        String string = Attribute.getValue("statementoffset", verb).toString();
        if (string != null && string.length() > 0) {
            try {
                this.setOffset(new Integer(string.toString()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string = Attribute.getValue("statementoffsetlast", verb).toString()) != null && string.length() > 0) {
            try {
                this.setLastOffset(new Integer(string.toString()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        NodeList children = verb.getElementsByTagName(verb.getNodeName());
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            this.addChild(new Statement(child));
            ++i;
        }
    }

    public Element buildElement(Element element) {
        Object data;
        element.setAttribute("statement_type", this.type.name());
        if (this.statement != 0) {
            element.setAttribute("statementnumber", String.format("%d", this.statement));
            if (!this.laststatement.equals(this.statement)) {
                element.setAttribute("laststatement", String.format("%d", this.laststatement));
            }
        }
        if (this.line != 0) {
            element.setAttribute("linenumber", String.format("%d", this.line));
            if (!this.lastline.equals(this.line)) {
                element.setAttribute("lastlinenumber", String.format("%d", this.lastline));
            }
        }
        if ((data = this.type.getData()) != null) {
            element.setAttribute("verb_data", data.toString());
        }
        if (this.subindex != 0) {
            element.setAttribute("subindex", String.format("%d", this.subindex));
        }
        if ((long)this.offset.intValue() != 0L) {
            element.setAttribute("statementoffset", this.offset.toString());
            if ((long)this.lastoffset.intValue() != 0L && this.lastoffset != this.offset) {
                element.setAttribute("statementoffsetlast", this.lastoffset.toString());
            }
        }
        for (Statement item : this.children) {
            Element childelement = element.getOwnerDocument().createElement(element.getNodeName());
            element.appendChild(item.buildElement(childelement));
        }
        return element;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void sort() {
        Collections.sort(this.children);
        for (Statement item : this.children) {
            item.sort();
        }
    }

    public boolean addChild(Statement child) {
        if (this.equals(child)) {
            return false;
        }
        for (Statement item : this.children) {
            if (!item.equals(child)) continue;
            return false;
        }
        this.children.add(child);
        child.parent = this;
        Collections.sort(this.children);
        return true;
    }

    public Statement hasLinenumber(int linenumber) {
        if (linenumber >= this.line && linenumber <= this.lastline) {
            return this;
        }
        for (Statement child : this.children) {
            Statement foundit = child.hasLinenumber(linenumber);
            if (foundit == null) continue;
            return foundit;
        }
        return null;
    }

    public Statement hasStatement(int statement) {
        if (statement >= this.statement && statement <= this.laststatement) {
            return this;
        }
        for (Statement child : this.children) {
            Statement foundit = child.hasStatement(statement);
            if (foundit == null) continue;
            return foundit;
        }
        return null;
    }

    public synchronized Statement getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public synchronized int getLastline() {
        return this.lastline;
    }

    public synchronized void setLastline(int lastline) {
        this.lastline = lastline;
    }

    public synchronized Statement getParent() {
        return this.parent;
    }

    public synchronized Statement[] getChildren(StatementType type) {
        ArrayList<Statement> chosen = new ArrayList<Statement>(this.children.size());
        for (Statement child : this.children) {
            if (type != null && !child.type.equals((Object)type)) continue;
            chosen.add(child);
        }
        return chosen.toArray(new Statement[chosen.size()]);
    }

    public synchronized void setStatement(int statement) {
        this.statement = statement;
        if (this.laststatement < statement) {
            this.laststatement = statement;
        }
    }

    public synchronized StatementType getType() {
        return this.type;
    }

    public synchronized void setType(StatementType type) {
        this.type = type;
    }

    public synchronized int getStatement() {
        return this.statement;
    }

    public synchronized int getSubindex() {
        return this.subindex;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.statement;
        result = 31 * result + this.subindex;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Statement) {
            return this.compareTo((Statement)obj) == 0;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        Statement newone = new Statement(this.type, this.statement, this.subindex, this.laststatement, this.line, this.lastline, this.offset);
        for (Statement item : this.children) {
            newone.addChild((Statement)item.clone());
        }
        return newone;
    }

    public String toString() {
        String mask;
        StringBuilder string = new StringBuilder(50);
        Formatter formatter = new Formatter(string);
        formatter.format("%s", this.type.toString());
        if (this.statement != 0) {
            mask = this.statement.equals(this.laststatement) ? "%1$d:%3$d" : "(%1$d-%2$d):%3$d";
            formatter.format(" Stmt:" + mask, this.statement, this.laststatement, this.subindex);
        }
        if (this.line != 0) {
            mask = this.line.equals(this.lastline) ? "%1$d" : "(%1$d-%2$d)";
            formatter.format(" Line:" + mask, this.line, this.lastline);
        }
        if (this.offset != 0) {
            mask = this.offset.equals(this.lastoffset) || this.lastoffset == 0 ? "%1$d" : "(%1$d-%2$d)";
            formatter.format(" Offset:" + mask, this.offset, this.lastoffset);
        }
        if (this.children.size() > 0) {
            formatter.format(" %s", Arrays.toString(this.children.toArray()));
        }
        return formatter.toString();
    }

    @Override
    public int compareTo(Statement e2) {
        int result = -1;
        if (e2 != null && (result = this.statement.compareTo(e2.statement)) == 0 && (result = this.subindex.compareTo(e2.subindex)) == 0) {
            return this.type.compareTo(e2.type);
        }
        return result;
    }

    public static Statement emptyStatement() {
        return new Statement();
    }

    public synchronized int getLaststatement() {
        return this.laststatement;
    }

    public synchronized void setLaststatement(int laststatement) {
        this.laststatement = laststatement;
    }

    public synchronized int getLine() {
        return this.line;
    }

    public synchronized void setLine(int line) {
        this.line = line;
        if (this.lastline < line) {
            this.lastline = line;
        }
    }

    public synchronized void setSubindex(int subindex) {
        this.subindex = subindex;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOffsetText() {
        return HexUtil.toHex(this.offset, 4);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Statement hasOffset(byte[] value, StatementType type) {
        return this.hasOffset(new BigInteger(value).intValue(), type);
    }

    public Statement hasOffset(int value, StatementType type) {
        if (value >= this.offset && value <= this.lastoffset && (type == null || type.equals((Object)this.type))) {
            return this;
        }
        for (Statement child : this.children) {
            Statement foundit = child.hasOffset(value, type);
            if (foundit == null) continue;
            return foundit;
        }
        return null;
    }

    public int getLastoffset() {
        return this.lastoffset;
    }

    public void setLastOffset(int lastoffset) {
        if (this.lastoffset != lastoffset) {
            this.lastoffset = lastoffset;
        }
    }
}

