/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.handlers;

import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PrevWatchHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = PrevWatchHandler.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private ScopedPreferenceStore store;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.testingtools");
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof WatchData)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Object obj = selection.getFirstElement();
        if (!(obj instanceof Data)) {
            return null;
        }
        Data data = (Data)obj;
        MFAddress mfaddress = data.getAddress();
        MFAddress newAddress = mfaddress.subtract((long)this.getChunk());
        IMemoryManager manager = data.getMemoryManager();
        try {
            Data newData = manager.getMemory(newAddress, this.getChunk());
            if (data == null || newData.isEmpty()) {
                MessageDialog.openWarning((Shell)part.getSite().getShell(), (String)"Previous data to Watch View", (String)String.format("Data at %s is not available", newAddress.toString()));
            } else {
                newData.setTitle(newAddress.toString());
                newData.setStride(32);
                newData.setOwner(data.getOwner());
                IWorkbenchWindow watchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = watchWindow.getActivePage();
                IViewPart viewPart = page.showView("com.ca.testingtools.ui.views.watchdataview");
                if (viewPart instanceof WatchData) {
                    WatchData viewer = (WatchData)viewPart;
                    viewer.addContent(new Data[]{newData});
                }
                page.activate((IWorkbenchPart)viewPart);
                page.bringToTop((IWorkbenchPart)viewPart);
                page.activate(part);
            }
        }
        catch (PartInitException e) {
            this.log.log(Level.WARNING, "Unexpected failure", e);
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        return null;
    }

    private int getChunk() {
        int size = this.store.getInt("chunksize");
        return size;
    }
}

