/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.Variable;
import java.util.Properties;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class ASMVariable
extends Variable {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final String BASE_REG = "base_reg";
    private int base_reg = -1;

    public ASMVariable(Element element) throws TTException {
        super(element);
    }

    @Override
    public boolean canEditDisplay() {
        return true;
    }

    @Override
    public boolean canEditHex() {
        return true;
    }

    @Override
    public int getDecimalPoint() {
        return (Integer)Attribute.getValue((String)"gt_sigfr", (Properties)this.attributes);
    }

    @Override
    public String varyCheck(String value, boolean mode) {
        return value;
    }

    @Override
    public String getValue() {
        this.getBackingdata();
        if (!this.canEditDisplay()) {
            return "(Not Displayable)";
        }
        if (this.backingdata == null) {
            return "";
        }
        return this.getValue(this.getData());
    }

    @Override
    protected void setDatatype() {
        int dptyp = (Integer)Attribute.getValue((String)"gt_dptyp", (Properties)this.attributes);
        switch (dptyp) {
            default: {
                this.datatype = Variable.DataType.ALPHA;
                this.storagetype = Variable.StorageType.CHAR;
                break;
            }
            case 194: 
            case 198: 
            case 199: 
            case 200: {
                this.datatype = Variable.DataType.UNSIGNED;
                this.storagetype = Variable.StorageType.BIN;
                break;
            }
            case 215: 
            case 233: {
                this.datatype = Variable.DataType.SIGNED;
                this.storagetype = Variable.StorageType.PACK;
            }
        }
    }

    @Override
    public String getHexText() {
        return this.getHexValue();
    }

    @Override
    public String getHexTextTooltipText() {
        return this.getHexText();
    }

    @Override
    public String getProperties() {
        Integer fsize = (Integer)Attribute.getValue((String)"length", (Properties)this.attributes);
        String sFsize = fsize > 0 ? String.format("[%d]", fsize) : "";
        String value = "";
        Integer dptyp = (Integer)Attribute.getValue((String)"gt_dptyp", (Properties)this.attributes);
        switch (dptyp) {
            case 0: {
                value = "DSECT";
                break;
            }
            case 193: {
                value = "A-, J-type address constant";
                break;
            }
            case 194: {
                value = "Binary constant";
                break;
            }
            case 195: {
                value = "Character constant";
                break;
            }
            case 196: {
                value = "Long floating-point constant";
                break;
            }
            case 197: {
                value = "Short floating-point constant";
                break;
            }
            case 198: {
                value = "Fullword fixed-point constant";
                break;
            }
            case 199: {
                value = "Fixed-point constant";
                break;
            }
            case 200: {
                value = "Halfword fixed-point constant";
                break;
            }
            case 210: {
                value = "Floating-point constant";
                break;
            }
            case 211: {
                value = "Extended floating-point constant";
                break;
            }
            case 215: {
                value = "Packed decimal constant";
                break;
            }
            case 216: {
                value = "Q-type address constant";
                break;
            }
            case 217: {
                value = "A-, S-, Q-, J, R-, C-, or Y-type constant";
                break;
            }
            case 226: {
                value = "S-type address constant";
                break;
            }
            case 229: {
                value = "R-, V-type address constant";
                break;
            }
            case 231: {
                value = "Hexadecimal constant";
                break;
            }
            case 232: {
                value = "Y-type address constant";
                break;
            }
            case 233: {
                value = "Zoned decimal constant";
            }
        }
        return String.format("%s %s", value, sFsize).trim();
    }

    @Override
    public String getPropertiesTooltipText() {
        return null;
    }

    @Override
    public String getValueTooltipText() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    private void _setBaseRegister(int offset, int stopStmt) {
        int register = -1;
        Integer level = (Integer)Attribute.getValue((String)"level", (Properties)this.attributes);
        Variable tree = level == 2 ? this.baseVariable : this;
        String utStmt = tree.getAttribute("utstmt");
        String utLstm = tree.getAttribute("utlstm");
        String utReg = tree.getAttribute("utreg");
        String utValu = tree.getAttribute("utvalu");
        String[] utStmts = utStmt.split(":");
        String[] utLstms = utLstm.split(":");
        String[] utRegs = utReg.split(":");
        String[] utValus = utValu.split(":");
        int utcnt = utStmts.length;
        block2 : switch (utcnt) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    register = Integer.parseInt(utReg);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            default: {
                int valu;
                boolean[] isGood = new boolean[utcnt];
                int hitCnt = 0;
                int reg = 0;
                int maxreg = 0;
                int i = 0;
                while (i < utcnt) {
                    int stmt = Integer.valueOf(utStmts[i]);
                    int lstm = Integer.valueOf(utLstms[i]);
                    if (stopStmt < stmt || stopStmt > lstm) {
                        isGood[i] = false;
                    } else {
                        isGood[i] = true;
                        reg = Integer.valueOf(utRegs[i]);
                        if (reg > maxreg) {
                            maxreg = reg;
                        }
                        ++hitCnt;
                    }
                    ++i;
                }
                if (hitCnt == 1) {
                    register = reg;
                }
                if (hitCnt <= true) break;
                int maxvalu = 0;
                hitCnt = 0;
                int i2 = 0;
                while (i2 < utcnt) {
                    if (isGood[i2]) {
                        valu = Integer.valueOf(utValus[i2]);
                        if (valu < offset) {
                            if (valu > maxvalu || maxvalu == 0 && valu == 0) {
                                maxvalu = valu;
                                ++hitCnt;
                                reg = Integer.valueOf(utRegs[i2]);
                            }
                        } else {
                            isGood[i2] = false;
                        }
                    }
                    ++i2;
                }
                if (hitCnt == 1) {
                    register = reg;
                }
                if (hitCnt <= true) break;
                i2 = 0;
                while (i2 < utcnt) {
                    valu = Integer.valueOf(utValus[i2]);
                    if (isGood[i2]) {
                        reg = Integer.valueOf(utRegs[i2]);
                        if (valu == maxvalu && reg == maxreg) {
                            register = reg;
                            break block2;
                        }
                    }
                    ++i2;
                }
                break block2;
            }
        }
        if (register == -1) {
            int reg = -1;
            try {
                if (utRegs.length == 1) {
                    reg = Integer.parseInt(utRegs[0]);
                } else if (utRegs.length == 2) {
                    int reg1 = Integer.parseInt(utRegs[0]);
                    int reg2 = Integer.parseInt(utRegs[1]);
                    reg = Math.max(reg1, reg2);
                }
            }
            catch (NumberFormatException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
            register = reg;
        }
        this.base_reg = register > 15 ? -1 : register;
    }

    public int setBaseRegister(int offset, int stopStmt) {
        if (this.base_reg == -1) {
            this._setBaseRegister(offset, stopStmt);
        }
        return this.base_reg;
    }

    public int getBase_reg() {
        return this.base_reg;
    }

    @Override
    public String getDataRequestName() {
        this.setBaseRegister(this.getOffset(), this.getStopStatement());
        if (this.base_reg < 0) {
            return this.getName();
        }
        String value = String.format("R%d.%s", this.base_reg, this.getName());
        return value;
    }

    @Override
    public Variable cloneforWatch(int stopStatement, IMemoryManager memoryManager, String programName) throws CloneNotSupportedException {
        ASMVariable clone = (ASMVariable)super.cloneforWatch(stopStatement, memoryManager, programName);
        int offset = (Integer)Attribute.getValue((String)"structureoffset", (Properties)this.getAttributes());
        clone.getBaseVariable();
        clone.getBaseVariable();
        clone.setBaseVariable(clone.baseVariable);
        if (stopStatement > 0) {
            clone.setBaseRegister(offset, stopStatement);
            if (this.baseVariable != null && this.baseVariable != this) {
                ((ASMVariable)this.baseVariable).setBaseRegister(offset, stopStatement);
            }
        }
        return clone;
    }
}

