/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.layout.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FileMasterLayout;
import com.ca.filemaster.common.FileMasterLayoutField;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.customlayout.wizards.CRLUpdate1Page;
import com.ca.filemaster.layout.wizards.LevelFieldLabelProvider;
import com.ca.filemaster.runners.RunGetViewLayout;
import com.ca.filemaster.ui.wizards.MemberSorter;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddLayoutPage2
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright (c) 2016 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.insertLayout";
    private Label serverNameLabel;
    private Label memberNameLabel;
    private Text serverNameCombo;
    private Text dataSetCombo;
    private Text memberNameComboPage2;
    private Combo datasetComboPage1;
    private Combo memberNameComboPage1;
    private Button selectAllClearButton;
    private Group selectLayoutsGroup;
    private CheckboxTableViewer checkboxTableViewer;
    private Table membersTable;
    private Listener sortListener;
    private FileMasterServer server;
    private ArrayList<Object> fmLayoutList = new ArrayList();
    private ArrayList<String> fm01LevelList = new ArrayList();
    private CRLClass crl = new CRLClass();
    private CRLUpdate1Page parentPage;

    public AddLayoutPage2(String pageName, FileMasterServer server, Combo datasetName, Combo memberName, boolean isDirectoryListCaller) {
        super(pageName, datasetName.getText(), server);
        this.setTitle("Select Top Level");
        this.server = server;
        this.datasetComboPage1 = datasetName;
        this.memberNameComboPage1 = memberName;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog && ((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof CRLUpdate1Page) {
            this.parentPage = (CRLUpdate1Page)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.insertLayout");
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("&Server:");
        this.serverNameCombo = new Text(this.dataSetComposite, 2056);
        GridData gd_serverNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.serverNameCombo.setLayoutData((Object)gd_serverNameCombo);
        this.serverNameCombo.setText(this.server.getText());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.dataSetLabel = new Label(this.dataSetComposite, 0);
        this.dataSetLabel.setText("&Data set name:");
        this.dataSetCombo = new Text(this.dataSetComposite, 2056);
        this.dataSetCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Text)this.dataSetCombo, (int)37);
        this.dataSetCombo.setTextLimit(44);
        this.dataSetCombo.setText(this.datasetComboPage1.getText());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
        this.memberNameLabel.setText("&Member name:");
        this.memberNameComboPage2 = new Text(this.dataSetComposite, 2056);
        GridData gd_memberNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.memberNameComboPage2.setLayoutData((Object)gd_memberNameCombo);
        this.memberNameComboPage2.setText(this.memberNameComboPage1.getText());
        this.memberNameComboPage2.addVerifyListener((VerifyListener)new verifytoUpperCase());
        new Label(this.dataSetComposite, 0);
        this.selectLayoutsGroup = new Group(this.container, 0);
        this.selectLayoutsGroup.setLayout((Layout)new GridLayout(2, false));
        this.selectLayoutsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selectLayoutsGroup.setText("Select layout");
        this.selectLayoutsGroup.setRedraw(true);
        this.createViewer((Composite)this.selectLayoutsGroup);
        this.selectAllClearButton = new Button((Composite)this.selectLayoutsGroup, 0);
        this.selectAllClearButton.setText("Select &All");
        GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAllClearButton.widthHint = 120;
        this.selectAllClearButton.setLayoutData((Object)gd_selectAllClearButton);
        this.selectAllClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddLayoutPage2.this.selectAllClearButton.getText() == "Select &All") {
                    AddLayoutPage2.this.checkboxTableViewer.setAllChecked(true);
                    AddLayoutPage2.this.selectAllClearButton.setText("&Clear Selections");
                } else {
                    AddLayoutPage2.this.selectAllClearButton.setText("Select &All");
                    AddLayoutPage2.this.checkboxTableViewer.setAllChecked(false);
                }
                AddLayoutPage2.this.setPageComplete(AddLayoutPage2.this.isPageComplete());
            }
        });
        this.process();
    }

    private void createViewer(Composite parent) {
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)this.selectLayoutsGroup, (int)68354);
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (AddLayoutPage2.this.checkboxTableViewer.getCheckedElements().length == AddLayoutPage2.this.checkboxTableViewer.getTable().getItemCount()) {
                    AddLayoutPage2.this.selectAllClearButton.setText("&Clear Selections");
                } else {
                    AddLayoutPage2.this.selectAllClearButton.setText("Select &All");
                }
                if (AddLayoutPage2.this.checkboxTableViewer.getCheckedElements().length == 0) {
                    AddLayoutPage2.this.selectAllClearButton.setText("Select &All");
                }
                AddLayoutPage2.this.setPageComplete(AddLayoutPage2.this.canFlipToNextPage());
            }
        });
        this.membersTable = this.checkboxTableViewer.getTable();
        this.membersTable.setLinesVisible(true);
        this.membersTable.setHeaderVisible(true);
        this.membersTable.setFocus();
        GridData gd_table = new GridData(4, 4, true, true, 2, 1);
        this.membersTable.setLayoutData((Object)gd_table);
        this.columnSorterListener();
        this.createColumns(parent, this.checkboxTableViewer);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkboxTableViewer.setInput(null);
    }

    private void createColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Top Level Field Name"};
        int[] bounds = new int[]{490};
        viewer.setSorter((ViewerSorter)new MemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    this.membersTable.setSortColumn(tableColumn);
                    this.membersTable.setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new LevelFieldLabelProvider());
                }
            }
            ++i;
        }
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = AddLayoutPage2.this.checkboxTableViewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                AddLayoutPage2.this.checkboxTableViewer.refresh();
            }
        };
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean canFinish() {
        return this.checkboxTableViewer.getCheckedElements().length > 0;
    }

    private void process() {
        this.fm01LevelList = new ArrayList();
        this.fmLayoutList = new ArrayList();
        RunGetViewLayout runner = new RunGetViewLayout(false, true, this.datasetComboPage1.getText(), this.memberNameComboPage1.getText(), this.server);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Field");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + AddLayoutPage2.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = AddLayoutPage2.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        FileMasterLayout layout;
                        Element layoutElement = (Element)nodes.item(i);
                        Element NameElement = (Element)layoutElement.getElementsByTagName("Name").item(0);
                        Element levelElement = (Element)layoutElement.getElementsByTagName("Level").item(0);
                        Element formatCharElement = (Element)layoutElement.getElementsByTagName("FormatChar").item(0);
                        Element signedElement = (Element)layoutElement.getElementsByTagName("Signed").item(0);
                        Element integerLenElement = (Element)layoutElement.getElementsByTagName("IntegerLength").item(0);
                        Element fractionLenElement = (Element)layoutElement.getElementsByTagName("FractionLength").item(0);
                        Element lengthElement = (Element)layoutElement.getElementsByTagName("Length").item(0);
                        Element positionElement = (Element)layoutElement.getElementsByTagName("Position").item(0);
                        Element redefineInfoElement = (Element)layoutElement.getElementsByTagName("RedefineInfo").item(0);
                        if (AddLayoutPage2.getTagValue("Level", levelElement).equalsIgnoreCase("01")) {
                            layout = new FileMasterLayout(null);
                            layout.setName(AddLayoutPage2.getTagValue("Name", NameElement));
                            layout.setLevel(AddLayoutPage2.getTagValue("Level", levelElement));
                            if (formatCharElement != null) {
                                layout.setFormatChar(AddLayoutPage2.getTagValue("FormatChar", formatCharElement));
                            }
                            if (signedElement != null) {
                                layout.setSigned(AddLayoutPage2.getTagValue("Signed", signedElement));
                            }
                            layout.setIntegerLength(AddLayoutPage2.getTagValue("IntegerLength", integerLenElement));
                            layout.setFractionLength(AddLayoutPage2.getTagValue("FractionLength", fractionLenElement));
                            layout.setLength(AddLayoutPage2.getTagValue("Length", lengthElement));
                            layout.setPosition(AddLayoutPage2.getTagValue("Postion", positionElement));
                            if (redefineInfoElement != null) {
                                layout.setRedefineInfo(AddLayoutPage2.getTagValue("RedefineInfo", redefineInfoElement));
                            } else {
                                layout.setRedefineInfo("");
                            }
                            this.fmLayoutList.add(layout);
                            this.fm01LevelList.add(layout.getName());
                        } else {
                            layout = new FileMasterLayoutField(null);
                            layout.setName(AddLayoutPage2.getTagValue("Name", NameElement));
                            layout.setLevel(AddLayoutPage2.getTagValue("Level", levelElement));
                            if (formatCharElement != null) {
                                layout.setFormatChar(AddLayoutPage2.getTagValue("FormatChar", formatCharElement));
                            }
                            if (signedElement != null) {
                                layout.setSigned(AddLayoutPage2.getTagValue("Signed", signedElement));
                            }
                            layout.setIntegerLength(AddLayoutPage2.getTagValue("IntegerLength", integerLenElement));
                            layout.setFractionLength(AddLayoutPage2.getTagValue("FractionLength", fractionLenElement));
                            layout.setLength(AddLayoutPage2.getTagValue("Length", lengthElement));
                            layout.setPosition(AddLayoutPage2.getTagValue("Postion", positionElement));
                            if (redefineInfoElement != null) {
                                layout.setRedefineInfo(AddLayoutPage2.getTagValue("RedefineInfo", redefineInfoElement));
                            } else {
                                layout.setRedefineInfo("");
                            }
                            this.fmLayoutList.add(layout);
                        }
                        ++i;
                    }
                }
            }
        }
        this.fm01LevelList.toArray(new Object[this.fm01LevelList.size()]);
        this.checkboxTableViewer.setInput((Object)this.fm01LevelList.toArray(new Object[this.fm01LevelList.size()]));
        this.checkboxTableViewer.setAllChecked(false);
        this.checkboxTableViewer.setSelection(null);
        this.checkboxTableViewer.refresh();
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }

    public void presetText(FileMasterServer server, String datasetName, String memberName) {
        if (this.memberNameComboPage2 != null && !this.memberNameComboPage2.getText().equalsIgnoreCase(memberName) || this.dataSetCombo != null && !this.dataSetCombo.getText().equalsIgnoreCase(datasetName) || this.serverNameCombo != null && !this.serverNameCombo.getText().equalsIgnoreCase(server.getText())) {
            this.process();
        }
        if (this.serverNameCombo != null) {
            this.serverNameCombo.setText(server.getText());
        }
        if (this.dataSetCombo != null) {
            this.dataSetCombo.setText(datasetName);
        }
        if (this.memberNameComboPage2 != null) {
            this.memberNameComboPage2.setText(memberName);
        }
    }

    public boolean doFinish() {
        if (this.parentPage != null) {
            int i = 0;
            while (i < this.checkboxTableViewer.getCheckedElements().length) {
                this.addTopLevelChildren(this.checkboxTableViewer.getCheckedElements()[i].toString());
                ++i;
            }
            this.parentPage.insertLayouts(this.crl);
        }
        return false;
    }

    private CRLClass.Layout addTopLevelChildren(String topLevelName) {
        CRLClass.Layout tempLayout = this.crl.addLayout(this.dataSetCombo.getText(), this.memberNameComboPage2.getText());
        int i = this.getIndex(topLevelName);
        while (i < this.fmLayoutList.size()) {
            if (this.fmLayoutList.get(i) instanceof FileMasterLayout) {
                if (!((FileMasterLayout)this.fmLayoutList.get(i)).getName().equalsIgnoreCase(topLevelName)) break;
                tempLayout.addField(((FileMasterLayout)this.fmLayoutList.get(i)).getName(), Integer.parseInt(((FileMasterLayout)this.fmLayoutList.get(i)).getLevel()), true, true, Integer.parseInt(((FileMasterLayout)this.fmLayoutList.get(i)).getPosition()), ((FileMasterLayout)this.fmLayoutList.get(i)).getSigned().equalsIgnoreCase("Y") ? String.valueOf(((FileMasterLayout)this.fmLayoutList.get(i)).getFormatChar()) + "S" : ((FileMasterLayout)this.fmLayoutList.get(i)).getFormatChar(), Integer.parseInt(((FileMasterLayout)this.fmLayoutList.get(i)).getIntegerLength()), Integer.parseInt(((FileMasterLayout)this.fmLayoutList.get(i)).getFractionLength()), Integer.parseInt(((FileMasterLayout)this.fmLayoutList.get(i)).getLength()), 0, 0, "");
            } else {
                tempLayout.addField(((FileMasterLayoutField)this.fmLayoutList.get(i)).getName(), Integer.parseInt(((FileMasterLayoutField)this.fmLayoutList.get(i)).getLevel()), true, true, Integer.parseInt(((FileMasterLayoutField)this.fmLayoutList.get(i)).getPosition()), ((FileMasterLayoutField)this.fmLayoutList.get(i)).getSigned().equalsIgnoreCase("Y") ? String.valueOf(((FileMasterLayoutField)this.fmLayoutList.get(i)).getFormatChar()) + "S" : ((FileMasterLayoutField)this.fmLayoutList.get(i)).getFormatChar(), Integer.parseInt(((FileMasterLayoutField)this.fmLayoutList.get(i)).getIntegerLength()), Integer.parseInt(((FileMasterLayoutField)this.fmLayoutList.get(i)).getFractionLength()), Integer.parseInt(((FileMasterLayoutField)this.fmLayoutList.get(i)).getLength()), 0, 0, "");
            }
            ++i;
        }
        return tempLayout;
    }

    private int getIndex(String topLevelName) {
        int i = 0;
        while (i < this.fmLayoutList.size()) {
            if (this.fmLayoutList.get(i) instanceof FileMasterLayout && ((FileMasterLayout)this.fmLayoutList.get(i)).getName().equalsIgnoreCase(topLevelName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

