/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.CoreDumpPage;
import com.ca.intertest.wizards.CoreStructurePage;
import com.ca.intertest.wizards.IMemoryWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class CoreWizard
extends Wizard
implements IMemoryWizard {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private final CoreDumpPage dumppage = new CoreDumpPage(dumppageName);
    private final CoreStructurePage structurepage = new CoreStructurePage(structurepageName);
    protected boolean startwithdialog = false;

    public CoreWizard() {
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Messages.CoreWizard_0);
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        super.addPages();
        this.dumppage.setTitle(dumppageName);
        this.addPage((IWizardPage)this.dumppage);
        this.structurepage.setTitle(structurepageName);
        this.addPage((IWizardPage)this.structurepage);
    }

    public boolean canFinish() {
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        Button finish;
        Button back;
        MemoryWizardDialog container = (MemoryWizardDialog)this.getContainer();
        Button next = container.getButton(15);
        if (next != null) {
            next.setText("&" + STRUCTURE_WORD);
        }
        if ((back = container.getButton(14)) != null) {
            back.setText(Messages.CoreWizard_2);
        }
        if ((finish = container.getButton(16)) != null) {
            finish.setText(Messages.CoreWizard_3);
        }
        super.createPageControls(pageContainer);
    }

    public CoreDumpPage getDumppage() {
        return this.dumppage;
    }

    public CoreStructurePage getStructurepage() {
        return this.structurepage;
    }

    @Override
    public void init(ListerEditor lsteditor) {
        this.dumppage.init(lsteditor);
        this.structurepage.initStructure(lsteditor);
    }

    @Override
    public void initCmd(ListerEditor lsteditor, String cmd, boolean postFlag) {
        this.dumppage.initCmd(lsteditor, cmd, postFlag);
        this.structurepage.initStructure(lsteditor);
    }

    @Override
    public void initCmd(ListerEditor lsteditor, String cmd, boolean postFlag, String arg1, String arg2, TreeObject tree) {
        this.dumppage.initCmd(lsteditor, cmd, postFlag, this.structurepage, arg1, arg2, tree);
        this.structurepage.initStructure(lsteditor);
    }

    @Override
    public void initVar(ListerEditor lsteditor, TreeObject treeobject, int zstmt) {
        this.dumppage.initVar(lsteditor, treeobject, zstmt, this.structurepage);
        this.structurepage.initStructure(lsteditor);
    }

    public Image getDefaultPageImage() {
        ImageDescriptor newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("BANNER_ICON_MEMORY");
        if (newimage != null) {
            return newimage.createImage(true);
        }
        return super.getDefaultPageImage();
    }
}

