/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.wizards.AbstractSettingsWizard;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractSettingsPage
extends WizardPage {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected FileServer currentServer;
    protected Combo serverCombo;
    protected ArrayList<FileServer> serverList;
    protected Button dontShowMe;
    protected Button stepAfter = null;
    protected AbstractSettingsWizard wizard;
    protected debugSession session;
    protected FocusListener focuslistener;
    protected SelectionListener selectionlistener;
    protected ModifyListener modifylistener;
    protected boolean changed = false;

    public AbstractSettingsPage(String pageName) {
        super(pageName);
    }

    public AbstractSettingsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected Composite startCreateControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.wizard = (AbstractSettingsWizard)this.getWizard();
        this.session = this.wizard.getSession();
        this.focuslistener = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                AbstractSettingsPage.this.wizard.getContainer().updateButtons();
            }
        };
        this.selectionlistener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    AbstractSettingsPage.this.changed = true;
                } else if (e.getSource() instanceof Combo) {
                    AbstractSettingsPage.this.changed = true;
                }
                AbstractSettingsPage.this.wizard.getContainer().updateButtons();
            }
        };
        this.modifylistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSettingsPage.this.changed = true;
                AbstractSettingsPage.this.wizard.getContainer().updateButtons();
            }
        };
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        this.createFileServerList(composite);
        this.createCICSServerList(composite);
        return composite;
    }

    protected void endCreateControl(Composite parent) {
        parent.setSize(parent.computeSize(-1, -1));
        Composite comp = parent.getParent();
        if (comp instanceof ScrolledComposite) {
            this.setControl((Control)comp);
        } else {
            this.setControl((Control)parent);
        }
        this.setPageComplete(this.validatePage());
    }

    protected void setOptions(Composite composite) {
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData grData = new GridData(4, 0, true, true, 1, 2);
        optionsGroup.setLayoutData((Object)grData);
        optionsGroup.setText(Messages.AbstractSettingsPage_0);
        this.dontShowMe = new Button((Composite)optionsGroup, 32);
        this.dontShowMe.setLayoutData((Object)new GridData(256, 0, true, false));
        this.dontShowMe.setText(Messages.AbstractSettingsPage_1);
        this.dontShowMe.setSelection(Boolean.parseBoolean(this.wizard.get("settingsShowWizard")));
        this.dontShowMe.addSelectionListener(this.selectionlistener);
        this.dontShowMe.setToolTipText(Messages.AbstractSettingsPage_2);
        this.stepAfter = new Button((Composite)optionsGroup, 32);
        this.stepAfter.setLayoutData((Object)new GridData(256, 0, true, false));
        this.stepAfter.setText(Messages.AbstractSettingsPage_3);
        this.stepAfter.setSelection(Boolean.parseBoolean(this.wizard.get("step_after")));
        this.stepAfter.addSelectionListener(this.selectionlistener);
        this.stepAfter.setToolTipText(Messages.AbstractSettingsPage_4);
        this.setOptionalButtons((Composite)optionsGroup);
    }

    protected abstract void createSettings(Composite var1);

    protected abstract void setOptionalButtons(Composite var1);

    protected void createFileServerList(Composite parent) {
        this.getServerList();
        Group serverGroup = new Group(parent, 0);
        serverGroup.setLayout((Layout)new GridLayout());
        serverGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        serverGroup.setText(Messages.AbstractSettingsPage_5);
        this.serverCombo = new Combo((Composite)serverGroup, 2060);
        this.serverCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        for (FileServer server : this.serverList) {
            this.serverCombo.add(server.getName());
        }
        int ix = this.serverList.indexOf(this.currentServer);
        this.serverCombo.select(ix);
        this.serverCombo.addSelectionListener(this.selectionlistener);
        this.serverCombo.addFocusListener(this.focuslistener);
    }

    private void getServerList() {
        this.currentServer = this.wizard.getFileServer();
        this.serverList = ServerList.getInstance().getFileServers();
    }

    protected abstract void createCICSServerList(Composite var1);

    protected abstract boolean isCICS();

    protected abstract boolean isBatch();

    void saveSettings() {
        this.wizard.put("settingsShowWizard", Boolean.toString(this.dontShowMe.getSelection()));
        this.wizard.put("step_after", Boolean.toString(this.stepAfter.getSelection()));
        int index = this.serverCombo.getSelectionIndex();
        this.currentServer = index >= 0 ? this.serverList.get(index) : null;
        this.wizard.setFileServer(this.currentServer);
        this.wizard.setDebugServer(this.currentServer);
        this.saveSetupGroup();
        this.changed = false;
    }

    public abstract void saveSetupGroup();

    protected boolean validatePage() {
        this.setErrorMessage(null);
        if (this.serverCombo.getItemCount() < 1) {
            this.setMessage(Messages.AbstractSettingsPage_6, 2);
        } else if (this.serverCombo.getSelectionIndex() < 0 || this.serverCombo.getText().length() < 1) {
            this.setMessage(Messages.AbstractSettingsPage_7, 2);
        } else {
            this.setMessage(null, 2);
        }
        return true;
    }

    protected boolean validateSubmit() {
        if (this.serverCombo.getItemCount() < 1) {
            this.setErrorMessage(Messages.AbstractSettingsPage_8);
            return false;
        }
        if (this.serverCombo.getSelectionIndex() < 0 || this.serverCombo.getText().length() < 1) {
            this.setErrorMessage(Messages.AbstractSettingsPage_7);
            this.serverCombo.setFocus();
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void handleEvent(Event event) {
        this.changed = true;
        this.getContainer().updateButtons();
    }

    public boolean canSubmit() {
        return this.validateSubmit();
    }
}

