/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Expressions;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.MemoryRequest;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.common.VariableArrays;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.AutoKeepMessage;
import com.ca.intertest.tools.DataRequestMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.ViewData;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;

public class AutoViewData
extends ViewData {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected debugFile debugfile;
    protected Integer lang;
    protected int defaultLength;
    protected IDebugListener listener;

    public AutoViewData(IResource resource, AbstractDataViewPage viewpage) {
        super(resource, viewpage);
        this.refreshed = false;
        this.debugfile = (debugFile)this.debugitem;
        this.lang = (Integer)Attribute.getValue("gt_m_lang", this.debugfile.getStore());
        this.defaultLength = IntertestPlugin.getConfigurationPreferences().getInt("DATAVIEW_ASM_VAR_DEFAULT_LENGTH");
        if (this.defaultLength == 0) {
            this.defaultLength = 20;
        }
    }

    @Override
    public TreeObject[] findObjects(String name) {
        return null;
    }

    @Override
    public boolean deleteObject(TreeObject item) {
        return false;
    }

    @Override
    public void sendMemoryMessage(TreeObject treeobject, TreeObject parent) {
        TreeObject tree;
        int lth = 0;
        TreeObject child = tree = treeobject;
        DataRequestMessage msg = null;
        if (this.session.isAtBreakpoint()) {
            try {
                switch (this.lang) {
                    case 16: {
                        msg = new DataRequestMessage(1);
                        msg.setProgram(this.debugitem.getName());
                        lth = (Integer)Attribute.getValue("length", tree);
                        msg.setDataLength(lth);
                        msg.setCoreCmd(tree.getAlternateName());
                        break;
                    }
                    case 32: 
                    case 128: {
                        msg = new DataRequestMessage(2);
                        if ((Integer)Attribute.getValue("gt_dmax1", tree) > 0) {
                            MFAddress baseaddr = tree.getAddress();
                            msg.setAddress(baseaddr);
                            lth = (Integer)Attribute.getValue("length", tree);
                            break;
                        }
                        int offset = (Integer)Attribute.getValue("structureoffset", tree);
                        lth = (Integer)Attribute.getValue("length", tree);
                        int parentoffset = 0;
                        int parentlth = 0;
                        if (parent != null && (Integer)Attribute.getValue("level", parent) > 0) {
                            parentoffset = (Integer)Attribute.getValue("structureoffset", parent);
                            parentlth = (Integer)Attribute.getValue("length", parent);
                            tree = parent;
                        }
                        if (offset < 0) {
                            offset = 0;
                        }
                        if (parentlth > 0) {
                            lth = parentlth;
                            offset -= parentoffset;
                        }
                        MFAddress baseaddr = child.getAddress().subtract((long)offset);
                        msg.setAddress(baseaddr);
                        break;
                    }
                }
                if (msg != null) {
                    msg.setDataLength(lth);
                    this.cvmiPacket.addMessage((DebugMessage)msg);
                    ++this.msgcnt;
                    this.fetchObjects.add(tree);
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof CVMI) {
            for (TreeObject element : this.keepObjects) {
                element.setAttribute(this.UniqueKey, null);
                parent = element.getParent();
                if (parent != null && parent.getType() == 1) {
                    parent.nullBackingdata();
                    continue;
                }
                if (element.getType() != 1) continue;
                element.nullBackingdata();
            }
            this.keepObjects.clear();
        } else if (inputElement instanceof CVMO) {
            this.keepObjects.clear();
            if (this.debugfile != null && !this.refreshed) {
                talker = this.debugfile.getSession().getTalker();
                if (talker != null && this.debugfile.equals(talker.getDebugfile())) {
                    cvmo = (CVMO)inputElement;
                    var9_8 = cvmo.getMessages();
                    var8_9 = var9_8.length;
                    var7_10 = 0;
                    while (var7_10 < var8_9) {
                        msg = var9_8[var7_10];
                        idx = -1;
                        block1 : switch (msg.getMessageID()) {
                            case 1: {
                                break;
                            }
                            case 7: {
                                message = (AutoKeepMessage)msg;
                                itemname = varname = message.getVarName();
                                varAddr = message.getAddress();
                                statement = message.getStatement();
                                switch (this.lang) {
                                    case 16: {
                                        exprName = "Expr:" + varname;
                                        treeobject = Expressions.getTree(exprName, "CORE_EXPRESSION");
                                        treeobject.setKeyword(varname);
                                        treeobject.setAlternateName(varname);
                                        treeobject.setAttribute("isclean", "true");
                                        len = message.getAlet();
                                        if (len == 0L) {
                                            len = this.defaultLength;
                                        }
                                        if (len > 4096L) {
                                            len = 4096L;
                                        }
                                        treeobject.setAttribute(this.UniqueKey, Long.toString(-1L));
                                        treeobject.setAttribute("length", Long.toString(len));
                                        treeobject.setAttribute("structureoffset", "0");
                                        this.addObject(treeobject);
                                        break block1;
                                    }
                                    case 128: {
                                        tokens = varname.split(" OF ");
                                        if (tokens.length > 1) {
                                            sb = new StringBuilder(varname.length());
                                            var23_29 = tokens;
                                            var22_26 = tokens.length;
                                            var21_25 = 0;
                                            while (var21_25 < var22_26) {
                                                item = var23_29[var21_25];
                                                sb.insert(0, String.valueOf(item) + '.');
                                                ++var21_25;
                                            }
                                            sb.setLength(sb.length() - 1);
                                            varname = sb.toString();
                                        }
                                        if ((idx = varname.lastIndexOf("->")) > -1) {
                                            itemname = varname.substring(idx + 2, varname.length());
                                        }
                                    }
                                    case 32: {
                                        chk = varname.indexOf("(");
                                        if (chk != -1 && chk > idx) {
                                            varname = varname.substring(0, chk);
                                        }
                                        savename = varname;
                                        chk = itemname.indexOf("(");
                                        if (chk != -1 && chk > idx) {
                                            itemname = itemname.substring(0, chk);
                                        }
                                        if ((item = this.viewpage.getOutline().getPostedTreeObject(itemname, statement)) != null) {
                                            try {
                                                cloneItem = (Variable)item.clone();
                                                cloneItem.setName(itemname);
                                                cloneItem.setAttribute(this.UniqueKey, Long.toString(-1L));
                                                cloneItem.setAttribute("isclean", "true");
                                                cloneItem.setAddress(varAddr);
                                                cloneItem.nullBackingdata();
                                                this.doChildOffsets(cloneItem, cloneItem.baseoffset, Integer.valueOf(cloneItem.getAttribute("structureoffset")));
                                                cloneItem.setAttribute("structureoffset", "0");
                                                cloneItem.baseoffset = 0;
                                                if ((Integer)Attribute.getValue("gt_dmax1", item) > 0) {
                                                    str = "";
                                                    if (itemname.equals(varname)) {
                                                        str = this.getSubscripts(item, varAddr);
                                                    }
                                                    cloneItem.setAttribute("gt_dmax1", "0");
                                                    cloneItem.setAlternateName(String.valueOf(savename) + str);
                                                    cloneItem.setAttribute("autoarray", "true");
                                                }
                                                this.addObject(cloneItem);
                                                break block1;
                                            }
                                            catch (CloneNotSupportedException e) {
                                                Logger.loggit(e);
                                            }
                                        } else {
                                            ** GOTO lbl99
                                        }
                                    }
                                }
                            }
                        }
lbl99:
                        // 8 sources

                        ++var7_10;
                    }
                }
            } else {
                this.keepObjects.clear();
            }
        }
        if (!this.refreshed) {
            this.fetchBackingData(false);
            this.refreshed = true;
        }
        return this.keepObjects.toArray(new TreeObject[this.keepObjects.size()]);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void dispose() {
        this.debugitem.removeDebugListener(this.listener);
        super.dispose();
    }

    public String getSubscripts(TreeObject tree, MFAddress varaddr) {
        TreeObject topParent = tree;
        boolean flag = true;
        while (flag) {
            TreeObject parent = topParent.getParent();
            if (parent == null) {
                flag = false;
                continue;
            }
            Integer level = (Integer)parent.getValue("level");
            if (level < 1) {
                flag = false;
                continue;
            }
            topParent = parent;
        }
        MemoryRequest mr = new MemoryRequest(this.session, this.viewpage.getEditor(), this.debugitem.getName(), this.lang);
        MFAddress parentAddr = mr.fetchAddressMessage(topParent);
        if (parentAddr == null || parentAddr.equals((Object)MFAddress.ZERO_ADDR)) {
            return "[(unknown)]";
        }
        int offset = (int)varaddr.subtract(parentAddr);
        return VariableArrays.getArrayIndexes((Variable)tree, this.lang, offset);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.setRefreshed(false);
        super.propertyChange(event);
    }

    protected void doChildOffsets(Variable to, int topOffset, int topStructureoffset) {
        TreeObject[] treeObjectArray = to.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject element = treeObjectArray[n2];
            Variable varElement = (Variable)element;
            int offset = varElement.baseoffset - topOffset;
            if (offset < 0) {
                offset = 0;
            }
            varElement.baseoffset = offset;
            int elementOffset = (Integer)Attribute.getValue("structureoffset", element);
            offset = elementOffset - topOffset;
            if (offset < 0) {
                offset = 0;
            }
            element.setAttribute("structureoffset", String.valueOf(offset));
            this.doChildOffsets(varElement, topOffset, topStructureoffset);
            ++n2;
        }
    }
}

