/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.util;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.ExecutionCountsMessage;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.GetCountsMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.ui.lister.ListerEditor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;

public class ExecutionCountRuler
extends AbstractRulerColumn
implements IPropertyChangeListener,
IContributedRulerColumn,
IPartListener2,
IElementStateListener {
    static String cacopyright = "Copyright (c) 2016 CA";
    private RulerColumnDescriptor rcd = null;
    private ListerEditor listerEditor = null;
    private Color backGround = null;
    private Color numbers;
    private final HashMap<Integer, String> countsTable = new HashMap();
    private HashMap<Integer, Integer> verbTable = null;
    private int firstLine = 99999;
    private int lastLine = 0;
    private String count;
    private int digits = 1;
    private debugSession dsess = null;
    private debugFile dfile = null;
    private CountsDebugListener dbugListener = null;
    private String initChar = "0";

    public void columnCreated() {
        Debug dbug = Debug.getInstance();
        this.dfile = (debugFile)dbug.getResource(this.listerEditor.getResource());
        if (this.dfile == null) {
            return;
        }
        this.dsess = this.dfile.getSession();
        this.loadVerbTable();
        this.initializeCountsTable();
        this.listerEditor.getSite().getPage().addPartListener((IPartListener2)this);
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        super.createControl(parentRuler, parentControl);
        this.backGround = new Color((Device)parentRuler.getControl().getDisplay(), 255, 255, 185);
        this.numbers = parentRuler.getControl().getDisplay().getSystemColor(4);
        this.computeWidth();
        this.dbugListener = new CountsDebugListener();
        if (this.dfile != null) {
            this.dfile.addDebugListener(this.dbugListener);
            this.dfile.addPropertyChangeListener(this);
            boolean countsOn = this.dfile.isExecutionCount();
            if (countsOn) {
                this.getCounts();
            }
        }
        this.listerEditor.getDocumentProvider().addElementStateListener((IElementStateListener)this);
        return this.getControl();
    }

    protected void loadVerbTable() {
        Statement[] stmtTree;
        try {
            stmtTree = Outline.getInstance(this.dfile).getStmtTree().getChildren(null);
        }
        catch (ITException e) {
            Logger.loggit(e);
            stmtTree = new Statement[]{};
        }
        this.firstLine = 99999;
        this.lastLine = 0;
        if (this.verbTable == null) {
            this.verbTable = new HashMap(stmtTree.length);
        } else {
            this.verbTable.clear();
        }
        Statement[] statementArray = stmtTree;
        int n = stmtTree.length;
        int n2 = 0;
        while (n2 < n) {
            Statement stmt = statementArray[n2];
            if (stmt.getType().equals((Object)StatementType.VERB) || stmt.getType().equals((Object)StatementType.LABEL)) {
                int lastLineInt;
                int firstLineInt = stmt.getLine();
                if (firstLineInt < this.firstLine) {
                    this.firstLine = firstLineInt;
                }
                if ((lastLineInt = stmt.getLastline()) > this.lastLine) {
                    this.lastLine = lastLineInt;
                }
                this.verbTable.put(firstLineInt - 1, stmt.getStatement());
            }
            ++n2;
        }
        --this.firstLine;
        --this.lastLine;
    }

    protected void initializeCountsTable() {
        this.countsTable.clear();
        for (Integer line : this.verbTable.keySet()) {
            Integer stmt = this.verbTable.get(line);
            this.countsTable.put(stmt, this.initChar);
        }
    }

    public void columnRemoved() {
        this.backGround.dispose();
        this.numbers.dispose();
        if (this.dfile != null) {
            this.dfile.removeDebugListener(this.dbugListener);
            this.dfile.removePropertyChangeListener(this);
        }
        this.listerEditor.getSite().getPage().removePartListener((IPartListener2)this);
        IDocumentProvider provider = this.listerEditor.getDocumentProvider();
        if (provider != null) {
            provider.removeElementStateListener((IElementStateListener)this);
        }
    }

    public RulerColumnDescriptor getDescriptor() {
        if (this.rcd == null) {
            return null;
        }
        return this.rcd;
    }

    public ITextEditor getEditor() {
        if (this.listerEditor == null) {
            return null;
        }
        return this.listerEditor;
    }

    public void setDescriptor(RulerColumnDescriptor descriptor) {
        this.rcd = descriptor;
    }

    public void setEditor(ITextEditor editor) {
        if (editor instanceof ListerEditor) {
            this.listerEditor = (ListerEditor)editor;
        }
    }

    protected Color computeBackground(int line) {
        if (line >= this.firstLine && line <= this.lastLine) {
            return this.backGround;
        }
        return this.getDefaultBackground();
    }

    protected String computeText(int line) {
        if (line < this.firstLine || line > this.lastLine) {
            return null;
        }
        Integer stmt = this.verbTable.get(line);
        return stmt == null ? null : this.countsTable.get(stmt);
    }

    protected Color computeForeground(int line) {
        if (line >= this.firstLine && line <= this.lastLine) {
            return this.numbers;
        }
        return super.computeForeground(line);
    }

    private void computeWidth() {
        GC gc = new GC((Drawable)this.getControl());
        try {
            char[] digs = new char[String.valueOf(this.digits).trim().length()];
            Arrays.fill(digs, '0');
            this.count = new String(digs);
            Point p = gc.stringExtent(this.count);
            this.setWidth(p.x + 4);
        }
        finally {
            gc.dispose();
        }
    }

    private void getCounts() {
        if (!this.dfile.isExecutionCount()) {
            this.resetCounts();
            return;
        }
        DebugTalker debugTalker = this.dsess.getTalker();
        if (debugTalker == null) {
            return;
        }
        ExecutionCountsMessage ecMsg = new ExecutionCountsMessage(this.dfile);
        CVMI cvmi = new CVMI();
        try {
            ecMsg.setSubmessageID((short)3);
            ecMsg.setTermId("    ");
        }
        catch (ITException e1) {
            Logger.loggit(e1);
        }
        cvmi.addMessage((DebugMessage)ecMsg);
        try {
            CVMO cvmo = debugTalker.process(cvmi);
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage dMsg = debugMessageArray[n2];
                if (dMsg.getMessageID() == 38) {
                    GetCountsMessage countMsg = (GetCountsMessage)dMsg;
                    int rc = countMsg.getResultCode();
                    if (rc == 0 || rc == 4) {
                        this.updateCountsTable(countMsg.getCountsTable());
                        this.digits = countMsg.getMaxCount();
                    } else {
                        this.initChar = "!";
                        this.digits = 1;
                        this.initializeCountsTable();
                    }
                    final int rulerWidth = this.digits;
                    Display display = this.getControl().getDisplay();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ExecutionCountRuler.this.digits = rulerWidth;
                            ExecutionCountRuler.this.computeWidth();
                            ExecutionCountRuler.this.redraw();
                        }
                    });
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object eventSource = event.getSource();
        debugFile eventFile = null;
        if (!(eventSource instanceof debugFile)) {
            return;
        }
        eventFile = (debugFile)eventSource;
        if (!"execution_count".equals(event.getProperty())) {
            return;
        }
        if (this.dfile.equals(eventFile)) {
            String newvalue = event.getNewValue().toString();
            if (Messages.CountsResetAction_2.equals(newvalue)) {
                Display display = this.listerEditor.getSite().getShell().getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExecutionCountRuler.this.initChar = "0";
                        ExecutionCountRuler.this.initializeCountsTable();
                        ExecutionCountRuler.this.redraw();
                    }
                });
                return;
            }
        } else {
            return;
        }
        this.getCounts();
    }

    public void dispose() {
        this.dfile.removeDebugListener(this.dbugListener);
        this.dfile.removePropertyChangeListener(this);
        super.dispose();
    }

    private void resetCounts() {
        this.initChar = "0";
        this.initializeCountsTable();
        Display display = this.getControl().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionCountRuler.this.computeWidth();
                ExecutionCountRuler.this.redraw();
            }
        });
    }

    protected void updateCountsTable(HashMap<Integer, Integer> msgCountsTable) {
        for (Map.Entry<Integer, Integer> item : msgCountsTable.entrySet()) {
            Integer count = item.getValue();
            if (count <= 0) continue;
            this.countsTable.put(item.getKey(), count.toString());
        }
    }

    protected boolean endOfTask(CVMO cvmo) {
        boolean isEnd = false;
        DebugMessage[] debugMessages = cvmo.getMessages();
        int i = 0;
        while (i < debugMessages.length) {
            short msgId = debugMessages[i].getMessageID();
            if (msgId == 4) {
                isEnd = true;
            }
            ++i;
        }
        return isEnd;
    }

    protected boolean endOfSession(CVMI cvmi) {
        boolean isEnd = false;
        DebugMessage[] debugMessages = cvmi.getMessages();
        int i = 0;
        while (i < debugMessages.length) {
            short msgId = debugMessages[i].getMessageID();
            if (msgId == 22) {
                isEnd = true;
            }
            ++i;
        }
        return isEnd;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        IWorkbenchPart thisPart = partRef.getPart(false);
        IWorkbenchPart listerPart = this.listerEditor.getSite().getPart();
        if (thisPart == null) {
            return;
        }
        if (listerPart == null) {
            return;
        }
        if (thisPart.equals(listerPart)) {
            boolean countsOn = this.dfile.isExecutionCount();
            if (countsOn) {
                this.getCounts();
            }
            return;
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
        IPath oldPath;
        Object obj = element;
        if (!(obj instanceof FileEditorInput)) {
            return;
        }
        IPath newPath = ((FileEditorInput)element).getFile().getRawLocation();
        if (!newPath.equals((Object)(oldPath = this.dfile.getResource().getRawLocation()))) {
            return;
        }
        this.loadVerbTable();
        this.resetCounts();
    }

    public void elementDeleted(Object element) {
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    public class CountsDebugListener
    implements IDebugListener {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void debugEventOccured(debugEvent event) {
            Object eventObject = event.getSource();
            if (!(eventObject instanceof CVMO)) {
                if (!(eventObject instanceof CVMI)) return;
                if (!ExecutionCountRuler.this.endOfSession((CVMI)((Object)eventObject))) return;
                ExecutionCountRuler.this.resetCounts();
                return;
            }
            if (ExecutionCountRuler.this.endOfTask((CVMO)((Object)eventObject))) {
                ExecutionCountRuler.this.resetCounts();
                return;
            }
            boolean countsOn = ExecutionCountRuler.this.dfile.isExecutionCount();
            if (!countsOn) return;
            ExecutionCountRuler.this.getCounts();
        }
    }
}

