/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BacktraceLogMessage;
import com.ca.intertest.tools.CallTraceListMessage;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.backtrace.BacktracePage;
import com.ca.intertest.ui.views.breakpoint.BreakpointPage;
import com.ca.intertest.ui.views.calltrace.CalltracePage;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class PositioninFileAction
implements IViewActionDelegate,
IDoubleClickListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private int stmt = -1;
    private PageBookView book = null;
    private ListerEditor editor;
    private String program;

    public void init(IViewPart view) {
        if (view instanceof PageBookView) {
            this.book = (PageBookView)view;
        }
    }

    public void run(IAction action) {
        if (this.stmt > 0 && this.book != null) {
            IPage page = this.book.getCurrentPage();
            if (page instanceof BreakpointPage) {
                BreakpointPage bppage = (BreakpointPage)page;
                this.editor = bppage.getEditor();
            } else if (page instanceof AbstractDataViewPage) {
                AbstractDataViewPage keeppage = (AbstractDataViewPage)page;
                this.editor = keeppage.getEditor();
            } else if (page instanceof BacktracePage) {
                debugSession session = ((BacktracePage)page).getSession();
                debugFile file = session.getFile(this.program);
                if (file != null) {
                    try {
                        this.editor = (ListerEditor)this.book.getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)file.getResource()), "com.ca.intertest.ui.lister");
                    }
                    catch (PartInitException e) {
                        Logger.loggit(e);
                        return;
                    }
                }
            } else if (page instanceof CalltracePage) {
                debugSession session = ((CalltracePage)page).getSession();
                debugFile file = session.getFile(this.program);
                if (file != null) {
                    try {
                        this.editor = (ListerEditor)this.book.getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)file.getResource()), "com.ca.intertest.ui.lister");
                    }
                    catch (PartInitException e) {
                        Logger.loggit(e);
                        return;
                    }
                }
            } else {
                return;
            }
            this.editor.positionDebugStatement(this.stmt);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        IStructuredSelection sel = (IStructuredSelection)selection;
        this.stmt = 0;
        if (sel.size() == 1) {
            Object obj = sel.getFirstElement();
            if (obj instanceof IT_TreeItem && ((IT_TreeItem)obj).getType() == TreeType.MARKER) {
                obj = ((IT_TreeItem)obj).getObj();
            }
            if (obj instanceof IMarker) {
                IMarker marker = (IMarker)obj;
                Integer statement = marker.getAttribute("stmtNumber", 0);
                if (statement != null && statement > 0) {
                    this.stmt = statement;
                }
            } else if (obj instanceof TreeObject) {
                TreeObject treeobject = (TreeObject)obj;
                this.stmt = (Integer)Attribute.getValue("statementnumber", treeobject);
            } else if (obj instanceof BacktraceLogMessage.TraceLogRecord) {
                this.stmt = ((BacktraceLogMessage.TraceLogRecord)obj).firstStatement;
                this.program = ((BacktraceLogMessage.TraceLogRecord)obj).program;
            } else if (obj instanceof CallTraceListMessage.CallLogRecord) {
                CallTraceListMessage.CallLogRecord calllogrecord = (CallTraceListMessage.CallLogRecord)obj;
                this.stmt = calllogrecord.getStatement();
                this.program = calllogrecord.getProgram();
            }
        }
        enabled = this.stmt > 0;
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(null, event.getSelection());
        this.run(null);
    }
}

