/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.tools.BackStepMessage;
import com.ca.intertest.ui.actions.AbstractDebuggingAction;
import com.ca.intertest.ui.views.backtrace.BacktracePage;
import com.ca.intertest.ui.views.backtrace.BacktracePageBook;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.part.IPage;

public class NavigatetoAction
extends AbstractDebuggingAction {
    private int index;

    @Override
    public void run(IAction action) {
        if (this.index != -1 && this.session != null && this.session.isAtBreakpoint()) {
            try {
                try {
                    int ip = this.session.getCurrentIP();
                    BackStepMessage msg = new BackStepMessage();
                    if (this.index < ip) {
                        msg.setSubmessageID((short)4);
                        msg.setCount((int)((short)(ip - this.index)));
                    } else {
                        msg.setSubmessageID((short)8);
                        msg.setCount((int)((short)(this.index - ip)));
                    }
                    this.session.getTalker().processExecute(msg);
                }
                catch (Exception exception) {
                    this.refocus();
                }
            }
            finally {
                this.refocus();
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        this.index = -1;
        this.session = null;
        if (selection instanceof IStructuredSelection) {
            IPage currentpage;
            this.selected = (IStructuredSelection)selection;
            if (this.selected.size() == 1 && this.book instanceof BacktracePageBook && (currentpage = this.book.getCurrentPage()) instanceof BacktracePage) {
                this.session = ((BacktracePage)currentpage).getSession();
                if (this.session != null && this.session.isAtBreakpoint()) {
                    this.index = 1 + ((BacktracePage)currentpage).getViewer().getTable().getSelectionIndex();
                    enabled = this.session.getCurrentIP() != this.index;
                }
            }
        }
        action.setEnabled(enabled);
    }
}

