/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.CoreExprDumpDialog;
import com.ca.intertest.dialogs.CoreExpressionDialog;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.AbstractDataViewPageBook;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;

public class ExpressionKeepItemAction
implements IViewActionDelegate,
IDoubleClickListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected final int maxlength = IntertestPlugin.getConfigurationPreferences().getInt("DATAVIEW_MAXLENGTH");
    private AbstractDataViewPageBook book = null;
    private AbstractDataViewPage page = null;
    protected Object object = null;
    protected IDebug debugitem;
    private boolean expression;
    protected IResource resource;

    public void doubleClick(DoubleClickEvent event) {
    }

    public void init(IPage page) {
        if (page instanceof AbstractDataViewPage) {
            this.page = (AbstractDataViewPage)page;
            this.debugitem = this.page.getDebugitem();
            this.resource = this.debugitem.getResource();
        } else {
            page = null;
            this.debugitem = null;
            this.resource = null;
        }
    }

    public void init(IViewPart view) {
        if (view instanceof AbstractDataViewPageBook) {
            this.book = (AbstractDataViewPageBook)view;
        }
    }

    public void run(IAction action) {
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        String cmd = "";
        if (this.object instanceof TreeObject) {
            boolean exprFlag;
            TreeObject treeobject = (TreeObject)this.object;
            boolean bl = exprFlag = treeobject == null ? false : treeobject.getAttribute("dataflag").equals("CORE_EXPRESSION");
            if (exprFlag) {
                cmd = treeobject.getAlternateName();
            }
        }
        debugSession session = this.page.getSession();
        CoreExprDumpDialog dialog = new CoreExprDumpDialog(this.page.getSite().getShell());
        ((CoreExpressionDialog)dialog).init(this.page.getEditor(), this.resource, session.getVersion(), cmd, this.page.getLang(), this.page, session);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        this.object = null;
        if (this.page != null && this.page.getSession().isAtBreakpoint()) {
            Object obj;
            enabled = true;
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof TreeObject) {
                TreeObject treeobject = (TreeObject)obj;
                this.expression = treeobject.getAttribute("dataflag").equals("CORE_EXPRESSION");
                if (this.expression || treeobject.getType() == 1) {
                    enabled = true;
                    this.object = treeobject;
                }
            }
        }
        if (enabled && this.page != null && !(this.debugitem instanceof debugFile)) {
            enabled = false;
            this.object = null;
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }
}

