/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.outline.OutlinePage;
import com.ca.intertest.wizards.CoreWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class CoreDialogAction
implements IEditorActionDelegate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private ListerEditor editor;
    private ArrayList<TreeObject> namelist = null;
    private IResource resource = null;
    private Outline outline = null;
    protected PageBookView book = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof ListerEditor ? (ListerEditor)targetEditor : null;
    }

    public void run(IAction action) {
        Shell shell = this.editor.getSite().getShell();
        CoreWizard wizard = new CoreWizard();
        String varname = "";
        int stmt = 0;
        TreeObject tree = null;
        if (this.namelist != null) {
            for (TreeObject treeobject : this.namelist) {
                if (treeobject.getType() != 1) continue;
                varname = treeobject.getName();
                stmt = (Integer)Attribute.getValue("statementnumber", treeobject);
                tree = treeobject;
                break;
            }
        }
        if (varname.length() > 0) {
            wizard.initVar(this.editor, tree, stmt);
        } else {
            wizard.init(this.editor);
        }
        MemoryWizardDialog dialog = new MemoryWizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        debugSession session;
        boolean enabled = false;
        this.checkInit();
        if (this.resource != null) {
            IStructuredSelection sel;
            if (selection instanceof IStructuredSelection) {
                sel = (IStructuredSelection)selection;
                this.namelist = new ArrayList();
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof TreeObject) {
                        TreeObject treeobject = (TreeObject)object;
                        if (treeobject.getType() == 1 && !this.isFiller(treeobject.getName())) {
                            this.namelist.add(treeobject);
                        }
                    } else {
                        String key = object.toString().trim();
                        TreeObject[] treeObjectArray = this.outline.getQualifiedObjects(key);
                        int n3 = treeObjectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TreeObject item = treeObjectArray[n4];
                            if (!this.namelist.add(item)) break;
                            ++n4;
                        }
                    }
                    ++n2;
                }
            } else if (selection instanceof TextSelection) {
                this.namelist = new ArrayList();
                sel = (TextSelection)selection;
                String key = sel.getText();
                key = key == null ? "" : key.trim();
                if (this.editor != null && !this.isFiller(key) && this.outline != null) {
                    Integer statement = this.outline.getLineXref().get(sel.getStartLine());
                    if (statement == null) {
                        statement = -1;
                    }
                    String stmtKey = String.format("%06d:%s", statement, key);
                    TreeObject[] treeObjectArray = this.outline.getQualifiedObjects(stmtKey);
                    int n = treeObjectArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        String name;
                        TreeObject item = treeObjectArray[n5];
                        if (item.getType() == 1 && (name = this.outline.getQualifiedName(item)) != null && name.equals(key) && !this.namelist.contains(name)) {
                            this.namelist.add(item);
                        }
                        ++n5;
                    }
                }
            }
            if (this.namelist != null && this.namelist.size() != 0) {
                enabled = true;
            }
        }
        if (this.editor != null && (session = Debug.getInstance().getSession(this.editor.getResource())) != null) {
            enabled = session.isAtBreakpoint();
        }
        action.setEnabled(enabled);
    }

    private void checkInit() {
        if (this.book != null) {
            IPage page = this.book.getCurrentPage();
            if (page instanceof AbstractDataViewPage) {
                AbstractDataViewPage keeppage = (AbstractDataViewPage)page;
                this.editor = keeppage.getEditor();
            } else if (page instanceof OutlinePage) {
                OutlinePage outlinepage = (OutlinePage)page;
                this.editor = outlinepage.getEditor();
            }
        }
        if (this.resource == null && this.editor != null) {
            this.resource = this.editor.getResource();
            this.outline = this.editor.getOutline();
        }
    }

    private boolean isFiller(String token) {
        return this.outline != null && this.outline.getLanguage() == 32 && "FILLER".equalsIgnoreCase(token);
    }
}

