/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.wizards.CompositeSetupPage;
import com.ca.intertest.wizards.CompositeSetupWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class CompositeAction
implements IViewActionDelegate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private IViewPart view;
    private static final Debug debug = Debug.getInstance();
    private debugFile file = null;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        if (this.file == null) {
            return;
        }
        CompositeSetupWizard wizard = new CompositeSetupWizard(this.file, CompositeSetupPage.CompositeType.STANDARD, null, true);
        IntertestWizardDialog dialog = new IntertestWizardDialog(null, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        boolean enabled = false;
        this.file = null;
        for (Object obj : sel.toList()) {
            if (obj instanceof IT_TreeItem) {
                debugSession session;
                IT_TreeItem root = ((IT_TreeItem)obj).getRoot();
                if (root != null && root.getType() == TreeType.SESSION && (!(session = (debugSession)root.getObj()).isCICS() || !session.isDebugging())) break;
                obj = ((IT_TreeItem)obj).getObj();
            }
            if (obj instanceof debugFile) {
                this.file = (debugFile)obj;
            } else if (obj instanceof IFile) {
                this.file = (debugFile)debug.getResource((IResource)((IFile)obj));
            }
            if (this.file == null || !this.file.isProgram()) continue;
            enabled = true;
            break;
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }
}

