/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.Command;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IStatusMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.ITSecurityException;
import com.ca.intertest.tools.MoreMessage;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.ValidateCredentials;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.entity.ByteArrayEntity;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public abstract class Connection {
    private static final int LOOP_COUNT = 1;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected static com.ca.intertest.common.Logger staticlog = com.ca.intertest.common.Logger.getLogger(Connection.class.getName());
    private XMLRequest xml;
    static String cacopyright = "Copyright (c) 2016 CA";
    protected boolean loggedin = false;
    protected boolean connected = false;
    protected String userid;
    protected String password;
    private Socket socket = null;
    protected Reader reader = null;
    protected Writer writer = null;
    protected DataInputStream instream = null;
    protected OutputStream outstream = null;
    public ServerElement server = null;
    protected int errorLevel;
    protected int errorCount;
    private String servername;
    protected String errorMessage = null;
    private Calendar timestamp = null;
    private int connecttime = 0;
    protected InetSocketAddress socketaddress = null;

    private Connection() {
    }

    protected Connection(ServerElement server, String service) {
        Assert.isNotNull((Object)server, (String)Messages.Connection_2);
        this.servername = server.getName();
        this.server = server;
        this.connecttime = ServerList.getInstance().getConnecttime();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public final boolean connect(boolean logon) throws Exception {
        this.initStatus();
        if (!this.connected) {
            try {
                this.socket = new Socket();
                this.socket.connect(this.socketaddress, this.connecttime);
                this.instream = new DataInputStream(this.socket.getInputStream());
                this.outstream = this.socket.getOutputStream();
                if (logon && !this.loggedin) {
                    this.login();
                }
                this.connected = true;
                this.socket.setSoTimeout(0);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.errorLevel = 4;
                this.errorMessage = String.format(Messages.Connection_3, this.socketaddress.getHostName(), this.socketaddress.getPort());
                throw new ITException(this.errorMessage);
            }
            catch (UnknownHostException unknownHostException) {
                this.errorLevel = 16;
                this.errorMessage = String.format(Messages.Connection_4, this.servername);
                throw new ITException(this.errorMessage);
            }
            catch (ITException e) {
                this.errorLevel = 4;
                this.errorMessage = HexUtil.getErrorText((Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.errorLevel = 4;
                String error = HexUtil.getErrorText((Throwable)e);
                this.errorMessage = String.format(Messages.Connection_5, this.socketaddress.getHostName(), this.socketaddress.getPort(), error);
                throw e;
            }
        } else if (this.socket.isClosed() || !this.socket.isConnected()) {
            this.disconnect(false);
        }
        return this.connected;
    }

    private void initStatus() {
        this.errorLevel = 0;
        this.errorMessage = Messages.Connection_6;
        if (this.socketaddress == null) {
            this.socketaddress = new InetSocketAddress(this.server.getHostname(), this.server.getPort());
        }
    }

    private int login() throws ITSecurityException {
        if (this.loggedin || this.server.isCICS_server()) {
            return 0;
        }
        int loop = 1;
        while (loop <= 1) {
            CVMO cvmo = new CVMO();
            CVMI cvmi = new CVMI();
            try {
                this.userid = this.server.getLogonUser();
                this.password = this.server.getPassword();
            }
            catch (ITException iTException) {
                return 4;
            }
            cvmi.addMessage((DebugMessage)new SignonMessage(this.userid, this.password));
            TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(this.server.name);
            apacheServer.setPassword(this.password);
            ValidateCredentials validate = new ValidateCredentials(apacheServer);
            this.errorLevel = validate.run(true);
            if (this.errorLevel == 0) {
                this.loggedin = true;
                loop = 1;
                apacheServer.setUser(this.userid);
                apacheServer.setUserDialog(true);
            } else {
                this.server.resetUserDialog();
                if (loop != 1) {
                    Connection.displayError(cvmo, Messages.Connection_7);
                }
            }
            ++loop;
        }
        if (this.errorLevel != 0) {
            throw new ITSecurityException(this.errorMessage);
        }
        return this.errorLevel;
    }

    protected void connectCmd() throws Exception {
        if (this instanceof CICSConnection) {
            return;
        }
        CVMI cvmi = new CVMI();
        this.process(cvmi);
        if (this.errorLevel >= 8) {
            throw new ITException(this.errorMessage);
        }
    }

    public CVMO process(CVMI cvmi) {
        CVMO cvmo;
        if (!this.server.isCICS_server()) {
            cvmo = this.processTomcat(true, new HashMap<String, Object>(), cvmi);
        } else {
            int result = 0;
            try {
                result = this.login();
            }
            catch (ITSecurityException e) {
                com.ca.intertest.common.Logger.loggit(e);
                this.showSecurityFailure(e);
            }
            if (result == 0) {
                cvmo = this.processRaw(cvmi);
                if (cvmi.size() > 0 && cvmo.size() == 0) {
                    cvmo.addMessage((DebugMessage)new StatusMessage(4, Messages.Connection_8));
                }
            } else {
                StatusMessage msg = result == 4 ? new StatusMessage((short)result, Messages.Connection_9) : new StatusMessage((short)this.errorLevel, this.errorMessage);
                cvmo = new CVMO();
                cvmo.addMessage((DebugMessage)msg);
                Connection.processStatusMessages(cvmi, cvmo);
            }
        }
        this.errorLevel = cvmo.getErrorLevel();
        this.errorMessage = cvmo.getErrorMessage();
        this.errorCount = cvmo.getErrorCount();
        return cvmo;
    }

    protected CVMO processRaw(CVMI cvmi) {
        CVMO cvmo = new CVMO();
        this.errorCount = 0;
        this.errorLevel = 0;
        this.errorMessage = Messages.Connection_6;
        try {
            try {
                this.WriteOut(cvmi);
                if (this.errorLevel != 0) {
                    throw new ITException(String.valueOf(Messages.Connection_11) + this.errorMessage);
                }
                cvmo = this.ReadIn();
            }
            catch (ITException e) {
                com.ca.intertest.common.Logger.loggit(e);
                cvmo.addMessage((DebugMessage)new StatusMessage(63, HexUtil.getErrorText((Throwable)e)));
                Connection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
            }
            catch (Exception e) {
                com.ca.intertest.common.Logger.loggit(e);
                this.connected = false;
                cvmo.addMessage((DebugMessage)new StatusMessage(64, String.valueOf(Messages.Connection_13) + HexUtil.getErrorText((Throwable)e)));
                Connection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
            }
        }
        finally {
            Connection.processStatusMessages(cvmi, cvmo);
            this.errorLevel = cvmo.getErrorLevel();
            this.errorMessage = cvmo.getErrorMessage();
            this.errorCount = cvmo.getErrorCount();
        }
        return cvmo;
    }

    public static void processStatusMessages(CVMI cvmi, CVMO cvmo) {
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            if (message.getMessageID() == 18) {
                IStatusMessage status = (IStatusMessage)message;
                short statuscode = status.getStatus();
                if (statuscode > 0) {
                    DebugMessage cvmimessage;
                    DebugMessage debugMessage = cvmimessage = cvmi == null ? null : cvmi.getMessage(status.getRequestseqno());
                    if (cvmimessage != null) {
                        String name;
                        String action = cvmimessage.getClass().getSimpleName().replace(Messages.Connection_14, "");
                        FileType filetype = cvmimessage.getFiletype();
                        switch (filetype) {
                            case TERMID: 
                            case TRANID: {
                                name = cvmimessage.getShortProgram();
                                break;
                            }
                            default: {
                                name = cvmimessage.getProgram();
                            }
                        }
                        String format = name == null || name.length() == 0 ? Messages.Connection_16 : Messages.Connection_17;
                        String text = String.format(format, action, filetype.toString(), name, statuscode, status.getMessage(0));
                        com.ca.intertest.common.Logger.loggit((int)statuscode, text);
                    }
                }
                StatusMessage.logStatus(status, null, (Exception)((Object)new ITException()));
            }
            ++n2;
        }
    }

    protected void showSecurityFailure(final ITSecurityException e) {
        final Display display = Display.getDefault();
        if (display != null) {
            IntertestPlugin.startErrorLog();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IT_ErrorDialog.openError(display.getActiveShell(), Messages.Connection_18, HexUtil.getErrorText((Throwable)e), (Throwable)e);
                }
            });
        }
    }

    public static void displayError(CVMO cvmo, String title) {
        if (cvmo.getErrorCount() > 0) {
            final String titletext = title == null ? Messages.Connection_19 : title;
            final int count = cvmo.getErrorCount();
            final int error = cvmo.getErrorLevel();
            Display display = Display.getDefault();
            if (display != null) {
                IntertestPlugin.startErrorLog();
                final String text = cvmo.getErrorMessage();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String format;
                        String word;
                        String string = word = error > 4 ? Messages.Connection_20 : Messages.Connection_21;
                        if (count == 1) {
                            format = String.valueOf(Messages.Connection_22) + IConstants.LINEFEED + Messages.Connection_23;
                        } else {
                            format = Messages.Connection_24;
                            format = String.valueOf(format) + IConstants.LINEFEED + Messages.Connection_25;
                        }
                        if (error > 4) {
                            MessageDialog.openError(null, (String)titletext, (String)String.format(format, count, text, word));
                        } else {
                            MessageDialog.openWarning(null, (String)titletext, (String)String.format(format, count, text, word));
                        }
                    }
                });
            }
        }
    }

    public int disconnect() {
        this.initStatus();
        return this.disconnect(false);
    }

    public int disconnect(boolean logoff) {
        if (logoff) {
            return this.disconnect();
        }
        this.initStatus();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.errorLevel = 32;
                this.errorMessage = HexUtil.getErrorText((Throwable)e);
            }
        }
        this.connected = false;
        this.loggedin = false;
        return this.errorLevel;
    }

    protected CVMO ReadIn() throws Exception {
        if (this.socket.isClosed()) {
            return null;
        }
        byte[] buffer = null;
        ByteBuffer bytebuffer = null;
        boolean morepackets = true;
        CVMO cvmo = new CVMO();
        int bufflen = 0;
        this.errorLevel = 0;
        this.errorMessage = Messages.Connection_6;
        com.ca.intertest.common.Logger.loggit(0, Messages.Connection_0);
        while (morepackets) {
            bufflen = this.instream.readInt();
            if (bufflen <= 4) continue;
            int toread = bufflen - 4;
            try {
                buffer = new byte[bufflen];
                int pos = 4;
                this.instream.readFully(buffer, pos, toread);
                bytebuffer = ByteBuffer.wrap(buffer).putInt(0, bufflen);
                com.ca.intertest.common.Logger.logPacket(buffer, CVMO.class, new Throwable(), this.servername);
                cvmo.setArray(bytebuffer, false);
                morepackets = cvmo.getLastMessage() instanceof MoreMessage;
            }
            catch (VirtualMachineError e) {
                com.ca.intertest.common.Logger.loggit(e);
                cvmo.addMessage((DebugMessage)new StatusMessage(32, Messages.Connection_BadPacket));
                morepackets = false;
            }
        }
        com.ca.intertest.common.Logger.DisplayPacket((DSECT)cvmo, new Throwable());
        return cvmo;
    }

    public void dispose() {
        this.disconnect();
    }

    protected void WriteOut(CVMI cvmi) {
        try {
            com.ca.intertest.common.Logger.DisplayPacket((DSECT)cvmi, new Throwable());
            byte[] bytes = cvmi.getArray();
            this.outstream.write(bytes);
            this.outstream.flush();
            com.ca.intertest.common.Logger.logPacket(bytes, CVMI.class, new Throwable(), this.servername);
        }
        catch (Exception e) {
            com.ca.intertest.common.Logger.loggit(e);
            this.errorLevel = 64;
            this.errorMessage = HexUtil.getErrorText((Throwable)e);
        }
        cvmi.setErrorLevel(this.errorLevel);
        cvmi.setErrorMessage(this.errorMessage);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorText() {
        String msg = String.valueOf(Messages.Connection_27) + Integer.toString(this.errorLevel) + " " + this.errorMessage;
        return msg;
    }

    protected void finalize() throws Throwable {
        if (this.socket != null && this.socket.isConnected()) {
            this.socket.shutdownInput();
            this.socket.shutdownOutput();
            this.socket.close();
        }
        super.finalize();
    }

    public synchronized ServerElement getServer() {
        return this.server;
    }

    protected StatusMessage buildStatus(DebugMessage message, String text) {
        return this.buildStatus(message, new String[]{text});
    }

    protected StatusMessage buildStatus(DebugMessage message, String[] messages) {
        StatusMessage status = new StatusMessage();
        status.setStatus((short)12);
        status.setRequestseqno(message.getSequencenumber());
        status.setMessages(messages);
        return status;
    }

    public int getConnecttime() {
        return this.connecttime;
    }

    public void setConnecttime(int connecttime) {
        int n = this.connecttime = connecttime >= 0 ? connecttime : this.server.getConnecttime();
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(this.connecttime);
            }
            catch (SocketException socketException) {}
        }
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    protected final void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    protected final void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    protected void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public CVMO processTomcat(boolean doSignon, Map<String, Object> map, CVMI cvmi) {
        CVMO cvmo;
        block14: {
            boolean hasCvmi;
            String apacheServerName = this.server.getName();
            TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(apacheServerName);
            ServerConnect connect = new ServerConnect(apacheServer, "intertest/server");
            cvmo = null;
            boolean bl = hasCvmi = cvmi != null && cvmi.size() > 0;
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            try {
                ByteArrayEntity entity;
                if (hasCvmi) {
                    byte[] data = cvmi.getArray();
                    entity = new ByteArrayEntity(data);
                    this.log.log(Level.FINE, "CVMI", (Object)data);
                    entity.setContentType("application/vnd.ca.intertest.dsect");
                } else {
                    entity = null;
                }
                this.xml = connect.connect(Command.passthru.toString(), map, doSignon, false, (Object)entity);
                this.errorLevel = this.xml.getErrorLevel();
                this.errorMessage = this.xml.getErrorMessage();
                if (this.errorLevel != 0) {
                    this.errorCount = 1;
                    cvmo = new CVMO();
                    cvmo.addMessage((DebugMessage)new StatusMessage((short)this.errorLevel, this.errorMessage));
                } else {
                    File file = this.xml.getAttachedFile();
                    if (file == null) {
                        cvmo = new CVMO();
                        if (hasCvmi) {
                            cvmo.addMessage((DebugMessage)new StatusMessage(16, "No CVMO received from server"));
                            this.xml.setStatus(16, "No CVMO received from server");
                        }
                    } else {
                        FileInputStream stream = new FileInputStream(file);
                        byte[] buffer = new byte[(int)file.length()];
                        stream.read(buffer);
                        stream.close();
                        file.delete();
                        this.log.log(Level.FINE, "CVMO", (Object)buffer);
                        cvmo = new CVMO(ByteBuffer.wrap(buffer));
                    }
                }
            }
            catch (ITException e) {
                cvmo = new CVMO();
                this.log.log(Level.WARNING, "", e);
                cvmo.addMessage((DebugMessage)new StatusMessage(63, HexUtil.getErrorText((Throwable)e)));
                Connection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
                break block14;
            }
            catch (Exception e) {
                try {
                    cvmo = new CVMO();
                    this.log.log(Level.WARNING, "", e);
                    this.connected = false;
                    cvmo.addMessage((DebugMessage)new StatusMessage(64, String.valueOf(Messages.Connection_13) + HexUtil.getErrorText((Throwable)e)));
                }
                catch (Throwable throwable) {
                    Connection.processStatusMessages(cvmi, cvmo);
                    this.errorLevel = cvmo.getErrorLevel();
                    this.errorMessage = cvmo.getErrorMessage();
                    this.errorCount = cvmo.getErrorCount();
                    throw throwable;
                }
                Connection.processStatusMessages(cvmi, cvmo);
                this.errorLevel = cvmo.getErrorLevel();
                this.errorMessage = cvmo.getErrorMessage();
                this.errorCount = cvmo.getErrorCount();
                break block14;
            }
            Connection.processStatusMessages(cvmi, cvmo);
            this.errorLevel = cvmo.getErrorLevel();
            this.errorMessage = cvmo.getErrorMessage();
            this.errorCount = cvmo.getErrorCount();
        }
        return cvmo;
    }
}

