/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.PLIVariable;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.dialogs.IntertestDialog;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PLIPointerDialog
extends IntertestDialog {
    static String cacopyright = "Copyright (c) 2016 CA";
    static final String NULL_STRING = "";
    private String title = Messages.PLIPointerDialog_title;
    private Combo pointerCombo;
    private TreeObject pointerObject;
    private String pointerName = "";
    private String subtitle;
    private HashMap<String, TreeObject> pointerObjects;
    private Object[] keys;
    private Text subscriptText;
    private String subscripts = "";
    private String errMsg = "";

    public PLIPointerDialog(Shell parentShell) {
        super(parentShell);
    }

    public PLIPointerDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void init(HashMap<String, TreeObject> ptrObjects, TreeObject basedObject) {
        this.CONTEXT_ID = "watchdataview";
        this.pointerObjects = ptrObjects;
        this.subtitle = String.format(Messages.PLIPointerDialog_subtitle, basedObject.getName());
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 4, true, true));
        this.createPointerGroup(composite);
        return composite;
    }

    private void createPointerGroup(Composite parent) {
        Group source = new Group(parent, 16);
        source.setLayout((Layout)new GridLayout(2, true));
        source.setText(this.subtitle);
        Label pointerLabel = new Label((Composite)source, 0);
        pointerLabel.setText(Messages.PLIPointerDialog_pointerLabel);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        pointerLabel.setLayoutData((Object)gridData);
        this.pointerCombo = new Combo((Composite)source, 516);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.pointerCombo.setTextLimit(40);
        this.pointerCombo.setToolTipText(Messages.PLIPointerDialog_pointerComboToolTip);
        gridData.grabExcessHorizontalSpace = false;
        this.keys = this.pointerObjects.keySet().toArray();
        Arrays.sort(this.keys);
        Object[] objectArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            TreeObject tree = this.pointerObjects.get(key);
            if (tree instanceof PLIVariable) {
                this.pointerCombo.add(key.toString());
            }
            ++n2;
        }
        this.pointerCombo.setLayoutData((Object)gridData);
        this.pointerCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int ptr = PLIPointerDialog.this.pointerCombo.getSelectionIndex();
                PLIPointerDialog.this.pointerObject = (TreeObject)PLIPointerDialog.this.pointerObjects.get(PLIPointerDialog.this.keys[ptr]);
            }
        });
        Label subscriptLabel = new Label((Composite)source, 0);
        subscriptLabel.setText(Messages.PLIPointerDialog_subscriptLabel);
        gridData = new GridData(32);
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        subscriptLabel.setLayoutData((Object)gridData);
        this.subscriptText = new Text((Composite)source, 2048);
        this.subscriptText.setText(NULL_STRING);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 120;
        this.subscriptText.setTextLimit(60);
        this.subscriptText.setToolTipText(Messages.PLIPointerDialog_subscriptTextToolTip);
        this.subscriptText.setLayoutData((Object)gridData);
        this.subscriptText.addVerifyListener((VerifyListener)new verifytoUpperCase());
    }

    protected void okPressed() {
        this.subscripts = this.subscriptText.getText().toUpperCase();
        if (this.verifySelection()) {
            super.okPressed();
        } else {
            MessageDialog.openWarning(null, (String)this.title, (String)this.errMsg);
        }
    }

    private boolean verifySelection() {
        if (this.pointerObject == null) {
            if (this.pointerCombo.getText().length() > 0) {
                this.pointerName = this.pointerCombo.getText().toUpperCase();
                return true;
            }
            this.errMsg = String.format(Messages.PLIPointerDialog_errMsg1, new Object[0]);
            return false;
        }
        this.pointerName = this.pointerCombo.getText().toUpperCase();
        if ((Integer)Attribute.getValue("gt_dmax1", this.pointerObject) > 0) {
            int dmax = 7;
            int i = 1;
            while (i < 7) {
                String str = String.valueOf(i);
                int dmaxvalue = (Integer)Attribute.getValue("gt_dmax" + str, this.pointerObject);
                if (dmaxvalue == 0) {
                    dmax = i - 1;
                    i = 7;
                }
                ++i;
            }
            this.errMsg = String.format(Messages.PLIPointerDialog_errMsg2, this.pointerObject.getName());
            if (dmax > 1) {
                this.errMsg = String.format(Messages.PLIPointerDialog_errMsg3, this.pointerObject.getName(), dmax);
            }
            if (this.subscripts.length() == 0) {
                return false;
            }
            String[] subs = this.subscripts.split(",");
            if (subs.length < dmax) {
                return false;
            }
        }
        this.errMsg = NULL_STRING;
        return true;
    }

    protected void cancelPressed() {
        this.pointerObject = null;
        super.cancelPressed();
    }

    public String getPLIPointer() {
        return this.pointerName;
    }

    public String getSubscripts() {
        return this.subscripts;
    }
}

