/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.Variable;
import com.ca.intertest.common.verifyFixed;
import com.ca.intertest.common.verifyHexFixed;
import com.ca.intertest.common.verifyNumber;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.tools.HexUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataViewValueDialog
extends IntertestDialog {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final int MAX_WIDTH = 40;
    private static final String EMPTY = "";
    private static final String MODIFIED = "modified";
    private String title = Messages.DataViewValueDialog_0;
    private Text valueText;
    private Text hexText;
    private Label errormsg;
    private String errortext = "";
    private Variable variable;
    private byte[] curhexvalue;
    public String curHexString;
    private String arrayCell = "";
    private debugSession session;
    private Button ok;
    private Button defaultbutton;

    public DataViewValueDialog(Shell parentShell) {
        super(parentShell);
    }

    public DataViewValueDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void initArray(Variable variable, debugSession session, String cellIndexes) {
        this.arrayCell = cellIndexes;
        this.init(variable, session);
    }

    public void init(Variable variable, debugSession session) {
        this.CONTEXT_ID = "dataviewdialogs";
        this.session = session;
        this.variable = variable;
        this.curhexvalue = variable.getData();
        this.curHexString = null;
        this.title = Messages.DataViewValueDialog_3;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        String hex = this.variable.getHexValue(this.curhexvalue);
        int width = Math.min(hex.length(), 40);
        int style = 2048;
        if (width > 40) {
            style |= 0x100;
        }
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 4, true, true));
        Label variableLabel = new Label(composite, 0);
        String pic = this.variable.getPicture();
        if (pic.length() > 0) {
            pic = String.format(Messages.DataViewValueDialog_10, pic);
        }
        variableLabel.setText(String.format(Messages.DataViewValueDialog_5, this.variable.toString(), this.arrayCell, this.variable.getPicture()));
        GridData gridData = new GridData(32);
        gridData.widthHint = 280;
        gridData.horizontalSpan = 2;
        variableLabel.setLayoutData((Object)gridData);
        final Button hexRadioButton = new Button(composite, 16);
        hexRadioButton.setText(Messages.DataViewValueDialog_6);
        gridData = new GridData(4, 2, true, false, 1, 1);
        hexRadioButton.setLayoutData((Object)gridData);
        hexRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = hexRadioButton.getSelection();
                if (selected) {
                    DataViewValueDialog.this.verifyInput();
                    DataViewValueDialog.this.valueText.setEnabled(false);
                    DataViewValueDialog.this.hexText.setEnabled(true);
                    DataViewValueDialog.this.hexText.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.hexText = new Text(composite, style);
        this.hexText.setText(hex);
        this.hexText.setTextLimit(hex.length());
        this.hexText.setFont(JFaceResources.getTextFont());
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 320;
        this.hexText.setLayoutData((Object)gridData);
        TextUtil.setWidth(this.hexText, width, width);
        this.hexText.addVerifyListener((VerifyListener)new verifyHexFixed());
        final Button charRadioButton = new Button(composite, 16);
        charRadioButton.setText(Messages.DataViewValueDialog_7);
        gridData = new GridData(4, 2, true, false, 1, 1);
        charRadioButton.setLayoutData((Object)gridData);
        charRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = charRadioButton.getSelection();
                if (selected) {
                    DataViewValueDialog.this.verifyInput();
                    DataViewValueDialog.this.valueText.setEnabled(true);
                    DataViewValueDialog.this.hexText.setEnabled(false);
                    DataViewValueDialog.this.valueText.setFocus();
                }
            }
        });
        this.valueText = new Text(composite, style);
        try {
            this.valueText.setText(this.variable.getEditValue());
            this.errortext = EMPTY;
        }
        catch (Exception e) {
            this.errortext = HexUtil.getErrorText((Throwable)e);
            this.valueText.setText(EMPTY);
        }
        this.valueText.setTextLimit(this.variable.getEditSize());
        this.valueText.setEnabled(false);
        this.hexText.setFont(JFaceResources.getTextFont());
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 320;
        this.valueText.setLayoutData((Object)gridData);
        TextUtil.setWidth(this.valueText, width, width);
        switch (this.variable.getDatatype()) {
            case SIGNED: {
                this.valueText.addVerifyListener((VerifyListener)new verifyNumber(true));
                break;
            }
            case UNSIGNED: {
                this.valueText.addVerifyListener((VerifyListener)new verifyNumber(true));
                break;
            }
            default: {
                this.valueText.addVerifyListener((VerifyListener)new verifyFixed());
            }
        }
        new Label(composite, 0);
        this.errormsg = new Label(composite, 0);
        this.errormsg.setText(this.errortext);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 320;
        this.errormsg.setLayoutData((Object)gridData);
        if (this.valueText.getText().indexOf(HexUtil.dot) == -1 && this.errortext.length() == 0) {
            hexRadioButton.setSelection(false);
            this.hexText.setEnabled(false);
            charRadioButton.setSelection(true);
            this.valueText.setEnabled(true);
            this.valueText.setFocus();
        } else {
            charRadioButton.setSelection(false);
            this.valueText.setEnabled(false);
            hexRadioButton.setSelection(true);
            this.hexText.setEnabled(true);
            this.hexText.setFocus();
        }
        return composite;
    }

    protected void okPressed() {
        if (this.verifyInput()) {
            this.doMemoryUpdates();
            super.okPressed();
        } else {
            MessageDialog.openWarning(null, (String)Messages.DataViewValueDialog_8, (String)(String.valueOf(Messages.DataViewValueDialog_9) + this.errormsg.getText()));
        }
    }

    private void doMemoryUpdates() {
        if (!this.curhexvalue.equals(this.variable.getData())) {
            this.curHexString = this.variable.getHexValue(this.curhexvalue);
            this.variable.updateHexValue(this.session, HexUtil.toHex((byte[])this.curhexvalue, (int)0));
        }
    }

    public String getCurHexString() {
        return this.curHexString;
    }

    protected boolean verifyInput() {
        if (!this.ok.isEnabled()) {
            return true;
        }
        boolean result = true;
        try {
            if (this.hexText.isEnabled()) {
                result = this.checkHex();
                this.valueText.setText(this.variable.getValue(this.curhexvalue));
            } else {
                result = this.checkChar();
                this.hexText.setText(this.variable.getHexValue(this.curhexvalue));
            }
        }
        catch (Exception e) {
            this.errortext = HexUtil.getErrorText((Throwable)e);
            this.errormsg.setText(this.errortext);
            result = false;
        }
        if (result) {
            this.errortext = EMPTY;
        }
        this.errormsg.setText(this.errortext);
        return result;
    }

    private boolean checkHex() throws Exception {
        if (((Boolean)this.hexText.getData(MODIFIED)).booleanValue()) {
            this.hexText.setData(MODIFIED, (Object)Boolean.FALSE);
            String value = this.hexText.getText();
            if (this.variable.validateHexValue(value)) {
                this.curhexvalue = HexUtil.HextoBytes((String)value);
                return true;
            }
        }
        return false;
    }

    private boolean checkChar() throws Exception {
        if (((Boolean)this.valueText.getData(MODIFIED)).booleanValue()) {
            this.valueText.setData(MODIFIED, (Object)Boolean.FALSE);
            String value = this.valueText.getText();
            if (this.variable.validateValue(value)) {
                this.curhexvalue = this.variable.getBytesFromString(value, this.curhexvalue);
                return true;
            }
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.ok = this.getButton(0);
        this.ok.setEnabled(false);
        this.defaultbutton = this.getShell().getDefaultButton();
        if (this.ok.equals(this.defaultbutton)) {
            this.getShell().setDefaultButton(this.getButton(1));
        }
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                if (!((Boolean)text.getData(DataViewValueDialog.MODIFIED)).booleanValue()) {
                    text.setData(DataViewValueDialog.MODIFIED, (Object)Boolean.TRUE);
                }
                if (!DataViewValueDialog.this.ok.isEnabled()) {
                    DataViewValueDialog.this.ok.setEnabled(true);
                    if (DataViewValueDialog.this.defaultbutton.equals(DataViewValueDialog.this.ok)) {
                        DataViewValueDialog.this.getShell().setDefaultButton(DataViewValueDialog.this.defaultbutton);
                    }
                }
            }
        };
        this.valueText.setData(MODIFIED, (Object)Boolean.FALSE);
        this.valueText.addModifyListener(listener);
        this.hexText.setData(MODIFIED, (Object)Boolean.FALSE);
        this.hexText.addModifyListener(listener);
    }
}

