/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Snapshot;
import com.ca.intertest.debug.BatchQueueBreakpoints;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.MonitorMessage;
import com.ca.intertest.debug.QueueBreakpoints;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugMarkerGroup;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.BatchConnection;
import com.ca.intertest.server.Connection;
import com.ca.intertest.tools.ATTNMessage;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IBreakpointMessage;
import com.ca.intertest.tools.IConditionalBreakpointMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.IUnconditionalBreakpointMessage;
import com.ca.intertest.tools.IVariableBreakpointMessage;
import com.ca.intertest.tools.SuspendDebugMessage;
import com.ca.intertest.tools.SynchMonitorMessage;
import com.ca.intertest.tools.SynchRequestBreakpointMessage;
import com.ca.intertest.tools.TerminateSessionMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class debugBatchSession
extends debugSession {
    String cacopyright = "Copyright \u00a9 2016 CA";
    private boolean backtrace;
    private boolean count;
    private byte[] sToken = null;
    private boolean initialbreakpoint = false;
    private final ArrayList<String> protsymlist = new ArrayList(8);
    private final IPropertyChangeListener listener;

    public debugBatchSession(IProject resource, Debug debug) throws ITException, CoreException {
        super(resource, debug);
        this.setVersion("01");
        this.backtrace = this.isStatementTrace();
        this.count = this.isExecutionCount();
        this.addDebugListener(this);
        debugMarkerGroup group = this.getMarkergroup();
        IDebugMarker marker = group.getMarker((short)128);
        this.initialbreakpoint = marker.isEnabled();
        this.buildProtymlist(this.store.getString("protsym_list"));
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("protsym_list")) {
                    debugBatchSession.this.buildProtymlist(event.getNewValue());
                }
            }
        };
        this.store.addPropertyChangeListener(this.listener);
    }

    private void buildProtymlist(Object object) {
        this.protsymlist.clear();
        if (object == null || object.toString().length() == 0) {
            return;
        }
        Object[] names = object.toString().split(";");
        Arrays.sort(names);
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (((String)(item = ((String)item).trim())).length() > 0 && !this.protsymlist.contains(item)) {
                this.protsymlist.add((String)item);
            }
            ++n2;
        }
    }

    @Override
    public void endSession() {
        BreakMessage msg;
        if (this.isDebugging() && this.isAtBreakpoint() && (msg = this.getTalker().getBreakmessage()).getMessageID() != 4) {
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)new TerminateSessionMessage());
            this.getTalker().processExecute(cvmi);
        }
        this.resetDebug();
    }

    @Override
    public String[] getUEXIT(boolean force) {
        return new String[0];
    }

    @Override
    public boolean isStatementTrace() {
        return (Boolean)Attribute.getValue("back_trace", this.getStore());
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public boolean isCICS() {
        return false;
    }

    @Override
    public boolean isDataMonitor() {
        return (Boolean)Attribute.getValue("data_monitor", this.getStore());
    }

    @Override
    public boolean isExecutionCount() {
        return (Boolean)Attribute.getValue("execution_count", this.getStore());
    }

    @Override
    public void debugEventOccured(debugEvent event) {
        Object obj = event.getSource();
        if (obj instanceof DSECT && ((DSECT)obj).size() > 0) {
            DebugMessage msg = ((DSECT)obj).getMessage(1);
            if (obj instanceof CVMO) {
                this.setTraceLog((CVMO)((Object)obj));
                DebugTalker eventtalker = event.getTalker();
                if (eventtalker != null && eventtalker.equals(this.talker) && msg.getMessageID() == 1) {
                    if (this.sToken == null) {
                        this.sToken = ((BreakMessage)msg).getSToken();
                    }
                    this.synchUp((CVMO)((Object)obj));
                    return;
                }
            } else if (obj instanceof CVMI) {
                this.setTraceInfo((CVMI)((Object)obj));
                if (msg.getMessageID() == 32) {
                    this.buildBreakpointQueue();
                }
            }
        }
    }

    @Override
    public void setStatementTrace(boolean trace) {
        if (this.backtrace != trace) {
            this.backtrace = trace;
            this.store.setValue("back_trace", this.backtrace);
            this.store.save();
            if (this.isDebugging()) {
                try {
                    this.addExecutionCount(this, true, (short)1);
                    this.post(null);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "back_trace", (Object)this, (Object)this));
        }
    }

    @Override
    public void setDataMonitor(boolean monitor) {
    }

    @Override
    public void setExecutionCount(boolean count) {
        if (this.count != count) {
            this.count = count;
            this.store.setValue("execution_count", count);
            this.store.save();
            if (this.isDebugging()) {
                try {
                    short sub = count ? (short)1 : 2;
                    this.addExecutionCount(this, true, sub);
                    this.post(null);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "execution_count", (Object)this, (Object)this));
        }
    }

    @Override
    public void suspendSession() {
        if (this.isDebugging() && this.isAtBreakpoint()) {
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)new SuspendDebugMessage());
            this.getTalker().processExecute(cvmi);
        }
        this.resetDebug();
    }

    @Override
    protected QueueBreakpoints getQueue() {
        if (this.queue == null) {
            this.queue = new BatchQueueBreakpoints(this);
        }
        return this.queue;
    }

    @Override
    public void buildBreakpointQueue() {
        this.queue.setSetStepAfter(true);
        try {
            this.addRBPBreakpoints();
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        try {
            this.addExecutionCount(this, true, (short)1);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        try {
            this.addStatementTrace(this, true);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        try {
            this.addDataMonitor(this, false);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        for (debugFile debugfile : this.getMonitored(true)) {
            try {
                this.addMonitor(debugfile);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    public byte[] getSToken() {
        if (this.sToken != null) {
            byte[] byArray = this.sToken;
            int n = this.sToken.length;
            int n2 = 0;
            while (n2 < n) {
                byte item = byArray[n2];
                if (item != 0) {
                    return this.sToken;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setSToken(byte[] token) {
        if (token != null) {
            byte[] byArray = token;
            int n = token.length;
            int n2 = 0;
            while (n2 < n) {
                byte item = byArray[n2];
                if (item != 0) {
                    this.sToken = HexUtil.sizeBytes((byte[])token, (int)12);
                    return;
                }
                ++n2;
            }
        }
        this.sToken = null;
    }

    @Override
    public synchronized void resetDebug() {
        this.setSToken(null);
        super.resetDebug();
    }

    @Override
    public synchronized void setDebug() {
        this.debugging = true;
        for (Map.Entry entry : this.debugfiles.entrySet()) {
            if (!((debugFile)entry.getValue()).exists()) continue;
            BreakpointMarker[] breakpointMarkerArray = ((debugFile)entry.getValue()).getBreakpointmarkers();
            int n = breakpointMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BreakpointMarker breakpoint = breakpointMarkerArray[n2];
                breakpoint.setBreakpointID(0L);
                ++n2;
            }
        }
    }

    public void interrupJob() {
        if (this.sToken != null) {
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)new ATTNMessage(this.sToken));
            BatchConnection connection = new BatchConnection(this.getFileServer());
            try {
                if (connection.connect(true)) {
                    CVMO cvmo = connection.process(cvmi);
                    Connection.displayError(cvmo, Messages.debugBatchSession_2);
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public String getType() {
        return "BATCH".toLowerCase();
    }

    @Override
    public void sendUnsetBreakpointsMessages() {
        CVMI cvmi = new CVMI();
        for (debugFile file : this.getMonitored(true)) {
            if (!file.exists()) continue;
            BreakpointMarker[] breakpointMarkerArray = file.getBreakpointmarkers();
            int n = breakpointMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BreakpointMarker breakpoint = breakpointMarkerArray[n2];
                try {
                    BreakpointMessage message = BreakpointMessageFactory.getUnsetBPMessage(breakpoint)[0];
                    cvmi.addMessage((DebugMessage)message);
                    breakpoint.setBreakpointID(0L);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
                ++n2;
            }
        }
        if (cvmi.size() > 0) {
            try {
                this.getTalker().process(cvmi);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void sendUnsetMonitorMessages() {
        CVMI cvmi = new CVMI();
        try {
            for (debugFile file : this.getMonitored(true)) {
                if (!file.exists()) continue;
                MonitorMessage message = new MonitorMessage(file);
                message.setEnabled(false);
                cvmi.addMessage((DebugMessage)message);
            }
            if (cvmi.size() > 0) {
                this.getTalker().process(cvmi);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    public void synchUp(CVMO cvmo) {
        DebugMessage[] messages;
        int ix = 0;
        DebugMessage[] debugMessageArray = messages = cvmo.getMessages();
        int n = messages.length;
        int n2 = 0;
        block7: while (n2 < n) {
            DebugMessage item = debugMessageArray[n2];
            switch (item.getMessageID()) {
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    ++ix;
                    break block7;
                }
                default: {
                    ++n2;
                }
            }
        }
        if (ix > 0) {
            IResource resource = this.getResource();
            SynchronizeSession runner = new SynchronizeSession(this, messages);
            try {
                resource.getWorkspace().run((IWorkspaceRunnable)runner, (ISchedulingRule)resource, 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        try {
            this.queue.post();
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    @Override
    public void postSnapshot(Snapshot snapshot, boolean monitor) {
    }

    @Override
    public boolean hasInitialBreakpoint() {
        return this.initialbreakpoint;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ca.intertest.breakpoint.rbp")) {
            if (!event.getSource().equals(this)) {
                return;
            }
            Object oldvalue = event.getOldValue();
            Object newvalue = event.getNewValue();
            boolean deleted = newvalue == null;
            IMarker marker = (IMarker)(oldvalue == null ? newvalue : oldvalue);
            if (marker == null || !marker.exists() || deleted) {
                return;
            }
            short commandID = (short)marker.getAttribute("cmd", 0);
            if (commandID != 128) {
                return;
            }
            this.initialbreakpoint = marker.getAttribute("BREAKPOINT_ENABLED", false);
            return;
        }
        super.propertyChange(event);
    }

    public ArrayList<String> getProtsymlist() {
        return this.protsymlist;
    }

    public void addProtsym(String protsym) {
        if (protsym == null) {
            return;
        }
        protsym = protsym.trim();
        this.protsymlist.add(protsym);
        Object[] protsymItems = this.protsymlist.toArray(new String[this.protsymlist.size()]);
        Arrays.sort(protsymItems);
        String protsyms = "";
        Object lastelement = "";
        Object[] objectArray = protsymItems;
        int n = protsymItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!((String)element).equals(lastelement)) {
                protsyms = String.valueOf(protsyms) + (String)element + ";";
                lastelement = element;
            }
            ++n2;
        }
        this.store.setValue("protsym_list", protsyms);
    }

    @Override
    public boolean isDataMonitorOK() {
        return this.isStatementTrace();
    }

    @Override
    public void dispose() {
        this.store.removePropertyChangeListener(this.listener);
        this.removeDebugListener(this);
        super.dispose();
    }

    @Override
    public String getProjectType() {
        return "BATCH";
    }

    final class SynchronizeSession
    implements IWorkspaceRunnable {
        private final debugSession session;
        private final DebugMessage[] messages;
        private debugMarkerGroup fileRBP = null;
        private debugMarkerGroup sessionRBP = null;

        protected SynchronizeSession(debugSession session, DebugMessage[] messages) {
            this.session = session;
            this.messages = messages;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            debugFile file = null;
            this.sessionRBP = this.session.getMarkergroup();
            DebugMessage[] debugMessageArray = this.messages;
            int n = this.messages.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage item = debugMessageArray[n2];
                switch (item.getMessageID()) {
                    case 37: {
                        SynchMonitorMessage synchMonitorMessage = (SynchMonitorMessage)item;
                        String program = synchMonitorMessage.getProgram();
                        String protsym = synchMonitorMessage.getProtsym();
                        file = this.session.refreshFile(program, protsym, true, false, true, 0, 0);
                        file.setEntered(true);
                        this.session.removeMonitor(file);
                        this.session.addBreakpoints(file);
                        try {
                            this.session.post(null);
                        }
                        catch (Exception e1) {
                            Logger.loggit(e1);
                        }
                        break;
                    }
                    case 33: 
                    case 34: 
                    case 35: {
                        IBreakpointMessage BPmsg = (IBreakpointMessage)item;
                        file = this.getFile(BPmsg.getProgram());
                        if (file == null) break;
                        try {
                            IMarker marker = this.buildMarker(BPmsg);
                            if (marker == null) break;
                            Map map = marker.getAttributes();
                            Integer statement = (Integer)map.get("stmtNumber");
                            if (statement == null) {
                                statement = 0;
                            }
                            map.put("source", String.format("%s", Messages.debugBatchSession_5));
                            marker.setAttributes(map);
                        }
                        catch (ITException e) {
                            Logger.loggit(e);
                        }
                        break;
                    }
                    case 36: {
                        Object rbps;
                        SynchRequestBreakpointMessage setrbp = (SynchRequestBreakpointMessage)item;
                        short[] codes = setrbp.getRbp_codes();
                        if (codes.length <= 0 || (rbps = setrbp.getProgram().length() == 0 ? this.sessionRBP : ((file = this.getFile(setrbp.getProgram())) == null ? null : this.fileRBP)) == null) break;
                        short[] sArray = codes;
                        int n3 = codes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            short code = sArray[n4];
                            short[] sArray2 = SynchRequestBreakpointMessage.BATCH_FLAG_BITS;
                            int n5 = SynchRequestBreakpointMessage.BATCH_FLAG_BITS.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IDebugMarker marker;
                                short flag = sArray2[n6];
                                short commandID = (short)(code & flag);
                                if (commandID != 0 && (marker = ((debugMarkerGroup)rbps).getMarker(commandID)) != null) {
                                    marker.setEnabled(true);
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                        ((debugMarkerGroup)rbps).save();
                    }
                }
                ++n2;
            }
        }

        private debugFile getFile(String program) {
            debugFile file = this.session.getFile(program);
            this.fileRBP = file.getMarkergroup();
            return file;
        }

        private IMarker buildMarker(IBreakpointMessage message) throws ITException, CoreException {
            Assert.isNotNull((Object)message, (String)Messages.debugBatchSession_6);
            IMarker marker = null;
            String program = message.getProgram();
            IResource resource = null;
            debugFile file = null;
            if (program.length() < 1) {
                resource = this.session.getResource();
            } else {
                file = this.session.getFile(program);
                if (file != null) {
                    resource = file.getResource();
                }
            }
            if (resource == null) {
                throw new ITException(String.valueOf(Messages.debugBatchSession_7) + message.getClass().getSimpleName());
            }
            if (resource.getType() != 1) {
                throw new ITException(String.valueOf(Messages.debugBatchSession_8) + message.getClass().getSimpleName());
            }
            BreakpointMarker[] breakpointMarkerArray = file.getBreakpointmarkers();
            int n = breakpointMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BreakpointMarker item;
                block17: {
                    item = breakpointMarkerArray[n2];
                    if (!item.exists()) break;
                    BreakpointMessage msg = BreakpointMessageFactory.getInstance(item)[0];
                    if (!message.equals(msg)) break block17;
                    msg.setBreakpointID(message.getBreakpointID());
                    return null;
                }
                try {
                    int statement = item.getAttribute("stmtNumber", 0);
                    if (statement > 0 && statement == message.getStatement()) {
                        item.delete();
                        break;
                    }
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
                ++n2;
            }
            if (message instanceof IUnconditionalBreakpointMessage) {
                marker = resource.createMarker("com.ca.intertest.breakpoint.unconditional");
            } else if (message instanceof IConditionalBreakpointMessage) {
                marker = resource.createMarker("com.ca.intertest.breakpoint.conditional");
            } else if (message instanceof IVariableBreakpointMessage) {
                marker = resource.createMarker("com.ca.intertest.breakpoint.watch");
            } else {
                throw new ITException(String.valueOf(Messages.debugBatchSession_9) + message.getClass().getSimpleName());
            }
            Map<String, Object> attributes = BreakpointMessageFactory.getAttributes(message);
            if (attributes != null) {
                marker.setAttributes(attributes);
            }
            return marker;
        }
    }
}

