/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.tools.ITException;

public abstract class DebugSessionSetup {
    static final String cacopyright = "Copyright (c) 2016 CA";
    protected Connection connection = null;
    protected CVMI cvmi;
    protected debugSession session;
    protected ServerElement server;
    protected static final String CICS_SERVER = Messages.DebugSessionSetup_1;
    protected static final String BATCH_SERVER = Messages.DebugSessionSetup_2;
    protected static final String FILE_SERVER = Messages.DebugSessionSetup_3;

    public DebugSessionSetup(debugSession session) throws ITException, Exception {
        this.session = session;
        this.server = session.getDebugServer();
        if (this.server == null) {
            String message = String.format(Messages.DebugSessionSetup_4, session.isCICS() ? CICS_SERVER : BATCH_SERVER);
            throw new ITException(message);
        }
        if (session.isCICS() && session.getFileServer() == null) {
            String message = String.format(Messages.DebugSessionSetup_4, FILE_SERVER);
            throw new ITException(message);
        }
        if (!this.connect()) {
            throw new ITException(String.format(Messages.DebugSessionSetup_6, this.server.getName()));
        }
    }

    protected abstract boolean connect();

    public abstract int launch() throws Exception;
}

