/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.ResourceProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class decorator
implements ILabelDecorator {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String extension = ".intertest".replace(".", "");
    HashMap<String, Image> images = null;
    private boolean usetable = false;

    public decorator(boolean usetable) {
        this.usetable = usetable;
        if (usetable) {
            this.images = new HashMap(10);
            String[] stringArray = new String[]{"COB_ICON", "ASM_ICON", "PLI_ICON", "GENERIC_ICON", "TERM_ICON", "TRAN_ICON", "CICS_ICON", "BATCH_ICON"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ImageDescriptor newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor(key);
                if (newimage != null) {
                    this.images.put(key, newimage.createImage(true));
                }
                ++n2;
            }
        }
    }

    public decorator() {
        this(false);
    }

    public Image decorateImage(Image image, Object resource) {
        if (this.usetable) {
            return this.lookupImage(resource);
        }
        if (!(resource instanceof IResource)) {
            return null;
        }
        if (!((IResource)resource).exists()) {
            return null;
        }
        if (resource instanceof IFile) {
            ResourceProperty store;
            IFile file = (IFile)resource;
            if (file.isAccessible() && extension.equals(file.getFileExtension()) && decorator.isIntertest(store = ResourceProperty.getStore((IResource)file))) {
                ImageDescriptor newimage = null;
                String type = Attribute.toString("item_type", store);
                if (type.length() == 0 || type.equals("PROGID")) {
                    Integer lang = (Integer)Attribute.getValue("gt_m_lang", store);
                    switch (lang) {
                        case 32: {
                            newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("COB_ICON");
                            break;
                        }
                        case 16: {
                            newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("ASM_ICON");
                            break;
                        }
                        case 128: {
                            newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("PLI_ICON");
                            break;
                        }
                        default: {
                            newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("GENERIC_ICON");
                            break;
                        }
                    }
                } else {
                    newimage = type.equals("TERMID") ? IntertestPlugin.getDefault().getImageRegistry().getDescriptor("TERM_ICON") : (type.equals("TRANID") ? IntertestPlugin.getDefault().getImageRegistry().getDescriptor("TRAN_ICON") : IntertestPlugin.getDefault().getImageRegistry().getDescriptor("GENERIC_ICON"));
                }
                if (newimage != null) {
                    return newimage.createImage(true);
                }
            }
        } else if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            ImageDescriptor newimage = null;
            try {
                if (project.hasNature("com.ca.intertest.natures.cics")) {
                    newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("CICS_ICON");
                } else if (project.hasNature("com.ca.intertest.natures.batch")) {
                    newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("BATCH_ICON");
                }
            }
            catch (CoreException coreException) {}
            if (newimage != null) {
                return newimage.createImage(true);
            }
        }
        return null;
    }

    private Image lookupImage(Object resource) {
        String key = null;
        if (!(resource instanceof IResource)) {
            return null;
        }
        if (!((IResource)resource).exists()) {
            return null;
        }
        if (resource instanceof IFile) {
            ResourceProperty store;
            IFile file = (IFile)resource;
            if (extension.equals(file.getFileExtension()) && decorator.isIntertest(store = ResourceProperty.getStore((IResource)file))) {
                String type = Attribute.toString("item_type", store);
                if (type.length() == 0 || type.equals("PROGID")) {
                    Integer lang = (Integer)Attribute.getValue("gt_m_lang", store);
                    switch (lang) {
                        case 32: {
                            key = "COB_ICON";
                            break;
                        }
                        case 16: {
                            key = "ASM_ICON";
                            break;
                        }
                        case 128: {
                            key = "PLI_ICON";
                            break;
                        }
                        default: {
                            key = "GENERIC_ICON";
                            break;
                        }
                    }
                } else {
                    key = type.equals("TERMID") ? "TERM_ICON" : (type.equals("TRANID") ? "TRAN_ICON" : "GENERIC_ICON");
                }
            }
        } else if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            try {
                if (project.hasNature("com.ca.intertest.natures.cics")) {
                    key = "CICS_ICON";
                } else if (project.hasNature("com.ca.intertest.natures.batch")) {
                    key = "BATCH_ICON";
                }
            }
            catch (CoreException coreException) {}
        }
        if (key != null) {
            return this.images.get(key);
        }
        return null;
    }

    public String decorateText(String text, Object element, ResourceProperty store) {
        IFolder folder;
        if (!(element instanceof IResource)) {
            return null;
        }
        if (!((IResource)element).exists()) {
            return null;
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            String name = file.getName();
            String replace = "";
            if (extension.equals(file.getFileExtension())) {
                name = name.replace(".intertest", "");
                String type = Attribute.toString("item_type", store);
                if (type.length() == 0 || type.equals("PROGID")) {
                    replace = Attribute.toString((String)"gt_m_lang", (String)store.getString("gt_m_lang"));
                } else if (type.equals("TRANID")) {
                    name = name.substring("$TRAN_".length());
                    replace = type;
                } else if (type.equals("TERMID")) {
                    name = name.substring("$TERM_".length());
                    replace = type;
                }
                if (replace.length() > 0) {
                    return String.format("%s(%s)", name, replace);
                }
            }
            return name;
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            String type = null;
            try {
                if (project.hasNature("com.ca.intertest.natures.cics")) {
                    type = "CICS";
                } else if (project.hasNature("com.ca.intertest.natures.batch")) {
                    type = "BATCH";
                }
            }
            catch (CoreException coreException) {}
            if (type != null) {
                return String.valueOf(project.getName()) + ": " + type;
            }
        } else if (element instanceof IFolder && "settings".equals((folder = (IFolder)element).getFileExtension())) {
            try {
                if (folder.getProject().hasNature("com.ca.intertest.natures.intertest")) {
                    return "Metadata";
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        IFolder folder;
        if (!(element instanceof IResource)) {
            return null;
        }
        if (element instanceof IFile) {
            return this.decorateText(text, element, ResourceProperty.getStore((IResource)((IFile)element)));
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            String type = null;
            try {
                if (project.hasNature("com.ca.intertest.natures.cics")) {
                    type = "CICS";
                } else if (project.hasNature("com.ca.intertest.natures.batch")) {
                    type = "BATCH";
                }
            }
            catch (CoreException coreException) {}
            if (type != null) {
                return String.valueOf(project.getName()) + ": " + type;
            }
        } else if (element instanceof IFolder && "settings".equals((folder = (IFolder)element).getFileExtension())) {
            try {
                if (folder.getProject().hasNature("com.ca.intertest.natures.intertest")) {
                    return "Metadata";
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.images != null) {
            for (Image image : this.images.values()) {
                image.dispose();
            }
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static boolean isIntertest(IResource res) {
        if (!(res instanceof IResource)) {
            return false;
        }
        if (!res.exists()) {
            return false;
        }
        ResourceProperty store = ResourceProperty.getStore(res);
        if (store == null) {
            return false;
        }
        switch (res.getType()) {
            case 4: {
                try {
                    IProjectDescription description = ((IProject)res).getDescription();
                    return description.hasNature("com.ca.intertest.natures.intertest");
                }
                catch (CoreException coreException) {
                    break;
                }
            }
            case 1: {
                if (!extension.equals(res.getFileExtension())) break;
                if (store.getBoolean("com.ca.intertest")) {
                    return true;
                }
                if (!decorator.isZip((IFile)res)) break;
                store.setValue("com.ca.intertest", true);
                return true;
            }
        }
        return false;
    }

    private static boolean isZip(IFile file) {
        boolean intertest = false;
        try {
            ZipFile zipfile = new ZipFile(file.getFullPath().toFile(), 1);
            ZipEntry zipEntry = zipfile.getEntry("listing");
            boolean bl = intertest = zipEntry == null;
            if (!intertest) {
                zipEntry = zipfile.getEntry("metadata");
            }
            intertest = zipEntry == null;
            zipfile.close();
        }
        catch (IOException iOException) {
            intertest = false;
        }
        return intertest;
    }

    public static String getShortName(IResource res) {
        int index;
        String name = res.getName();
        if (res.getType() == 1 && (index = name.lastIndexOf(".intertest")) > 0 && ResourceProperty.getStore(res).getBoolean("com.ca.intertest")) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static boolean isIntertest(ResourceProperty store) {
        IResource res = store.getResource();
        switch (res.getType()) {
            case 4: {
                try {
                    return ((IProject)res).hasNature("com.ca.intertest.natures.intertest");
                }
                catch (CoreException coreException) {
                    break;
                }
            }
            case 1: {
                if (!extension.equals(res.getFileExtension())) break;
                if (store.getBoolean("com.ca.intertest")) {
                    return true;
                }
                if (!decorator.isZip((IFile)res)) break;
                store.setValue("com.ca.intertest", true);
                return true;
            }
        }
        return false;
    }

    public static String getShortName(ResourceProperty store) {
        int index;
        IResource res = store.getResource();
        String name = res.getName();
        if (res.getType() == 1 && (index = name.lastIndexOf(".intertest")) > 0 && store.getBoolean("com.ca.intertest")) {
            name = name.substring(0, index);
        }
        return name;
    }
}

