/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.attributes;

import com.ca.intertest.attributes.IAttribute;
import com.ca.intertest.attributes.StringAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarAttribute
extends StringAttribute
implements IAttribute {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
    protected Calendar value;

    static {
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public CalendarAttribute(String name, String title, String value) {
        super(name, title, value);
    }

    @Override
    public Object setValue(String value) {
        super.setValue(value);
        this.value = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        try {
            Date date = df.parse(value);
            this.value.setTime(date);
            date = this.value.getTime();
            this.string = df.format(date);
        }
        catch (ParseException parseException) {
            this.value = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        }
        catch (Exception exception) {}
        return this.value;
    }

    @Override
    public int getType() {
        return 4;
    }
}

