/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.views.cicstrace;

import com.ca.symdump.CICSTrace;
import com.ca.symdump.CICSTraceLine;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class IdColumnlabelProvider
extends OwnerDrawLabelProvider {
    private static final String format = "%05d";
    static String cacopyright = "Copyright (c) 2016 CA";

    public String getText(Object element) {
        CICSTraceLine line = (CICSTraceLine)element;
        return line.isFirstline() ? String.format(format, line.getTraceRecord().getRecordnumber()) : "";
    }

    public void update(ViewerCell cell) {
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        CICSTraceLine line = (CICSTraceLine)element;
        CICSTrace record = line.getTraceRecord();
        if (line.getType() != 3) {
            return record.getFullRecord();
        }
        return record.getAbrevRecord();
    }

    protected void measure(Event event, Object element) {
        Point extent = event.gc.textExtent(this.getText(element));
        event.setBounds(new Rectangle(event.x, event.y, extent.y + 4, extent.y));
    }

    protected void paint(Event event, Object element) {
        String buffer = this.getText(element);
        Display display = event.display;
        TextLayout layout = new TextLayout((Device)display);
        layout.setText(buffer);
        layout.setFont(JFaceResources.getTextFont());
        layout.setAlignment(0x1000088);
        layout.draw(event.gc, event.x, event.y);
    }

    public Font getToolTipFont(Object object) {
        return JFaceResources.getTextFont();
    }
}

