/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.Abend;
import com.ca.symdump.SymdumpDatset;
import com.ca.symdump.views.index.IndexView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.NodeChild;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class LockDumpHandler
extends AbstractHandler {
    static String cacopyright = "Copyright (c) 2016 CA";
    Logger log = Logger.getLogger(LockDumpHandler.class.getName());
    Level baseLevel = this.log.getLevel();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof IndexView) {
            ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
                Abend dump = null;
                ArrayList<SymdumpDatset> DSNList = new ArrayList<SymdumpDatset>();
                int count = 0;
                for (Object obj : (IStructuredSelection)sel) {
                    if (!(obj instanceof Abend)) continue;
                    dump = (Abend)obj;
                    XMLRequest returnXML = null;
                    SymdumpDatset dumpDSN = dump.getDataset();
                    if (!DSNList.contains((Object)dumpDSN)) {
                        DSNList.add(dumpDSN);
                    }
                    try {
                        returnXML = dump.lockDump();
                        if (returnXML.getErrorLevel() == 0) continue;
                        ++count;
                        this.log.log(Level.WARNING, returnXML.getErrorMessage());
                    }
                    catch (MalformedURLException e) {
                        this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                    }
                    catch (TTException e) {
                        this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                    }
                }
                Dataset[] datasets = DSNList.toArray(new Dataset[DSNList.size()]);
                ((IndexView)part).setContent((NodeChild[])DSNList.toArray(datasets), false);
                if (count != 0) {
                    String message = "";
                    message = String.format("%d out of %d requests failed.  See Error Log for details.", count, ((IStructuredSelection)sel).size());
                    MessageDialog.openInformation(null, (String)"Lock Dump Request", (String)message);
                } else {
                    MessageDialog.openInformation(null, (String)"Lock Dump Request", (String)"Lock request was successful");
                }
            } else {
                MessageDialog.openInformation(null, (String)"Lock Dump Request", (String)"Please select a Dump to Lock.");
            }
        }
        return null;
    }
}

