/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class StorageReturnMessage
extends DebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected int user24 = 0;
    protected int user31 = 0;
    protected int cics24 = 0;
    protected int cics31 = 0;
    protected int numEntries = 0;
    protected int lowAddr = 0;
    protected int highAddr = 0;
    protected byte[] type;
    protected byte[] flg2;
    protected ArrayList<MFAddress> address;
    protected ArrayList<ByteBuffer> hexdata;
    protected ArrayList<Integer> length;

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.putInt(this.cics24);
        this.buffer.putInt(this.user24);
        this.buffer.putInt(this.cics31);
        this.buffer.putInt(this.user31);
        this.buffer.putShort(Numbers.putUShort(this.numEntries));
        int i = 0;
        while (i < this.numEntries) {
            this.buffer.put(this.type[i]);
            this.buffer.put(this.flg2[i]);
            long high = this.address.get(i).getHigh();
            long low = this.address.get(i).getLow();
            this.buffer.putLong(high);
            this.buffer.putLong(low);
            this.buffer.putInt(this.length.get(i));
            this.buffer.put(this.hexdata.get(i));
            ++i;
        }
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            this.cics24 = this.buffer.getInt();
            this.user24 = this.buffer.getInt();
            this.cics31 = this.buffer.getInt();
            this.user31 = this.buffer.getInt();
            this.numEntries = Numbers.getUShort(this.buffer.getShort());
            this.type = new byte[this.numEntries];
            this.flg2 = new byte[this.numEntries];
            this.address = new ArrayList(this.numEntries);
            this.length = new ArrayList(this.numEntries);
            this.hexdata = new ArrayList(this.numEntries);
            int i = 0;
            while (i < this.numEntries) {
                this.type[i] = this.buffer.get();
                this.flg2[i] = this.buffer.get();
                int high = this.buffer.getInt();
                int low = this.buffer.getInt();
                MFAddress addr = new MFAddress(high, low);
                this.address.add(addr);
                this.length.add(this.buffer.getInt());
                byte[] hex16 = new byte[16];
                this.buffer.get(hex16);
                ByteBuffer bb = ByteBuffer.wrap(hex16);
                this.hexdata.add(bb);
                ++i;
            }
        }
        catch (Exception e) {
            throw new ITException(e);
        }
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public byte[] getType() {
        return this.type;
    }

    public void setType(byte[] type) {
        this.type = type;
    }

    public byte[] getFlg2() {
        return this.flg2;
    }

    public void setFlg2(byte[] flg2) {
        this.flg2 = flg2;
    }

    public int getUser24() {
        return this.user24;
    }

    public void setUser24(int iUser24) {
        this.user24 = iUser24;
    }

    public int getUser31() {
        return this.user31;
    }

    public void setUser31(int iUser31) {
        this.user31 = iUser31;
    }

    public int getCics24() {
        return this.cics24;
    }

    public void setCics24(int iCics24) {
        this.cics24 = iCics24;
    }

    public int getCics31() {
        return this.cics31;
    }

    public void setCics31(int iCics31) {
        this.cics31 = iCics31;
    }

    public ArrayList<MFAddress> getAddress() {
        return this.address;
    }

    public void setAddr(ArrayList<MFAddress> address) {
        this.address = address;
    }

    public void setLength(ArrayList<Integer> length) {
        this.length = length;
    }

    public ArrayList<Integer> getLength() {
        return this.length;
    }

    public ArrayList<ByteBuffer> getHexdata() {
        return this.hexdata;
    }

    public void setHexdata(ArrayList<ByteBuffer> hexdata) {
        this.hexdata = hexdata;
    }

    @Override
    protected short _defaultID() {
        return 43;
    }

    @Override
    protected int _getMessageSize() {
        return 2000;
    }

    @Override
    protected String _toString() {
        return null;
    }
}

