/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import java.nio.ByteBuffer;

public class SetBacktraceMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private String userid;
    private String termid;
    public static final short CVMI_TRACE_ON = 4;
    public static final short CVMI_TRACE_OFF = 8;
    public static final short CVMI_DMON_ON = 1;
    public static final short CVMI_DMON_OFF = 2;

    public SetBacktraceMessage() {
        super(true);
    }

    @Override
    protected short _defaultID() {
        return 13;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.setSubmessageID(this.submessageID);
        try {
            this.setProgram(this.getProgram(this.buffer));
            switch (this.buffer.get()) {
                case 2: {
                    this.filetype = FileType.TERMID;
                    break;
                }
                case 1: {
                    this.filetype = FileType.TRANID;
                    break;
                }
                default: {
                    this.filetype = FileType.PROGID;
                }
            }
            this.getAvailable(this.buffer);
            byte[] buf = new byte[4];
            newbuffer.get(buf);
            this.termid = HexUtil.rightTrim(new String(buf, "IBM1047"));
            buf = new byte[8];
            newbuffer.get(buf);
            this.userid = HexUtil.rightTrim(new String(buf, "IBM1047"));
        }
        catch (Exception e) {
            throw new ITException(e);
        }
    }

    @Override
    protected int _getMessageSize() {
        return 53;
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.putProgram());
        switch (this.filetype) {
            case TERMID: {
                this.buffer.put((byte)2);
                break;
            }
            case TRANID: {
                this.buffer.put((byte)1);
                break;
            }
            default: {
                this.buffer.put((byte)0);
            }
        }
        this.buffer.put(this.putAvailable());
        this.buffer.put(HexUtil.spaceFill(this.termid, 4).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.userid, 8).toUpperCase().getBytes("IBM1047"));
    }

    @Override
    protected String _toString() {
        return null;
    }

    public String getUserID() {
        return this.userid;
    }

    public void setUserID(String userId) {
        this.userid = userId;
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                super.setSubmessageID(submessageID);
                return;
            }
        }
        throw new ITException(String.format("%02x is invalid SubmessagID", submessageID));
    }

    public String getTermID() {
        return this.termid;
    }

    public void setTermID(String termid) {
        this.termid = termid;
    }

    public static enum EnableType {
        NOOP,
        OFF,
        ON;

    }
}

