/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import java.nio.ByteBuffer;

public class BlsEnqMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private String port = "";
    private String sysplexPort = "";
    private String localHost = "";
    private String enqId = "BLS";
    private String blsEntry = "";

    public BlsEnqMessage() {
        super(false);
    }

    @Override
    protected short _defaultID() {
        return 51;
    }

    @Override
    protected void buildMessage() throws Exception {
        this.blsEntry = String.valueOf(this.enqId) + " " + this.localHost + " " + this.sysplexPort + " " + this.port + " ";
        this.buffer.put(HexUtil.spaceFill(this.blsEntry, 80).getBytes("IBM1047"));
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] bytes = new byte[80];
        this.buffer.get(bytes);
        this.blsEntry = new String(bytes, "IBM1047");
        this.enqId = this.blsEntry.substring(0, 3);
        int index1 = this.blsEntry.indexOf(" ", 4);
        this.localHost = this.blsEntry.substring(4, index1);
        int index2 = this.blsEntry.indexOf(" ", index1 + 1);
        this.sysplexPort = this.blsEntry.substring(index1 + 1, index2);
        index1 = this.blsEntry.indexOf(" ", index2 + 1);
        this.port = this.blsEntry.substring(index2 + 1, index1);
    }

    @Override
    protected String _toString() {
        return null;
    }

    @Override
    protected int _getMessageSize() {
        return 500;
    }

    public String getEnqId() {
        return this.enqId;
    }

    public void setEnqId(String id) {
        this.enqId = id == null ? "   " : id;
    }

    public String getSysplexPort() {
        return this.sysplexPort;
    }

    public void setSysplexPort(String portNum) {
        this.sysplexPort = portNum;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String portNum) {
        this.port = portNum;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    public String getIpName() {
        int index1 = this.localHost.indexOf("/");
        return this.localHost.substring(0, index1);
    }

    public void setIpName(String name) {
        if (name.length() > 8) {
            name = name.substring(0, 8);
        }
        String ipAddress = this.getIpAddress();
        this.localHost = String.valueOf(name) + "/" + ipAddress;
    }

    public String getIpAddress() {
        int index1 = this.localHost.indexOf("/");
        return this.localHost.substring(index1 + 1);
    }

    public void setIpAddress(String ip) {
        String sysId = this.getIpName();
        this.localHost = String.valueOf(sysId) + "/" + ip;
    }
}

