/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class AutoKeepMessage
extends DebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected String varname = "";
    protected MFAddress address = MFAddress.ZERO_ADDR;
    protected String pliProcName;
    protected int statement = 0;

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.address.toByteArray());
        this.buffer.put(HexUtil.spaceFill(this.pliProcName, 31).getBytes("IBM1047"));
        this.buffer.putInt(this.statement);
        this.varname = this.varname.trim();
        this.buffer.putShort((short)this.varname.length());
        this.buffer.put(this.varname.getBytes("IBM1047"));
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.address = new MFAddress(this.buffer);
        byte[] proc = new byte[31];
        this.buffer.get(proc);
        this.pliProcName = HexUtil.rightTrim(new String(proc, "IBM1047"));
        this.statement = this.buffer.getInt();
        int lth = Numbers.getUShort(this.buffer.getShort());
        byte[] buf = new byte[lth];
        this.buffer.get(buf);
        this.varname = new String(buf, "IBM1047").trim();
    }

    public String getVarName() {
        return this.varname;
    }

    public void setVarName(String vname) {
        this.varname = vname.trim();
    }

    public String getAddressAsString() {
        return this.address.toString();
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public void setAddress(String address) throws Exception {
        this.address = new MFAddress(address);
    }

    public void setAddress(MFAddress address) {
        this.address = address;
    }

    public void setAddr(long baseaddr) {
        try {
            this.address = new MFAddress(0L, baseaddr);
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.address = MFAddress.ZERO_ADDR;
        }
    }

    @Override
    protected boolean _checkID(short messageID) {
        return messageID == 7;
    }

    @Override
    protected short _defaultID() {
        return 7;
    }

    @Override
    protected int _getMessageSize() {
        return 500;
    }

    @Override
    protected String _toString() {
        return String.format("%s Addr:%s", this.varname, this.address.toString());
    }

    public long getAlet() {
        return this.address.getAlet();
    }

    public String getPliProcName() {
        return this.pliProcName;
    }

    public void setPliProcName(String name) {
        this.pliProcName = name;
    }

    public int getStatement() {
        return this.statement;
    }

    public void setStatement(int stmt) {
        this.statement = stmt;
    }
}

