/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.ui.actions.ChangeStructureItemAction;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPageBook;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import com.ca.intertest.ui.views.data.HexValueColumnLabelProvider;
import com.ca.intertest.ui.views.data.HexValueEditingSupport;
import com.ca.intertest.ui.views.data.PropertyColumnLabelProvider;
import com.ca.intertest.ui.views.data.ValueColumnLabelProvider;
import com.ca.intertest.ui.views.data.ValueEditingSupport;
import com.ca.intertest.ui.views.data.VariableColumnLabelProvider;
import com.ca.intertest.wizards.CoreStructureContentProvider;
import com.ca.intertest.wizards.IMemoryWizard;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class CoreStructurePage
extends WizardPage
implements Listener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public TreeObject treeobject;
    private ListerEditor editor;
    private static final Debug debug = Debug.getInstance();
    private debugSession session;
    private debugFile debugfile;
    private IDebug debugitem;
    public TreeViewer viewer;
    private CoreStructureContentProvider treeContent;
    private int lang;
    private int[] widths = null;
    private static final int[] column_width = new int[]{10, 15, 15, 20};
    private final String CONTEXT_HELP_ID = "com.ca.intertest.coreStructurePage";

    public CoreStructurePage(String pageName) {
        super(pageName);
    }

    public void initStructure(ListerEditor lsteditor) {
        this.editor = lsteditor;
        this.debugitem = debug.getResource(this.editor.getResource());
        this.session = (debugSession)debug.getResource((IResource)this.editor.getResource().getProject());
        this.debugfile = (debugFile)debug.getResource(this.editor.getResource());
        this.lang = this.debugfile.getStore().getHex("gt_m_lang");
        if (this.isBackTraceStop()) {
            this.setDescription(Messages.CoreStructurePage_0);
        } else {
            this.setDescription(" ");
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer(composite, 68354);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        TreeViewerFocusCellManager mgr = new TreeViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && (event.keyCode == 13 || event.character == ' ') || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.viewer, (SWTFocusCellManager)mgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        tree.setFont(JFaceResources.getTextFont());
        String[] labels = AbstractDataViewPageBook.labels;
        int[] styles = AbstractDataViewPageBook.styles;
        if (this.widths == null) {
            GC gc = new GC((Drawable)tree);
            gc.setFont(tree.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.widths = new int[column_width.length];
            int j = 0;
            while (j < column_width.length) {
                this.widths[j] = (int)((double)(column_width[j] * CHAR_WIDTH) * 1.2);
                ++j;
            }
        }
        int columnIndex = 0;
        while (columnIndex < labels.length) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new VariableColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new BasicEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 1: {
                    column.setLabelProvider((CellLabelProvider)new ValueColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new ValueEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 2: {
                    column.setLabelProvider((CellLabelProvider)new HexValueColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new HexValueEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 3: {
                    column.setLabelProvider((CellLabelProvider)new PropertyColumnLabelProvider(this.debugitem));
                    column.setEditingSupport((EditingSupport)new BasicEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                }
            }
            column.getColumn().setWidth(this.widths[columnIndex]);
            column.getColumn().setText(labels[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData("column_width", (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(true);
            ++columnIndex;
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.treeContent = new CoreStructureContentProvider(this.getDebugitem().getResource(), this);
        this.viewer.setContentProvider((IContentProvider)this.treeContent);
        this.viewer.setColumnProperties(labels);
        this.viewer.setInput((Object)this.treeContent);
        this.viewer.expandAll();
        this.hookDoubleClickAction();
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.coreStructurePage");
    }

    protected void hookDoubleClickAction() {
        ChangeStructureItemAction change = new ChangeStructureItemAction();
        change.init((IWizardPage)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)change);
    }

    public IDebug getDebugitem() {
        return this.debugitem;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public debugSession getSession() {
        return this.session;
    }

    public ListerEditor getEditor() {
        return this.editor;
    }

    public int getLang() {
        return this.lang;
    }

    public void setStructureTreeObject(TreeObject tree) {
        this.treeobject = tree;
    }

    public TreeObject getStructureTreeObject() {
        return this.treeobject;
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage(IMemoryWizard.dumppageName);
    }

    public void refreshViewer() {
        this.viewer.refresh();
        this.viewer.expandAll();
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public IWizardPage getNextPage() {
        return this.getPreviousPage();
    }

    public boolean isBackTraceStop() {
        return this.session.isBackTraceStop(this.debugfile);
    }
}

