/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import java.nio.ByteBuffer;

public class CoreDumpRow {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    public static final int CELL_IX_OFFSET = 2;
    public static final int CELL_LENGTH = 4;
    public static final int MAX_LENGTH = 16;
    private final MFAddress address;
    private final ByteBuffer databuffer;
    private final int offset;

    public CoreDumpRow(MFAddress address, int offset, byte[] data) {
        this.address = address.add((long)offset);
        this.offset = offset;
        int length = offset + 16 <= data.length ? 16 : data.length - offset;
        this.databuffer = ByteBuffer.wrap(data, offset, length);
    }

    public boolean canEditDisplay(int columnIndex) {
        return this.databuffer.position(this.offset).remaining() > columnIndex * 4;
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public byte[] getCellData(int cellIX) {
        try {
            this.databuffer.position(this.offset + cellIX * 4);
        }
        catch (Exception exception) {
            return new byte[0];
        }
        int size = Math.min(this.databuffer.remaining(), 4);
        byte[] data = new byte[size];
        this.databuffer.get(data);
        return data;
    }

    public MFAddress getCellAddress(int colnum) {
        long off = colnum * 4;
        return this.address.add(off);
    }

    public int getLength() {
        int result = this.databuffer.position(this.offset).remaining();
        return result;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getRowData() {
        this.databuffer.position(this.offset);
        byte[] data = new byte[this.databuffer.remaining()];
        this.databuffer.get(data);
        return data;
    }

    public void setRowData(byte[] value) {
        if (value == null) {
            return;
        }
        this.databuffer.position(this.offset);
        this.databuffer.put(value);
    }

    public void setRowData(String value) {
        if (value == null) {
            return;
        }
        try {
            this.databuffer.position(this.offset);
            byte[] data = this.getRowData();
            boolean changed = HexUtil.StringtoBytes((String)value, (byte[])data);
            if (changed) {
                this.setRowData(data);
            }
        }
        catch (Exception exception) {}
    }

    public String toString() {
        String string = String.format("%s (%d)-%s", this.address.toString(), this.offset, HexUtil.toHex((byte[])this.getRowData(), (int)0));
        return string;
    }
}

