/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.ChannelReturnMessage;
import com.ca.intertest.tools.DataRequestMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.StatusMessage;
import com.ca.intertest.ui.lister.ListerEditor;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ChannelData
implements ITreeContentProvider {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final Debug debug = Debug.getInstance();
    private debugSession session;
    private ListerEditor editor;
    private ArrayList<TreeObject> channelObjects = null;
    private String[] segchars;
    private MFAddress[] segaddrs;
    private Integer[] seglengths;
    private String channel = "";
    private String saveChannel = "";
    protected final String UniqueKey = Integer.toString(this.hashCode());

    public ChannelData(IResource resource, ListerEditor lsteditor) {
        this.session = debug.getSession((IResource)resource.getProject());
        this.editor = lsteditor;
    }

    public TreeObject[] findObjects(String name) {
        return null;
    }

    public boolean deleteObject(TreeObject treeobject) {
        return false;
    }

    public TreeObject getRootObject(TreeObject item) {
        if (item == null) {
            return null;
        }
        String markerid = item.getAttribute(this.getUniqueKey());
        if (markerid == null || markerid.length() == 0) {
            return this.getRootObject(item.getParent());
        }
        return item;
    }

    public boolean removeObject(TreeObject item) {
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)parentElement;
            return treeobject.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)element;
            if (treeobject.getAttribute(this.UniqueKey) != null) {
                return null;
            }
            return treeobject.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeObject) {
            return ((TreeObject)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.channelObjects == null) {
            return this.sendChannelMemoryMessage();
        }
        return this.channelObjects.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] sendChannelMemoryMessage() {
        this.channelObjects = new ArrayList();
        DataRequestMessage msg = null;
        if (this.session.isAtBreakpoint()) {
            CVMO cvmo = null;
            try {
                CVMI cvmi = new CVMI();
                msg = new DataRequestMessage(4);
                msg.setProgram(decorator.getShortName(this.editor.getResource()));
                msg.setDataLength(0);
                String coreCmd = "CHANNEL";
                msg.setCoreCmd(coreCmd);
                cvmi.addMessage((DebugMessage)msg);
                cvmo = this.session.getTalker().process(cvmi);
                return this.processCVMO(cvmo);
            }
            catch (Exception e) {
                Logger.loggit(e);
                return new TreeObject[0];
            }
        }
        return new TreeObject[0];
    }

    protected Object[] processCVMO(CVMO cvmo) {
        TreeObject treeobject = null;
        this.saveChannel = "";
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 40: {
                    ChannelReturnMessage crmsg = (ChannelReturnMessage)message;
                    this.channel = crmsg.getChannel();
                    if (!this.channel.equals(this.saveChannel)) {
                        if (this.saveChannel.length() > 0) {
                            this.channelObjects.add(treeobject);
                        }
                        treeobject = new TreeObject(this.channel, "1");
                        treeobject.setAttribute("level", "1");
                        treeobject.setAddress(crmsg.getAddress());
                        this.saveChannel = this.channel;
                    }
                    try {
                        treeobject.addChild(this.doAddContainer(crmsg));
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                    break;
                }
                case 18: {
                    StatusMessage smsg = (StatusMessage)message;
                    Shell shell = Display.getDefault().getActiveShell();
                    String text = String.format(Messages.ChannelData_8, smsg.getStatus(), smsg.getMessage());
                    MessageDialog.openWarning((Shell)shell, (String)Messages.ChannelData_9, (String)text);
                    return new TreeObject[0];
                }
            }
            ++n2;
        }
        if (this.saveChannel.length() > 0) {
            this.channelObjects.add(treeobject);
            return this.channelObjects.toArray();
        }
        return new TreeObject[0];
    }

    private TreeObject doAddContainer(ChannelReturnMessage crmsg) throws Exception {
        TreeObject child = new TreeObject(crmsg.getContainer(), "1");
        Object[] objschars = crmsg.getSegChars().toArray();
        Object[] objsaddrs = crmsg.getSegAddrs().toArray();
        Object[] objslths = crmsg.getSegLengths().toArray();
        int len = objschars.length;
        this.segchars = new String[len];
        this.segaddrs = new MFAddress[len];
        this.seglengths = new Integer[len];
        int i = 0;
        while (i < len) {
            this.segchars[i] = objschars[i].toString();
            this.segaddrs[i] = (MFAddress)objsaddrs[i];
            this.seglengths[i] = (Integer)objslths[i];
            ++i;
        }
        child.setAttribute("level", "2");
        int lth = this.seglengths[0];
        int segmentcount = crmsg.getsegmentCount();
        if (segmentcount > 1) {
            int i2 = 1;
            while (i2 < segmentcount) {
                lth += this.seglengths[i2] + 40;
                ++i2;
            }
        }
        String str = crmsg.getCurrFlag() == 0 ? " " : "*";
        child.setAttribute("curr", str);
        child.setAttribute("cpgid", crmsg.getCodePage());
        child.setAttribute("length", String.valueOf(lth));
        child.setAttribute("data", this.segchars[0]);
        child.setAddress(this.segaddrs[0]);
        if (segmentcount > 1) {
            int i3 = 1;
            while (i3 < segmentcount) {
                TreeObject grandChild = new TreeObject(this.segaddrs[i3].getLowString(), "1");
                grandChild.setAttribute("level", "3");
                grandChild.setAttribute("data", this.segchars[i3]);
                grandChild.setAddress(this.segaddrs[i3]);
                child.addChild(grandChild);
                ++i3;
            }
        }
        return child;
    }

    public String getUniqueKey() {
        return this.UniqueKey;
    }

    public void dispose() {
    }
}

