/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.wizards.BreakpointWizard;
import com.ca.intertest.wizards.IBreakpointPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class BreakpointAbstractPage
extends WizardPage
implements IBreakpointPage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected static final String[] constants = IConstants.COBOL_CONSTANTS;
    protected static final String[] keywords = IConstants.CICS_CBP_COREKEYWORDS;
    protected static final String[] literals = IConstants.LITERALS;
    protected static final String[] operators = IConstants.OPERATOR_TEXTS;
    protected static final String[] registers = IConstants.CICS_CBP_REGISTERS;
    protected Map<String, Object> attributes = null;
    protected String mrkrType = null;
    public Button buttonVbp = null;
    protected Group vbpGroup = null;
    protected Label labelVbpArea = null;
    public Combo vbpDataname = null;
    protected Label labelVbpLength = null;
    public Text textVbpLength = null;
    protected Label labelVbpOffset = null;
    public Text textVbpOffset = null;
    public Button buttonCbp = null;
    protected Group cbpGroup = null;
    protected Label labelLeftArea = null;
    protected Label labelOperator = null;
    protected Label labelRightArea = null;
    public Combo leftDataname = null;
    public Combo operator = null;
    public Combo rightDataname = null;
    protected Group groupLeftSide = null;
    protected Group groupRightSide = null;
    protected Group groupOperator = null;
    protected Button buttonLeftVar = null;
    protected Combo comboLeftVar = null;
    protected Button buttonLeftKey = null;
    public Combo comboLeftKey = null;
    protected Label labelLeftLength = null;
    public Text textLeftLength = null;
    protected Label labelLeftOffset = null;
    public Text textLeftOffset = null;
    protected Button buttonRightVar = null;
    protected Combo comboRightVar = null;
    protected Button buttonRightKey = null;
    public Combo comboRightKey = null;
    protected Button buttonRightLiterals = null;
    public Combo comboRightLiterals = null;
    protected Button buttonRightConstants = null;
    public Combo comboRightConstants = null;
    protected Label labelRightLength = null;
    public Text textRightLength = null;
    protected Label labelRightOffset = null;
    public Text textRightOffset = null;
    protected Label labelNewBP = null;
    public Button checkNewBP = null;
    protected Label labelDropMonitor = null;
    public Button checkDropMonitor = null;
    public Button buttonUbp = null;
    protected Group ubpGroup = null;
    protected Label labelUbpArea = null;
    protected Composite pageControl = null;
    protected Button chkStopAfter = null;
    protected Text textSkip = null;
    protected boolean isCICS;
    protected boolean isCOBOL;
    protected String pageTitle;
    protected BreakpointWizard wizard;

    public BreakpointAbstractPage(String pageName) {
        super(pageName);
        this.pageTitle = pageName;
    }

    public String getTitle() {
        return this.pageTitle;
    }

    public BreakpointAbstractPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void setBPWizard(BreakpointWizard breakpointWizard) {
        this.wizard = breakpointWizard;
    }

    @Override
    public void setAttributes(Map<String, Object> attrs) {
        this.attributes = attrs;
    }

    public abstract String getCbpButtonText();

    public abstract String getUbpButtonText();

    public abstract String getUbpPageMessage();

    public abstract String getCbpPageMessage();

    protected Composite createPageControl(Composite parent) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, true);
        this.pageControl = new Composite(parent, 0);
        this.pageControl.setLayout((Layout)new GridLayout(1, true));
        this.pageControl.setLayoutData((Object)gridData);
        this.isCICS = this.wizard.isCICS();
        this.isCOBOL = this.wizard.isCOBOL();
        return this.pageControl;
    }

    protected void createInfoArea() {
        Group stmtGroup = new Group(this.pageControl, 16);
        stmtGroup.setLayout((Layout)new GridLayout(4, false));
        stmtGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        stmtGroup.setText(Messages.BreakpointAbstractPage_0);
        Label labelStmt = new Label((Composite)stmtGroup, 0);
        labelStmt.setLayoutData((Object)new GridData(4, 0, false, false));
        labelStmt.setText(Messages.BreakpointAbstractPage_1);
        Integer stmtNumber = (Integer)this.attributes.get("stmtNumber");
        Label labelStmtNum = new Label((Composite)stmtGroup, 0);
        labelStmtNum.setLayoutData((Object)new GridData(4, 0, false, false));
        if (stmtNumber != null && stmtNumber > 0) {
            labelStmtNum.setText(stmtNumber.toString());
        } else {
            labelStmtNum.setText("0     ");
        }
        String stmt = (String)this.attributes.get("source");
        if (stmt == null) {
            stmt = "";
            this.attributes.put("source", stmt);
        }
        Label labelStmtSource = new Label((Composite)stmtGroup, 1);
        GridData gridData = new GridData(1, 0, true, false, 2, 1);
        gridData.minimumWidth = 300;
        labelStmtSource.setLayoutData((Object)gridData);
        labelStmtSource.setText(stmt);
        Label label = new Label((Composite)stmtGroup, 0x1000008);
        label.setText(Messages.BreakpointAbstractPage_4);
        label.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        String pgmName = this.wizard.getLister().getResource().getName();
        label = new Label((Composite)stmtGroup, 1);
        label.setText(pgmName.substring(0, pgmName.indexOf(".")));
        label = new Label((Composite)stmtGroup, 0x1000008);
        label.setText(Messages.BreakpointAbstractPage_5);
        label.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        String project = this.wizard.getLister().getResource().getProject().getName();
        label = new Label((Composite)stmtGroup, 1);
        label.setText(project);
    }

    protected void createVariableArea() {
        this.buttonVbp = new Button(this.pageControl, 16);
        this.buttonVbp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buttonVbp.setText(Messages.BreakpointAbstractPage_6);
        this.buttonVbp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (BreakpointAbstractPage.this.buttonVbp.isFocusControl()) {
                    BreakpointAbstractPage.this.mrkrType = "com.ca.intertest.breakpoint.watch";
                    BreakpointAbstractPage.this.showVariable();
                    BreakpointAbstractPage.this.wizard.getContainer().updateButtons();
                }
            }
        });
        this.vbpGroup = new Group(this.pageControl, 0);
        this.vbpGroup.setLayout((Layout)new GridLayout(2, false));
        this.vbpGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.labelVbpArea = new Label((Composite)this.vbpGroup, 0);
        this.labelVbpArea.setLayoutData((Object)new GridData(4, 4, false, false));
        this.labelVbpArea.setText(Messages.BreakpointAbstractPage_7);
        this.vbpDataname = new Combo((Composite)this.vbpGroup, 24);
        this.vbpDataname.setLayoutData((Object)new GridData(4, 4, true, false));
        this.vbpDataname.setItems(this.getLeftItems());
        int ix = this.matchItem(this.getLeftItems());
        this.vbpDataname.select(ix);
        if (this.isCICS) {
            Composite cicsGroup = new Composite((Composite)this.vbpGroup, 0);
            cicsGroup.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            cicsGroup.setLayout((Layout)new GridLayout(4, false));
            this.labelVbpLength = new Label(cicsGroup, 0);
            this.labelVbpLength.setLayoutData((Object)new GridData(4, 0, false, false));
            this.labelVbpLength.setText(Messages.BreakpointAbstractPage_8);
            GridData textData = new GridData(4, 0, false, false);
            this.textVbpLength = new Text(cicsGroup, 2048);
            this.textVbpLength.setLayoutData((Object)textData);
            this.textVbpLength.setTextLimit(10);
            textData.widthHint = 65;
            this.labelVbpOffset = new Label(cicsGroup, 0);
            this.labelVbpOffset.setLayoutData((Object)new GridData(4, 0, false, false));
            this.labelVbpOffset.setText(Messages.BreakpointAbstractPage_9);
            textData = new GridData(4, 0, false, false);
            this.textVbpOffset = new Text(cicsGroup, 2048);
            this.textVbpOffset.setLayoutData((Object)textData);
            this.textVbpOffset.setTextLimit(20);
            textData.widthHint = 130;
        }
    }

    protected void createConditionalArea() {
        this.buttonCbp = new Button(this.pageControl, 16);
        this.buttonCbp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buttonCbp.setText(this.getCbpButtonText());
        this.buttonCbp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (BreakpointAbstractPage.this.buttonCbp.isFocusControl()) {
                    BreakpointAbstractPage.this.mrkrType = "com.ca.intertest.breakpoint.conditional";
                    BreakpointAbstractPage.this.showConditional();
                    BreakpointAbstractPage.this.wizard.getContainer().updateButtons();
                }
            }
        });
        if (this.isCICS) {
            this.createCICSConditionalArea();
            return;
        }
        Group cbpGroup = new Group(this.pageControl, 0);
        cbpGroup.setLayout((Layout)new GridLayout(2, false));
        cbpGroup.setLayoutData((Object)new GridData(4, 0, false, false));
        this.labelLeftArea = new Label((Composite)cbpGroup, 0);
        this.labelLeftArea.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelLeftArea.setText(Messages.BreakpointAbstractPage_10);
        this.leftDataname = new Combo((Composite)cbpGroup, 2816);
        this.leftDataname.setLayoutData((Object)new GridData(4, 0, true, false));
        this.leftDataname.setItems(this.getLeftItems());
        int ix = this.matchItem(this.getLeftItems());
        this.leftDataname.select(ix);
        this.labelOperator = new Label((Composite)cbpGroup, 0);
        this.labelOperator.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelOperator.setText(Messages.BreakpointAbstractPage_11);
        this.operator = new Combo((Composite)cbpGroup, 2824);
        this.operator.setLayoutData((Object)new GridData(0, 4, false, false));
        this.operator.setItems(operators);
        this.operator.select(0);
        this.labelRightArea = new Label((Composite)cbpGroup, 0);
        this.labelRightArea.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelRightArea.setText(Messages.BreakpointAbstractPage_12);
        this.rightDataname = new Combo((Composite)cbpGroup, 0);
        this.rightDataname.setLayoutData((Object)new GridData(4, 0, true, false));
        this.rightDataname.setItems(this.getRightItems());
        this.rightDataname.select(0);
    }

    protected void createCICSConditionalArea() {
        this.groupLeftSide = new Group(this.pageControl, 0);
        this.groupLeftSide.setLayout((Layout)new GridLayout(2, false));
        this.groupLeftSide.setLayoutData((Object)new GridData(0, 0, false, false));
        this.groupLeftSide.setText(Messages.BreakpointAbstractPage_13);
        Composite leftListGroup = new Composite((Composite)this.groupLeftSide, 0);
        leftListGroup.setLayout((Layout)new GridLayout(2, false));
        leftListGroup.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonLeftVar = new Button(leftListGroup, 16);
        this.buttonLeftVar.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonLeftVar.setText(Messages.BreakpointAbstractPage_14);
        this.comboLeftVar = new Combo(leftListGroup, 2048);
        this.comboLeftVar.setLayoutData((Object)new GridData(0, 0, false, false));
        this.comboLeftVar.setItems(this.getSortedVariables());
        this.comboLeftVar.select(0);
        this.comboLeftVar.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BreakpointAbstractPage.this.buttonLeftVar.setSelection(true);
                BreakpointAbstractPage.this.buttonLeftKey.setSelection(false);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.buttonLeftKey = new Button(leftListGroup, 16);
        this.buttonLeftKey.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonLeftKey.setText(Messages.BreakpointAbstractPage_15);
        this.comboLeftKey = new Combo(leftListGroup, 2056);
        this.comboLeftKey.setLayoutData((Object)new GridData(4, 0, false, false));
        ArrayList<String> keyItems = new ArrayList<String>();
        this.addCoreKeywords(keyItems);
        this.addRegisters(keyItems);
        String[] strItems = new String[keyItems.size()];
        keyItems.toArray(strItems);
        this.comboLeftKey.setItems(strItems);
        this.comboLeftKey.select(0);
        this.comboLeftKey.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BreakpointAbstractPage.this.buttonLeftVar.setSelection(false);
                BreakpointAbstractPage.this.buttonLeftKey.setSelection(true);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Composite leftOptsGroup = new Composite((Composite)this.groupLeftSide, 0);
        leftOptsGroup.setLayout((Layout)new GridLayout(2, false));
        leftOptsGroup.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelLeftLength = new Label(leftOptsGroup, 0);
        this.labelLeftLength.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelLeftLength.setText(Messages.BreakpointAbstractPage_16);
        GridData textData = new GridData(0, 0, false, false);
        this.textLeftLength = new Text(leftOptsGroup, 2048);
        this.textLeftLength.setLayoutData((Object)textData);
        this.textLeftLength.setTextLimit(10);
        textData.widthHint = 60;
        this.labelLeftOffset = new Label(leftOptsGroup, 0);
        this.labelLeftOffset.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelLeftOffset.setText(Messages.BreakpointAbstractPage_17);
        textData = new GridData(0, 0, false, false);
        this.textLeftOffset = new Text(leftOptsGroup, 2048);
        this.textLeftOffset.setLayoutData((Object)textData);
        this.textLeftOffset.setTextLimit(10);
        textData.widthHint = 60;
        Composite operComp = new Composite(this.pageControl, 0);
        operComp.setLayoutData((Object)new GridData(0, 0, false, false));
        operComp.setLayout((Layout)new GridLayout(2, true));
        this.groupOperator = new Group(operComp, 0);
        this.groupOperator.setLayoutData((Object)new GridData(0, 0, false, false));
        this.groupOperator.setLayout((Layout)new GridLayout(1, true));
        this.groupOperator.setText(Messages.BreakpointAbstractPage_18);
        this.operator = new Combo((Composite)this.groupOperator, 2056);
        this.operator.setLayoutData((Object)new GridData(0, 0, false, false));
        this.operator.setItems(operators);
        this.operator.select(0);
        this.groupRightSide = new Group(this.pageControl, 0);
        this.groupRightSide.setLayout((Layout)new GridLayout(2, false));
        this.groupRightSide.setLayoutData((Object)new GridData(0, 0, false, false));
        this.groupRightSide.setText(Messages.BreakpointAbstractPage_19);
        Composite rightListGroup = new Composite((Composite)this.groupRightSide, 0);
        rightListGroup.setLayout((Layout)new GridLayout(2, false));
        rightListGroup.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightVar = new Button(rightListGroup, 16);
        this.buttonRightVar.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightVar.setText(Messages.BreakpointAbstractPage_20);
        this.buttonRightVar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BreakpointAbstractPage.this.labelRightLength.setEnabled(true);
                BreakpointAbstractPage.this.textRightLength.setEnabled(true);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(true);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(true);
            }
        });
        this.comboRightVar = new Combo(rightListGroup, 2048);
        this.comboRightVar.setLayoutData((Object)new GridData(0, 0, false, false));
        this.comboRightVar.setItems(this.getSortedVariables());
        this.comboRightVar.select(0);
        this.comboRightVar.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BreakpointAbstractPage.this.buttonRightVar.setSelection(true);
                BreakpointAbstractPage.this.buttonRightKey.setSelection(false);
                BreakpointAbstractPage.this.buttonRightLiterals.setSelection(false);
                BreakpointAbstractPage.this.buttonRightConstants.setSelection(false);
                BreakpointAbstractPage.this.labelRightLength.setEnabled(true);
                BreakpointAbstractPage.this.textRightLength.setEnabled(true);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(true);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.buttonRightKey = new Button(rightListGroup, 16);
        this.buttonRightKey.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightKey.setText(Messages.BreakpointAbstractPage_21);
        this.buttonRightKey.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BreakpointAbstractPage.this.labelRightLength.setEnabled(true);
                BreakpointAbstractPage.this.textRightLength.setEnabled(true);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(true);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(true);
            }
        });
        this.comboRightKey = new Combo(rightListGroup, 2056);
        this.comboRightKey.setLayoutData((Object)new GridData(4, 0, false, false));
        keyItems = new ArrayList();
        this.addCoreKeywords(keyItems);
        this.addRegisters(keyItems);
        strItems = new String[keyItems.size()];
        keyItems.toArray(strItems);
        this.comboRightKey.setItems(strItems);
        this.comboRightKey.select(0);
        this.comboRightKey.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BreakpointAbstractPage.this.buttonRightVar.setSelection(false);
                BreakpointAbstractPage.this.buttonRightKey.setSelection(true);
                BreakpointAbstractPage.this.buttonRightLiterals.setSelection(false);
                BreakpointAbstractPage.this.buttonRightConstants.setSelection(false);
                BreakpointAbstractPage.this.labelRightLength.setEnabled(true);
                BreakpointAbstractPage.this.textRightLength.setEnabled(true);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(true);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.buttonRightLiterals = new Button(rightListGroup, 16);
        this.buttonRightLiterals.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightLiterals.setText(Messages.BreakpointAbstractPage_22);
        this.buttonRightLiterals.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BreakpointAbstractPage.this.labelRightLength.setEnabled(false);
                BreakpointAbstractPage.this.textRightLength.setEnabled(false);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(false);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(false);
            }
        });
        this.comboRightLiterals = new Combo(rightListGroup, 2048);
        this.comboRightLiterals.setLayoutData((Object)new GridData(4, 0, false, false));
        this.comboRightLiterals.setItems(literals);
        this.comboRightLiterals.select(0);
        this.comboRightLiterals.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BreakpointAbstractPage.this.buttonRightVar.setSelection(false);
                BreakpointAbstractPage.this.buttonRightKey.setSelection(false);
                BreakpointAbstractPage.this.buttonRightLiterals.setSelection(true);
                BreakpointAbstractPage.this.buttonRightConstants.setSelection(false);
                BreakpointAbstractPage.this.labelRightLength.setEnabled(false);
                BreakpointAbstractPage.this.textRightLength.setEnabled(false);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(false);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(false);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.buttonRightConstants = new Button(rightListGroup, 16);
        this.buttonRightConstants.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightConstants.setText(Messages.BreakpointAbstractPage_23);
        this.buttonRightConstants.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BreakpointAbstractPage.this.labelRightLength.setEnabled(false);
                BreakpointAbstractPage.this.textRightLength.setEnabled(false);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(false);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(false);
            }
        });
        this.comboRightConstants = new Combo(rightListGroup, 2056);
        this.comboRightConstants.setLayoutData((Object)new GridData(4, 0, false, false));
        this.comboRightConstants.setItems(constants);
        this.comboRightConstants.select(0);
        this.comboRightConstants.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BreakpointAbstractPage.this.buttonRightVar.setSelection(false);
                BreakpointAbstractPage.this.buttonRightKey.setSelection(false);
                BreakpointAbstractPage.this.buttonRightLiterals.setSelection(false);
                BreakpointAbstractPage.this.buttonRightConstants.setSelection(true);
                BreakpointAbstractPage.this.labelRightLength.setEnabled(false);
                BreakpointAbstractPage.this.textRightLength.setEnabled(false);
                BreakpointAbstractPage.this.labelRightOffset.setEnabled(false);
                BreakpointAbstractPage.this.textRightOffset.setEnabled(false);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Composite rightOptsGroup = new Composite((Composite)this.groupRightSide, 0);
        rightOptsGroup.setLayout((Layout)new GridLayout(2, false));
        rightOptsGroup.setLayoutData((Object)new GridData(0, 0, false, false));
        Label space = new Label(rightOptsGroup, 0);
        space.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.labelRightLength = new Label(rightOptsGroup, 0);
        this.labelRightLength.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelRightLength.setText(Messages.BreakpointAbstractPage_24);
        textData = new GridData(0, 0, false, false);
        this.textRightLength = new Text(rightOptsGroup, 2048);
        this.textRightLength.setLayoutData((Object)textData);
        this.textRightLength.setTextLimit(10);
        textData.widthHint = 60;
        this.labelRightOffset = new Label(rightOptsGroup, 0);
        this.labelRightOffset.setLayoutData((Object)new GridData(0, 0, false, false));
        this.labelRightOffset.setText(Messages.BreakpointAbstractPage_25);
        textData = new GridData(0, 0, false, false);
        this.textRightOffset = new Text(rightOptsGroup, 2048);
        this.textRightOffset.setLayoutData((Object)textData);
        this.textRightOffset.setTextLimit(10);
        textData.widthHint = 60;
        this.buttonLeftVar.setSelection(true);
        this.buttonRightLiterals.setSelection(true);
        this.labelRightLength.setEnabled(false);
        this.textRightLength.setEnabled(false);
        this.labelRightOffset.setEnabled(false);
        this.textRightOffset.setEnabled(false);
    }

    protected void createUnconditionalArea() {
        this.buttonUbp = new Button(this.pageControl, 16);
        this.buttonUbp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.buttonUbp.setText(this.getUbpButtonText());
        this.buttonUbp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (BreakpointAbstractPage.this.buttonUbp.isFocusControl()) {
                    BreakpointAbstractPage.this.mrkrType = "com.ca.intertest.breakpoint.unconditional";
                    BreakpointAbstractPage.this.showUnconditional();
                    BreakpointAbstractPage.this.wizard.getContainer().updateButtons();
                }
            }
        });
    }

    protected void createOptionsArea() {
        Group optGroup = new Group(this.pageControl, 0);
        optGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        optGroup.setLayout((Layout)new GridLayout(2, false));
        optGroup.setText(Messages.BreakpointAbstractPage_26);
        Composite optEdits = new Composite((Composite)optGroup, 0);
        optEdits.setLayoutData((Object)new GridData(4, 0, true, false));
        optEdits.setLayout((Layout)new GridLayout(2, false));
        Label labelSkip = new Label(optEdits, 0);
        labelSkip.setLayoutData((Object)new GridData(0, 0, false, false));
        labelSkip.setText(Messages.BreakpointAbstractPage_27);
        GridData gridData = new GridData(0, 0, false, false);
        gridData.widthHint = 100;
        this.textSkip = new Text(optEdits, 2048);
        this.textSkip.setLayoutData((Object)gridData);
        this.textSkip.setTextLimit(8);
        this.textSkip.setText("0");
        Composite optChecks = new Composite((Composite)optGroup, 0);
        optChecks.setLayoutData((Object)new GridData(4, 0, true, false));
        optChecks.setLayout((Layout)new GridLayout(2, false));
        Label labelChkStopAfter = new Label(optChecks, 0);
        labelChkStopAfter.setLayoutData((Object)new GridData(0, 0, false, false));
        labelChkStopAfter.setText(Messages.BreakpointAbstractPage_29);
        this.chkStopAfter = new Button(optChecks, 32);
        this.chkStopAfter.setLayoutData((Object)new GridData(0, 0, false, false));
        this.chkStopAfter.setSelection(false);
        if (this.isCICS) {
            this.labelDropMonitor = new Label(optChecks, 0);
            this.labelDropMonitor.setLayoutData((Object)new GridData(4, 0, false, false));
            this.labelDropMonitor.setText(Messages.BreakpointAbstractPage_30);
            this.checkDropMonitor = new Button(optChecks, 32);
            this.checkDropMonitor.setLayoutData((Object)new GridData(4, 0, false, false));
            this.checkDropMonitor.setSelection(false);
        }
    }

    protected void createControlFinish() {
        this.setControl((Control)this.pageControl);
        if (this.wizard.canPreLoad()) {
            this.preLoadPage();
        }
    }

    protected void createBlankLine() {
        Label space = new Label(this.pageControl, 0);
        space.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    protected void showVariable() {
        if (this.labelLeftArea != null) {
            this.labelLeftArea.setEnabled(false);
            this.leftDataname.setEnabled(false);
            this.labelOperator.setEnabled(false);
            this.operator.setEnabled(false);
            this.labelRightArea.setEnabled(false);
            this.rightDataname.setEnabled(false);
        }
        if (this.labelVbpLength != null) {
            this.labelVbpLength.setEnabled(true);
            this.textVbpLength.setEnabled(true);
            this.labelVbpOffset.setEnabled(true);
            this.textVbpOffset.setEnabled(true);
        }
        if (this.labelUbpArea != null) {
            this.labelUbpArea.setEnabled(false);
        }
        if (this.labelVbpArea != null) {
            this.labelVbpArea.setEnabled(true);
            this.vbpDataname.setEnabled(true);
        }
        if (this.textLeftLength != null) {
            this.groupLeftSide.setEnabled(false);
            this.buttonLeftVar.setEnabled(false);
            this.comboLeftVar.setEnabled(false);
            this.buttonLeftKey.setEnabled(false);
            this.comboLeftKey.setEnabled(false);
            this.labelLeftLength.setEnabled(false);
            this.textLeftLength.setEnabled(false);
            this.labelLeftOffset.setEnabled(false);
            this.textLeftOffset.setEnabled(false);
            this.groupOperator.setEnabled(false);
            this.operator.setEnabled(false);
            this.groupRightSide.setEnabled(false);
            this.buttonRightVar.setEnabled(false);
            this.comboRightVar.setEnabled(false);
            this.buttonRightKey.setEnabled(false);
            this.comboRightKey.setEnabled(false);
            this.buttonRightLiterals.setEnabled(false);
            this.comboRightLiterals.setEnabled(false);
            this.buttonRightConstants.setEnabled(false);
            this.labelRightLength.setEnabled(false);
            this.textRightLength.setEnabled(false);
            this.labelRightOffset.setEnabled(false);
            this.textRightOffset.setEnabled(false);
            this.comboRightConstants.setEnabled(false);
            this.labelDropMonitor.setEnabled(true);
            this.checkDropMonitor.setEnabled(true);
        }
        this.setMessage(Messages.BreakpointAbstractPage_31);
        this.setErrorMessage(null);
    }

    protected void showConditional() {
        if (this.labelLeftArea != null) {
            this.labelLeftArea.setEnabled(true);
            this.leftDataname.setEnabled(true);
            this.labelOperator.setEnabled(true);
            this.operator.setEnabled(true);
            this.labelRightArea.setEnabled(true);
            this.rightDataname.setEnabled(true);
        }
        if (this.labelUbpArea != null) {
            this.labelUbpArea.setEnabled(false);
        }
        if (this.labelVbpArea != null) {
            this.labelVbpArea.setEnabled(false);
            this.vbpDataname.setEnabled(false);
        }
        if (this.labelVbpLength != null) {
            this.labelVbpLength.setEnabled(false);
            this.textVbpLength.setEnabled(false);
            this.labelVbpOffset.setEnabled(false);
            this.textVbpOffset.setEnabled(false);
        }
        if (this.textLeftLength != null) {
            this.groupLeftSide.setEnabled(true);
            this.buttonLeftVar.setEnabled(true);
            this.comboLeftVar.setEnabled(true);
            this.buttonLeftKey.setEnabled(true);
            this.comboLeftKey.setEnabled(true);
            this.labelLeftLength.setEnabled(true);
            this.textLeftLength.setEnabled(true);
            this.labelLeftOffset.setEnabled(true);
            this.textLeftOffset.setEnabled(true);
            this.groupOperator.setEnabled(true);
            this.operator.setEnabled(true);
            this.groupRightSide.setEnabled(true);
            this.buttonRightVar.setEnabled(true);
            this.comboRightVar.setEnabled(true);
            this.buttonRightKey.setEnabled(true);
            this.comboRightKey.setEnabled(true);
            this.buttonRightLiterals.setEnabled(true);
            this.comboRightLiterals.setEnabled(true);
            this.buttonRightConstants.setEnabled(true);
            this.comboRightConstants.setEnabled(true);
            if (this.buttonRightVar.getSelection() || this.buttonRightKey.getSelection()) {
                this.labelRightLength.setEnabled(true);
                this.textRightLength.setEnabled(true);
                this.labelRightOffset.setEnabled(true);
                this.textRightOffset.setEnabled(true);
            }
            this.labelDropMonitor.setEnabled(true);
            this.checkDropMonitor.setEnabled(true);
        }
        this.setMessage(this.getCbpPageMessage());
        this.setErrorMessage(null);
    }

    protected void showUnconditional() {
        if (this.labelLeftArea != null) {
            this.labelLeftArea.setEnabled(false);
            this.leftDataname.setEnabled(false);
            this.labelOperator.setEnabled(false);
            this.operator.setEnabled(false);
            this.labelRightArea.setEnabled(false);
            this.rightDataname.setEnabled(false);
        }
        if (this.labelUbpArea != null) {
            this.labelUbpArea.setEnabled(true);
        }
        if (this.labelVbpArea != null) {
            this.labelVbpArea.setEnabled(false);
            this.vbpDataname.setEnabled(false);
        }
        if (this.labelVbpLength != null) {
            this.labelVbpLength.setEnabled(false);
            this.textVbpLength.setEnabled(false);
            this.labelVbpOffset.setEnabled(false);
            this.textVbpOffset.setEnabled(false);
        }
        if (this.textLeftLength != null) {
            this.groupLeftSide.setEnabled(false);
            this.buttonLeftVar.setEnabled(false);
            this.comboLeftVar.setEnabled(false);
            this.buttonLeftKey.setEnabled(false);
            this.comboLeftKey.setEnabled(false);
            this.labelLeftLength.setEnabled(false);
            this.textLeftLength.setEnabled(false);
            this.labelLeftOffset.setEnabled(false);
            this.textLeftOffset.setEnabled(false);
            this.groupOperator.setEnabled(false);
            this.operator.setEnabled(false);
            this.groupRightSide.setEnabled(false);
            this.buttonRightVar.setEnabled(false);
            this.comboRightVar.setEnabled(false);
            this.buttonRightKey.setEnabled(false);
            this.comboRightKey.setEnabled(false);
            this.buttonRightLiterals.setEnabled(false);
            this.comboRightLiterals.setEnabled(false);
            this.buttonRightConstants.setEnabled(false);
            this.comboRightConstants.setEnabled(false);
            this.labelRightLength.setEnabled(false);
            this.textRightLength.setEnabled(false);
            this.labelRightOffset.setEnabled(false);
            this.textRightOffset.setEnabled(false);
            this.labelDropMonitor.setEnabled(false);
            this.checkDropMonitor.setEnabled(false);
        }
        this.setMessage(this.getUbpPageMessage());
        this.setErrorMessage(null);
    }

    @Override
    public String getMarkerType() {
        return this.mrkrType;
    }

    protected void preLoadPage() {
        try {
            if (this.wizard.getMarker() != null) {
                this.mrkrType = this.wizard.getMarker().getType();
            } else {
                this.mrkrType = (String)this.attributes.get("markerType");
                if (this.mrkrType == null || this.mrkrType.length() <= 0) {
                    this.mrkrType = "com.ca.intertest.breakpoint.unconditional";
                }
            }
            if (this.mrkrType.equals("com.ca.intertest.breakpoint.unconditional")) {
                this.showUnconditional();
                this.buttonUbp.setSelection(true);
                this.preLoadOptions();
                return;
            }
            if (this.mrkrType.equals("com.ca.intertest.breakpoint.watch")) {
                String off;
                String varName = (String)this.attributes.get("left_variable");
                this.vbpDataname.select(this.vbpDataname.indexOf(varName));
                Integer len = (Integer)this.attributes.get("left_length_override");
                if (len != null && len > 0) {
                    this.textVbpLength.setText(len.toString());
                }
                if ((off = (String)this.attributes.get("left_offset")) != null && off.length() > 0) {
                    this.textVbpOffset.setText(off);
                }
                this.showVariable();
                this.buttonVbp.setSelection(true);
                this.preLoadOptions();
                return;
            }
            if (this.mrkrType.equals("com.ca.intertest.breakpoint.conditional")) {
                if (this.isCICS) {
                    this.preLoadCICSCbpPage();
                    return;
                }
                String dataName = (String)this.attributes.get("left_variable");
                int ix = this.getSelectionIndex(this.leftDataname, dataName);
                if (ix >= 0) {
                    this.leftDataname.select(ix);
                } else {
                    this.leftDataname.setText(dataName);
                }
                Integer oper = (Integer)this.attributes.get("operator");
                this.operator.select(oper - 1);
                dataName = (String)this.attributes.get("right_variable");
                ix = this.getSelectionIndex(this.rightDataname, dataName);
                if (ix >= 0) {
                    this.rightDataname.select(this.rightDataname.indexOf(dataName));
                } else {
                    String[] temp = this.rightDataname.getItems();
                    String[] newlist = new String[temp.length + 1];
                    newlist[0] = dataName;
                    int i = 1;
                    while (i < newlist.length) {
                        newlist[i] = temp[i - 1];
                        ++i;
                    }
                    this.rightDataname.setItems(newlist);
                    this.rightDataname.select(0);
                }
                this.showConditional();
                this.buttonCbp.setSelection(true);
                this.preLoadOptions();
                return;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    protected void preLoadOptions() {
        Boolean stop = (Boolean)this.attributes.get("stop_after");
        if (stop != null) {
            this.chkStopAfter.setSelection(stop.booleanValue());
        }
        Integer skip = (Integer)this.attributes.get("skip_count");
        this.textSkip.setText(skip.toString());
    }

    protected void preLoadCICSCbpPage() {
        Boolean drop;
        String rightOffset;
        String leftOff;
        String leftVar = (String)this.attributes.get("left_variable");
        Byte b = 1;
        Integer leftType = (Integer)this.attributes.get("left_type");
        if (leftType == null) {
            leftType = new Integer(1);
        }
        if (leftType.byteValue() == 1) {
            this.buttonLeftVar.setSelection(true);
            this.buttonLeftKey.setSelection(false);
            this.comboLeftVar.select(this.comboLeftVar.indexOf(leftVar));
        } else {
            this.buttonLeftVar.setSelection(false);
            this.buttonLeftKey.setSelection(true);
            this.comboLeftKey.select(this.comboLeftKey.indexOf(leftVar));
        }
        Integer leftLen = (Integer)this.attributes.get("left_length_override");
        if (leftLen != null && leftLen > 0) {
            this.textLeftLength.setText(leftLen.toString());
        }
        if ((leftOff = (String)this.attributes.get("left_offset")) != null && leftOff.length() > 0) {
            this.textLeftOffset.setText(leftOff);
        }
        Integer oper = (Integer)this.attributes.get("operator");
        this.operator.select(oper - 1);
        String rightVar = (String)this.attributes.get("right_variable");
        Integer rightType = (Integer)this.attributes.get("right_type");
        if (rightType == null) {
            rightType = new Integer(1);
        }
        b = rightType.byteValue();
        block0 : switch (b) {
            case 1: {
                this.buttonRightVar.setSelection(true);
                this.buttonRightKey.setSelection(false);
                this.buttonRightLiterals.setSelection(false);
                this.buttonRightConstants.setSelection(false);
                this.comboRightVar.select(this.comboRightVar.indexOf(rightVar));
                this.labelRightLength.setEnabled(true);
                this.textRightLength.setEnabled(true);
                this.labelRightOffset.setEnabled(true);
                this.textRightOffset.setEnabled(true);
                break;
            }
            case 2: {
                this.buttonRightVar.setSelection(false);
                this.buttonRightKey.setSelection(true);
                this.buttonRightLiterals.setSelection(false);
                this.buttonRightConstants.setSelection(false);
                this.comboRightKey.select(this.comboRightKey.indexOf(rightVar));
                break;
            }
            case 8: {
                this.buttonRightVar.setSelection(false);
                this.buttonRightKey.setSelection(false);
                this.buttonRightLiterals.setSelection(false);
                this.buttonRightConstants.setSelection(true);
                this.comboRightConstants.select(this.comboRightConstants.indexOf(rightVar));
                break;
            }
            default: {
                this.buttonRightVar.setSelection(false);
                this.buttonRightKey.setSelection(false);
                this.buttonRightLiterals.setSelection(true);
                this.buttonRightConstants.setSelection(false);
                String prefix = rightVar.substring(0, 1);
                int i = 0;
                while (i < IConstants.LITERALS.length) {
                    if (IConstants.LITERALS[i].substring(0, 1).equals(prefix)) {
                        this.comboRightLiterals.setItem(i, rightVar);
                        this.comboRightLiterals.select(i);
                        break block0;
                    }
                    ++i;
                }
                break block0;
            }
        }
        Integer rightLen = (Integer)this.attributes.get("right_length_override");
        if (rightLen != null && rightLen > 0) {
            this.textRightLength.setText(rightLen.toString());
        }
        if ((rightOffset = (String)this.attributes.get("right_offset")) != null && rightOffset.length() > 0) {
            this.textRightOffset.setText(rightOffset);
        }
        if ((drop = (Boolean)this.attributes.get("drop_monitoring")) != null) {
            this.checkDropMonitor.setSelection(drop.booleanValue());
        }
        this.buttonCbp.setSelection(true);
        this.showConditional();
        this.preLoadOptions();
    }

    protected String[] getLeftItems() {
        ArrayList<String> itemsList = new ArrayList<String>();
        this.addSortedVariables(itemsList);
        if (this.isCICS) {
            this.addCoreKeywords(itemsList);
            this.addRegisters(itemsList);
        }
        String[] items = new String[itemsList.size()];
        itemsList.toArray(items);
        return items;
    }

    protected String[] getRightItems() {
        ArrayList<String> itemsList = new ArrayList<String>();
        if (this.isCICS) {
            this.addLiterals(itemsList);
            this.addCoreKeywords(itemsList);
            this.addRegisters(itemsList);
        } else {
            if (itemsList.isEmpty()) {
                itemsList.add(Messages.BreakpointAbstractPage_32);
            }
            String[] stringArray = IConstants.COBOL_CONSTANTS;
            int n = IConstants.COBOL_CONSTANTS.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                itemsList.add(str);
                ++n2;
            }
            itemsList.add("X'hex'");
        }
        String[] items = new String[itemsList.size()];
        itemsList.toArray(items);
        return items;
    }

    protected int getSelectionIndex(Combo combo, String variable) {
        String upper = null;
        int ix = combo.indexOf(variable);
        if (ix >= 0) {
            return ix;
        }
        upper = variable.toUpperCase();
        ix = combo.indexOf(upper);
        return ix;
    }

    protected int matchItem(String[] items) {
        int ix = 0;
        String source = (String)this.attributes.get("source");
        if (source == null) {
            return ix;
        }
        String var = null;
        String[] parts = source.split(" ");
        HashMap<String, ArrayList<TreeObject>> names = this.wizard.getDataNames();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (names.containsKey(part)) {
                var = part;
                break;
            }
            ++n2;
        }
        if (var != null) {
            int i = 0;
            while (i < items.length) {
                if (var.endsWith(items[i])) {
                    ix = i;
                    break;
                }
                ++i;
            }
        }
        return ix;
    }

    protected Integer getVariableLength(String variable) {
        String var = variable;
        ArrayList<TreeObject> treeList = this.wizard.getDataNames().get(var);
        if (treeList == null) {
            var = var.toUpperCase();
            treeList = this.wizard.getDataNames().get(var);
            if (treeList == null) {
                return 0;
            }
        }
        TreeObject to = treeList.get(0);
        return (Integer)Attribute.getValue("length", to);
    }

    protected Integer getLiteralType(String literal) {
        Integer type = -1;
        if (!this.isLiteral(literal)) {
            return type;
        }
        String prefix = literal.substring(0, 1);
        int i = 0;
        while (i < IConstants.LITERALS.length) {
            if (IConstants.LITERALS[i].substring(0, 1).equals(prefix)) {
                type = IConstants.LITERAL_TYPES[i];
                break;
            }
            ++i;
        }
        return type;
    }

    protected Integer getLiteralImpliedLength(String literal) {
        Integer len = 0;
        Integer type = 0;
        type = this.getLiteralType(literal);
        switch (type) {
            case 3: {
                String lit = this.getLiteralString(literal);
                len = lit.length();
                break;
            }
            case 4: {
                String lit = this.getLiteralString(literal);
                len = lit.length() / 2;
                break;
            }
            case 5: {
                String lit = this.getLiteralString(literal);
                if (lit.length() == 1) {
                    len = 1;
                    break;
                }
                int length = lit.length();
                len = length / 2 + 1;
                break;
            }
            case 6: {
                len = 2;
                break;
            }
            case 7: {
                len = 4;
                break;
            }
        }
        return len;
    }

    protected Integer getLiteralLength(String literal) {
        Integer len = -1;
        if (!this.isLiteral(literal)) {
            return len;
        }
        String[] subs = literal.split("'");
        len = subs[1].length();
        return len;
    }

    protected String getLiteralString(String literal) {
        String[] parts = literal.split("'");
        return parts[1];
    }

    @Override
    public Integer getSkipCount() {
        Integer count = new Integer(this.textSkip.getText());
        if (count >= 0) {
            return count;
        }
        return 0;
    }

    @Override
    public boolean getStopAfter() {
        return this.chkStopAfter.getSelection();
    }

    @Override
    public boolean getDropMonitoring() {
        return this.checkDropMonitor.getSelection();
    }

    public boolean getNewBP() {
        return this.checkNewBP.getSelection();
    }

    protected void setRightLiteralAttributes(String literal) {
        this.attributes.put("right_type", this.getLiteralType(literal));
        this.attributes.put("right_variable", literal);
        int literalLen = this.getLiteralImpliedLength(literal);
        this.attributes.put("right_value_len", literalLen);
        this.attributes.put("left_value_len", literalLen);
    }

    protected String[] getSortedVariables() {
        HashMap<String, ArrayList<TreeObject>> dataNames = this.wizard.getDataNames();
        ArrayList<String> itemsList = new ArrayList<String>();
        String[] dataArray = new String[dataNames.size()];
        dataNames.keySet().toArray(dataArray);
        int i = 0;
        while (i < dataArray.length) {
            int toType = dataNames.get(dataArray[i]).get(0).getType();
            if (toType == 1) {
                // empty if block
            }
            itemsList.add(dataArray[i]);
            ++i;
        }
        Collections.sort(itemsList);
        String[] items = new String[itemsList.size()];
        return itemsList.toArray(items);
    }

    protected void addSortedVariables(ArrayList<String> items) {
        HashMap<String, ArrayList<TreeObject>> dataNames = this.wizard.getDataNames();
        String[] dataArray = new String[dataNames.size()];
        dataNames.keySet().toArray(dataArray);
        int i = 0;
        while (i < dataArray.length) {
            int toType = dataNames.get(dataArray[i]).get(0).getType();
            if (toType == 1) {
                // empty if block
            }
            items.add(dataArray[i]);
            ++i;
        }
        Collections.sort(items);
    }

    protected void addCoreKeywords(ArrayList<String> items) {
        int i = 0;
        while (i < keywords.length) {
            items.add(keywords[i]);
            ++i;
        }
    }

    protected void addRegisters(ArrayList<String> items) {
        int j = 0;
        while (j < registers.length) {
            items.add(registers[j]);
            ++j;
        }
    }

    protected void addLiterals(ArrayList<String> items) {
        int i = 0;
        while (i < literals.length) {
            items.add(literals[i]);
            ++i;
        }
    }

    protected void addConstants(ArrayList<String> items) {
        int i = 0;
        while (i < constants.length) {
            items.add(constants[i]);
            ++i;
        }
    }

    @Override
    public boolean canFinish() {
        if (this.buttonUbp != null && this.buttonUbp.getSelection()) {
            return this.isUbpComplete();
        }
        if (this.buttonVbp != null && this.buttonVbp.getSelection()) {
            return this.isVbpComplete();
        }
        if (this.isCICS) {
            return this.isCICSPageComplete();
        }
        return this.isBatchPageComplete();
    }

    protected boolean isVariable(String variable) {
        boolean isVariable = false;
        String var = variable;
        ArrayList<TreeObject> treeList = this.wizard.getDataNames().get(var);
        if (treeList == null) {
            var = var.toUpperCase();
            treeList = this.wizard.getDataNames().get(var);
            isVariable = treeList != null;
        } else {
            isVariable = true;
        }
        return isVariable;
    }

    protected boolean isKeyword(String keyword) {
        boolean isKeyword = false;
        int i = 0;
        while (i < keywords.length) {
            if (keyword.equals(keywords[i])) {
                isKeyword = true;
                break;
            }
            ++i;
        }
        return isKeyword;
    }

    protected boolean isRegister(String reg) {
        boolean isRegister = false;
        int i = 0;
        while (i < registers.length) {
            if (reg.equals(registers[i])) {
                isRegister = true;
                break;
            }
            ++i;
        }
        return isRegister;
    }

    protected boolean isLiteral(String literal) {
        boolean isLiteral = false;
        int i = 0;
        while (i < literals.length) {
            if (literals[i].substring(0, 2).toUpperCase().equals(literal.substring(0, 2).toUpperCase())) {
                if (!literal.endsWith("'")) break;
                isLiteral = true;
                break;
            }
            ++i;
        }
        return isLiteral;
    }

    protected boolean isValidLiteral(String literal) {
        boolean isValid = true;
        literal = literal.toUpperCase();
        Pattern p = null;
        Matcher m = null;
        String[] parts = literal.split("'");
        String num = parts[1];
        byte type = this.getLiteralType(literal).byteValue();
        switch (type) {
            case 4: {
                p = Pattern.compile("[0-9A-F]+");
                m = p.matcher(num);
                isValid = m.matches();
                if (!isValid) {
                    this.setErrorMessage(Messages.BreakpointAbstractPage_39);
                    break;
                }
                if (num.length() % 2 == 0) break;
                isValid = false;
                this.setErrorMessage(Messages.BreakpointAbstractPage_40);
                break;
            }
            case 5: {
                p = Pattern.compile("[\\-0-9A-F]*[0-9A-F]+");
                m = p.matcher(num);
                isValid = m.matches();
                if (isValid) break;
                this.setErrorMessage(Messages.BreakpointAbstractPage_42);
                break;
            }
            case 6: {
                Integer hw = null;
                try {
                    hw = Integer.parseInt(num);
                    if (hw < 32768) break;
                    isValid = false;
                    this.setErrorMessage(Messages.BreakpointAbstractPage_43);
                }
                catch (NumberFormatException numberFormatException) {
                    isValid = false;
                    this.setErrorMessage(Messages.BreakpointAbstractPage_44);
                }
                break;
            }
            case 7: {
                Integer fw = null;
                try {
                    fw = Integer.parseInt(num);
                    if (fw > Integer.MIN_VALUE && fw < Integer.MAX_VALUE) {
                        isValid = true;
                        break;
                    }
                    isValid = false;
                    this.setErrorMessage(Messages.BreakpointAbstractPage_45);
                }
                catch (NumberFormatException numberFormatException) {
                    isValid = false;
                    this.setErrorMessage(Messages.BreakpointAbstractPage_46);
                }
                break;
            }
        }
        return isValid;
    }

    protected boolean isConstant(String constant) {
        boolean isConstant = false;
        int i = 0;
        while (i < constants.length) {
            if (constant.equals(constants[i])) {
                isConstant = true;
                break;
            }
            ++i;
        }
        return isConstant;
    }

    protected boolean isOffset(String offset) {
        return true;
    }

    protected boolean isCICSPageComplete() {
        this.setErrorMessage(null);
        int ix = 0;
        String leftSide = null;
        String leftLength = null;
        String leftOffset = null;
        String rightSide = null;
        String rightLength = null;
        String rightOffset = null;
        boolean bLeftSide = false;
        if (this.buttonLeftVar.getSelection()) {
            ix = this.comboLeftVar.getSelectionIndex();
            leftSide = ix >= 0 ? this.comboLeftVar.getItem(ix) : this.comboLeftVar.getText();
            if (this.isVariable(leftSide)) {
                bLeftSide = true;
                this.attributes.put("left_variable", leftSide);
                this.attributes.put("left_type", new Integer(1));
                this.attributes.put("left_value_len", this.getVariableLength(leftSide));
            } else {
                bLeftSide = false;
                this.setErrorMessage(Messages.BreakpointAbstractPage_47);
            }
        }
        if (this.buttonLeftKey.getSelection()) {
            ix = this.comboLeftKey.getSelectionIndex();
            leftSide = ix >= 0 ? this.comboLeftKey.getItem(ix) : this.comboLeftKey.getText();
            if (this.isKeyword(leftSide) || this.isRegister(leftSide)) {
                bLeftSide = true;
                this.attributes.put("left_variable", leftSide);
                this.attributes.put("left_type", new Integer(2));
                this.attributes.put("left_value_len", 1);
            } else {
                bLeftSide = false;
                this.setErrorMessage(Messages.BreakpointAbstractPage_48);
            }
        }
        boolean bLeftLength = true;
        leftLength = this.textLeftLength.getText();
        if (leftLength != null && leftLength.length() > 0) {
            try {
                Integer len = Integer.valueOf(leftLength);
                bLeftLength = true;
                this.attributes.put("left_length_override", len);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.BreakpointAbstractPage_49);
                bLeftLength = false;
            }
        }
        boolean bLeftOffset = true;
        leftOffset = this.textLeftOffset.getText();
        if (leftOffset != null && leftOffset.length() > 0) {
            if (this.isOffset(leftOffset)) {
                bLeftOffset = true;
                this.attributes.put("left_offset", leftOffset);
            } else {
                bLeftOffset = false;
                this.setErrorMessage(Messages.BreakpointAbstractPage_50);
            }
        }
        Integer oper = this.operator.getSelectionIndex();
        this.attributes.put("operator", oper + 1);
        boolean bRightSide = false;
        if (this.buttonRightVar.getSelection()) {
            ix = this.comboRightVar.getSelectionIndex();
            rightSide = ix >= 0 ? this.comboRightVar.getItem(ix) : this.comboRightVar.getText();
            if (this.isVariable(rightSide)) {
                bRightSide = true;
                this.attributes.put("right_variable", rightSide);
                this.attributes.put("right_type", new Integer(1));
                this.attributes.put("right_value_len", this.getVariableLength(rightSide));
            } else {
                bRightSide = false;
                this.setErrorMessage(Messages.BreakpointAbstractPage_51);
            }
        }
        if (this.buttonRightKey.getSelection()) {
            ix = this.comboRightKey.getSelectionIndex();
            rightSide = ix >= 0 ? this.comboRightKey.getItem(ix) : this.comboRightKey.getText();
            if (this.isKeyword(rightSide) || this.isRegister(rightSide)) {
                bRightSide = true;
                this.attributes.put("right_variable", rightSide);
                this.attributes.put("right_type", new Integer(2));
                this.attributes.put("right_value_len", 1);
            } else {
                bRightSide = false;
                this.setErrorMessage(Messages.BreakpointAbstractPage_52);
            }
        }
        if (this.buttonRightLiterals.getSelection()) {
            ix = this.comboRightLiterals.getSelectionIndex();
            rightSide = ix >= 0 ? this.comboRightLiterals.getItem(ix) : this.comboRightLiterals.getText();
            String prefix = rightSide.substring(0, 1);
            if (prefix.equals("X") || prefix.equals("x")) {
                rightSide = rightSide.toUpperCase();
            }
            if (this.isLiteral(rightSide) && this.isValidLiteral(rightSide)) {
                bRightSide = true;
                this.setRightLiteralAttributes(rightSide);
            } else {
                bRightSide = false;
            }
        }
        if (this.buttonRightConstants.getSelection()) {
            ix = this.comboRightConstants.getSelectionIndex();
            rightSide = ix >= 0 ? this.comboRightConstants.getItem(ix) : this.comboRightConstants.getText();
            if (this.isConstant(rightSide)) {
                bRightSide = true;
                this.attributes.put("right_variable", rightSide);
                this.attributes.put("right_type", new Integer(8));
            } else {
                bRightSide = false;
            }
        }
        boolean bRightLength = true;
        rightLength = this.textRightLength.getText();
        if (rightLength != null && rightLength.length() > 0) {
            try {
                Integer len = Integer.valueOf(rightLength);
                bRightLength = true;
                this.attributes.put("right_length_override", len);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.BreakpointAbstractPage_55);
                bRightLength = false;
            }
        }
        boolean bRightOffset = true;
        rightOffset = this.textRightOffset.getText();
        if (rightOffset != null && rightOffset.length() > 0) {
            if (this.isOffset(rightOffset)) {
                bRightOffset = true;
                this.attributes.put("right_offset", rightOffset);
            } else {
                bRightOffset = false;
                this.setErrorMessage(Messages.BreakpointAbstractPage_56);
            }
        }
        return bLeftSide && bRightSide && bLeftLength && bLeftOffset && bRightLength && bRightOffset;
    }

    protected boolean isBatchPageComplete() {
        boolean bLeft = false;
        String left = null;
        int ix = this.leftDataname.getSelectionIndex();
        left = ix >= 0 ? this.leftDataname.getItem(ix) : this.leftDataname.getText();
        if (this.isVariable(left)) {
            bLeft = true;
            this.attributes.put("left_variable", left);
            this.attributes.put("left_type", new Integer(1));
            this.attributes.put("left_value_len", this.getVariableLength(left));
        } else {
            bLeft = false;
        }
        Integer oper = this.operator.getSelectionIndex();
        this.attributes.put("operator", oper + 1);
        String rightSide = null;
        boolean bRight = false;
        ix = this.rightDataname.getSelectionIndex();
        rightSide = ix >= 0 ? this.rightDataname.getItem(ix) : this.rightDataname.getText();
        if (this.isVariable(rightSide)) {
            bRight = true;
            this.attributes.put("right_variable", rightSide);
            this.attributes.put("right_type", new Integer(1));
            this.attributes.put("right_value_len", this.getVariableLength(rightSide));
        } else if (this.isConstant(rightSide)) {
            bRight = true;
            this.attributes.put("right_variable", rightSide);
            this.attributes.put("right_type", new Integer(8));
            this.attributes.put("right_value_len", rightSide.length());
        } else {
            bRight = true;
            this.attributes.put("right_variable", rightSide);
            if (this.isLiteral(rightSide)) {
                this.attributes.put("right_type", this.getLiteralType(rightSide));
            } else {
                this.attributes.put("right_type", new Integer(3));
            }
            this.attributes.put("right_value_len", rightSide.length());
        }
        return bLeft && bRight;
    }

    protected boolean isUbpComplete() {
        return true;
    }

    protected boolean isVbpComplete() {
        String var = null;
        boolean bVar = false;
        int ix = this.vbpDataname.getSelectionIndex();
        var = ix >= 0 ? this.vbpDataname.getItem(ix) : this.vbpDataname.getText();
        if (this.isVariable(var)) {
            bVar = true;
            this.attributes.put("left_variable", var);
            this.attributes.put("left_type", (byte)1);
            this.attributes.put("left_value_len", var.length());
        }
        boolean bLen = true;
        boolean bOff = true;
        if (this.isCICS) {
            bLen = true;
            String len = this.textVbpLength.getText();
            if (len != null && len.length() > 0) {
                try {
                    Integer iLen = Integer.valueOf(len);
                    bLen = true;
                    this.attributes.put("right_length_override", iLen);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.BreakpointAbstractPage_57);
                    bLen = false;
                }
            }
            bOff = true;
            String off = null;
            off = this.textVbpOffset.getText();
            if (off != null && off.length() > 0) {
                if (this.isOffset(off)) {
                    bOff = true;
                    this.attributes.put("right_offset", off);
                } else {
                    bOff = false;
                    this.setErrorMessage(Messages.BreakpointAbstractPage_58);
                }
            }
        }
        return bVar && bLen && bOff;
    }
}

