/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.verifyDSN;
import com.ca.intertest.common.verifyPDS;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugMarkerGroup;
import com.ca.intertest.dialogs.ConvertJCL;
import com.ca.intertest.dialogs.EditBatchJCL;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.dialogs.MRUCombo;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.wizards.AbstractSettingsPage;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BatchSettingsPage
extends AbstractSettingsPage {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected static final String UNSET_NDVR = Messages.BatchSettingsPage_0;
    protected static final String SET_NDVR = Messages.BatchSettingsPage_1;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.batchSettingsPage";
    private Group protsymGroup;
    private ArrayList<String> protsymList;
    private List protsymListbox;
    private Text protsymEndevor;
    private Button protsymAdd;
    private Button protsymEdit;
    private Button protsymDelete;
    private Button protsymSet;
    private Button convertJCL;
    private Text jclDataset;
    private Text jclStep;
    private Combo jclType;
    private Text jclSubDataset;
    private Button editJCL;
    private Button forceASM;
    private Button notifyEOJ;
    private Button count;
    private Button trace;
    private Button datamonitor;
    private Text proclibList;
    protected Button pl1;
    private Composite dsscomp;
    private CTabFolder folder;
    private CTabItem JCLtab;
    private CTabItem maintab;
    private CTabItem protsymtab;
    Button[] rbpbuttons;
    private String[] dsnTypeLabels = new String[]{Messages.FileTypePDS, Messages.FileTypePanvalet, Messages.FileTypeLibrarian};
    private debugMarkerGroup markerGroup;

    public BatchSettingsPage(String pageName) {
        super(pageName);
    }

    public BatchSettingsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createProtsymGroup(Composite parent) {
        this.protsymGroup = new Group(parent, 0);
        this.protsymGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.protsymGroup.setLayout((Layout)new GridLayout(1, false));
        this.protsymGroup.setText(Messages.BatchSettingsPage_3);
        this.protsymListbox = new List((Composite)this.protsymGroup, 2816);
        GridData gridData = new GridData(4, 4, true, true, 2, 0);
        this.protsymListbox.setLayoutData((Object)gridData);
        this.protsymListbox.setToolTipText(Messages.BatchSettingsPage_4);
        String protsymStore = this.wizard.get("protsym_list");
        this.protsymList = new ArrayList();
        if (protsymStore.length() > 0) {
            String[] list;
            String[] stringArray = list = protsymStore.split("[;]+");
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if ((item = item.trim()).length() > 0) {
                    this.protsymList.add(item);
                }
                ++n2;
            }
        }
        Object[] protsymarray = this.protsymList.toArray(new String[this.protsymList.size()]);
        Arrays.sort(protsymarray);
        this.protsymListbox.setItems((String[])protsymarray);
        this.protsymListbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int ix = BatchSettingsPage.this.protsymListbox.getSelectionIndex();
                if (ix < 0) {
                    return;
                }
                String dsn = BatchSettingsPage.this.protsymListbox.getItem(ix);
                if (dsn.equals(BatchSettingsPage.this.protsymEndevor.getText())) {
                    BatchSettingsPage.this.protsymSet.setText(UNSET_NDVR);
                } else {
                    BatchSettingsPage.this.protsymSet.setText(SET_NDVR);
                }
            }
        });
        this.protsymListbox.addSelectionListener(this.selectionlistener);
        this.protsymListbox.addFocusListener(this.focuslistener);
        this.dsscomp = new Composite((Composite)this.protsymGroup, 0);
        this.dsscomp.setLayoutData((Object)new GridData(16384, 16384, true, false));
        this.dsscomp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.dsscomp, 0);
        label.setText(Messages.BatchSettingsPage_6);
        this.protsymEndevor = new Text(this.dsscomp, 8);
        this.protsymEndevor.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.protsymEndevor.setText(this.wizard.get("protsymEndevor").trim());
        GridData data = new GridData(16384, 0, true, false);
        data.horizontalIndent = 10;
        data.horizontalSpan = 2;
        this.forceASM = new Button(this.dsscomp, 32);
        this.forceASM.setLayoutData((Object)data);
        this.forceASM.setText(Messages.BatchSettingsPage_7);
        this.forceASM.setToolTipText(Messages.BatchSettingsPage_7);
        this.forceASM.setSelection(Boolean.parseBoolean(this.wizard.get("settingsForceASM")));
        this.forceASM.addSelectionListener(this.selectionlistener);
        this.forceASM.setEnabled(this.protsymEndevor.getText().length() > 0);
        Composite comp = new Composite((Composite)this.protsymGroup, 0);
        comp.setLayout((Layout)new GridLayout(5, false));
        this.protsymAdd = new Button(comp, 8);
        this.protsymAdd.setLayoutData((Object)new GridData(4, 0, true, false));
        this.protsymAdd.setText(Messages.BatchSettingsPage_9);
        this.protsymAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String dsn;
                BatchSettingsDialog input = new BatchSettingsDialog(BatchSettingsPage.this.getShell(), Messages.BatchSettingsPage_10, null);
                if (input.open() == 0 && (dsn = input.getDSN().trim()).length() > 0 && BatchSettingsPage.this.protsymList.indexOf(dsn) == -1) {
                    BatchSettingsPage.this.protsymList.add(dsn);
                    Object[] protsymarray = BatchSettingsPage.this.protsymList.toArray(new String[BatchSettingsPage.this.protsymList.size()]);
                    Arrays.sort(protsymarray);
                    BatchSettingsPage.this.protsymListbox.setItems((String[])protsymarray);
                    BatchSettingsPage.this.protsymListbox.select(BatchSettingsPage.this.protsymListbox.indexOf(dsn));
                    BatchSettingsPage.this.protsymListbox.redraw();
                    BatchSettingsPage.this.handleEvent(new Event());
                }
            }
        });
        this.protsymAdd.addFocusListener(this.focuslistener);
        this.protsymEdit = new Button(comp, 8);
        this.protsymEdit.setLayoutData((Object)new GridData(4, 0, true, false));
        this.protsymEdit.setText(Messages.BatchSettingsPage_11);
        this.protsymEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int ix = BatchSettingsPage.this.protsymListbox.getSelectionIndex();
                if (ix < 0) {
                    MessageDialog.openInformation((Shell)BatchSettingsPage.this.getShell(), (String)BatchSettingsPage.this.getWizard().getWindowTitle(), (String)Messages.BatchSettingsPage_12);
                    return;
                }
                String dsn = BatchSettingsPage.this.protsymListbox.getItem(ix);
                BatchSettingsDialog input = new BatchSettingsDialog(BatchSettingsPage.this.getShell(), Messages.BatchSettingsPage_13, dsn);
                if (input.open() == 0) {
                    dsn = input.getDSN();
                    BatchSettingsPage.this.protsymListbox.setItem(ix, dsn.toUpperCase());
                    BatchSettingsPage.this.handleEvent(new Event());
                }
            }
        });
        this.protsymEdit.addFocusListener(this.focuslistener);
        this.protsymDelete = new Button(comp, 8);
        this.protsymDelete.setLayoutData((Object)new GridData(4, 0, true, false));
        this.protsymDelete.setText(Messages.BatchSettingsPage_14);
        this.protsymDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int ix = BatchSettingsPage.this.protsymListbox.getSelectionIndex();
                if (ix < 0) {
                    MessageDialog.openInformation((Shell)BatchSettingsPage.this.getShell(), (String)BatchSettingsPage.this.getWizard().getWindowTitle(), (String)Messages.BatchSettingsPage_15);
                    return;
                }
                String dsn = BatchSettingsPage.this.protsymListbox.getItem(ix);
                boolean ok = MessageDialog.openConfirm((Shell)BatchSettingsPage.this.getShell(), (String)BatchSettingsPage.this.getWizard().getWindowTitle(), (String)(String.valueOf(Messages.BatchSettingsPage_16) + dsn));
                if (ok) {
                    String endv = BatchSettingsPage.this.protsymEndevor.getText();
                    if (endv.equals(dsn)) {
                        BatchSettingsPage.this.protsymEndevor.setText("");
                    }
                    BatchSettingsPage.this.protsymEndevor.setSize(BatchSettingsPage.this.protsymEndevor.computeSize(-1, -1));
                    BatchSettingsPage.this.protsymListbox.remove(ix);
                    BatchSettingsPage.this.protsymListbox.redraw();
                    BatchSettingsPage.this.handleEvent(new Event());
                }
            }
        });
        this.protsymDelete.addFocusListener(this.focuslistener);
        Button protsymPopulate = new Button(comp, 8);
        protsymPopulate.setLayoutData((Object)new GridData(4, 0, true, false));
        protsymPopulate.setText(Messages.BatchSettingsPage_18);
        protsymPopulate.setToolTipText(Messages.BatchSettingsPage_19);
        protsymPopulate.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList<debugFile> files = BatchSettingsPage.this.wizard.getSession().getMonitored(true);
                for (debugFile item : files) {
                    String file = item.getStore().getString("dsn");
                    if (file == null || (file = file.trim()).length() <= 0 || BatchSettingsPage.this.protsymList.contains(file)) continue;
                    BatchSettingsPage.this.protsymList.add(file);
                }
                Object[] protsymarray = BatchSettingsPage.this.protsymList.toArray(new String[BatchSettingsPage.this.protsymList.size()]);
                Arrays.sort(protsymarray);
                BatchSettingsPage.this.protsymListbox.setItems((String[])protsymarray);
                BatchSettingsPage.this.setPageComplete(BatchSettingsPage.this.validatePage());
                BatchSettingsPage.this.protsymListbox.redraw();
                BatchSettingsPage.this.handleEvent(new Event());
            }
        });
        this.protsymSet = new Button(comp, 8);
        this.protsymSet.setLayoutData((Object)new GridData(4, 0, true, false));
        this.protsymSet.setText(SET_NDVR);
        this.protsymSet.setToolTipText(Messages.BatchSettingsPage_20);
        this.protsymSet.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int ix = BatchSettingsPage.this.protsymListbox.getSelectionIndex();
                if (ix < 0) {
                    MessageDialog.openInformation((Shell)BatchSettingsPage.this.getShell(), (String)BatchSettingsPage.this.getWizard().getWindowTitle(), (String)Messages.BatchSettingsPage_21);
                    return;
                }
                if (BatchSettingsPage.this.protsymSet.getText().equals(SET_NDVR)) {
                    BatchSettingsPage.this.protsymEndevor.setText(BatchSettingsPage.this.protsymListbox.getItem(ix));
                    BatchSettingsPage.this.protsymSet.setText(UNSET_NDVR);
                } else {
                    BatchSettingsPage.this.protsymEndevor.setText("");
                    BatchSettingsPage.this.protsymSet.setText(SET_NDVR);
                }
                BatchSettingsPage.this.protsymEndevor.setTextLimit(44);
                BatchSettingsPage.this.protsymEndevor.setSize(BatchSettingsPage.this.protsymEndevor.computeSize(-1, -1));
                BatchSettingsPage.this.dsscomp.setSize(BatchSettingsPage.this.dsscomp.computeSize(-1, -1));
                BatchSettingsPage.this.setPageComplete(BatchSettingsPage.this.validatePage());
                BatchSettingsPage.this.handleEvent(new Event());
                BatchSettingsPage.this.changed = true;
            }
        });
        this.protsymSet.addFocusListener(this.focuslistener);
    }

    @Override
    protected void createCICSServerList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(0, 0));
        label.setText(Messages.BatchSettingsPage_23);
    }

    @Override
    public void saveSetupGroup() {
        this.wizard.put("protsym_list", this.buildProtsymList());
        this.wizard.put("protsymEndevor", this.protsymEndevor.getText());
        this.wizard.put("settingsBatchDSN", this.jclDataset.getText());
        this.wizard.put("settingsBatchStep", this.jclStep.getText());
        this.wizard.put("proclib_list", this.proclibList.getText());
        this.wizard.put("settingsConvertDSN", this.jclSubDataset.getText());
        this.wizard.put("settingsEditConverted", Boolean.toString(this.editJCL.getSelection()));
        int index = this.jclType.getSelectionIndex();
        String result = null;
        if (index >= 0) {
            String sel = this.jclType.getItem(index);
            Byte type = IConstants.FileTypes.get(sel);
            result = type.toString();
        }
        this.wizard.put("settingsDSNType", result);
        this.wizard.put("settingsNotifyEOJ", Boolean.toString(this.notifyEOJ.getSelection()));
        if (this.count != null) {
            this.wizard.put("execution_count", Boolean.toString(this.count.getSelection()));
        }
        this.wizard.put("back_trace", Boolean.toString(this.trace.getSelection()));
        this.wizard.put("data_monitor", Boolean.toString(this.datamonitor.getSelection()));
        this.wizard.put("PL/I", Boolean.toString(this.pl1.getSelection()));
        this.wizard.put("settingsForceASM", Boolean.toString(this.forceASM.getSelection()));
        this.markerGroup.cleanEnable();
        this.markerGroup.checkChanged();
        this.markerGroup.save();
    }

    private String buildProtsymList() {
        Object[] protsymItems = this.protsymListbox.getItems();
        Arrays.sort(protsymItems);
        String protsyms = "";
        Object lastelement = "";
        Object[] objectArray = protsymItems;
        int n = protsymItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (((String)(element = ((String)element).trim())).length() > 0 && !((String)element).equals(lastelement)) {
                protsyms = String.valueOf(protsyms) + (String)element + ";";
                lastelement = element;
            }
            ++n2;
        }
        return protsyms;
    }

    private void enableConvGroup(boolean enable) {
        this.jclStep.setEnabled(enable);
        this.jclType.setEnabled(enable);
        this.proclibList.setEnabled(enable);
        if (enable) {
            boolean goodtogo;
            boolean bl = goodtogo = this.serverCombo.getSelectionIndex() >= 0;
            if (goodtogo) {
                goodtogo = this.jclSubDataset.getText().length() > 0;
            }
            this.convertJCL.setEnabled(goodtogo);
        } else {
            this.convertJCL.setEnabled(enable);
        }
    }

    private void enableSubmitGroup(boolean enable) {
        if (enable) {
            this.editJCL.setEnabled(this.serverCombo.getSelectionIndex() >= 0);
        } else {
            this.editJCL.setEnabled(enable);
        }
    }

    @Override
    protected boolean validatePage() {
        if (this.protsymtab.equals(this.folder.getSelection())) {
            this.dsscomp.setVisible(this.protsymEndevor.getText().length() > 0);
            this.forceASM.setEnabled(this.protsymEndevor.getText().length() > 0);
            if (this.protsymListbox.getSelectionIndex() < 0) {
                int[] nArray = new int[3];
                nArray[0] = 1;
                nArray[2] = 2;
                int[] nArray2 = nArray;
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray2[n2];
                    this.setMessage(null, i);
                    ++n2;
                }
                if (this.protsymListbox.getItems().length > 0) {
                    this.setMessage(Messages.BatchSettingsPage_27, 1);
                }
                this.protsymEdit.setEnabled(false);
                this.protsymDelete.setEnabled(false);
                this.protsymSet.setEnabled(false);
                return this.changed;
            }
            this.protsymEdit.setEnabled(true);
            this.protsymDelete.setEnabled(true);
            this.protsymSet.setEnabled(true);
        }
        if (this.JCLtab.equals(this.folder.getSelection())) {
            if (this.jclDataset.getText().length() == 0) {
                this.enableConvGroup(false);
                this.setErrorMessage(null);
                this.setMessage(Messages.BatchSettingsPage_28, 1);
                return this.changed;
            }
            this.enableConvGroup(true);
            if (this.jclSubDataset.getText().length() == 0) {
                this.setErrorMessage(null);
                this.enableSubmitGroup(false);
                this.setMessage(Messages.BatchSettingsPage_29, 1);
                return this.changed;
            }
            if (this.jclSubDataset.getText().length() == 0) {
                this.enableSubmitGroup(false);
                String message = Messages.BatchSettingsPage_30;
                this.setErrorMessage(null);
                this.setMessage(message, 1);
            } else {
                this.enableSubmitGroup(true);
            }
        }
        return super.validatePage();
    }

    @Override
    protected void setOptionalButtons(Composite composite) {
        String format = Messages.BatchSettingsPage_44;
        String rbpTooltip = Messages.BatchSettingsPage_45;
        this.markerGroup = this.wizard.getMarkergroup();
        IDebugMarker[] iDebugMarkerArray = this.markerGroup.getChildren();
        int n = iDebugMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugMarker item = iDebugMarkerArray[n2];
            Button button = new Button(composite, 32);
            button.setText(String.format(format, item.toString()));
            button.setToolTipText(String.format(rbpTooltip, item.toString()));
            button.setSelection(item.isEnabled());
            button.setData((Object)item);
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.widget;
                    IDebugMarker marker = (IDebugMarker)button.getData();
                    marker.setEnabled(button.getSelection());
                    BatchSettingsPage.this.changed = true;
                    BatchSettingsPage.this.wizard.getContainer().updateButtons();
                }
            });
            ++n2;
        }
        this.pl1 = new Button(composite, 16416);
        this.pl1.setText("Session will debug PL/I");
        this.pl1.setSelection(Boolean.parseBoolean(this.wizard.get("PL/I")));
        this.pl1.addSelectionListener(this.selectionlistener);
        this.count = new Button(composite, 32);
        this.count.setText(Messages.BatchSettingsPage_46);
        this.count.setToolTipText(Messages.BatchSettingsPage_47);
        String countValue = this.wizard.get("execution_count");
        if (countValue.length() == 0) {
            this.count.setSelection(false);
        } else {
            this.count.setSelection(Boolean.parseBoolean(countValue));
        }
        this.count.addSelectionListener(this.selectionlistener);
        this.trace = new Button(composite, 32);
        this.trace.setText(Messages.BatchSettingsPage_48);
        this.trace.setToolTipText(Messages.BatchSettingsPage_49);
        String value = this.wizard.get("back_trace");
        if (value.length() == 0) {
            this.trace.setSelection(false);
        } else {
            this.trace.setSelection(Boolean.parseBoolean(value));
        }
        this.trace.addSelectionListener(this.selectionlistener);
        GC gc = new GC((Drawable)this.trace);
        Point size = this.trace.computeSize(-1, -1);
        this.trace.setSize(size);
        Point textsize = gc.textExtent(this.trace.getText());
        this.datamonitor = new Button(composite, 32);
        GridData data = new GridData(256, 0, true, false);
        data = new GridData(256, 0, true, false);
        data.horizontalIndent = (int)((double)(size.x - textsize.x) * 0.9);
        this.datamonitor.setLayoutData((Object)data);
        this.datamonitor.setText(Messages.BatchSettingsPage_50);
        this.datamonitor.setToolTipText(Messages.BatchSettingsPage_51);
        value = this.wizard.get("data_monitor");
        if (value.length() == 0) {
            this.datamonitor.setSelection(false);
        } else {
            this.datamonitor.setSelection(Boolean.parseBoolean(value));
        }
        this.datamonitor.addSelectionListener(this.selectionlistener);
        this.datamonitor.setVisible(false);
        this.notifyEOJ = new Button(composite, 32);
        this.notifyEOJ.setLayoutData((Object)new GridData(256, 0, true, false));
        this.notifyEOJ.setText(Messages.BatchSettingsPage_52);
        value = this.wizard.get("settingsNotifyEOJ");
        if (value.length() == 0) {
            this.notifyEOJ.setSelection(true);
        } else {
            this.notifyEOJ.setSelection(Boolean.parseBoolean(value));
        }
        this.notifyEOJ.setToolTipText(Messages.BatchSettingsPage_53);
        this.notifyEOJ.addSelectionListener(this.selectionlistener);
    }

    @Override
    protected boolean isBatch() {
        return true;
    }

    @Override
    protected boolean isCICS() {
        return false;
    }

    @Override
    protected void createSettings(Composite composite) {
    }

    public void createControl(Composite parent) {
        Composite composite = this.startCreateControl(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 1;
        this.folder = new CTabFolder(composite, 2180);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, false));
        this.folder.setSimple(false);
        this.folder.setToolTipText(Messages.BatchSettingsPage_54);
        this.folder.setSingle(false);
        this.folder.setUnselectedImageVisible(true);
        this.folder.setUnselectedCloseVisible(false);
        this.folder.setMinimizeVisible(false);
        this.folder.setMaximizeVisible(false);
        this.folder.addSelectionListener(this.selectionlistener);
        this.maintab = new CTabItem(this.folder, 0);
        this.maintab.setToolTipText(Messages.BatchSettingsPage_55);
        this.maintab.setText(Messages.BatchSettingsPage_56);
        Composite pagecomposite = new Composite((Composite)this.folder, 0);
        gridLayout = new GridLayout(2, true);
        pagecomposite.setLayout((Layout)gridLayout);
        this.maintab.setControl((Control)pagecomposite);
        this.createSettings(pagecomposite);
        this.setOptions(pagecomposite);
        this.protsymtab = new CTabItem(this.folder, 0);
        this.protsymtab.setToolTipText(Messages.BatchSettingsPage_57);
        this.protsymtab.setText(Messages.BatchSettingsPage_58);
        pagecomposite = new Composite((Composite)this.folder, 0);
        gridLayout = new GridLayout(1, true);
        pagecomposite.setLayout((Layout)gridLayout);
        this.protsymtab.setControl((Control)pagecomposite);
        this.createProtsymGroup(pagecomposite);
        this.JCLtab = new CTabItem(this.folder, 0);
        this.JCLtab.setText(Messages.BatchSettingsPage_59);
        this.JCLtab.setToolTipText(Messages.BatchSettingsPage_60);
        pagecomposite = new Composite((Composite)this.folder, 0);
        gridLayout = new GridLayout(2, false);
        pagecomposite.setLayout((Layout)gridLayout);
        this.JCLtab.setControl((Control)pagecomposite);
        this.creatJCLGroup(pagecomposite);
        this.folder.setSelection(0);
        this.endCreateControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.batchSettingsPage");
    }

    private void creatJCLGroup(Composite pagecomposite) {
        Byte type;
        Label label = new Label(pagecomposite, 0);
        label.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        label.setText(Messages.BatchSettingsPage_61);
        this.convertJCL = new Button(pagecomposite, 8);
        this.convertJCL.setText(Messages.BatchSettingsPage_62);
        this.convertJCL.setToolTipText(Messages.BatchSettingsPage_63);
        this.convertJCL.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        this.convertJCL.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = BatchSettingsPage.this.jclType.getSelectionIndex();
                String result = null;
                if (index >= 0) {
                    String sel = BatchSettingsPage.this.jclType.getItem(index);
                    Byte type = IConstants.FileTypes.get(sel);
                    result = type.toString();
                }
                ConvertJCL convert = new ConvertJCL(BatchSettingsPage.this.getSelectedServer(), BatchSettingsPage.this.jclDataset.getText(), BatchSettingsPage.this.jclStep.getText(), BatchSettingsPage.this.proclibList.getText(), Byte.parseByte(result), BatchSettingsPage.this.jclSubDataset.getText());
                convert.process();
                if (convert.getStatus() != 0) {
                    BatchSettingsPage.this.setErrorMessage(convert.getErrorText());
                } else {
                    String value = convert.getBatchDSN();
                    if (!value.equals(BatchSettingsPage.this.jclDataset.getText())) {
                        BatchSettingsPage.this.jclDataset.setText(value);
                        BatchSettingsPage.this.changed = true;
                    }
                    if (!(value = convert.getBatchStep()).equals(BatchSettingsPage.this.jclStep.getText())) {
                        BatchSettingsPage.this.jclStep.setText(value);
                        BatchSettingsPage.this.changed = true;
                    }
                    boolean readonly = false;
                    if (convert.getTargetfile().getFiletype() == 4) {
                        readonly = !BatchSettingsPage.this.wizard.isSubmit();
                    }
                    BatchSettingsPage.this.editJCL(readonly);
                    BatchSettingsPage.this.getContainer().updateButtons();
                }
            }
        });
        this.jclDataset = new Text(pagecomposite, 2048);
        this.jclDataset.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.jclDataset.setText(this.wizard.get("settingsBatchDSN"));
        this.jclDataset.addVerifyListener((VerifyListener)new verifyPDS());
        this.jclDataset.addSelectionListener(this.selectionlistener);
        this.jclDataset.addFocusListener(this.focuslistener);
        this.jclDataset.addModifyListener(this.modifylistener);
        this.jclDataset.setToolTipText(Messages.BatchSettingsPage_64);
        label = new Label(pagecomposite, 0);
        label.setLayoutData((Object)new GridData(131072, 0, false, false));
        label.setText(Messages.BatchSettingsPage_65);
        this.jclType = new Combo(pagecomposite, 2060);
        this.jclType.setLayoutData((Object)new GridData(16384, 0, true, false));
        this.jclType.setItems(this.dsnTypeLabels);
        this.jclType.setToolTipText(Messages.BatchSettingsPage_66);
        try {
            type = Byte.valueOf(this.wizard.get("settingsDSNType"));
        }
        catch (NumberFormatException numberFormatException) {
            type = new Byte(1);
        }
        String name = IConstants.FileTypesNames.get(type);
        int i = 0;
        while (i < this.dsnTypeLabels.length) {
            if (this.dsnTypeLabels[i].equals(name)) {
                this.jclType.select(i);
                break;
            }
            ++i;
        }
        this.jclType.addSelectionListener(this.selectionlistener);
        this.jclType.addFocusListener(this.focuslistener);
        label = new Label(pagecomposite, 0);
        label.setLayoutData((Object)new GridData(131072, 0, false, false));
        label.setText(Messages.BatchSettingsPage_67);
        this.jclStep = new Text(pagecomposite, 2048);
        this.jclStep.setLayoutData((Object)new GridData(4, 0, true, false));
        this.jclStep.setText(this.wizard.get("settingsBatchStep"));
        this.jclStep.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.jclStep.addSelectionListener(this.selectionlistener);
        this.jclStep.addFocusListener(this.focuslistener);
        this.jclStep.addModifyListener(this.modifylistener);
        this.jclStep.setToolTipText(Messages.BatchSettingsPage_68);
        label = new Label(pagecomposite, 0);
        label.setLayoutData((Object)new GridData(131072, 0, false, false));
        label.setText(Messages.BatchSettingsPage_69);
        this.proclibList = new Text(pagecomposite, 2048);
        this.proclibList.setLayoutData((Object)new GridData(4, 0, true, false));
        this.proclibList.setText(this.wizard.get("proclib_list"));
        this.proclibList.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.proclibList.addSelectionListener(this.selectionlistener);
        this.proclibList.addFocusListener(this.focuslistener);
        this.proclibList.addModifyListener(this.modifylistener);
        this.proclibList.setToolTipText(Messages.BatchSettingsPage_70);
        label = new Label(pagecomposite, 0);
        label.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        label.setText(Messages.BatchSettingsPage_71);
        this.editJCL = new Button(pagecomposite, 8);
        this.editJCL.setText(Messages.BatchSettingsPage_72);
        this.editJCL.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        this.editJCL.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BatchSettingsPage.this.editJCL(false);
            }
        });
        this.jclSubDataset = new Text(pagecomposite, 2048);
        this.jclSubDataset.setToolTipText(Messages.BatchSettingsPage_73);
        this.jclSubDataset.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.jclSubDataset.setText(this.wizard.get("settingsConvertDSN"));
        this.jclSubDataset.addVerifyListener((VerifyListener)new verifyPDS());
        this.jclSubDataset.addSelectionListener(this.selectionlistener);
        this.jclSubDataset.addFocusListener(this.focuslistener);
        this.jclSubDataset.addModifyListener(this.modifylistener);
        this.enableConvGroup(this.jclDataset.getText().length() > 0);
    }

    public boolean isPageComplete() {
        return this.validatePage() ? this.changed : false;
    }

    @Override
    public boolean canSubmit() {
        return this.validateSubmit();
    }

    @Override
    protected boolean validateSubmit() {
        if (this.jclSubDataset.getText().length() == 0) {
            String message = Messages.BatchSettingsPage_74;
            this.setErrorMessage(message);
            return false;
        }
        if (super.validateSubmit()) {
            if (!this.trace.getSelection()) {
                boolean found = false;
                for (debugFile file : this.session.getMonitored(true)) {
                    if (!file.isDataMonitor()) continue;
                    found = true;
                    break;
                }
                if (found) {
                    String msg = Messages.BatchSettingsPage_75;
                    this.setMessage(msg, 2);
                }
            }
            return true;
        }
        return false;
    }

    private void editJCL(boolean readonly) {
        EditBatchJCL editjcl = new EditBatchJCL(this.getSelectedServer(), new FileName(1, this.jclSubDataset.getText()));
        editjcl.setReadonly(readonly);
        editjcl.process();
        if (editjcl.getStatus() != 0) {
            this.setErrorMessage(editjcl.getErrorText());
        } else {
            this.getContainer().updateButtons();
        }
    }

    private FileServer getSelectedServer() {
        int index = this.serverCombo.getSelectionIndex();
        if (index >= 0) {
            return (FileServer)this.serverList.get(index);
        }
        return null;
    }

    class BatchSettingsDialog
    extends IntertestDialog {
        String title;
        String dsn;
        MRUCombo protsym;
        Text errText;

        protected BatchSettingsDialog(Shell shell, String title, String initial) {
            super(shell);
            this.title = null;
            this.dsn = null;
            this.title = title;
            this.dsn = initial;
        }

        protected void setShellStyle(int newShellStyle) {
            int style = 240;
            super.setShellStyle(newShellStyle | style);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (this.title != null) {
                newShell.setText(this.title);
            }
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.protsym = new MRUCombo(composite, 2052, "PROTSYM");
            if (this.dsn != null) {
                this.protsym.setSelection(this.dsn);
            }
            this.protsym.getCombo().addVerifyListener((VerifyListener)new verifyDSN());
            this.protsym.getCombo().setTextLimit(44);
            TextUtil.setWidth(this.protsym.getCombo(), 44);
            Composite dsnType = new Composite(composite, 0);
            dsnType.setLayoutData((Object)new GridData(4, 0, true, false));
            dsnType.setLayout((Layout)new GridLayout(3, true));
            this.errText = new Text(composite, 8);
            GridData gridData = new GridData(4, 0, true, true);
            this.errText.setLayoutData((Object)gridData);
            gridData.minimumWidth = 250;
            return composite;
        }

        public String getDSN() {
            return this.dsn;
        }

        private boolean verifyDSN() {
            String[] parts;
            String dsn = this.protsym.getCombo().getText().trim();
            if (dsn.length() == 0) {
                this.setError(Messages.BatchSettingsPage_31);
                return false;
            }
            if (dsn.contains(" ")) {
                this.setError(Messages.BatchSettingsPage_33);
                return false;
            }
            if (dsn.contains("(") || dsn.contains(")")) {
                this.setError(Messages.BatchSettingsPage_36);
                return false;
            }
            if (dsn.endsWith(".")) {
                this.setError(Messages.BatchSettingsPage_38);
                return false;
            }
            if (dsn.startsWith(".")) {
                this.setError(Messages.BatchSettingsPage_40);
                return false;
            }
            String[] stringArray = parts = dsn.split("[.]");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.length() == 0) {
                    this.setError(Messages.BatchSettingsPage_41);
                    return false;
                }
                if (part.length() > 8) {
                    this.setError(Messages.BatchSettingsPage_42);
                    return false;
                }
                if (!Character.isLetter(part.charAt(0)) && part.charAt(0) != '#' && part.charAt(0) != '@' && part.charAt(0) != '$') {
                    this.setError(Messages.BatchSettingsPage_39);
                    return false;
                }
                int j = 1;
                while (j < part.length()) {
                    if (!Character.isLetterOrDigit(part.charAt(j)) && part.charAt(j) != '#' && part.charAt(j) != '@' && part.charAt(j) != '$' && part.charAt(j) != '-') {
                        this.setError(Messages.BatchSettingsPage_43);
                        return false;
                    }
                    ++j;
                }
                ++n2;
            }
            this.dsn = dsn;
            return true;
        }

        private void setError(String errorMsg) {
            this.errText.setText(errorMsg);
            this.errText.redraw();
            this.protsym.getCombo().setFocus();
        }

        protected void okPressed() {
            if (this.verifyDSN()) {
                this.protsym.save();
                super.okPressed();
            }
        }
    }
}

