/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.BatchConfigWizard;
import com.ca.intertest.wizards.BatchSettingsWizard;
import com.ca.intertest.wizards.CICSConfigWizard;
import com.ca.intertest.wizards.CICSSettingsWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import com.ca.intertest.wizards.SettingsWizardDialog;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageBookViewPage;

public class ConfigureBreakpointAction
implements IViewActionDelegate,
IDoubleClickListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    static final String CONFIGURE_TOOLTIP_FORMAT = Messages.ConfigureBreakpointAction_0;
    static final String CONFIGURE_FORMAT = Messages.ConfigureBreakpointAction_1;
    static final String TRANSACTION = Messages.ConfigureBreakpointAction_2;
    static final String TERMINAL = Messages.ConfigureBreakpointAction_3;
    static final String PROGRAM = Messages.ConfigureBreakpointAction_4;
    private static final Debug debug = Debug.getInstance();
    private debugSession session = null;
    private debugFile debugfile = null;
    private Shell shell;
    private boolean forcerun = false;
    private static final String ERROR_TTSERVER_NOTSET = "CA TestingTools Server is not set.";
    private static final String ERROR_TTSERVER_NOTSET_REASON = "CA TestingTools Server needs to be set to obtain CAVHCONF.";

    public void init(IViewPart view) {
        this.shell = view.getViewSite().getShell();
    }

    public void init(Shell shell) {
        this.shell = shell;
    }

    public void run(IAction action) {
        IntertestWizardDialog dialog = null;
        if (this.debugfile != null) {
            dialog = this.debugfile.getSession().isCICS() ? new IntertestWizardDialog(this.shell, (IWizard)new CICSConfigWizard(this.debugfile)) : new IntertestWizardDialog(this.shell, (IWizard)new BatchConfigWizard(this.debugfile));
        } else if (this.session != null) {
            if (this.session.getFileServer() == null) {
                TT_ErrorDialog.openError(null, (String)"CA InterTest for CICS", (String)ERROR_TTSERVER_NOTSET, (Throwable)new TTException(ERROR_TTSERVER_NOTSET_REASON));
                return;
            }
            try {
                if (!this.session.getFileServer().isEnabled(this.session.isCICS())) {
                    this.session.getFileServer().reportCavhconfError(this.session.isCICS());
                    return;
                }
            }
            catch (TTException e) {
                this.session.getFileServer().reportCavhconfError(this.session.isCICS(), e);
                return;
            }
            dialog = this.session.isCICS() ? new SettingsWizardDialog(this.shell, (IWizard)new CICSSettingsWizard(this.session, false)) : new SettingsWizardDialog(this.shell, (IWizard)new BatchSettingsWizard(this.session, false));
        } else {
            return;
        }
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        String text = Messages.ConfigureBreakpointAction_5;
        String tooltip = "";
        boolean enabled = false;
        this.forcerun = false;
        this.debugfile = null;
        this.session = null;
        IEditorPart part = null;
        try {
            part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (RuntimeException runtimeException) {}
        if (part instanceof ListerEditor) {
            IResource resource = ((ListerEditor)part).getResource();
            this.debugfile = resource == null ? null : (debugFile)debug.getResource(resource);
            debugSession debugSession2 = this.session = this.debugfile == null ? null : this.debugfile.getSession();
        }
        if (selection.isEmpty() && this.debugfile != null && this.session != null) {
            enabled = true;
            String type = PROGRAM;
            text = String.format(CONFIGURE_FORMAT, type);
            tooltip = String.format(CONFIGURE_TOOLTIP_FORMAT, this.debugfile.getName());
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            tooltip = Messages.ConfigureBreakpointAction_7;
            if (sel.size() == 1) {
                Object obj = sel.getFirstElement();
                if (obj instanceof IT_TreeItem) {
                    IT_TreeItem item = (IT_TreeItem)obj;
                    if ((obj = item.getObj()) instanceof IDebug) {
                        String type;
                        enabled = true;
                        if (obj instanceof debugSession) {
                            this.session = (debugSession)obj;
                            this.debugfile = null;
                            type = "Session";
                        } else {
                            this.session = debug.getSession((IResource)((IDebug)obj).getResource().getProject());
                            this.debugfile = (debugFile)obj;
                            type = PROGRAM;
                            switch (this.debugfile.getFiletype()) {
                                case TERMID: {
                                    type = TERMINAL;
                                    break;
                                }
                                case TRANID: {
                                    type = TRANSACTION;
                                }
                            }
                        }
                        text = String.format(CONFIGURE_FORMAT, type);
                        tooltip = String.format(CONFIGURE_TOOLTIP_FORMAT, ((IDebug)obj).getName());
                    }
                } else {
                    if (obj instanceof IDebugMarker) {
                        obj = ((IDebugMarker)obj).getMarker();
                    }
                    if (obj instanceof IMarker) {
                        if (action != null) {
                            enabled = true;
                        } else {
                            IMarker marker = (IMarker)obj;
                            try {
                                String markertype = marker.getType();
                                if ("com.ca.intertest.breakpoint.unconditional".equals(markertype) && this.isAllLabel(marker) || "com.ca.intertest.breakpoint.rbp".equals(markertype)) {
                                    this.debugfile = (debugFile)debug.getResource(marker.getResource());
                                    this.session = this.debugfile.getSession();
                                    enabled = true;
                                    this.forcerun = true;
                                }
                            }
                            catch (CoreException coreException) {
                                enabled = false;
                            }
                        }
                        if (enabled) {
                            text = String.format(CONFIGURE_FORMAT, PROGRAM);
                            tooltip = String.format(CONFIGURE_TOOLTIP_FORMAT, this.debugfile.getName());
                        }
                    }
                }
            }
        } else if (selection instanceof TextSelection) {
            tooltip = Messages.ConfigureBreakpointAction_9;
            enabled = true;
        }
        if (action != null) {
            action.setEnabled(enabled);
            action.setText(text);
            action.setToolTipText(tooltip);
        }
    }

    private boolean isAllLabel(IMarker marker) {
        int bkptype = marker.getAttribute("sub_type", 0);
        return bkptype == 1;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(null, event.getSelection());
        if (this.debugfile == null || !this.debugfile.isProgram() || this.forcerun) {
            this.run(null);
        }
    }

    public void init(IPageBookViewPage page) {
        this.shell = page.getSite().getShell();
    }
}

