/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.server.CICSServer;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.testingtools.core.TTServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;

public class ServerList
implements IPropertyChangeListener {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final ServerList servers = new ServerList();
    private File propertyFile;
    private boolean changed;
    private boolean defaultschanged = false;
    private ArrayList<ServerElement> serverElements = new ArrayList();
    private ArrayList<TTServer> ttServers = new ArrayList();
    private ListenerList propertyChangeListeners = new ListenerList();
    @Deprecated
    private int monitorInterval = -1;
    private int connecttime = -1;
    private String serverFilename = null;
    private int port;
    private ServerElement default_server;
    private final ScopedPreferenceStore store = (ScopedPreferenceStore)IntertestPlugin.getConfigurationPreferences();

    private ServerList() {
        this.connecttime = this.store.getInt("DEFAULT_SERVER_CONNECT_TIMEOUT");
        if (this.connecttime < 0) {
            this.connecttime = this.store.getDefaultInt("DEFAULT_SERVER_CONNECT_TIMEOUT");
        }
        this.monitorInterval = this.store.getInt("DEFAULT_SERVER_REFRESH_TIME");
        if (this.monitorInterval < 0) {
            this.monitorInterval = this.store.getDefaultInt("DEFAULT_SERVER_REFRESH_TIME");
        }
        this.loadservers();
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void loadservers() {
        boolean preinstall;
        this.propertyFile = null;
        FileReader fileReader = null;
        try {
            this.store.setDefault("JCL_stream", this.getDefaultJCL());
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        this.setFileName();
        File pFile = new File(this.propertyFile.getPath());
        boolean bl = preinstall = !pFile.canRead();
        if (preinstall) {
            this.importPreInstalled();
        }
        if (pFile.canRead()) {
            try {
                fileReader = new FileReader(this.propertyFile);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)fileReader);
                this.initContentFromFile(memento, preinstall);
            }
            catch (IOException iOException) {
            }
            catch (WorkbenchException workbenchException) {}
        }
    }

    public static final synchronized ServerList getInstance() {
        return servers;
    }

    public static final void load() {
        servers.loadservers();
    }

    public static final void save() {
        servers.saveAll();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public void addServerElement(ServerElement newServer, boolean checkIfExists) throws ITException {
        ServerElement oldServer = this.getServer(newServer);
        TTServer oldTTServer = this.getTomcatServer(newServer);
        if (checkIfExists && oldServer != null) {
            throw new ITException(Messages.ServerList_1);
        }
        if (newServer.getHostname().length() < 1 || newServer.getName().length() < 1 || newServer.getPort() < 1) {
            throw new ITException(Messages.ServerList_2);
        }
        if (newServer.getPort() < 1) {
            newServer.setPort(this.port);
        }
        if (oldServer != null) {
            oldServer.setHostname(newServer.getHostname());
            oldServer.setName(newServer.getName());
            oldServer.setPort(newServer.getPort());
            if (!oldServer.isCICS_server()) {
                ((FileServer)oldServer).setJCL_stream(((FileServer)newServer).getJCL_stream());
            }
            if (oldTTServer != null) {
                oldTTServer.setHostname(newServer.getHostname());
                oldTTServer.setName(newServer.getName());
                oldTTServer.setPort(newServer.getPort());
            }
        } else {
            TTServer newTomcatServer = null;
            if (!newServer.isCICS_server()) {
                newTomcatServer = new TTServer(newServer.getName(), newServer.getHostname(), new Integer(newServer.getPort()).toString(), null);
                newTomcatServer.setUser(newServer.getUser());
                this.ttServers.add(newTomcatServer);
            }
            if (this.serverElements.add(newServer)) {
                newServer.checkStatus(0L);
                if (newServer.isDefaultserver()) {
                    ServerElement defaultelement = this.getDefault_server();
                    if (defaultelement != null) {
                        defaultelement.setDefaultserver(false);
                    }
                    defaultelement = newServer;
                }
                newServer.addPropertyChangeListener(this);
                PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.serverview", null, (Object)newServer);
                this.firePropertyChangeListeners(event);
                this.setChanged(true);
            }
        }
    }

    public void addServerElement(ServerElement element) throws ITException {
        this.addServerElement(element, true);
    }

    public void firePropertyChangeListeners(PropertyChangeEvent event) {
        this.changed = true;
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    public int getConnecttime() {
        return this.connecttime;
    }

    public ServerElement getDefault_server() {
        return this.default_server;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public ServerElement getServer(String name) {
        for (ServerElement element : this.serverElements) {
            if (!element.getUUIDString().equals(name)) continue;
            return element;
        }
        for (ServerElement element : this.serverElements) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    public ServerElement getServer(ServerElement server) {
        int index = this.serverElements.indexOf(server);
        return index >= 0 ? this.serverElements.get(index) : null;
    }

    public TTServer getTomcatServer(ServerElement newServer) {
        for (TTServer server : this.ttServers) {
            if (server.getName() != newServer.getName()) continue;
            return server;
        }
        return null;
    }

    public ServerElement getCICSServer(String name) {
        ArrayList<ServerElement> list = this.getCICSServers();
        for (ServerElement element : list) {
            if (!element.getUUIDString().equals(name)) continue;
            return element;
        }
        for (ServerElement element : list) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public FileServer getFileServer(String name) {
        ArrayList<FileServer> list = this.getFileServers();
        for (FileServer element : list) {
            if (!element.getUUIDString().equals(name)) continue;
            return element;
        }
        for (FileServer element : list) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public ArrayList<ServerElement> getServerElements() {
        return this.serverElements;
    }

    private void initContentFromFile(XMLMemento memento, boolean preinstall) throws IOException {
        IMemento[] children;
        try {
            String JCL = memento.getTextData();
            try {
                if (JCL == null || JCL.length() < 3) {
                    JCL = this.store.getDefaultString("JCL_stream");
                }
            }
            catch (Exception exception) {}
            this.store.setDefault("JCL_stream", JCL);
            this.store.setValue("DEFAULT_SERVER_PORT", memento.getString("DEFAULT_SERVER_PORT"));
            this.port = this.store.getInt("DEFAULT_SERVER_PORT");
            this.setBookshelf("bookshelf.BATCH", memento, preinstall);
            this.setBookshelf("bookshelf.CICS", memento, preinstall);
        }
        catch (NullPointerException nullPointerException) {
            this.defaultschanged = true;
        }
        IMemento[] iMementoArray = children = memento.getChildren("Server");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            try {
                boolean cics = Boolean.parseBoolean(child.getString("CICS_SERVER"));
                if (cics) {
                    this.addServerElement(new CICSServer(child), false);
                } else {
                    this.addServerElement(new FileServer(child), false);
                }
                this.setChanged(false);
            }
            catch (ITException e) {
                Logger.loggit(2, HexUtil.getErrorText((Throwable)e), e);
            }
            ++n2;
        }
    }

    private void setBookshelf(String property, XMLMemento memento, boolean preinstall) {
        String format;
        String message;
        String bookshelf = preinstall ? "" : this.store.getString(property);
        String newbookshelf = memento.getString(property);
        if (newbookshelf == null) {
            newbookshelf = "";
        }
        if (preinstall) {
            this.store.setValue(property, newbookshelf);
            return;
        }
        if (bookshelf.length() == 0 && newbookshelf.length() != 0) {
            this.store.setValue(property, newbookshelf);
            this.defaultschanged = true;
            return;
        }
        if (newbookshelf.length() != 0 && !bookshelf.equals(newbookshelf) && MessageDialog.openQuestion(null, (String)Messages.ServerList_8, (String)(message = String.format(format = String.valueOf(Messages.ServerList_5) + IConstants.LINEFEED + Messages.ServerList_6 + IConstants.LINEFEED + Messages.ServerList_7, bookshelf, newbookshelf)))) {
            this.store.setValue(property, newbookshelf);
            this.defaultschanged = true;
        }
    }

    public String getDefaultJCL() throws Exception {
        Bundle bundle = IntertestPlugin.getDefault().getBundle();
        String jclFilename = this.store.getDefaultString("DEFAULT_SERVER_JCL_FILENAME");
        URL jclURL = bundle.getEntry(jclFilename);
        BufferedReader urlReader = new BufferedReader(new InputStreamReader(jclURL.openStream()));
        String line = urlReader.readLine();
        StringBuilder text = new StringBuilder("");
        while (line != null) {
            text.append(line);
            text.append(IConstants.LINEFEED);
            line = urlReader.readLine();
        }
        text.delete(text.lastIndexOf(IConstants.LINEFEED), text.length());
        urlReader.close();
        return text.toString();
    }

    public boolean ischanged() {
        Iterator<ServerElement> iterator = this.serverElements.iterator();
        boolean serverschange = false;
        while (iterator.hasNext()) {
            if (!iterator.next().isChanged()) continue;
            serverschange = true;
            break;
        }
        return this.changed || serverschange || this.defaultschanged;
    }

    public synchronized void removeChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public synchronized void removeServerElement(ServerElement element) {
        element.removePropertyChangeListener(this);
        this.serverElements.remove(element);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.serverview", (Object)element, null);
        this.firePropertyChangeListeners(event);
        this.setChanged(true);
        if (element.isCICS_server()) {
            return;
        }
        TTServer oldTTServer = this.getTomcatServer(element);
        if (oldTTServer != null) {
            this.ttServers.remove(oldTTServer);
        }
    }

    public ArrayList<TTServer> getTtServers() {
        return this.ttServers;
    }

    private void saveAll() {
        try {
            this.store.save();
        }
        catch (IOException e1) {
            Logger.loggit(e1);
        }
        if (this.ischanged()) {
            this.setFileName();
            this.setChanged(false);
            this.defaultschanged = false;
            XMLMemento memento = XMLMemento.createWriteRoot((String)"Intertest");
            memento.putTextData(this.store.getString("JCL_stream"));
            memento.putString("DEFAULT_SERVER_PORT", this.store.getString("DEFAULT_SERVER_PORT"));
            memento.putString("bookshelf.BATCH", this.store.getString("bookshelf.BATCH"));
            memento.putString("bookshelf.CICS", this.store.getString("bookshelf.CICS"));
            for (ServerElement element : this.serverElements) {
                IMemento child = memento.createChild("Server");
                element.setChild(child);
                element.setChanged(false);
            }
            FileWriter out = null;
            try {
                if (!this.propertyFile.exists()) {
                    this.propertyFile.createNewFile();
                }
                out = new FileWriter(this.propertyFile);
            }
            catch (IOException e) {
                Logger.loggit(2, HexUtil.getErrorText((Throwable)e), e);
                return;
            }
            try {
                memento.save((Writer)out);
            }
            catch (IOException e) {
                Logger.loggit(2, HexUtil.getErrorText((Throwable)e), e);
            }
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    private void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setConnecttime(int connecttime) {
        this.connecttime = connecttime;
        this.store.setValue("DEFAULT_SERVER_CONNECT_TIMEOUT", connecttime);
        try {
            this.store.save();
        }
        catch (IOException e) {
            Logger.loggit(e);
        }
    }

    public void setDefault_server(ServerElement default_server) {
        if (!this.default_server.equals(default_server)) {
            this.default_server = default_server;
            this.setChanged(true);
        }
    }

    private void setFileName() {
        String filename = this.store.getString("SERVER_FILE");
        if (filename == null || filename.length() <= 0) {
            filename = this.store.getDefaultString("DEFAULT_SERVER_FILE_NAME");
            this.store.setValue("SERVER_FILE", filename);
            try {
                this.store.save();
            }
            catch (IOException iOException) {}
        }
        this.serverFilename = filename;
        IPath propertyPath = IntertestPlugin.getLocation();
        propertyPath = propertyPath.append(filename);
        this.propertyFile = propertyPath.toFile();
    }

    public String getFilename() {
        if (this.serverFilename == null || this.serverFilename.length() <= 0) {
            this.setFileName();
        }
        return this.serverFilename;
    }

    public boolean isDefaultschanged() {
        return this.defaultschanged;
    }

    public void setDefaultschanged(boolean defaultschanged) {
        this.defaultschanged = defaultschanged;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("bookshelf.BATCH".equals(property) || "bookshelf.CICS".equals(property)) {
            this.changed = true;
        }
        this.firePropertyChangeListeners(event);
    }

    public ArrayList<FileServer> getFileServers() {
        ArrayList<FileServer> elements = new ArrayList<FileServer>();
        for (ServerElement server : this.serverElements) {
            if (!(server instanceof FileServer)) continue;
            elements.add((FileServer)server);
        }
        return elements;
    }

    public ArrayList<ServerElement> getCICSServers() {
        ArrayList<ServerElement> elements = new ArrayList<ServerElement>();
        for (ServerElement server : this.serverElements) {
            if (server instanceof FileServer) continue;
            elements.add(server);
        }
        return elements;
    }

    public int size() {
        return this.serverElements.size();
    }

    private void importPreInstalled() {
        String serverFile = null;
        String serverPath = IntertestPlugin.getDefault().getBundle().getBundleContext().getProperty("ServerFilename");
        if (serverPath == null || serverPath.length() <= 0) {
            return;
        }
        File sPath = new File(serverPath);
        if (!sPath.isDirectory()) {
            return;
        }
        File[] files = sPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File sFile) {
                File file = sFile;
                if (file.canRead()) {
                    String name = file.getName().toLowerCase();
                    return name.endsWith(".xml");
                }
                return false;
            }
        });
        if (files.length == 0) {
            return;
        }
        if (files.length == 1) {
            serverFile = files[0].getAbsolutePath();
        } else {
            FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell());
            fd.setFilterPath(serverPath);
            fd.setFilterExtensions(new String[]{"*.xml"});
            fd.setText(Messages.ServerList_13);
            serverFile = fd.open();
            if (serverFile == null) {
                return;
            }
        }
        try {
            FileReader fileReader = new FileReader(serverFile);
            FileWriter fileWriter = new FileWriter(this.getPropertyFile());
            XMLMemento xml = XMLMemento.createReadRoot((Reader)fileReader);
            xml.save((Writer)fileWriter);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    public TTServer getInterTestServerByName(String oldServerName) {
        for (TTServer server : this.ttServers) {
            if (!server.getName().equalsIgnoreCase(oldServerName)) continue;
            return server;
        }
        return null;
    }
}

