/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.dialogs.IntertestDialog;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class RulerCICSBreakpointDialog
extends IntertestDialog {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private IMarker[] markers = null;
    private List markerView = null;
    private boolean change = true;
    private int ix = 0;
    private int ixCount = 0;
    private int[] ixArray;

    public RulerCICSBreakpointDialog(Shell parentShell, boolean change) {
        this(parentShell);
        this.change = change;
    }

    public RulerCICSBreakpointDialog(Shell parentShell) {
        super(parentShell);
    }

    public RulerCICSBreakpointDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public void init(IMarker[] markers) {
        this.markers = markers;
        this.CONTEXT_ID = "abstractBreakpointPage";
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = this.change ? Messages.RulerCICSBreakpointDialog_1 : Messages.RulerCICSBreakpointDialog_2;
        newShell.setText(title);
    }

    public int getSelectedIndex() {
        return this.ix;
    }

    public int getSelectionCount() {
        return this.ixCount;
    }

    public int[] getSelectionIndices() {
        return this.ixArray;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, true));
        String[] markerList = null;
        Composite dcomp = new Composite(composite, 0);
        dcomp.setLayoutData((Object)new GridData(4, 4, true, true));
        dcomp.setLayout((Layout)new GridLayout(1, true));
        Group group = new Group(dcomp, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, true));
        String text = this.change ? Messages.RulerCICSBreakpointDialog_3 : Messages.RulerCICSBreakpointDialog_4;
        group.setText(text);
        int viewStyle = 2816;
        viewStyle = this.change ? (viewStyle |= 4) : (viewStyle |= 2);
        this.markerView = new List((Composite)group, viewStyle);
        this.markerView.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.markers != null && this.markers.length > 0) {
            markerList = this.getMarkerItems();
            this.markerView.setItems(markerList);
        } else {
            markerList = new String[]{Messages.RulerCICSBreakpointDialog_5};
        }
        this.markerView.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                RulerCICSBreakpointDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        if (!this.change) {
            Composite buttonGroup = new Composite(dcomp, 0);
            buttonGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            buttonGroup.setLayout((Layout)new GridLayout(2, false));
            Button selectAll = new Button(buttonGroup, 0);
            selectAll.setLayoutData((Object)new GridData(131072, 4, true, true));
            selectAll.setText(Messages.RulerCICSBreakpointDialog_6);
            selectAll.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    RulerCICSBreakpointDialog.this.markerView.selectAll();
                }
            });
            Button deselectAll = new Button(buttonGroup, 0);
            deselectAll.setLayoutData((Object)new GridData(131072, 4, false, true));
            deselectAll.setText(Messages.RulerCICSBreakpointDialog_7);
            deselectAll.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    RulerCICSBreakpointDialog.this.markerView.deselectAll();
                }
            });
            selectAll.pack(true);
            deselectAll.pack(true);
        }
        return composite;
    }

    protected void okPressed() {
        this.ixCount = this.markerView.getSelectionCount();
        this.ixArray = this.markerView.getSelectionIndices();
        this.ix = this.markerView.getSelectionIndex();
        if (this.change) {
            super.okPressed();
        } else {
            boolean choice = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.RulerCICSBreakpointDialog_8, (String)Messages.RulerCICSBreakpointDialog_9);
            if (choice) {
                super.okPressed();
            } else {
                return;
            }
        }
    }

    protected String[] getMarkerItems() {
        String[] items = new String[this.markers.length];
        int i = 0;
        while (i < this.markers.length) {
            try {
                String type = this.markers[i].getType();
                String text = null;
                StringBuffer buildText = new StringBuffer();
                if (type.equals("com.ca.intertest.breakpoint.conditional")) {
                    buildText.append(Messages.RulerCICSBreakpointDialog_10);
                    buildText.append(String.valueOf(((Integer)this.markers[i].getAttribute("stmtNumber")).toString()) + Messages.RulerCICSBreakpointDialog_18);
                    buildText.append(String.valueOf((String)this.markers[i].getAttribute("left_variable")) + Messages.RulerCICSBreakpointDialog_19);
                    Integer oper = (Integer)this.markers[i].getAttribute("operator");
                    buildText.append(String.valueOf(IConstants.OPERATOR_TEXTS[oper - 1].substring(0, 2)) + "   ");
                    buildText.append((String)this.markers[i].getAttribute("right_variable"));
                    text = buildText.toString();
                } else {
                    buildText.append(Messages.RulerCICSBreakpointDialog_14);
                    buildText.append(((Integer)this.markers[i].getAttribute("stmtNumber")).toString());
                    text = buildText.toString();
                }
                items[i] = text;
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            ++i;
        }
        return items;
    }
}

