/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.debug.IDebugMarker;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.IMemento;

public class debugMarker
implements IDebugMarker,
Comparable<debugMarker> {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected String breakpoint = null;
    protected String name;
    protected String label;
    protected IDebugMarker parent = null;
    protected boolean enabled = false;
    protected boolean changed = false;
    protected IMarker marker = null;
    protected int commandID = 0;
    protected IResource resource;
    protected String markername;
    protected int RBP_Type = 0;
    protected HashMap<String, Object> attributes;

    public debugMarker(IMemento item) {
        String value;
        this.name = value = this.fixString(item.getTextData());
        this.breakpoint = value;
        this.label = value;
        String text = item.getString("cmd");
        if (text != null && text.length() > 1) {
            try {
                this.commandID = Integer.decode(text).shortValue();
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    protected debugMarker(String name) {
        String value;
        this.breakpoint = value = this.fixString(name);
        this.name = value;
        this.label = value;
    }

    public debugMarker(IMarker marker) {
        this.setMarker(marker, true);
    }

    @Override
    public boolean setMarker(IMarker marker, boolean force) {
        String markertype;
        if (this.isDummy() || !marker.exists()) {
            return false;
        }
        if (marker.equals((Object)this.marker)) {
            return true;
        }
        if (this.resource == null) {
            this.resource = marker.getResource();
        }
        try {
            markertype = marker.getType();
        }
        catch (CoreException e) {
            Logger.loggit(e);
            return false;
        }
        if (!markertype.equals("com.ca.intertest.breakpoint.rbp")) {
            return false;
        }
        byte rbptype = (byte)marker.getAttribute("rbp_type", 0);
        int command = marker.getAttribute("cmd", 0);
        if (force) {
            this.RBP_Type = rbptype;
            this.commandID = command;
            this.markername = markertype;
        } else if (rbptype != this.RBP_Type || command != this.commandID) {
            return false;
        }
        this.setEnabled(marker.getAttribute("BREAKPOINT_ENABLED", false));
        this.breakpoint = marker.getAttribute("name", "");
        this.marker = marker;
        return true;
    }

    @Override
    public String toString() {
        if (this.name == null || this.name.length() == 0) {
            if (this.markername != null) {
                this.name = this.markername;
            } else if (this.name == null) {
                this.name = "";
            }
        }
        if (this.name.equals(this.breakpoint)) {
            return this.name;
        }
        return this.name;
    }

    @Override
    public final String getBreakpoint() {
        return this.getFullBreakpoint();
    }

    @Override
    public final IDebugMarker getParent() {
        return this.parent;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof debugMarker) {
            return this.compareTo((debugMarker)obj) == 0;
        }
        return false;
    }

    protected String getFullBreakpoint() {
        this.breakpoint = this.marker != null ? this.marker.getAttribute("name", this.breakpoint) : (this.commandID == 0 ? this.toString() : String.format("0x%02x-%s-0x%04x", this.RBP_Type, this.name, (short)this.commandID));
        return this.breakpoint;
    }

    @Override
    public void setParent(IDebugMarker parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.changed = true;
            this.enabled = enabled;
        }
    }

    @Override
    public IMarker getMarker() {
        return this.marker;
    }

    @Override
    public boolean setMarker(IMarker marker) {
        return this.setMarker(marker, false);
    }

    private String fixString(String string) {
        if (string != null) {
            int i = string.indexOf(10);
            if (i == -1) {
                return string.trim();
            }
            return string.substring(0, i).trim();
        }
        return "";
    }

    @Override
    public void setResource(IResource resource) {
        if (this.resource != null) {
            return;
        }
        this.resource = resource;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public synchronized void save() {
        if (this.isDummy()) {
            return;
        }
        if (this.resource != null && this.changed) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        debugMarker.this.setAttribute("BREAKPOINT_ENABLED", debugMarker.this.enabled);
                        debugMarker.this.setAttribute("rbp_type", new Integer((short)debugMarker.this.RBP_Type));
                        debugMarker.this.setAttribute("cmd", new Integer(debugMarker.this.commandID));
                        debugMarker.this.setAttribute("label", debugMarker.this.label);
                        debugMarker.this.setAttribute("name", debugMarker.this.getBreakpoint());
                        if (debugMarker.this.enabled && (debugMarker.this.marker == null || !debugMarker.this.marker.exists())) {
                            debugMarker.this.markername = "com.ca.intertest.breakpoint.rbp";
                            debugMarker.this.marker = debugMarker.this.resource.createMarker(debugMarker.this.markername);
                        }
                        if (debugMarker.this.marker != null && debugMarker.this.marker.exists()) {
                            debugMarker.this.marker.setAttributes(debugMarker.this.attributes);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            try {
                this.resource.getWorkspace().run(r, (ISchedulingRule)this.resource, 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        this.changed = false;
    }

    @Override
    public boolean isDummy() {
        return this.commandID == 0;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public IDebugMarker getMarker(IMarker key) {
        if (this.marker.equals((Object)key)) {
            return this;
        }
        return null;
    }

    @Override
    public ArrayList<IDebugMarker> getEnabled() {
        ArrayList<IDebugMarker> list = new ArrayList<IDebugMarker>(1);
        if (this.enabled) {
            list.add(this);
        }
        return list;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(this.getClass())) {
            return this;
        }
        if (adapter.equals(IDebugMarker.class)) {
            return this;
        }
        return null;
    }

    @Override
    public int getCommandID() {
        return this.commandID;
    }

    @Override
    public int getRBP_Type() {
        return this.RBP_Type;
    }

    @Override
    public void setRBP_Type(int type) {
        int temp = this.RBP_Type | type;
        if (temp != this.RBP_Type) {
            this.RBP_Type = temp;
            this.getFullBreakpoint();
        }
    }

    public HashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    protected void unsetAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.unsetAttribute(key);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(key, value);
        }
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes != null && this.attributes.containsKey(key)) {
            return this.attributes.get(key);
        }
        return new Object();
    }

    @Override
    public void setAttribute(String key, int value) {
        this.setAttribute(key, new Integer(value));
    }

    @Override
    public void setAttribute(String key, boolean value) {
        this.setAttribute(key, (Object)value);
    }

    @Override
    public int compareTo(debugMarker anotherMarker) {
        int thistype;
        if (anotherMarker == null) {
            throw new NullPointerException();
        }
        int anothertype = anotherMarker.getType();
        if (anothertype != (thistype = this.getType())) {
            return anothertype < thistype ? 1 : -1;
        }
        if (this.getBreakpoint().equals(anotherMarker.getBreakpoint())) {
            return 0;
        }
        return this.toString().compareTo(anotherMarker.toString());
    }

    @Override
    public IDebugMarker getMarker(short commandID) {
        return commandID == this.commandID ? this : null;
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }
}

